/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.aprpurcsalesttr.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.Item;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.StTrD;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.exception.BDBExceptionHandler;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.util.ChangeTracker;
import com.borland.dx.dataset.CalcFieldsListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.Variant;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StTrDCustom
extends BTable
implements CalcFieldsListener,
ColumnChangeListener,
DataChangeListener,
ResourceGetter {
    private static final Logger logger = LoggerFactory.getLogger(StTrD.class);
    private BDBExceptionHandler handler;
    private final LocaleInstance l = LocaleInstance.getInstance();
    private final Item item = (Item)BTableProvider.createTable(Item.class);
    private final boolean useQtyX = Reg.getInstance().getValueBoolean("QTYX_ENABLED");

    public StTrDCustom() {
        super(BDM.getDefault(), "sttrd", "sttrno,sttrdno");
        this.initBTable();
    }

    private void initBTable() {
        com.bits.lib.dx.Column[] cols = new com.bits.lib.dx.Column[]{new com.bits.lib.dx.Column("sttrno", this.getResourcesBL("col.sttrno"), 16), new com.bits.lib.dx.Column("sttrdno", this.getResourcesBL("col.sttrdno"), 3), new com.bits.lib.dx.Column("itemid", this.getResourcesBL("col.itemid"), 16), new com.bits.lib.dx.Column("itemdesc", this.getResourcesBL("col.itemdesc"), 16), new com.bits.lib.dx.Column("pid", this.getResourcesBL("col.pid"), 16), new com.bits.lib.dx.Column("qty", this.getResourcesBL("col.qty"), 10), new com.bits.lib.dx.Column("unit", this.getResourcesBL("col.unit"), 16), new com.bits.lib.dx.Column("conv", this.getResourcesBL("col.conv"), 10), new com.bits.lib.dx.Column("qtyx", this.getResourcesBL("col.qtyx"), 10), new com.bits.lib.dx.Column("cost", this.getResourcesBL("col.cost"), 10), new com.bits.lib.dx.Column("deptid", this.getResourcesBL("col.deptid"), 16), new com.bits.lib.dx.Column("prjid", this.getResourcesBL("col.prjid"), 16), new com.bits.lib.dx.Column("sttrdnote", this.getResourcesBL("col.sttrdnote"), 16)};
        cols = this.addAdditionalColumn(cols);
        BLUtil.setDataPreferredOrdinal((Column[])cols);
        HashMap hm = JBSQL.ColumnsToHashMap((Column[])cols);
        JBSQL.setCalc((Column)((com.bits.lib.dx.Column)hm.get("itemdesc")));
        this.setOrderBy("sttrdno");
        this.createDataSet((Column[])cols);
        try {
            this.dataset.addCalcFieldsListener((CalcFieldsListener)this);
            this.dataset.addColumnChangeListener((ColumnChangeListener)this);
            this.dataset.addDataChangeListener((DataChangeListener)this);
        }
        catch (DataSetException ex) {
            logger.error("DataSet Exception", (Throwable)ex);
        }
        catch (TooManyListenersException ex) {
            logger.error("TooManyListenerException", (Throwable)ex);
        }
        this.setOrderBy("StTrNo, StTrDNo");
        this.dataset.open();
    }

    public void calcFields(ReadRow readRow, DataRow dataRow, boolean isPosted) {
        dataRow.setString("itemdesc", ItemList.getInstance().getItemDesc(readRow.getString("itemid")));
    }

    public void setBDBExceptionHandler(BDBExceptionHandler handler) {
        this.handler = handler;
    }

    public void changed(DataSet dataSet, Column column, Variant variant) {
        if (this.bypass) {
            return;
        }
        if (column.getColumnName().equalsIgnoreCase("itemid")) {
            this.ItemID_Changed();
            dataSet.post();
        }
        ChangeTracker.getInstance().track("STTR:" + dataSet.getString("sttrno"), true, column.getColumnName());
    }

    private void ItemID_Changed() {
        BigDecimal qty = BigDecimal.ONE;
        String itemid = this.getString("itemid");
        if (itemid.indexOf("*") > 0) {
            String[] itemSplit = itemid.split("\\*");
            try {
                qty = new BigDecimal(itemSplit[0]);
                this.getDataSet().setBigDecimal("qty", qty);
                itemid = itemSplit[1];
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (Reg.getInstance().getValueBoolean("USE_BC").booleanValue()) {
            itemid = ItemList.getInstance().getItemIDByBarCode(itemid);
        }
        if (itemid != null && itemid.length() > 0 && !ItemList.getInstance().isStock(itemid)) {
            if (this.handler != null) {
                if (!ItemList.getInstance().isItemValid(itemid)) {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(this.getResourcesBL("ex.itemnotfound")));
                } else {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(this.getResourcesBL("ex.notforstock")));
                }
            }
            this.setString("itemid", null);
        } else if (!ItemList.getInstance().isActive(itemid)) {
            BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(this.getResourcesBL("ex.iteminactive")));
            this.setString("itemid", null);
        } else {
            if (ItemList.getInstance().isItemValid(itemid)) {
                this.setString("itemid", itemid);
                this.setString("unit", this.itemgetsttrunit(itemid));
                this.setBigDecimal("qty", qty);
            }
            this.firePropertyChange("itemid", null, itemid);
        }
    }

    public String itemgetsttrunit(String itemid) {
        if (Reg.getInstance().getValueString("STTR_UNIT").equalsIgnoreCase("Unit3")) {
            if (ItemList.getInstance().getUnit3(itemid) != null) {
                return ItemList.getInstance().getUnit3(itemid);
            }
            if (ItemList.getInstance().getUnit2(itemid) != null) {
                return ItemList.getInstance().getUnit2(itemid);
            }
            return ItemList.getInstance().getUnit1(itemid);
        }
        if (Reg.getInstance().getValueString("STTR_UNIT").equalsIgnoreCase("Unit2")) {
            if (ItemList.getInstance().getUnit2(itemid) != null) {
                return ItemList.getInstance().getUnit2(itemid);
            }
            return ItemList.getInstance().getUnit1(itemid);
        }
        return ItemList.getInstance().getUnit1(itemid);
    }

    public void validate(DataSet dataSet, Column column, Variant variant) throws Exception, DataSetException {
        String columnName = column.getColumnName();
        if ("qtyx".equalsIgnoreCase(columnName) && this.useQtyX && !ItemList.getInstance().useQtyX(dataSet.getString("itemid"))) {
            dataSet.setBigDecimal("qtyx", null);
            if (this.handler != null) {
                BDBExceptionHandler.handleException((DataSet)dataSet, null, (Exception)new Exception(this.getResourcesBL("ex.notuseqtyx")));
            }
        }
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        if (this.getDataSet().isNull("itemid") || this.getDataSet().getString("itemid").length() <= 0) {
            this.getDataSet().emptyRow();
        }
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(StTrD.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(StTrD.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(StTrD.class, key);
    }
}

