/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.aprpurcsalesttr.bl;

import com.bits.bee.aprpurcsalesttr.bl.StTrCustom;
import com.bits.bee.aprpurcsalesttr.bl.StTrDCustom;
import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.Canvas;
import com.bits.bee.bl.City;
import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Per;
import com.bits.bee.bl.Pid;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.StTrTrans;
import com.bits.bee.bl.Stock;
import com.bits.bee.bl.exception.PKExceptionFactory;
import com.bits.bee.bl.procedure.SPRecurringUpdate;
import com.bits.bee.bl.procedure.spLogTrans_New;
import com.bits.bee.bl.procedure.spStockTransfer_New;
import com.bits.bee.bl.procedure.spStockTransfer_Void;
import com.bits.bee.bl.util.memorized.MemorizedException;
import com.bits.bee.bl.util.memorized.MemorizedObject;
import com.bits.bee.bl.util.memorized.MemorizedSubject;
import com.bits.bee.bl.util.memorized.SPMemorizedUtil;
import com.bits.bee.bl.util.recurring.RecurringObject;
import com.bits.lib.BHelp;
import com.bits.lib.annotation.PostSaveEvent;
import com.bits.lib.annotation.PostVoidEvent;
import com.bits.lib.annotation.PreVoidEvent;
import com.bits.lib.dbswing.BdbState;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BProcSimple;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StTrTransCustom
extends BTrans
implements MemorizedObject,
MemorizedSubject,
RecurringObject {
    private static final Logger logger = LoggerFactory.getLogger(StTrTrans.class);
    private final StTrCustom sttr = (StTrCustom)BTableProvider.createTable(StTrCustom.class);
    private final StTrDCustom sttrd = (StTrDCustom)BTableProvider.createTable(StTrDCustom.class);
    private final Canvas canvas = (Canvas)BTableProvider.createTable(Canvas.class);
    private final LocaleInstance l = LocaleInstance.getInstance();
    private String ModeSttr = "S";
    private boolean inAuth = false;
    private String OBJID;
    private final BdbState state = new BdbState();
    private final QueryDataSet qds = new QueryDataSet();
    private final SPMemorizedUtil spMemorizedUtil = new SPMemorizedUtil();
    private final SPRecurringUpdate spRecurringUpdate = new SPRecurringUpdate();
    SttrDAdapter sttrdadapter = new SttrDAdapter();

    public StTrTransCustom() {
        super(BDM.getDefault(), "STTR", "sttrdate", "branchid", "sttrno", "Mutasi Stock");
        this.initialize();
    }

    private void initialize() {
        this.doInit();
    }

    public StTrCustom createMaster() {
        return this.sttr;
    }

    public StTrDCustom createStTrD() {
        return this.sttrd;
    }

    protected void doInit() {
        this.setMaster(this.createMaster());
        this.addDetail(this.createStTrD());
        this.setspNew((BProcSimple)new spStockTransfer_New());
        this.setspVoid((BProcSimple)new spStockTransfer_Void());
        this.setspLog((BProcSimple)new spLogTrans_New());
        this.setRefType("STTR");
        this.setCrtBy(BAuthMgr.getDefault().getUserID());
        this.getDataSetDetail().addDataChangeListener((DataChangeListener)this.sttrdadapter);
    }

    public boolean checkIsLocked() {
        DataSet dsMaster = this.getDataSetMaster();
        boolean status = dsMaster.getColumn("isLocked") == null ? true : (dsMaster.getBoolean("isLocked") && this.state.getState() == 2 ? BAuthMgr.getDefault().getAuth(this.OBJID, "UNLOCK") : true);
        return status;
    }

    public void setOBJID(String OBJID) {
        this.OBJID = OBJID;
    }

    public void setState(int StateType) {
        this.state.setState(StateType);
    }

    public void setMode(String mode) {
        this.ModeSttr = mode;
    }

    public void newDefaultValues() {
        DataSet dsMaster = this.getDataSetMaster();
        dsMaster.setString("sttrno", "AUTO");
        dsMaster.setDate("sttrdate", BHelp.getCurrentDate_SQL());
        if (this.ModeSttr.equalsIgnoreCase("S")) {
            dsMaster.setString("sttrtype", "S");
        } else {
            dsMaster.setString("sttrtype", "C");
        }
        dsMaster.setString("crtby", BAuthMgr.getDefault().getUserID());
        dsMaster.setString("updby", BAuthMgr.getDefault().getUserID());
        dsMaster.setTimestamp("crtdate", BHelp.getCurrentDateTime());
        dsMaster.setTimestamp("upddate", BHelp.getCurrentDateTime());
        dsMaster.setString("perid", Per.getInstance().getPeriodeActive());
    }

    public void newAddDetail(String itemid) {
        DataSet dsDetail = this.getDataSetDetail();
        dsDetail.setString("itemid", itemid);
        dsDetail.setString("sttrno", this.getDataSetMaster().getString("sttrno"));
        dsDetail.setShort("sttrdno", (short)(dsDetail.getRow() + 1));
        dsDetail.setString("unit", ItemList.getInstance().getUnit1(itemid));
    }

    public void newAddDetail(String itemid, int newQty) {
        this.newAddDetail(itemid);
        this.getDataSetDetail().setBigDecimal("qty", new BigDecimal(newQty));
    }

    public void initPrint() {
        DataSet dsMaster = this.getDataSetMaster();
        DataSet drcmp = Cmp.getInstance().getDataSet();
        dsMaster.setString("cmpname", drcmp.getString("cmpname"));
        dsMaster.setString("cmpownername", drcmp.getString("ownername"));
        dsMaster.setString("cmpaddr", drcmp.getString("cmpaddr"));
        dsMaster.setString("cmpphone", drcmp.getString("phone"));
        dsMaster.setString("cmpcity", City.getInstance().getCityName(drcmp.getString("cityid")));
        dsMaster.setString("cmptaxregno", drcmp.getString("taxregno"));
        dsMaster.setString("cmpvatregno", drcmp.getString("vatregno"));
        dsMaster.setDate("cmpvatregdate", drcmp.getDate("vatregdate"));
        dsMaster.setString("formserno", drcmp.getString("formserno"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBulkPID(Pid pid) {
        this.setBypass(true);
        DataSet dsDetail = this.getDataSetDetail();
        int bookmark = dsDetail.getRow();
        this.enableDataSetEvents(false);
        try {
            int count = pid.getDataSet().getRowCount();
            short laststtrdno = this.getDetail().getShort_LastRow("sttrdno");
            for (int i = 0; i < count; ++i) {
                pid.getDataSet().goToRow(i);
                this.getDetail().New();
                dsDetail.setString("sttrno", this.getDataSetMaster().getString("sttrno"));
                laststtrdno = (short)(laststtrdno + 1);
                dsDetail.setShort("sttrdno", laststtrdno);
                dsDetail.setString("itemid", pid.getString("itemid"));
                dsDetail.setString("pid", pid.getString("pid"));
                dsDetail.setString("unit", pid.getString("unit"));
                dsDetail.setBigDecimal("qty", pid.getBigDecimal("qty"));
            }
            BLUtil.renumberDetail((BTrans)this, (String)"sttrdno");
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.enableDataSetEvents(true);
            dsDetail.goToRow(bookmark);
            this.setBypass(false);
        }
    }

    public void validateCanvas() throws Exception {
        DataSet dsMaster = this.getDataSetMaster();
        if (dsMaster.isNull("canvasid") || dsMaster.getString("canvasid").length() <= 0) {
            throw new Exception(this.getResourcesBL("ex.canvasid"));
        }
    }

    public void strans_validate() throws Exception {
        DataSet master = this.getDataSetMaster();
        DataSet dsDetail = this.getDataSetDetail();
        if (master.isNull("sttrno") || master.getString("sttrno").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.sttrno"));
        }
        if (master.isNull("sttrdate")) {
            throw new Exception(this.getResourcesBL("ex.sttrdate"));
        }
        if (master.isNull("sttrtype") || master.getString("sttrtype").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.sttrtype"));
        }
        if (master.isNull("whid1") || master.getString("whid1").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.whid1"));
        }
        if (master.isNull("whid2") || master.getString("whid2").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.whid2"));
        }
        dsDetail.last();
        if (dsDetail.isNull("itemid") || dsDetail.getString("itemid").length() == 0) {
            dsDetail.emptyRow();
        }
        if (dsDetail.getRowCount() == 0) {
            throw new Exception(this.getResourcesBL("ex.notransaction"));
        }
        try {
            dsDetail.first();
        }
        catch (Exception e) {
            dsDetail.emptyAllRows();
            throw new Exception(this.getResourcesBL("ex.notransaction"));
        }
        if (dsDetail.getRowCount() == 0) {
            throw new Exception(this.getResourcesBL("ex.nostock"));
        }
    }

    public void cek_QtyInWh(boolean check) throws Exception {
        if (!Reg.getInstance().getValueBoolean("CEK_STOCK").booleanValue()) {
            return;
        }
        DataSet dsDetail = this.getDataSetDetail();
        if (dsDetail.getRowCount() > 0) {
            for (int i = 0; i < dsDetail.rowCount(); ++i) {
                dsDetail.goToRow(i);
                if (!ItemList.getInstance().getBooleanField(dsDetail.getString("itemid"), "ispurc")) continue;
                BigDecimal QtySaled = ItemList.getInstance().getQtyZToQty1(dsDetail.getString("itemid"), dsDetail.getBigDecimal("qty"), dsDetail.getString("unit"));
                BigDecimal QtyStock = Stock.getInstance().getQty(dsDetail.getString("itemid"), dsDetail.getString("pid"), this.getDataSetMaster().getString("whid1"));
                if (QtyStock == null) {
                    QtyStock = BigDecimal.ZERO;
                }
                if (this.inAuth || QtySaled.compareTo(QtyStock) != 1) continue;
                if (check) {
                    this.inAuth = true;
                    continue;
                }
                throw new Exception(String.format(this.getResourcesBL("ex.notenoughstock"), dsDetail.getString("itemdesc"), dsDetail.getString("whid")));
            }
        }
    }

    public void Save() throws Exception {
        try {
            this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
            BLUtil.renumberDetail((BTrans)this, (String)"sttrdno");
            super.Save();
        }
        catch (Exception ex) {
            throw PKExceptionFactory.INSTANCE.createException(BHelp.getExceptionDetail((Exception)ex), ex, this.getResourcesBL("ex.pk"));
        }
    }

    protected Class getSubclass() {
        return ((Object)((Object)this)).getClass();
    }

    @PreVoidEvent
    public void checkVersioning() throws Exception {
        DataSet dsMaster = this.getDataSetMaster();
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), String.format("SELECT version FROM sttr WHERE sttrno=%s", BHelp.QuoteSingle((String)dsMaster.getString("sttrno")))));
        this.qds.open();
        Long version = this.qds.getLong("version");
        if (version.compareTo(dsMaster.getLong("version")) > 0) {
            throw new IllegalArgumentException(LocaleInstance.getInstance().getMessageBL(null, "ex.version"));
        }
    }

    @PostSaveEvent
    public void saveUpdateRecurring() throws Exception {
        DataSet dsMaster = this.getDataSetMaster();
        if (!dsMaster.isNull("recurno")) {
            this.spRecurringUpdate.execute(dsMaster.getString("sttrno"), dsMaster.getString("sttrnote"), dsMaster.getString("recurno"), dsMaster.getShort("recurdno"), true);
        }
    }

    @PostVoidEvent
    public void voidUpdateRecurring() throws Exception {
        DataSet dsMaster = this.getDataSetMaster();
        if (!dsMaster.isNull("recurno")) {
            this.spRecurringUpdate.execute(dsMaster.getString("sttrno"), null, dsMaster.getString("recurno"), dsMaster.getShort("recurdno"), false);
        }
    }

    public void memorized(String memorizedNote) throws MemorizedException {
        DataSet dsMaster = this.getDataSetMaster();
        if (dsMaster.getBoolean("ismemorized")) {
            throw new MemorizedException(this.getResourcesBL("ex.already.memorized"));
        }
        try {
            boolean memorized = true;
            this.spMemorizedUtil.execute("sttr", "sttrno", dsMaster.getString("sttrno"), memorized, memorizedNote);
            dsMaster.setBoolean("ismemorized", memorized);
            dsMaster.setString("memorizednote", memorizedNote);
        }
        catch (Exception ex) {
            throw new MemorizedException(this.getResourcesBL("ex.memorized.failed"), (Throwable)ex);
        }
    }

    public void unmemorized() throws MemorizedException {
        DataSet dsMaster = this.getDataSetMaster();
        if (!dsMaster.getBoolean("ismemorized")) {
            throw new MemorizedException(this.getResourcesBL("ex.not.memorized"));
        }
        try {
            boolean memorized = false;
            this.spMemorizedUtil.execute("sttr", "sttrno", dsMaster.getString("sttrno"), memorized, "");
            dsMaster.setBoolean("ismemorized", memorized);
            dsMaster.setString("memorizednote", "");
        }
        catch (Exception ex) {
            throw new MemorizedException(this.getResourcesBL("ex.unmemorized.failed"), (Throwable)ex);
        }
    }

    public boolean isMemorized() {
        return this.getDataSetMaster().getBoolean("ismemorized");
    }

    public boolean isMemorizedEnabled() {
        return !this.getDataSetMaster().getBoolean("isdraft");
    }

    public void importMemorized(ArrayList<String> memorizedRefs) throws MemorizedException {
        if (memorizedRefs != null) {
            for (String memorizeRef : memorizedRefs) {
                this.importMemorized(memorizeRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMemorized(String memorizedRef) throws MemorizedException {
        try {
            if (memorizedRef == null) {
                return;
            }
            DataSet dsDetail = this.getDataSetDetail();
            StTrDCustom localSttrD = (StTrDCustom)BTableProvider.createTable(StTrDCustom.class);
            localSttrD.LoadID(memorizedRef);
            dsDetail.last();
            short lastDetailNumber = dsDetail.getShort("sttrdno");
            String sttrno = this.getDataSetMaster().getString("sttrno");
            int rowCount = localSttrD.getDataSet().getRowCount();
            this.setBypass(true);
            this.enableDataSetEvents(false);
            try {
                for (int i = 0; i < rowCount; ++i) {
                    localSttrD.getDataSet().goToRow(i);
                    DataRow dr = new DataRow(dsDetail);
                    dr.setString("sttrno", sttrno);
                    short s = lastDetailNumber;
                    lastDetailNumber = (short)(lastDetailNumber + 1);
                    dr.setShort("sttrdno", s);
                    dr.setString("itemid", localSttrD.getString("itemid"));
                    dr.setString("pid", localSttrD.getString("pid"));
                    dr.setString("unit", localSttrD.getString("unit"));
                    dr.setString("sttrdnote", localSttrD.getString("sttrdnote"));
                    dr.setBigDecimal("qty", localSttrD.getBigDecimal("qty"));
                    dr.setBigDecimal("conv", localSttrD.getBigDecimal("conv"));
                    dr.setBigDecimal("qtyx", localSttrD.getBigDecimal("qtyx"));
                    if (!localSttrD.getDataSet().isNull("prjid")) {
                        dr.setString("prjid", localSttrD.getString("prjid"));
                    }
                    if (!localSttrD.getDataSet().isNull("deptid")) {
                        dr.setString("prjid", localSttrD.getString("deptid"));
                    }
                    dsDetail.addRow(dr);
                }
            }
            finally {
                this.enableDataSetEvents(true);
                this.setBypass(false);
            }
        }
        catch (Exception ex) {
            throw new MemorizedException("", (Throwable)ex);
        }
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(StTrTrans.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(StTrTrans.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(StTrTrans.class, key);
    }

    public boolean isRecurring() {
        return this.getDataSetMaster().getBoolean("isrecurring");
    }

    public boolean isRecurringEnabled() {
        return !this.getDataSetMaster().getBoolean("isdraft");
    }

    public Date getReferenceDate() {
        return this.getDataSetMaster().getDate("sttrdate");
    }

    public BigDecimal getReferenceTotal() {
        return null;
    }

    public String getReferenceDesc() {
        return this.getDataSetMaster().getString("sttrnote");
    }

    public String getReferenceType() {
        return "STTR";
    }

    public String getReferenceNumber() {
        return this.getDataSetMaster().getString("sttrno");
    }

    public String getRecurringNumber() {
        return this.getDataSetMaster().getString("recurno");
    }

    class SttrDAdapter
    implements DataChangeListener {
        SttrDAdapter() {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (StTrTransCustom.this.sttrd.isBypass()) {
                return;
            }
            DataSet dsDetail = StTrTransCustom.this.getDataSetDetail();
            if (dataChangeEvent.getID() == 1 && dsDetail.isNull("sttrno")) {
                dsDetail.setString("sttrno", StTrTransCustom.this.getDataSetMaster().getString("sttrno"));
                dsDetail.setShort("sttrdno", (short)(dsDetail.getRow() + 1));
            }
        }

        public void postRow(DataChangeEvent event) throws Exception {
        }

        public void changed(DataSet dataSet, Column column, Variant variant) {
            if (column.getColumnName().equalsIgnoreCase("itemid")) {
                String itemid = dataSet.getString("itemid");
                if (ItemList.getInstance().isItemValid(itemid)) {
                    dataSet.setBigDecimal("qty", BigDecimal.valueOf(1L));
                    dataSet.setString("unit", ItemList.getInstance().getUnit1(itemid));
                }
            }
        }

        public void validate(DataSet dataSet, Column column, Variant variant) throws Exception, DataSetException {
        }
    }
}

