/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.aprpurcsalesttr.ui;

import com.bits.bee.aprpurcsalesttr.ui.dlg.DlgSOCustom;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.SOTrans;
import com.bits.bee.ui.FrmSO;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.JBCheckApprove;
import com.bits.bee.ui.myswing.JNoteBranch;
import com.bits.bee.ui.myswing.JTotal;
import com.bits.lib.dbswing.JBToolbar;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.security.BAuthMgr;
import com.borland.dbswing.JdbCheckBox;
import com.borland.dx.dataset.DataSet;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmSOCustom
extends FrmSO {
    private static Logger logger = LoggerFactory.getLogger(FrmSOCustom.class);
    private final LocaleInstance l = LocaleInstance.getInstance();
    private static final String OBJID = "815002";
    private JBCheckApprove jBCheckApprove1;
    private JBToolbar jBToolbar1;
    private JdbCheckBox chkIsDraft;
    private JPanel jPanelFooter;
    private JNoteBranch jNoteBranch1;
    private JTotal jTotal1;

    public FrmSOCustom() {
        this.init();
    }

    public FrmSOCustom(SOTrans sotrans) {
        super(sotrans);
        this.init();
    }

    public FrmSOCustom(boolean istaxed) {
        super(istaxed);
        this.init();
    }

    private void init() {
        this.jBCheckApprove1 = new JBCheckApprove();
        this.jBToolbar1 = this.getJBToolbarComponent((Container)((Object)this));
        this.chkIsDraft = this.getChkIsDraft((Container)((Object)this));
        this.jNoteBranch1 = this.getJNoteBranch((Container)((Object)this));
        this.jTotal1 = this.getJTotal((Container)((Object)this));
        this.jPanelFooter = (JPanel)this.jNoteBranch1.getParent();
        this.addJBCheckApprove();
        this.jBCheckApprove1.setDataSet(this.getSOTrans().getDataSetMaster());
        this.jBCheckApprove1.setEnable(false);
        this.jBCheckApprove1.setOpaque(false);
        this.jBToolbar1.setEnableSaveDraft(false);
        if (Reg.getInstance().getValueBoolean("APR_ENB_SO").booleanValue()) {
            this.jBCheckApprove1.setVisible(true);
            this.jBToolbar1.remove((Component)this.chkIsDraft);
        } else {
            this.jBCheckApprove1.setVisible(false);
        }
    }

    private void addJBCheckApprove() {
        this.jPanelFooter.add((Component)this.jBCheckApprove1);
        GroupLayout layout = (GroupLayout)this.jPanelFooter.getLayout();
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jNoteBranch1, -2, 243, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jBCheckApprove1, -2, 126, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jTotal1, -2, 245, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jNoteBranch1, -2, 92, -2).add((Component)this.jBCheckApprove1, -2, 36, -2).add((Component)this.jTotal1, -2, 92, -2));
        this.jPanelFooter.revalidate();
        this.jPanelFooter.repaint();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("state") && this.state.getState() == 2) {
            DataSet dsMaster = this.getSOTrans().getDataSetMaster();
            if (!dsMaster.getBoolean("isdraft") && "".equals(dsMaster.getString("aprby"))) {
                this.jBCheckApprove1.setEnable(true);
            } else if (!dsMaster.getBoolean("isdraft")) {
                this.jBCheckApprove1.setEnable(false);
            }
        }
    }

    public void doSave() {
        try {
            this.validateApproval();
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.save"), (Exception)ex, (Logger)logger);
            return;
        }
        super.doSave();
    }

    public void doOpen() {
        DlgSOCustom dlg = DlgSOCustom.getInstance();
        dlg.setTotalVisible(true);
        dlg.setXT(this.alwaysTaxed);
        dlg.setVisible(true);
        String retval = dlg.getSelectedID();
        this.OpenSO(retval);
    }

    public void siapkanReport() {
        if (this.checkApproval()) {
            super.siapkanReport();
        } else {
            UIMgr.showErrorDialog((String)"Order Penjualan belum diapprove !");
        }
    }

    private void validateApproval() throws Exception {
        DataSet dsMaster = this.getSOTrans().getDataSetMaster();
        if (!BAuthMgr.getDefault().getAuth(OBJID, "CHK") && !dsMaster.isNull("chkby")) {
            throw new Exception("Order Penjualan sudah dicheck dan Anda tidak punya hak akses !");
        }
        if (!BAuthMgr.getDefault().getAuth(OBJID, "APR") && !dsMaster.isNull("aprby")) {
            throw new Exception("Order Penjualan sudah diapprove dan Anda tidak punya hak akses !");
        }
        if (!"".equals(dsMaster.getString("aprby"))) {
            dsMaster.setBoolean("isdraft", false);
        } else {
            dsMaster.setBoolean("isdraft", true);
        }
    }

    private boolean checkApproval() {
        boolean status = false;
        if (Reg.getInstance().getValueBoolean("APR_ENB_SO").booleanValue()) {
            DataSet dsMaster = this.getSOTrans().getDataSetMaster();
            if (dsMaster.getString("aprby").length() > 0 || !"".equals(dsMaster.getString("aprby"))) {
                status = true;
            }
        } else {
            status = true;
        }
        return status;
    }

    private JBToolbar getJBToolbarComponent(Container comp) {
        for (Component c : comp.getComponents()) {
            JBToolbar creturn;
            if (c instanceof JBToolbar) {
                return (JBToolbar)c;
            }
            if (!(c instanceof Container) || (creturn = this.getJBToolbarComponent((Container)c)) == null) continue;
            return creturn;
        }
        return null;
    }

    private JdbCheckBox getChkIsDraft(Container comp) {
        for (Component c : comp.getComponents()) {
            JdbCheckBox creturn;
            if (c instanceof JdbCheckBox && "isdraft".equalsIgnoreCase(((JdbCheckBox)c).getColumnName())) {
                return (JdbCheckBox)c;
            }
            if (!(c instanceof Container) || (creturn = this.getChkIsDraft((Container)c)) == null) continue;
            return creturn;
        }
        return null;
    }

    private JNoteBranch getJNoteBranch(Container comp) {
        for (Component c : comp.getComponents()) {
            JNoteBranch creturn;
            if (c instanceof JNoteBranch) {
                return (JNoteBranch)c;
            }
            if (!(c instanceof Container) || (creturn = this.getJNoteBranch((Container)c)) == null) continue;
            return creturn;
        }
        return null;
    }

    private JTotal getJTotal(Container comp) {
        for (Component c : comp.getComponents()) {
            JTotal creturn;
            if (c instanceof JTotal) {
                return (JTotal)c;
            }
            if (!(c instanceof Container) || (creturn = this.getJTotal((Container)c)) == null) continue;
            return creturn;
        }
        return null;
    }

    public String getResourcesUI(String key) {
        return LocaleInstance.getInstance().getMessageUI(FrmSO.class, key);
    }

    public String getResourcesBL(String key) {
        return LocaleInstance.getInstance().getMessageBL(FrmSO.class, key);
    }

    public String getResourcesLib(String key) {
        return LocaleInstance.getInstance().getMessageLib(FrmSO.class, key);
    }
}

