/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.aprpurcsalesttr.ui.myswing;

import com.bits.bee.ui.UIMgr;
import com.bits.lib.abstraction.BUIResources;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JPanelChooserCustom
extends JPanel
implements ResourceGetter {
    LocaleInstance l = LocaleInstance.getInstance();
    FileFilter filter;
    String dotExtension;
    String filePath;
    Boolean stateWarning = false;
    String warningmessage = null;
    private JFileChooser fileChooser;
    private JButton jButton1;
    private JTextField txtPath;

    public JPanelChooserCustom() {
        this.initComponents();
        this.initLang();
        this.initChooser();
    }

    private void initChooser() {
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.setFileFilter("Jasper File", "jrxml");
    }

    private void initLang() {
        this.jButton1.setText(this.getResourcesUI("jButton1.text"));
    }

    public void setFileFilter(String title, String extension) {
        this.filter = this.createFileFilter(title, true, extension);
        this.fileChooser.setFileFilter(this.filter);
        this.dotExtension = "." + extension;
    }

    public void setFileFilter(String title, String extension, boolean deleteOld) {
        if (deleteOld) {
            this.fileChooser.resetChoosableFileFilters();
        }
        this.setFileFilter(title, extension);
    }

    private FileFilter createFileFilter(String description, boolean showExtensionInDescription, String ... extensions) {
        if (showExtensionInDescription) {
            description = this.createFileNameFilterDescriptionFromExtensions(description, extensions);
        }
        return new FileNameExtensionFilter(description, extensions);
    }

    private String createFileNameFilterDescriptionFromExtensions(String description, String[] extensions) {
        String fullDescription = description == null ? " ( " : description + " ( ";
        fullDescription = fullDescription + "." + extensions[0];
        for (int i = 1; i < extensions.length; ++i) {
            fullDescription = fullDescription + ", .";
            fullDescription = fullDescription + extensions[i];
        }
        fullDescription = fullDescription + " ) ";
        return fullDescription;
    }

    private void showChooser() {
        int retval = this.fileChooser.showDialog(this.getParent(), null);
        if (retval == 0) {
            this.setFileName(this.getFilePath());
        }
    }

    public void setFileName(String newValue) {
        String oldValue = this.txtPath.getText();
        if (newValue.indexOf(this.dotExtension) < 0) {
            newValue = newValue + this.dotExtension;
        }
        this.txtPath.setText(newValue);
        this.firePropertyChange("fileName", oldValue, newValue);
    }

    public String getFilePath() {
        String localFile = "";
        File file = this.fileChooser.getSelectedFile();
        if (file != null) {
            localFile = file.getPath();
        }
        if (localFile != null && localFile.length() > 0 && localFile.indexOf(this.dotExtension) < 0) {
            localFile = localFile + this.dotExtension;
        }
        return localFile;
    }

    public String getFileName() {
        String fileName = "";
        File file = this.fileChooser.getSelectedFile();
        if (file != null) {
            fileName = file.getName();
        }
        if (fileName != null && fileName.length() > 0 && fileName.indexOf(this.dotExtension) < 0) {
            fileName = fileName + this.dotExtension;
        }
        return fileName;
    }

    public String getFileParentDir() {
        File file = this.fileChooser.getSelectedFile();
        return file.getParent();
    }

    public JButton getBtnBrowse() {
        return this.jButton1;
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void resetChoosenFile() {
        this.txtPath.setText(null);
    }

    public void setStateWarning(boolean b) {
        this.stateWarning = b;
    }

    public void warning(String warningMessage) {
        this.warningmessage = warningMessage;
    }

    public void warning() {
        UIMgr.showMessageDialog((String)this.warningmessage, (Component)this);
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(this.getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(this.getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(this.getClass(), key);
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.txtPath = new JTextField();
        this.jButton1 = new JButton();
        this.txtPath.setFont(BUIResources.getDefaultFont());
        this.txtPath.setPreferredSize(new Dimension(4, 24));
        this.jButton1.setFont(BUIResources.getDefaultFontBold());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/browse.png")));
        this.jButton1.setText("Browse");
        this.jButton1.setPreferredSize(new Dimension(94, 24));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelChooserCustom.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.txtPath, -1, 178, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, -1, -2).addComponent(this.txtPath, -2, 27, -2));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.stateWarning.booleanValue()) {
            this.warning();
        }
        this.showChooser();
    }
}

