/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.argoxdoublerow;

import com.bits.bee.bl.Barcode;
import com.bits.bee.bl.BarcodeItem;
import com.bits.bee.ui.comm.ArgoxConstants;
import com.borland.dx.dataset.DataSet;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.standard.PrinterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgoxDesainerCustom {
    private static Logger logger = LoggerFactory.getLogger(ArgoxDesainerCustom.class);
    private int H_MARGIN = 10;
    private int H_BASE_REFERENCE_POINT;
    private int V_BASE_REFERENCE_POINT;
    private int START_COL;
    private int LABEL_COUNT;
    protected int REPORT_PAGE_WIDTH;
    protected int REPORT_PAGE_HEIGHT;
    protected int REPORT_LEFT_MARGIN;
    protected int REPORT_RIGHT_MARGIN;
    protected int REPORT_TOP_MARGIN;
    protected int REPORT_BOTTOM_MARGIN;
    protected int REPORT_HORIZONTAL_PITCH;
    protected int REPORT_VERTICAL_PITCH;
    protected int ROW_MAX;
    protected int COL_MAX;
    protected int FONT_SIZE;
    protected String BARCODE_TYPE;
    protected int LABEL_HEIGHT;
    protected int LABEL_WIDTH;
    protected int BARCODE_NARROW;
    protected int BARCODE_WIDTH;
    protected int BARCODE_HEIGHT;
    protected ComponentSize barcodeSize;
    protected ComponentSize barcodeImageSize;
    protected ComponentSize itemdescSize;
    protected ComponentSize priceSize;
    private BarcodeItem barcodeItem;
    NumberFormat formatter = new DecimalFormat("#,##0");
    public static int LIMIT_MINUS;
    public static int CURRENT_COL;
    public static int CURRENT_ROW;
    Barcode barcode;
    protected StringBuffer rptDesign;
    protected StringBuffer rptDesignItemDesc;
    private boolean showItemID;

    public ArgoxDesainerCustom(Barcode barcode) {
        this.barcode = barcode;
        this.initFieldSetting();
    }

    protected void initFieldSetting() {
        BigDecimal CM_TO_DOT = ArgoxConstants.CM_TO_INCH.multiply(ArgoxConstants.INCH_TO_MM).multiply(ArgoxConstants.DPMM);
        BigDecimal TWO = BigDecimal.ONE.add(BigDecimal.ONE);
        this.REPORT_PAGE_WIDTH = this.barcode.getDataSet().getBigDecimal("pagewidth").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        this.REPORT_PAGE_HEIGHT = this.barcode.getDataSet().getBigDecimal("pageheight").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        this.REPORT_LEFT_MARGIN = this.barcode.getDataSet().getBigDecimal("bottommargin").multiply(CM_TO_DOT).subtract(ArgoxConstants.ERROR_RANGE).setScale(0, 1).intValue();
        this.REPORT_RIGHT_MARGIN = this.barcode.getDataSet().getBigDecimal("topmargin").multiply(CM_TO_DOT).subtract(ArgoxConstants.ERROR_RANGE).setScale(0, 1).intValue();
        this.REPORT_TOP_MARGIN = this.barcode.getDataSet().getBigDecimal("leftmargin").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        this.REPORT_BOTTOM_MARGIN = this.barcode.getDataSet().getBigDecimal("rightmargin").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        this.REPORT_HORIZONTAL_PITCH = this.barcode.getDataSet().getBigDecimal("horizontalpitch").multiply(CM_TO_DOT).setScale(0, 1).intValue() + 4;
        this.REPORT_VERTICAL_PITCH = this.barcode.getDataSet().getBigDecimal("verticalpitch").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        this.ROW_MAX = this.barcode.getDataSet().getShort("rowmax");
        this.COL_MAX = this.barcode.getDataSet().getShort("colmax");
        this.FONT_SIZE = this.barcode.getDataSet().getShort("fontsize");
        this.BARCODE_NARROW = this.barcode.getDataSet().getShort("barcodenarrow");
        this.BARCODE_WIDTH = this.barcode.getDataSet().getShort("barcodewidth");
        this.BARCODE_HEIGHT = this.barcode.getDataSet().getShort("barcodeheight");
        this.BARCODE_TYPE = ArgoxConstants.getBarcodeType((String)this.barcode.getDataSet().getString("barcodetype"));
        this.LABEL_WIDTH = this.barcode.getBigDecimal("width").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        this.LABEL_HEIGHT = this.barcode.getBigDecimal("height").multiply(CM_TO_DOT).setScale(0, 1).intValue();
        BigDecimal PAGE_WIDTH = this.barcode.getDataSet().getBigDecimal("pagewidth").multiply(CM_TO_DOT).setScale(0, 1);
        BigDecimal RIGHT_MARGIN = this.barcode.getDataSet().getBigDecimal("rightmargin").multiply(CM_TO_DOT).subtract(ArgoxConstants.ERROR_RANGE).setScale(0, 1);
        this.H_BASE_REFERENCE_POINT = ArgoxConstants.MAX_PRINT_WIDTH.subtract(PAGE_WIDTH).divide(TWO, 0, 1).add(RIGHT_MARGIN).subtract(ArgoxConstants.ERROR_RANGE).add(TWO).intValue() + 4;
    }

    private void initComponentSize() {
        this.barcodeImageSize = new ComponentSize(this.LABEL_WIDTH, (this.LABEL_HEIGHT - 10) * 4 / 10);
        this.barcodeSize = new ComponentSize(this.LABEL_WIDTH, (this.LABEL_HEIGHT - 10) * 2 / 10);
        this.itemdescSize = new ComponentSize(this.LABEL_WIDTH, (this.LABEL_HEIGHT - 10) * 2 / 10);
        this.priceSize = new ComponentSize(this.LABEL_WIDTH, (this.LABEL_HEIGHT - 10) * 2 / 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDesign() {
        this.initComponentSize();
        int columnCounter = this.START_COL;
        int COL_COUNTER = 0;
        int LABEL_COUNTER = 0;
        String ESC = "\u001b";
        this.rptDesign = new StringBuffer();
        this.rptDesignItemDesc = new StringBuffer();
        short maxDesc = this.barcode.getShort("descsize");
        int halfmaxDesc = this.barcode.getShort("descsize") / 2;
        boolean begin = true;
        DataSet ds = this.barcodeItem.getDataSet();
        int bookmark = ds.getRow();
        String showItemIDCode = this.isShowItemID() ? "B" : "N";
        this.rptDesign.append(String.format("N\nFK\"TEST\"\nFS\"TEST\"\n", new Object[0]));
        CURRENT_ROW = 0;
        try {
            for (int i = 0; i < ds.getRowCount(); ++i) {
                ds.goToRow(i);
                int COUNT = this.LABEL_COUNT = ds.getBigDecimal("qty").intValue();
                boolean showPrice = ds.getBoolean("showprice");
                String barcode = ds.getString("barcode");
                String itemdesc = ds.getString("itemdesc");
                String itemid = ds.getString("itemid");
                if (maxDesc > 0 && itemdesc.length() > maxDesc) {
                    itemdesc = itemdesc.substring(0, maxDesc);
                }
                String listprice = this.formatter.format(ds.getBigDecimal("listprice").doubleValue());
                for (int j = 0; j < COUNT; ++j) {
                    this.rptDesign.append(String.format("V%d,10,N,\"\"\n", ++LABEL_COUNTER));
                    this.rptDesignItemDesc.append(String.format("%s\n", itemdesc));
                    this.rptDesign.append(String.format("A%s,%s,0,%d,1,1,N,V%d[0,%d]\n", this.REPORT_LEFT_MARGIN + (++COL_COUNTER - 1) * this.REPORT_HORIZONTAL_PITCH, this.REPORT_TOP_MARGIN + CURRENT_ROW * this.REPORT_VERTICAL_PITCH, 1, LABEL_COUNTER, halfmaxDesc));
                    this.rptDesign.append(String.format("A%s,%s,0,%d,1,1,N,V%d[%d,%d]\n", this.REPORT_LEFT_MARGIN + (COL_COUNTER - 1) * this.REPORT_HORIZONTAL_PITCH, this.REPORT_TOP_MARGIN + CURRENT_ROW * this.REPORT_VERTICAL_PITCH + 20, 1, LABEL_COUNTER, halfmaxDesc, (int)maxDesc));
                    this.rptDesign.append(String.format("B%s,%s,0,%s,%d,%d,%d,%s,\"%s\"\n", this.REPORT_LEFT_MARGIN + (COL_COUNTER - 1) * this.REPORT_HORIZONTAL_PITCH, 40 + this.REPORT_TOP_MARGIN + CURRENT_ROW * this.REPORT_VERTICAL_PITCH, this.BARCODE_TYPE, this.BARCODE_NARROW, this.BARCODE_WIDTH, this.BARCODE_HEIGHT, showItemIDCode, itemid));
                    if (showPrice) {
                        this.rptDesign.append(String.format("A%s,%s,0,%d,1,1,N,\"Rp. %s\"\n", this.REPORT_LEFT_MARGIN + (COL_COUNTER - 1) * this.REPORT_HORIZONTAL_PITCH, 100 + this.REPORT_TOP_MARGIN + CURRENT_ROW * this.REPORT_VERTICAL_PITCH, this.FONT_SIZE, listprice));
                    }
                    if (COL_COUNTER != this.COL_MAX) continue;
                    ++CURRENT_ROW;
                    COL_COUNTER = 0;
                }
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
        this.rptDesign.append("FE\nFR\"TEST\"\n?\n");
        this.rptDesign.append(this.rptDesignItemDesc);
        this.rptDesign.append(String.format("P1\n", new Object[0]));
    }

    public void testPreviewText() {
        this.prepareDesign();
        System.out.println("!!!!!!!!!!!!! Plugin !!!!!!!!!!!!!");
        System.out.println(this.rptDesign.toString());
    }

    public void printBarcode() {
        this.prepareDesign();
        try {
            PrintService psArgox = null;
            String sPrinterName = null;
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < services.length; ++i) {
                PrinterName attr = services[i].getAttribute(PrinterName.class);
                sPrinterName = attr.getValue();
                if (sPrinterName.toLowerCase().indexOf("argox") < 0) continue;
                psArgox = services[i];
                break;
            }
            if (psArgox == null) {
                System.out.println("Printer Argox tidak ditemukan");
                return;
            }
            DocPrintJob job = psArgox.createPrintJob();
            byte[] by = this.rptDesign.toString().getBytes();
            DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            SimpleDoc doc = new SimpleDoc(by, flavor, null);
            job.print(doc, null);
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sumColumnValue(DataSet ds, String columnName) {
        int retval = 0;
        int bookmark = ds.getRow();
        try {
            for (int i = 0; i < ds.getRowCount(); ++i) {
                ds.goToRow(i);
                retval += ds.getBigDecimal(columnName).intValue();
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
        return retval;
    }

    public void setH_BASE_REFERENCE_POINT(int H_BASE_REFERENCE_POINT) {
        this.H_BASE_REFERENCE_POINT = H_BASE_REFERENCE_POINT;
    }

    public void setV_BASE_REFERENCE_POINT(int V_BASE_REFERENCE_POINT) {
        this.V_BASE_REFERENCE_POINT = V_BASE_REFERENCE_POINT;
    }

    public void setSTART_COL(int START_COL) {
        this.START_COL = START_COL;
    }

    public void setLABEL_COUNT(int LABEL_COUNT) {
        this.LABEL_COUNT = LABEL_COUNT;
    }

    public String getFourDigitCode(int value) {
        String valueString = "" + value;
        for (int valueLength = valueString.length(); valueLength < 4; ++valueLength) {
            valueString = "0" + valueString;
        }
        return valueString;
    }

    public String getThreeDigitCode(int value) {
        String valueString = "" + value;
        for (int valueLength = valueString.length(); valueLength < 3; ++valueLength) {
            valueString = "0" + valueString;
        }
        return valueString;
    }

    public String getTwoDigitCode(int value) {
        String valueString = "" + value;
        for (int valueLength = valueString.length(); valueLength < 2; ++valueLength) {
            valueString = "0" + valueString;
        }
        return valueString;
    }

    public void setBarcodeItem(BarcodeItem barcodeItem) {
        this.barcodeItem = barcodeItem;
    }

    private String getUCC128Code(String BARCODE_TYPE) {
        String retval = "";
        if (BARCODE_TYPE.equals("0")) {
            retval = "2";
        }
        return retval;
    }

    private int getFontSizeCode() {
        if (this.FONT_SIZE >= 4) {
            if (this.FONT_SIZE == 4) {
                return (this.FONT_SIZE - 1) * 100 + this.FONT_SIZE;
            }
            return this.FONT_SIZE * 100 + this.FONT_SIZE;
        }
        return 202;
    }

    public boolean isShowItemID() {
        return this.showItemID;
    }

    public void setShowItemID(boolean showItemID) {
        this.showItemID = showItemID;
    }

    protected class ComponentSize {
        private int width;
        private int height;

        public ComponentSize(int width, int height) {
            this.width = width;
            this.height = height;
            System.out.println("H : " + height + " -> W : " + width);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

