/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.bl.BPAddressList;
import com.bits.bee.bl.BPList;
import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.bl.Reg;
import com.bits.bee.conf.InstanceMgr;
import com.bits.lib.BHelp;
import com.bits.lib.BThread;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BQuery;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ReadRow;
import java.sql.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPListBengkel
extends BQuery
implements InstanceObserver,
BThread {
    private static Logger logger = LoggerFactory.getLogger(BPList.class);
    private static BPListBengkel singleton = null;
    private DataRow lookuprow;
    private DataRow lookupBCRow;
    private String[] lookupBC = new String[]{"bpid", "crcid"};
    private DataRow resultrow;
    private String prclvlid_default;
    private boolean isCached = Reg.getInstance().getValueBooleanDefaultTrue("CACHEDLIST");
    private boolean isLoadedOnInstance = false;
    private Thread instanceThread;

    public BPListBengkel() {
        super(BDM.getDefault());
        String localBaseSQL = "SELECT bp.bpid, bpname, bpgrpid, prclvlid, srepid, taxregno, vatregno, vatregdate, purcistaxed, purctaxinc, purctaxid, saleistaxed, saletaxinc, saletaxid, carid, carnopol,carkm,problem, acc.crcid, acc.saletermtype, acc.purctermtype, acc.accar, acc.arduedays, acc.ardiscdays, acc.arearlydisc, acc.arlatecharge, acc.accap, acc.apduedays, acc.apdiscdays, acc.apearlydisc, acc.apLatecharge, acc.isdefault FROM bp LEFT JOIN bpacc acc ON bp.bpid=acc.bpid LEFT JOIN car ON bp.bpid=car.bpid";
        this.setBaseSQL(localBaseSQL);
        this.setSQL(localBaseSQL);
        this.prclvlid_default = Reg.getInstance().getValueString("PRCLVL_DEFAULT");
        this.dataset.open();
    }

    public static synchronized BPListBengkel getInstance() {
        if (singleton == null) {
            singleton = new BPListBengkel();
            if (Reg.getInstance().getValueBooleanDefaultTrue("CACHEDLIST").booleanValue()) {
                singleton.Load();
                BPListBengkel.singleton.isLoadedOnInstance = true;
            }
            InstanceMgr.getInstance().addObserver((InstanceObserver)singleton);
        }
        if (BPListBengkel.singleton.instanceThread != null) {
            while (BPListBengkel.singleton.instanceThread.isAlive()) {
            }
        }
        return singleton;
    }

    public void Load() {
        this.instanceThread = new Thread((Runnable)((Object)this));
        this.instanceThread.start();
    }

    public int getRowCount() {
        this.Load();
        return this.dataset.getRowCount();
    }

    private boolean isMatchLastResult(String bpid) {
        return this.resultrow != null && bpid != null && this.resultrow.getString("bpid").equalsIgnoreCase(bpid);
    }

    private boolean isMatchLastResult(String bpid, String crcid) {
        return this.resultrow != null && bpid != null && crcid != null && bpid.equals(this.resultrow.getString("bpid")) && crcid.equals(this.resultrow.getString("crcid"));
    }

    private boolean lookup(String bpid) {
        if (this.isMatchLastResult(bpid)) {
            return true;
        }
        if (!this.isCached) {
            this.queryBP(bpid);
        }
        this.lookuprow.setString("bpid", bpid);
        return this.dataset.lookup((ReadRow)this.lookuprow, this.resultrow, 32);
    }

    private boolean lookup(String bpid, String crcid) {
        if (this.isMatchLastResult(bpid, crcid)) {
            return true;
        }
        if (!this.isCached) {
            this.queryBP(bpid, crcid);
        }
        if (null != crcid && crcid.length() > 0) {
            this.lookupBCRow.setString("bpid", bpid);
            this.lookupBCRow.setString("crcid", crcid);
            return this.dataset.lookup((ReadRow)this.lookupBCRow, this.resultrow, 32);
        }
        DataRow localLookup = new DataRow((DataSet)this.dataset, new String[]{"bpid", "isdefault"});
        localLookup.setBoolean("isdefault", true);
        localLookup.setString("bpid", bpid);
        return this.dataset.lookup((ReadRow)localLookup, this.resultrow, 32);
    }

    public void queryBP(String bpid) {
        String filter = String.format("UPPER(bp.BPID) LIKE UPPER('%s')", bpid);
        StringBuffer buf = new StringBuffer(this.basesql);
        StringBuffer filt = new StringBuffer(filter);
        JBSQL.setWHERE((StringBuffer)buf, (StringBuffer)filt);
        this.setSQL(buf.toString());
        this.open();
        this.lookuprow = new DataRow((DataSet)this.dataset, "bpid");
        this.resultrow = new DataRow((DataSet)this.dataset);
    }

    private void queryBP(String bpid, String crcid) {
        String filter = String.format("UPPER(bp.BPID) LIKE UPPER('%s') AND acc.crcid=%s", bpid, BHelp.QuoteSingle((String)crcid));
        StringBuffer buf = new StringBuffer(this.basesql);
        StringBuffer filt = new StringBuffer(filter);
        JBSQL.setWHERE((StringBuffer)buf, (StringBuffer)filt);
        this.setSQL(buf.toString());
        this.open();
        this.lookuprow = new DataRow((DataSet)this.dataset, "bpid");
        this.lookupBCRow = new DataRow((DataSet)this.dataset, this.lookupBC);
        this.resultrow = new DataRow((DataSet)this.dataset);
    }

    public String getString(String field, String id) {
        if (this.isCached) {
            if (this.lookup(id)) {
                return this.resultrow.getString(field);
            }
            return null;
        }
        this.queryBP(id);
        return this.dataset.getString(field);
    }

    public String getBPName(String bpid) {
        return this.getString("bpname", bpid);
    }

    public String getPrcLvlID(String bpid) {
        if (this.lookup(bpid)) {
            if (!this.resultrow.isNull("prclvlid")) {
                return this.resultrow.getString("prclvlid");
            }
            return this.prclvlid_default;
        }
        return null;
    }

    public String getBPGrpID(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getString("bpgrpid");
        }
        return null;
    }

    public boolean isBPValid(String bpid) {
        return this.lookup(bpid);
    }

    public String getShipto(String bpid) {
        return BPAddressList.getInstance().getShipTo(bpid);
    }

    public String getBillto(String bpid) {
        return BPAddressList.getInstance().getBillTo(bpid);
    }

    public boolean getPurcIsTaxed(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getBoolean("purcistaxed");
        }
        return false;
    }

    public boolean getSaleIsTaxed(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getBoolean("saleistaxed");
        }
        return false;
    }

    public boolean getPurcTaxInc(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getBoolean("purctaxinc");
        }
        return false;
    }

    public boolean getSaleTaxInc(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getBoolean("saletaxinc");
        }
        return false;
    }

    public String getCrcID(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getString("crcid");
        }
        return null;
    }

    public String getTaxRegNo(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getString("taxregno");
        }
        return null;
    }

    public String getVatRegNo(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getString("vatregno");
        }
        return null;
    }

    public Date getVatRegDate(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow.getDate("vatregdate");
        }
        return null;
    }

    public DataRow getSale_BPIDChanged(String bpid) {
        if (this.lookup(bpid)) {
            return this.resultrow;
        }
        return null;
    }

    public DataRow getSale_BPIDChanged(String bpid, String crcid) {
        if (this.lookup(bpid, crcid)) {
            return this.resultrow;
        }
        return null;
    }

    public String getAccAP(String bpid, String crcid) {
        if (this.lookup(bpid, crcid)) {
            return this.resultrow.getString("accap");
        }
        return null;
    }

    public String getAccAR(String bpid, String crcid) {
        if (this.lookup(bpid, crcid)) {
            return this.resultrow.getString("accar");
        }
        return null;
    }

    public String getBPIDFromLastResult() {
        if (this.resultrow != null) {
            return this.resultrow.getString("bpid");
        }
        return null;
    }

    public String getBPShipCode(String bpid) {
        return this.getString("bpshipcode", bpid);
    }

    public String getBPNote(String bpid) {
        return this.getString("bpnote", bpid);
    }

    public void resetLastResult() {
        this.resultrow = new DataRow((DataSet)this.dataset);
    }

    public void doUpdate() {
        singleton = null;
    }

    public void loadingProcess() {
        if (this.isCached && !this.isLoadedOnInstance) {
            this.open();
            this.lookuprow = new DataRow((DataSet)this.dataset, "bpid");
            this.lookupBCRow = new DataRow((DataSet)this.dataset, this.lookupBC);
            this.resultrow = new DataRow((DataSet)this.dataset);
        }
        this.isLoadedOnInstance = false;
    }

    public void run() {
        this.loadingProcess();
    }
}

