/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.bl.abstraction.CachingProcess;
import com.bits.bee.conf.InstanceMgr;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;

public class BillSaleList
implements CachingProcess,
InstanceObserver {
    private QueryDataSet qds = new QueryDataSet();
    private QueryDataSet qdsSingle = new QueryDataSet();
    private DataRow lookupRow;
    private DataRow resultRow;
    private String lookupCols = "saleno";
    private static BillSaleList singleton;

    public static synchronized BillSaleList getInstance() {
        if (null == singleton) {
            singleton = new BillSaleList();
            singleton.doLoadList();
            InstanceMgr.getInstance().addObserver((InstanceObserver)singleton);
        }
        return singleton;
    }

    public void doCache() {
        BillSaleList.getInstance().doLoadList();
    }

    public void doUpdate() {
        singleton = null;
    }

    private void doLoadList() {
        String query = "Select billsale.saleno,billsale.billno, bill.* from billsale LEFT JOIN bill ON bill.billno=billsale.billno LEFT JOIN sale ON billsale.saleno=sale.saleno";
        try {
            if (this.qds.isOpen()) {
                this.qds.close();
            }
            this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), query));
            this.qds.open();
            this.lookupRow = new DataRow((DataSet)this.qds, this.lookupCols);
            this.resultRow = new DataRow((DataSet)this.qds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BigDecimal getCarKm(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.carkm from billsale LEFT JOIN bill ON bill.billno=billsale.billno WHERE saleno = " + BHelp.QuoteSingle((String)saleno));
        BigDecimal retval = new BigDecimal(0);
        if (null != this.lookupRow && null != this.resultRow && saleno != null) {
            this.lookupRow.setString("saleno", saleno);
            if (this.qds.lookup((ReadRow)this.lookupRow, this.resultRow, 32)) {
                retval = this.resultRow.getBigDecimal("carkm");
            } else {
                if (this.qdsSingle.isOpen()) {
                    this.qdsSingle.close();
                }
                this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
                this.qdsSingle.open();
                retval = this.qdsSingle.getBigDecimal("carkm");
            }
        }
        return retval;
    }

    public String getProblem(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.problem from billsale LEFT JOIN bill ON bill.billno=billsale.billno WHERE saleno = " + BHelp.QuoteSingle((String)saleno));
        String retval = null;
        if (null != this.lookupRow && null != this.resultRow && saleno != null) {
            this.lookupRow.setString("saleno", saleno);
            if (this.qds.lookup((ReadRow)this.lookupRow, this.resultRow, 32)) {
                retval = this.resultRow.getString("problem");
            } else {
                if (this.qdsSingle.isOpen()) {
                    this.qdsSingle.close();
                }
                this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
                this.qdsSingle.open();
                retval = this.qdsSingle.getString("problem");
            }
        }
        return retval;
    }

    public String getNopol(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.carnopol from billsale LEFT JOIN bill ON bill.billno=billsale.billno WHERE saleno = " + BHelp.QuoteSingle((String)saleno));
        String retval = null;
        if (null != this.lookupRow && null != this.resultRow && saleno != null) {
            this.lookupRow.setString("saleno", saleno);
            if (this.qds.lookup((ReadRow)this.lookupRow, this.resultRow, 32)) {
                retval = this.resultRow.getString("carnopol");
            } else {
                if (this.qdsSingle.isOpen()) {
                    this.qdsSingle.close();
                }
                this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
                this.qdsSingle.open();
                retval = this.qdsSingle.getString("carnopol");
            }
        }
        return retval;
    }

    public Date getBillOutDate(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.billoutdate, billsale.billno from billsale LEFT JOIN bill ON bill.billno=billsale.billno LEFT JOIN sale ON billsale.saleno=sale.saleno WHERE billsale.saleno = " + BHelp.QuoteSingle((String)saleno));
        Date retval = null;
        if (this.qdsSingle.isOpen()) {
            this.qdsSingle.close();
        }
        this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
        this.qdsSingle.open();
        retval = this.qdsSingle.getString("billno") != null && this.qdsSingle.getString("billno").length() > 0 ? this.qdsSingle.getDate("billoutdate") : null;
        return retval;
    }

    public Date getBillDate(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.billdate, billsale.billno from billsale LEFT JOIN bill ON bill.billno=billsale.billno LEFT JOIN sale ON billsale.saleno=sale.saleno WHERE billsale.saleno = " + BHelp.QuoteSingle((String)saleno));
        Date retval = null;
        if (null != this.lookupRow && null != this.resultRow && saleno != null) {
            this.lookupRow.setString("saleno", saleno);
            if (this.qds.lookup((ReadRow)this.lookupRow, this.resultRow, 32)) {
                retval = this.resultRow.getString("billno") != null && this.resultRow.getString("billno").length() > 0 ? this.resultRow.getDate("billdate") : null;
            } else {
                if (this.qdsSingle.isOpen()) {
                    this.qdsSingle.close();
                }
                this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
                this.qdsSingle.open();
                retval = this.qdsSingle.getString("billno") != null && this.qdsSingle.getString("billno").length() > 0 ? this.qdsSingle.getDate("billdate") : null;
            }
        }
        return retval;
    }

    public Time getBillArrivetime(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.arrivetime from billsale LEFT JOIN bill ON bill.billno=billsale.billno WHERE saleno = " + BHelp.QuoteSingle((String)saleno));
        Time retval = null;
        if (null != this.lookupRow && null != this.resultRow && saleno != null) {
            this.lookupRow.setString("saleno", saleno);
            if (this.qds.lookup((ReadRow)this.lookupRow, this.resultRow, 32)) {
                retval = this.resultRow.getTime("arrivetime");
            } else {
                if (this.qdsSingle.isOpen()) {
                    this.qdsSingle.close();
                }
                this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
                this.qdsSingle.open();
                retval = this.qdsSingle.getTime("arrivetime");
            }
        }
        return retval;
    }

    public Time getBillLeavetime(String saleno) {
        StringBuilder querySingle = new StringBuilder("Select bill.leavetime from billsale LEFT JOIN bill ON bill.billno=billsale.billno WHERE saleno = " + BHelp.QuoteSingle((String)saleno));
        Time retval = null;
        if (this.qdsSingle.isOpen()) {
            this.qdsSingle.close();
        }
        this.qdsSingle.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), querySingle.toString()));
        this.qdsSingle.open();
        retval = this.qdsSingle.getTime("leavetime");
        return retval;
    }
}

