/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.swing.appointment;

import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.CalendarListModel;
import com.bits.bee.ui.myswing.JBCalendar;
import com.bits.bee.ui.myswing.JBCalendarPnlButton;
import com.bits.bee.ui.myswing.PanelPage;
import com.bits.beebengkel.swing.appointment.CalendarListenerApp;
import com.bits.beebengkel.swing.appointment.JBCalendarPnlButtonApp;
import com.bits.beebengkel.swing.appointment.PnlApp;
import com.bits.beebengkel.swing.appointment.PnlButtonListenerApp;
import com.bits.lib.BHelp;
import com.bits.lib.DateDif;
import com.bits.lib.dx.BDM;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dbswing.JdbList;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import com.toedter.calendar.JMonthChooser;
import com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBCalendarAppointment
extends JPanel
implements CalendarListenerApp,
PnlButtonListenerApp,
ResourceGetter {
    private LocaleInstance l = LocaleInstance.getInstance();
    private static Logger logger = LoggerFactory.getLogger(JBCalendarAppointment.class);
    private int CALENDAR_HEIGHT;
    private int CALENDAR_WIDTH;
    private Calendar calendar;
    private Calendar tempCalendar;
    private Calendar genCalendar = new GregorianCalendar();
    private Calendar helpCalendar;
    private java.util.Date startDate;
    private java.util.Date endDate;
    private int month;
    private int year;
    private int date;
    private int minDays;
    private int maxDate;
    private int dateNow;
    private int monthNow;
    private int yearNow;
    private int now;
    private JBCalendarPnlButtonApp[][] btnArray;
    private JLabel[] daysLabel;
    private static String[] days = new String[]{"Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"};
    private JPanel panelDays;
    private JPanel panelDates;
    private JButton btn = new JButton();
    private JBCalendarPnlButtonApp calBtn = new JBCalendarPnlButtonApp();
    private boolean doPropertyChange = true;
    private JLabel label;
    private static final SimpleDateFormat calendarFormat = new SimpleDateFormat("EEEE, dd MMMM yyyy");
    private QueryDataSet qds = new QueryDataSet();
    private QueryDataSet qdsDate = new QueryDataSet();
    private HashMap<Integer, HashMap<String, StringBuffer>> eventMap = new HashMap();
    private HashMap<Integer, ArrayList<String>> todoMap = new HashMap();
    private Integer key;
    String[] bufPiutang;
    CalendarListModel calendarList = new CalendarListModel();
    private JButton btnLeft;
    private JButton btnRight;
    private JButton btnToday;
    private JMonthChooser jMonthChooser1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JYearChooser jYearChooser1;
    private JdbList jdbList1;
    private PanelPage panelPage1;
    private PnlApp pnlApp1;
    private JPanel pnlCalendar;
    private JPanel pnlControl;
    private JPanel pnlList;

    public JBCalendarAppointment() {
        this.initComponents();
        this.jMonthChooser1.setFont(new Font("Dialog", 1, 9));
        this.jYearChooser1.setFont(new Font("Dialog", 1, 9));
        this.startDate = new java.util.Date();
        this.endDate = new java.util.Date();
        this.initForm();
        this.setNow();
    }

    private void showTodoPanel(boolean show) {
    }

    private void initLang() {
        this.btnToday.setText(this.getResourcesUI("btnToday.text"));
    }

    public JBCalendarPnlButtonApp[][] getCalendarPnlButton() {
        return this.btnArray;
    }

    private void loadDate() throws Exception {
        StringBuilder sql = new StringBuilder("Select distinct appdate from appoint WHERE appdate >= " + BHelp.QuoteDate((java.util.Date)this.startDate) + " AND " + "appdate <= " + BHelp.QuoteDate((java.util.Date)this.endDate));
        StringBuilder filter = new StringBuilder();
        StringBuilder my = new StringBuilder();
        if (this.qdsDate.isOpen()) {
            this.qdsDate.close();
        }
        this.qdsDate.setAllRowIds(true);
        this.qdsDate.setMetaDataUpdate(0);
        this.qdsDate.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qdsDate.open();
    }

    private void loadEvent(Date date) throws Exception {
        StringBuilder sql = new StringBuilder("Select appdate,bpname, cast(starttime as Varchar) as start,appid From appoint LEFT JOIN bp ON appoint.custid = bp.bpid WHERE appdate = " + BHelp.QuoteDate((java.util.Date)date) + " Order by appdate asc");
        StringBuilder filter = new StringBuilder();
        StringBuilder my = new StringBuilder();
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setAllRowIds(true);
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
    }

    private void setYear(int year) {
        this.calendar.set(year, this.month, this.date);
        this.now = 0;
        this.tempCalendar.set(year, this.month, 1);
        this.setCalendar();
        if (this.isDateNow()) {
            this.label.setText(this.getResourcesUI("label.text.todaydate") + calendarFormat.format(this.tempCalendar.getTime()));
        } else {
            this.label.setText(this.getResourcesUI("label.text.date") + calendarFormat.format(this.tempCalendar.getTime()));
        }
    }

    private void setMonth(int month) {
        this.calendar.setTime(DateDif.getMonthBefore((java.util.Date)this.calendar.getTime(), (int)(month - this.month)));
        this.now = 0;
        this.tempCalendar.set(this.year, month, 1);
        this.setCalendar();
        if (this.isDateNow()) {
            this.label.setText(this.getResourcesUI("label.text.todaydate") + calendarFormat.format(this.tempCalendar.getTime()));
        } else {
            this.label.setText(this.getResourcesUI("label.text.date") + calendarFormat.format(this.tempCalendar.getTime()));
        }
    }

    public void setNow() {
        GregorianCalendar cal = new GregorianCalendar();
        this.now = cal.get(5);
        this.dateNow = cal.get(5);
        this.monthNow = cal.get(2);
        this.yearNow = cal.get(1);
        this.setCalendar(cal);
    }

    private boolean isNow() {
        return this.month == this.monthNow && this.year == this.yearNow;
    }

    private boolean isDateNow() {
        return this.isDateNow(this.date, this.month, this.year);
    }

    private boolean isDateNow(int date, int month, int year) {
        return date == this.dateNow && month == this.monthNow && year == this.yearNow;
    }

    private void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.setCalendar();
    }

    private void setCalendar() {
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        this.date = this.calendar.get(5);
        this.minDays = DateDif.getDay((java.util.Date)DateDif.getFirstDate((java.util.Date)this.calendar.getTime()));
        this.maxDate = DateDif.getDayofMonth((java.util.Date)this.calendar.getTime()) + this.minDays;
        if (this.isNow()) {
            this.now = this.dateNow;
        }
        this.helpCalendar.set(this.year, this.month, 1);
        this.startDate = this.helpCalendar.getTime();
        this.helpCalendar.set(this.year, this.month, DateDif.getDayofMonth((java.util.Date)this.calendar.getTime()));
        this.endDate = this.helpCalendar.getTime();
        this.drawCalendar();
    }

    private void initForm() {
        int i;
        this.tempCalendar = new GregorianCalendar();
        this.helpCalendar = new GregorianCalendar();
        this.label = new JLabel();
        this.label.setText("Ini Label");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add(this.label);
        this.daysLabel = new JLabel[7];
        this.btnArray = new JBCalendarPnlButtonApp[6][7];
        for (i = 0; i < this.daysLabel.length; ++i) {
            JLabel localLabel = new JLabel(days[i]);
            localLabel.setBorder(BorderFactory.createEtchedBorder());
            localLabel.setBackground(new Color(153, 153, 255));
            localLabel.setHorizontalAlignment(0);
            this.daysLabel[i] = localLabel;
        }
        for (i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                JBCalendarPnlButtonApp button = new JBCalendarPnlButtonApp();
                if (j == 0) {
                    button.setDateForeground(Color.RED);
                } else {
                    button.setDateForeground(Color.BLUE);
                }
                button.setPnlButtonListener(this);
                button.setCalendarListener(this);
                this.btnArray[i][j] = button;
            }
        }
        this.panelDays = new JPanel();
        this.panelDays.setLayout(new GridLayout(0, 7, 1, 1));
        this.panelDates = new JPanel();
        this.panelDates.setLayout(new GridLayout(0, 7, 1, 1));
        this.pnlCalendar.setLayout(new BorderLayout());
        this.pnlCalendar.add((Component)this.panelDays, "North");
        this.pnlCalendar.add((Component)this.panelDates, "Center");
        for (i = 0; i < this.daysLabel.length; ++i) {
            this.daysLabel[i].setFont(new Font("Dialog", 1, 10));
            if (i == 0) {
                this.daysLabel[i].setForeground(Color.RED);
            } else {
                this.daysLabel[i].setForeground(Color.BLUE);
            }
            this.panelDays.add(this.daysLabel[i]);
        }
        for (i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.panelDates.add(this.btnArray[i][j]);
            }
        }
        this.panelPage1.setDataset(this.pnlApp1.getDataSet());
    }

    private void drawCalendar() {
        int i;
        try {
            this.loadDate();
            this.eventMap.clear();
            for (int x = 0; x < this.qdsDate.rowCount(); ++x) {
                StringBuilder sb = new StringBuilder();
                this.qdsDate.goToRow(x);
                this.loadEvent(this.qdsDate.getDate(0));
                for (i = 0; i < this.qds.getRowCount(); ++i) {
                    this.qds.goToRow(i);
                    sb.append(this.qds.getDate(0).toString() + ",@," + this.qds.getString(1) + ":" + this.qds.getString(2) + "," + this.qds.getString(3) + "\\");
                }
                this.parseEvent(sb.toString());
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.getResourcesUI("ex.load"), (Exception)ex, (Component)this, (Logger)logger);
        }
        int counter = 0;
        int dayCounter = 0;
        for (i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (++counter > this.minDays && counter <= this.maxDate) {
                    this.btnArray[i][j].getHTMLGenerator().resetData();
                    Integer localKey = ++dayCounter;
                    if (j == 0) {
                        this.btnArray[i][j].setDateForeground(Color.RED);
                    } else {
                        this.btnArray[i][j].setDateForeground(Color.BLUE);
                    }
                    if (this.eventMap.containsKey(localKey) && this.eventMap.get(localKey).containsKey("@")) {
                        this.btnArray[i][j].getHTMLGenerator().setDivAppointment(this.eventMap.get(localKey).get("@"));
                        if (this.todoMap.containsKey(localKey)) {
                            boolean first = true;
                            int loop = this.todoMap.get(localKey).size();
                            for (int z = 0; z < loop; ++z) {
                                if (first) {
                                    this.btnArray[i][j].setListTodo(new StringBuffer());
                                    this.btnArray[i][j].getListTodo().append("(");
                                    this.btnArray[i][j].getListTodo().append(BHelp.QuoteSingle((String)this.todoMap.get(localKey).get(z)));
                                    first = false;
                                    continue;
                                }
                                this.btnArray[i][j].getListTodo().append(",").append(BHelp.QuoteSingle((String)this.todoMap.get(localKey).get(z)));
                            }
                            this.btnArray[i][j].getListTodo().append(")");
                        }
                    }
                    this.btnArray[i][j].setText("" + dayCounter);
                    this.genCalendar.set(this.year, this.month, dayCounter);
                    this.btnArray[i][j].setDate(dayCounter);
                    this.btnArray[i][j].setSqlDate(new Date(this.genCalendar.getTime().getTime()));
                    this.btnArray[i][j].setEnabledPanel(true);
                    this.btnArray[i][j].setBackground(this.calBtn.getBackground());
                    this.btnArray[i][j].setDateBackground(this.calBtn.getBackground());
                    this.btnArray[i][j].setEventBackground(this.calBtn.getBackground());
                    this.btnArray[i][j].setIsNow(false);
                    if (dayCounter != this.now) continue;
                    this.btnArray[i][j].doClick();
                    this.btnArray[i][j].setIsNow(true);
                    this.btnArray[i][j].setBackground(JBCalendarPnlButton.FOCUS_COLOR);
                    this.btnArray[i][j].setDateBackground(JBCalendarPnlButton.FOCUS_COLOR);
                    this.btnArray[i][j].setEventBackground(JBCalendarPnlButton.FOCUS_COLOR);
                    continue;
                }
                this.btnArray[i][j].setText("");
                this.btnArray[i][j].setDate(0);
                this.btnArray[i][j].setEnabledPanel(false);
                this.btnArray[i][j].setIsNow(false);
                this.btnArray[i][j].setBackground(this.calBtn.getBackground());
                this.btnArray[i][j].setDateBackground(this.calBtn.getBackground());
                this.btnArray[i][j].setEventBackground(this.calBtn.getBackground());
            }
        }
    }

    private void parseEvent(String event) {
        StringTokenizer token = new StringTokenizer(event, "\\");
        while (token.hasMoreTokens()) {
            String nextToken = token.nextToken();
            String[] split = nextToken.split(",");
            split[0] = split[0].substring(8, split[0].length());
            this.key = Integer.parseInt(split[0]);
            if (!this.eventMap.containsKey(this.key)) {
                this.eventMap.put(this.key, new HashMap());
                if (split[1].equals("@")) {
                    this.todoMap.put(this.key, new ArrayList());
                    this.todoMap.get(this.key).add(split[3]);
                }
                if (!this.eventMap.get(this.key).containsKey(split[1])) {
                    this.eventMap.get(this.key).put(split[1], new StringBuffer());
                    this.eventMap.get(this.key).get(split[1]).append(split[1]).append(" ").append(split[2]).append(".\n");
                    continue;
                }
                this.eventMap.get(this.key).get(split[1]).append(split[1]).append(" ").append(split[2]).append(".\n");
                continue;
            }
            if (split[1].equals("@")) {
                if (this.todoMap.get(this.key) == null) {
                    this.todoMap.put(this.key, new ArrayList());
                }
                this.todoMap.get(this.key).add(split[3]);
            }
            if (!this.eventMap.get(this.key).containsKey(split[1])) {
                this.eventMap.get(this.key).put(split[1], new StringBuffer());
                this.eventMap.get(this.key).get(split[1]).append(split[1]).append(" ").append(split[2]).append(".\n");
                continue;
            }
            this.eventMap.get(this.key).get(split[1]).append(split[1]).append(" ").append(split[2]).append(".\n");
        }
    }

    private void updateListModel(JBCalendarPnlButtonApp btn) {
        this.bufPiutang = btn.getHTMLGenerator().getDivAppointment().split(".\n");
        boolean first = true;
        ArrayList<String> vectorList = new ArrayList<String>();
        for (int i = 0; i < this.bufPiutang.length; ++i) {
            if (this.bufPiutang[i] == null || this.bufPiutang[i].length() <= 0) continue;
            if (first) {
                vectorList.add("Appointment");
                first = false;
            }
            vectorList.add("  " + this.bufPiutang[i]);
        }
        first = true;
        this.calendarList.setModel(vectorList);
        if (btn.getListTodo().length() > 0) {
            this.pnlApp1.doLoad(String.format("appid IN %s", btn.getListTodo().toString()));
        } else {
            this.pnlApp1.getDataSet().emptyAllRows();
        }
    }

    private void updateDataView() {
        for (int i = 0; i < this.btnArray.length; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (this.btnArray[i][j].getDate() <= 0) continue;
                this.btnArray[i][j].updateText(true);
            }
        }
    }

    private void initComponents() {
        this.pnlControl = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jMonthChooser1 = new JMonthChooser();
        this.jYearChooser1 = new JYearChooser();
        this.jPanel1 = new JPanel();
        this.btnRight = new JButton();
        this.btnLeft = new JButton();
        this.btnToday = new JButton();
        this.pnlList = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jdbList1 = new JdbList();
        this.panelPage1 = new PanelPage();
        this.pnlApp1 = new PnlApp();
        this.pnlCalendar = new JPanel();
        this.pnlControl.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel3.setBackground(new Color(204, 204, 255));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 278, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jMonthChooser1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JBCalendarAppointment.this.jMonthChooser1PropertyChange(evt);
            }
        });
        this.jYearChooser1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JBCalendarAppointment.this.jYearChooser1PropertyChange(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.jMonthChooser1, -2, -1, -2).addGap(0, 0, 0).addComponent((Component)this.jYearChooser1, -2, -1, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jMonthChooser1, -2, -1, -2).addComponent((Component)this.jYearChooser1, -2, -1, -2));
        this.btnRight.setFont(new Font("Dialog", 1, 9));
        this.btnRight.setText(">");
        this.btnRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBCalendarAppointment.this.btnRightActionPerformed(evt);
            }
        });
        this.btnLeft.setFont(new Font("Dialog", 1, 9));
        this.btnLeft.setText("<");
        this.btnLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBCalendarAppointment.this.btnLeftActionPerformed(evt);
            }
        });
        this.btnToday.setFont(new Font("Dialog", 1, 9));
        this.btnToday.setText("Today");
        this.btnToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBCalendarAppointment.this.btnTodayActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnLeft).addGap(0, 0, 0).addComponent(this.btnToday).addGap(0, 0, 0).addComponent(this.btnRight)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLeft).addComponent(this.btnToday).addComponent(this.btnRight));
        GroupLayout pnlControlLayout = new GroupLayout(this.pnlControl);
        this.pnlControl.setLayout(pnlControlLayout);
        pnlControlLayout.setHorizontalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlControlLayout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        pnlControlLayout.setVerticalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)));
        this.pnlList.setBorder(BorderFactory.createTitledBorder("Event List"));
        this.jdbList1.setModel((ListModel)this.calendarList);
        this.jScrollPane1.setViewportView((Component)this.jdbList1);
        GroupLayout pnlListLayout = new GroupLayout(this.pnlList);
        this.pnlList.setLayout(pnlListLayout);
        pnlListLayout.setHorizontalGroup(pnlListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlListLayout.createSequentialGroup().addContainerGap().addGroup(pnlListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlListLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlApp1, -2, 0, Short.MAX_VALUE).addComponent((Component)this.panelPage1, -1, 197, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 197, -2)).addContainerGap()));
        pnlListLayout.setVerticalGroup(pnlListLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlListLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlApp1, -2, 240, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.panelPage1, -2, -1, -2)));
        this.pnlCalendar.setBorder(BorderFactory.createTitledBorder("Event Calendar"));
        GroupLayout pnlCalendarLayout = new GroupLayout(this.pnlCalendar);
        this.pnlCalendar.setLayout(pnlCalendarLayout);
        pnlCalendarLayout.setHorizontalGroup(pnlCalendarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 375, Short.MAX_VALUE));
        pnlCalendarLayout.setVerticalGroup(pnlCalendarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlCalendar, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlList, -2, -1, -2)).addComponent(this.pnlControl, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlControl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCalendar, -1, -1, Short.MAX_VALUE).addComponent(this.pnlList, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private void jYearChooser1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("year") && this.doPropertyChange) {
            this.setYear(this.jYearChooser1.getYear());
        }
    }

    private void jMonthChooser1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("month") && this.doPropertyChange) {
            this.setMonth(this.jMonthChooser1.getMonth());
        }
    }

    private void btnLeftActionPerformed(ActionEvent evt) {
        this.setMonth(this.month - 1);
        this.doPropertyChange = false;
        this.jMonthChooser1.setMonth(this.month);
        if (this.year != this.jYearChooser1.getYear()) {
            this.jYearChooser1.setYear(this.year);
        }
        this.doPropertyChange = true;
    }

    private void btnTodayActionPerformed(ActionEvent evt) {
        this.setNow();
        this.doPropertyChange = false;
        if (this.month != this.jMonthChooser1.getMonth()) {
            this.jMonthChooser1.setMonth(this.month);
        }
        if (this.year != this.jYearChooser1.getYear()) {
            this.jYearChooser1.setYear(this.year);
        }
        this.doPropertyChange = true;
    }

    private void btnRightActionPerformed(ActionEvent evt) {
        this.setMonth(this.month + 1);
        this.doPropertyChange = false;
        this.jMonthChooser1.setMonth(this.month);
        if (this.year != this.jYearChooser1.getYear()) {
            this.jYearChooser1.setYear(this.year);
        }
        this.doPropertyChange = true;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test Frame");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new JBCalendar());
        frame.pack();
        frame.setVisible(true);
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(JBCalendar.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(JBCalendar.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(JBCalendar.class, key);
    }

    @Override
    public void eventClicked(JBCalendarPnlButtonApp jbcpb) {
        this.updateListModel(jbcpb);
    }

    @Override
    public void doEvent(JBCalendarPnlButtonApp btn) {
        this.tempCalendar.set(this.year, this.month, btn.getDate());
        if (this.isDateNow(btn.getDate(), this.month, this.year)) {
            this.label.setText(this.getResourcesUI("label.text.todaydate") + calendarFormat.format(this.tempCalendar.getTime()));
        } else {
            this.label.setText(this.getResourcesUI("label.text.date") + calendarFormat.format(this.tempCalendar.getTime()));
        }
    }
}

