/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.swing.appointment;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JIntTimeSpinner
extends JComponent {
    public static final String HOUR_12 = "hh";
    public static final String HOUR_24 = "HH";
    public static final int DEFAULT_WIDTH = 40;
    public static final int DEFAULT_HEIGHT = 20;
    private int previous;
    private String hour_mode;
    private JSpinner hour_spinner;
    private JSpinner minute_spinner;
    private Dimension dimension;

    public JIntTimeSpinner() {
        this.hour_mode = HOUR_24;
        this.dimension = new Dimension(40, 20);
        this.initComponent();
    }

    public JIntTimeSpinner(String hour_mode) {
        this.hour_mode = hour_mode;
        this.dimension = new Dimension(40, 20);
        this.initComponent();
    }

    public JIntTimeSpinner(String hour_mode, Dimension dimension) {
        this.hour_mode = hour_mode;
        this.dimension = dimension;
        this.initComponent();
    }

    public JIntTimeSpinner(String hour_mode, int width, int height) {
        this.hour_mode = hour_mode;
        this.dimension = new Dimension(width, height);
        this.initComponent();
    }

    private void initComponent() {
        this.setSize(new Dimension(this.dimension.width + 40, this.dimension.height * 2 + 20));
        SpinnerDateModel hour_model = new SpinnerDateModel();
        hour_model.setCalendarField(10);
        this.hour_spinner = new JSpinner(hour_model);
        this.hour_spinner.setEditor(new JSpinner.DateEditor(this.hour_spinner, this.hour_mode));
        this.hour_spinner.setPreferredSize(this.dimension);
        SpinnerDateModel minute_model = new SpinnerDateModel();
        minute_model.setCalendarField(12);
        this.minute_spinner = new JSpinner(minute_model);
        this.minute_spinner.setEditor(new JSpinner.DateEditor(this.minute_spinner, "mm"));
        this.minute_spinner.setPreferredSize(this.dimension);
        this.minute_spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JIntTimeSpinner.this.spinnerStateChanged(evt);
            }
        });
        this.setLayout(new GridLayout(1, 2));
        this.add(this.hour_spinner);
        this.add(this.minute_spinner);
        this.previous = this.parseDate(new Date(), 12);
    }

    private int parseDate(Date date, int state) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(state);
    }

    private Date incDate(Date date, int inc) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, inc);
        return cal.getTime();
    }

    private void spinnerStateChanged(ChangeEvent evt) {
        int now = this.getMinute();
        if (this.previous == 59 && now == 0) {
            this.hour_spinner.setValue(this.incDate((Date)this.hour_spinner.getValue(), 1));
        } else if (this.previous == 0 && now == 59) {
            this.hour_spinner.setValue(this.incDate((Date)this.hour_spinner.getValue(), -1));
        }
        this.previous = now;
    }

    public void setMinute(Date m) {
        this.minute_spinner.setValue(m);
    }

    public void setHour(Date h) {
        this.hour_spinner.setValue(h);
    }

    public void setTime(Date m) {
        this.minute_spinner.setValue(m);
        this.hour_spinner.setValue(m);
    }

    public int getMinute() {
        return this.parseDate((Date)this.minute_spinner.getValue(), 12);
    }

    public int getHour() {
        if (this.hour_mode.equals(HOUR_12)) {
            return this.parseDate((Date)this.hour_spinner.getValue(), 10);
        }
        return this.parseDate((Date)this.hour_spinner.getValue(), 11);
    }

    public Time getTime() {
        String Hour = Integer.toString(this.getHour());
        String Minute = Integer.toString(this.getMinute());
        String time = Hour + ":" + Minute + ":00";
        return Time.valueOf(time);
    }

    public void setTime(Time time) {
        Date date = new Date();
        date.setHours(time.getHours());
        date.setMinutes(time.getMinutes());
        this.setTime(date);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.hour_spinner.setEnabled(enabled);
        this.minute_spinner.setEnabled(enabled);
    }
}

