/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui;

import com.bits.bee.bl.DP;
import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.ui.DlgDownPayment;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.BtnCancel;
import com.bits.bee.ui.myswing.BtnOK;
import com.bits.bee.ui.myswing.JBOSPeriode;
import com.bits.bee.ui.myswing.JCboAktif;
import com.bits.bee.ui.myswing.JFormBackgroundPanel;
import com.bits.bee.ui.myswing.PikCust;
import com.bits.bee.ui.myswing.PikDept;
import com.bits.bee.ui.myswing.PikPrj;
import com.bits.bee.ui.myswing.PikVendor;
import com.bits.lib.BHelp;
import com.bits.lib.dbswing.JBDialog;
import com.bits.lib.dbswing.JBPeriode;
import com.bits.lib.dbswing.JBPicker;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBToolbarDialog;
import com.bits.lib.dbswing.JBToolbarEvent;
import com.bits.lib.dbswing.JBToolbarListener;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dbswing.util.TableUtil;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgDownPaymentBengkel
extends JBDialog<DataSetView>
implements InstanceObserver,
ResourceGetter,
DataChangeListener {
    private static Logger logger = LoggerFactory.getLogger(DlgDownPaymentBengkel.class);
    private static DlgDownPaymentBengkel singleton;
    private QueryDataSet qds = new QueryDataSet();
    private DataSetView dsv = new DataSetView();
    private DP_MODE dpMode;
    private LocaleInstance l = LocaleInstance.getInstance();
    private GroupLayout groupLayout;
    private JComponent currentComp;
    private String crcid;
    private BigDecimal dpAmt = BigDecimal.ZERO;
    private boolean listenerAdded = false;
    private BtnCancel btnCancel1;
    private BtnOK btnOK1;
    private JBOSPeriode jBOSPeriode1;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBToolbarDialog jBToolbarDialog1;
    private JBdbTable jBdbTable1;
    private JCboAktif jCboAktif1;
    private JFormBackgroundPanel jFormBackgroundPanel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblActive;
    private JLabel lblActive1;
    private JLabel lblActive2;
    private JLabel lblBP;
    private JLabel lblPeriode;
    private PikCust pikCust1;
    private PikDept pikDept1;
    private PikPrj pikPrj1;
    private PikVendor pikVendor1;

    public DlgDownPaymentBengkel() {
        super((Frame)ScreenManager.getParent(), "Uang Muka");
        this.init();
    }

    public DlgDownPaymentBengkel(Dialog parent) {
        super(parent, "Uang Muka");
        this.init();
    }

    public DlgDownPaymentBengkel(Frame parent) {
        super(parent, "Uang Muka");
        this.init();
    }

    private void init() {
        this.initComponents();
        ScreenManager.setCenter((JDialog)((Object)this));
        this.groupLayout = (GroupLayout)this.jPanel2.getLayout();
        this.currentComp = this.pikCust1;
        this.setDPMode(DP_MODE.MODE_PO);
        UIMgr.setPeriode((JBPeriode)this.jBOSPeriode1, (int)0);
        this.initLang();
        this.initForm();
        this.setTopFocusComponent((JComponent)this.jBdbTable1);
    }

    public static synchronized DlgDownPaymentBengkel getInstance() {
        if (singleton == null) {
            singleton = new DlgDownPaymentBengkel();
        }
        return singleton;
    }

    private void initForm() {
        TableUtil.setReadOnlyTable((JBdbTable)this.jBdbTable1, (boolean)true);
    }

    private void initLang() {
        this.setTitle(this.getResourcesUI("title"));
        this.lblPeriode.setText(this.getResourcesUI("lblPeriode.text"));
        this.lblActive.setText(this.getResourcesUI("lblActive.text"));
        if (this.getDPMode() == DP_MODE.MODE_PO) {
            this.lblBP.setText(this.getResourcesUI("lblBP.textVend"));
        } else if (this.getDPMode() == DP_MODE.MODE_SO) {
            this.lblBP.setText(this.getResourcesUI("lblBP.textCust"));
        }
    }

    private void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setEditable(false);
        }
        UIMgr.setBrowseUICaption((DataSet)this.qds);
        this.qds.getColumn("dpid").setCaption(this.l.getMessageBL(DP.class, "col.dpid"));
        this.qds.getColumn("dpid").setWidth(6);
        this.qds.getColumn("dpdate").setCaption(this.l.getMessageBL(DP.class, "col.dpdate"));
        this.qds.getColumn("dpdate").setWidth(9);
        this.qds.getColumn("refno").setCaption(this.l.getMessageBL(DP.class, "col.refno"));
        this.qds.getColumn("refno").setWidth(9);
        this.qds.getColumn("reftype").setCaption(this.l.getMessageBL(DP.class, "col.reftype"));
        this.qds.getColumn("crcid").setVisible(0);
        this.qds.getColumn("crcsymbol").setCaption(this.l.getMessageBL(DP.class, "col.crcsymbol"));
        this.qds.getColumn("excrate").setCaption(this.l.getMessageBL(DP.class, "col.excrate"));
        this.qds.getColumn("excrate").setWidth(7);
        this.qds.getColumn("dpamt").setCaption(this.l.getMessageBL(DP.class, "col.dpamt"));
        this.qds.getColumn("usedamt").setCaption(this.l.getMessageBL(DP.class, "col.usedamt"));
        this.qds.getColumn("dpbal").setCaption(this.l.getMessageBL(DP.class, "col.dpbal"));
        this.qds.getColumn("note").setCaption(this.l.getMessageBL(DP.class, "col.paynote"));
        this.qds.getColumn("note").setWidth(14);
    }

    private void refresh() throws Exception {
        StringBuffer sql = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        if (this.getDPMode() == DP_MODE.MODE_PO) {
            sql.append("SELECT dpid, dpdate, dp.refno, dp.reftype, dp.crcid, c.crcsymbol, dp.excrate, dpamt, usedamt, dpbal, paynote AS note FROM dp JOIN crc c ON dp.crcid=c.crcid JOIN pay p ON dp.paidno=p.payno AND paidtype='PAY' JOIN ppaid pp ON pp.payno=p.payno LEFT JOIN dept d ON pp.deptid=d.deptid LEFT JOIN prj pr ON pp.prjid=pr.prjid ");
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"dp.bpid", (JBPicker)this.pikVendor1);
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"pp.deptid", (JBPicker)this.pikDept1);
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"pp.prjid", (JBPicker)this.pikPrj1);
            JBSQL.ANDFilter((StringBuffer)filter, (String)"pp.reftype='DP'");
        } else if (this.getDPMode() == DP_MODE.MODE_SO) {
            sql.append("SELECT dpid, dpdate, dp.refno, dp.reftype, dp.crcid, c.crcsymbol, dp.excrate, dpamt, usedamt, dpbal, rcvnote AS note FROM dp JOIN crc c ON dp.crcid=c.crcid JOIN rcv r ON dp.paidno=r.rcvno AND paidtype='RCV' JOIN spaid sp ON sp.rcvno=r.rcvno LEFT JOIN dept d ON sp.deptid=d.deptid LEFT JOIN prj pr ON sp.prjid=pr.prjid ");
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"dp.bpid", (JBPicker)this.pikCust1);
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"sp.deptid", (JBPicker)this.pikDept1);
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"sp.prjid", (JBPicker)this.pikPrj1);
            JBSQL.ANDFilter((StringBuffer)filter, (String)"sp.reftype='DP'");
        }
        if (this.jCboAktif1.getSelectedIndex() == 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"dp.dpbal>0");
        } else if (this.jCboAktif1.getSelectedIndex() == 1) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"dp.dpbal<=0");
        }
        if (this.crcid != null && this.crcid.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)String.format("dp.crcid=%s", BHelp.QuoteSingle((String)this.crcid)));
        }
        if (filter.length() > 0) {
            JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        }
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.qds.setRowId("dpid", true);
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
        if (!this.listenerAdded) {
            this.dsv.addDataChangeListener((DataChangeListener)this);
            this.listenerAdded = true;
        }
    }

    public DP_MODE getDPMode() {
        return this.dpMode;
    }

    public void setDPMode(DP_MODE dpMode) {
        this.dpMode = dpMode;
        if (this.getDPMode() == DP_MODE.MODE_PO && this.currentComp == this.pikCust1) {
            this.groupLayout.replace(this.currentComp, (Component)this.pikVendor1);
            this.currentComp = this.pikVendor1;
        } else if (this.getDPMode() == DP_MODE.MODE_SO && this.currentComp == this.pikVendor1) {
            this.groupLayout.replace(this.currentComp, (Component)this.pikCust1);
            this.currentComp = this.pikCust1;
        }
        this.initLang();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoad() {
        try {
            ScreenManager.setCursorThinking((JBDialog)this);
            this.refresh();
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.refresh"), (Exception)ex, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JBDialog)this);
        }
    }

    public void filterActive() {
        this.jCboAktif1.setSelectedIndex(0);
        this.jCboAktif1.setEnabled(false);
    }

    public void filterBPID(String bpid) {
        if (bpid == null) {
            return;
        }
        if (this.getDPMode() == DP_MODE.MODE_PO) {
            this.pikVendor1.setKeyValue(bpid);
            this.pikVendor1.setEnabled(false);
        } else if (this.getDPMode() == DP_MODE.MODE_SO) {
            this.pikCust1.setKeyValue(bpid);
            this.pikCust1.setEnabled(false);
        }
    }

    public void filterCrcID(String crcid) {
        this.crcid = crcid;
    }

    private void resetFilter() {
        this.jCboAktif1.setEnabled(true);
        this.pikCust1.setEnabled(true);
        this.pikVendor1.setEnabled(true);
        this.pikDept1.setEnabled(true);
        this.pikPrj1.setEnabled(true);
        this.crcid = null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetFilter();
        }
    }

    protected void OK() {
        this.setSelectedID("" + this.dsv.getLong("dpid"));
        this.setSelectedObject(this.dsv);
        this.setDPAmt(this.dsv.getBigDecimal("dpbal"));
        super.OK();
    }

    public BigDecimal getDPAmt() {
        return this.dpAmt;
    }

    private void setDPAmt(BigDecimal dpAmt) {
        this.dpAmt = dpAmt;
    }

    private boolean validateSelection() {
        boolean retval = false;
        DataRow locateRow = new DataRow((DataSet)this.dsv, "check");
        locateRow.setBoolean("check", true);
        if (this.dsv.locate((ReadRow)locateRow, 32)) {
            retval = true;
        }
        return retval;
    }

    private void initComponents() {
        this.pikVendor1 = new PikVendor();
        this.jFormBackgroundPanel1 = new JFormBackgroundPanel();
        this.jPanel1 = new JPanel();
        this.btnCancel1 = new BtnCancel();
        this.btnOK1 = new BtnOK();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel2 = new JPanel();
        this.lblPeriode = new JLabel();
        this.jBOSPeriode1 = new JBOSPeriode();
        this.pikCust1 = new PikCust();
        this.lblBP = new JLabel();
        this.lblActive = new JLabel();
        this.jCboAktif1 = new JCboAktif();
        this.pikDept1 = new PikDept();
        this.pikPrj1 = new PikPrj();
        this.lblActive1 = new JLabel();
        this.lblActive2 = new JLabel();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.jBToolbarDialog1 = new JBToolbarDialog();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new FlowLayout(2, 5, 0));
        this.btnCancel1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgDownPaymentBengkel.this.btnCancel1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.btnCancel1);
        this.btnOK1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgDownPaymentBengkel.this.btnOK1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.btnOK1);
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jBdbTable1.setPopupMenuEnabled(false);
        this.jBdbTable1.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DlgDownPaymentBengkel.this.jBdbTable1MouseClicked(evt);
            }
        });
        this.jBdbTable1.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DlgDownPaymentBengkel.this.jBdbTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), NbBundle.getMessage(DlgDownPaymentBengkel.class, (String)"DlgDownPaymentBengkel.jPanel2.border.title")));
        this.jPanel2.setOpaque(false);
        this.lblPeriode.setHorizontalAlignment(4);
        this.lblPeriode.setText(NbBundle.getMessage(DlgDownPaymentBengkel.class, (String)"DlgDownPaymentBengkel.lblPeriode.text"));
        this.jBOSPeriode1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikCust1.setOpaque(false);
        this.lblBP.setHorizontalAlignment(4);
        this.lblBP.setText("Customer:");
        this.lblActive.setHorizontalAlignment(4);
        this.lblActive.setText(NbBundle.getMessage(DlgDownPaymentBengkel.class, (String)"DlgDownPaymentBengkel.lblActive.text"));
        this.pikDept1.setOpaque(false);
        this.pikPrj1.setOpaque(false);
        this.lblActive1.setHorizontalAlignment(4);
        this.lblActive1.setText(NbBundle.getMessage(DlgDownPaymentBengkel.class, (String)"DlgDownPaymentBengkel.lblActive1.text"));
        this.lblActive2.setHorizontalAlignment(4);
        this.lblActive2.setText("Department:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblActive, GroupLayout.Alignment.TRAILING).addComponent(this.lblActive1, GroupLayout.Alignment.TRAILING).addComponent(this.lblActive2, GroupLayout.Alignment.TRAILING).addComponent(this.lblBP, GroupLayout.Alignment.TRAILING).addComponent(this.lblPeriode, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBOSPeriode1, -2, -1, -2).addComponent((Component)this.pikCust1, -1, 517, Short.MAX_VALUE).addComponent((Component)this.pikDept1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.pikPrj1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCboAktif1, -2, -1, -2)).addContainerGap(234, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPeriode).addComponent((Component)this.jBOSPeriode1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikCust1, -2, -1, -2).addComponent(this.lblBP)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikDept1, -2, -1, -2).addComponent(this.lblActive2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent((Component)this.pikPrj1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblActive).addComponent((Component)this.jCboAktif1, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lblActive1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout jFormBackgroundPanel1Layout = new GroupLayout((Container)this.jFormBackgroundPanel1);
        this.jFormBackgroundPanel1.setLayout((LayoutManager)jFormBackgroundPanel1Layout);
        jFormBackgroundPanel1Layout.setHorizontalGroup(jFormBackgroundPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jFormBackgroundPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jFormBackgroundPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 630, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 647, Short.MAX_VALUE)).addContainerGap()));
        jFormBackgroundPanel1Layout.setVerticalGroup(jFormBackgroundPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jFormBackgroundPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 142, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.jBStatusbarDialog1.setShowF1(false);
        this.jBStatusbarDialog1.setShowF2(false);
        this.jBToolbarDialog1.setEnableNew(false);
        this.jBToolbarDialog1.addJBToolbarListener(new JBToolbarListener(){

            public void toolbarNewPerformed(JBToolbarEvent evt) {
            }

            public void toolbarEditPerformed(JBToolbarEvent evt) {
            }

            public void toolbarRefreshPerformed(JBToolbarEvent evt) {
                DlgDownPaymentBengkel.this.jBToolbarDialog1ToolbarRefreshPerformed(evt);
            }

            public void toolbarOpenPerformed(JBToolbarEvent evt) {
            }

            public void toolbarSavePerformed(JBToolbarEvent evt) {
            }

            public void toolbarCancelPerformed(JBToolbarEvent evt) {
            }

            public void toolbarDeletePerformed(JBToolbarEvent evt) {
            }

            public void toolbarVoidPerformed(JBToolbarEvent evt) {
            }

            public void toolbarPrintPerformed(JBToolbarEvent evt) {
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBStatusbarDialog1, -1, 656, Short.MAX_VALUE).addComponent((Component)this.jBToolbarDialog1, GroupLayout.Alignment.TRAILING, -1, 656, Short.MAX_VALUE).addComponent((Component)this.jFormBackgroundPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jBToolbarDialog1, -2, 25, -2).addGap(7, 7, 7).addComponent((Component)this.jFormBackgroundPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void jBdbTable1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.OK();
        }
    }

    private void jBdbTable1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.OK();
        }
    }

    private void jBToolbarDialog1ToolbarRefreshPerformed(JBToolbarEvent evt) {
        this.doLoad();
    }

    private void btnCancel1ActionPerformed(ActionEvent evt) {
        this.Cancel();
    }

    private void btnOK1ActionPerformed(ActionEvent evt) {
        this.OK();
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(DlgDownPayment.class, key);
    }

    public String getResourcesBL(String key) {
        return null;
    }

    public String getResourcesLib(String key) {
        return null;
    }

    public void doUpdate() {
        singleton = null;
    }

    public void postRow(DataChangeEvent dce) throws Exception {
    }

    public void dataChanged(DataChangeEvent event) {
        if (event.getID() == 3) {
            int nextRow = this.dsv.getRow() + 1;
            this.dsv.goToRow(nextRow);
            this.jBdbTable1.changeSelection(nextRow, 0, false, false);
        }
    }

    public static enum DP_MODE {
        MODE_PO,
        MODE_SO;

    }
}

