/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui;

import com.bits.bee.ui.FrmMasterAbstract;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.beebengkel.bl.CarBrand;
import com.bits.beebengkel.ui.FrmCarBrandImport;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BTable;
import com.bits.lib.security.AuthMgr;
import com.bits.lib.security.BAuthMgr;
import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JInternalFrame;
import org.slf4j.Logger;

public class FrmCarBrand
extends FrmMasterAbstract {
    private String ErrorSpace = "";
    private String ErrorEmpty = "";
    private static final String OBJID = "999992";

    public FrmCarBrand() {
        super((BTable)new CarBrand(), "Merk", null);
        super.getToolbar().getBtnHelp().setVisible(false);
        this.initLang();
        this.initForm();
    }

    private void initForm() {
        this.table.getDataSet().getColumn(0).setWidth(8);
        this.table.getDataSet().getColumn(1).setWidth(20);
        try {
            this.table.Load();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        this.setEnableXLS(true);
        this.getToolbar().setObjid(OBJID);
        this.getToolbar().setAuthMgr((AuthMgr)BAuthMgr.getDefault());
    }

    private boolean ValidateSpace() {
        boolean valid = true;
        this.ErrorSpace = "";
        String[] content = new String[3];
        for (int i = 0; i < this.table.getDataSet().getColumnCount(); ++i) {
            content[i] = this.table.getDataSet().getString(i);
            String temp = content[i].replace(" ", "");
            if (content[i].length() <= 0 || !"".equalsIgnoreCase(temp)) continue;
            valid = false;
            if (i == 0) {
                this.ErrorSpace = "Kode Merk";
                break;
            }
            if (i != 1) break;
            this.ErrorSpace = "Nama Merk";
            break;
        }
        return valid;
    }

    private boolean ValidateEmpty() {
        boolean valid = true;
        this.ErrorEmpty = "";
        String[] content = new String[3];
        for (int i = 0; i < this.table.getDataSet().getColumnCount(); ++i) {
            content[i] = this.table.getDataSet().getString(i);
            if (content[i].length() > 0) continue;
            valid = false;
            if (i == 0) {
                this.ErrorEmpty = "Kode Merk";
                break;
            }
            if (i != 1) break;
            this.ErrorEmpty = "Nama Merk";
            break;
        }
        return valid;
    }

    public void Refresh_CachedDataSet() {
        try {
            CarBrand.getInstance().Load();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public void doXLS() {
        ScreenManager.getMainFrame().addInternalFrame((JInternalFrame)new FrmCarBrandImport());
    }

    private void initLang() {
        this.setTitle("Master Merk Kendaraan | Bengkel");
    }

    public void doSave() {
        try {
            if (!this.ValidateSpace()) {
                UIMgr.showErrorDialog((String)(this.ErrorSpace + " Tidak Boleh Diisi Dengan Spasi !"), null, (Component)((Object)this), (Logger)logger);
            } else if (!this.ValidateEmpty()) {
                UIMgr.showErrorDialog((String)("Masukkan " + this.ErrorEmpty + " !"), null, (Component)((Object)this), (Logger)logger);
            } else {
                this.table.saveChanges();
                UIMgr.showMessageDialog((String)"Saved, OK !", (Component)((Object)this));
                this.state.setState(0);
            }
        }
        catch (Exception e) {
            if (BHelp.getExceptionDetail((Exception)e).indexOf("pk_") > 0) {
                UIMgr.showErrorDialog((String)"Error Simpan Data, Kode Duplikat !", (Exception)e, (Component)((Object)this), (Logger)logger);
            }
            if (BHelp.getExceptionDetail((Exception)e).indexOf("null") > 0) {
                UIMgr.showErrorDialog((String)"Error Simpan Data, Field Tidak Boleh Kosong !", (Exception)e, (Component)((Object)this), (Logger)logger);
            }
            UIMgr.showErrorDialog((String)"Error Simpan Data !", (Exception)e, (Component)((Object)this), (Logger)logger);
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 394, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 274, Short.MAX_VALUE));
        this.pack();
    }
}

