/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui.mySwing;

import com.bits.beebengkel.ui.toolbar.BToolbarExtensionAction;
import com.bits.beebengkel.ui.toolbar.BToolbarExtensionAware;
import com.bits.lib.BUtil;
import com.bits.lib.HelpMgr;
import com.bits.lib.abstraction.BUIResources;
import com.bits.lib.dbswing.BdbState;
import com.bits.lib.dbswing.JBToolbarDraftListener;
import com.bits.lib.dbswing.JBToolbarEvent;
import com.bits.lib.dbswing.JBToolbarHelpListener;
import com.bits.lib.dbswing.JBToolbarListener;
import com.bits.lib.dbswing.JBToolbarMediator;
import com.bits.lib.dbswing.JBToolbarValidator;
import com.bits.lib.dbswing.JBToolbarXLSListener;
import com.bits.lib.security.AuthMgr;
import com.bits.lib.swing.JDropDownButton;
import com.bits.lib.util.SwingUtil;
import com.jgoodies.looks.HeaderStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class JBToolbarCustom
extends JToolBar
implements PropertyChangeListener {
    private String objid = "";
    private AuthMgr authMgr;
    private String editstyle;
    private boolean enableCancel;
    private boolean enableDelete;
    private boolean enableEdit;
    private boolean enableNew;
    private boolean enableOpen;
    private boolean enablePrint;
    private boolean enableRefresh;
    private boolean enableSave;
    private boolean enableVoid;
    private boolean enableHelp;
    private boolean enableXLS;
    private boolean enableDraft;
    private JBToolbarMediator mediator;
    private static JBToolbarValidator validator;
    private BdbState state = null;
    private StateAdapter stateadapter = new StateAdapter();
    private int oldState;
    private int newState;
    private KeyStroke skC = KeyStroke.getKeyStroke(67, 2);
    private KeyStroke skD = KeyStroke.getKeyStroke(68, 2);
    private KeyStroke skE = KeyStroke.getKeyStroke(69, 2);
    private KeyStroke skN = KeyStroke.getKeyStroke(78, 2);
    private KeyStroke skO = KeyStroke.getKeyStroke(79, 2);
    private KeyStroke skP = KeyStroke.getKeyStroke(80, 2);
    private KeyStroke skR = KeyStroke.getKeyStroke(82, 2);
    private KeyStroke skS = KeyStroke.getKeyStroke(83, 2);
    private KeyStroke skV = KeyStroke.getKeyStroke(86, 2);
    private KeyStroke skH = KeyStroke.getKeyStroke(72, 2);
    private KeyStroke skL = KeyStroke.getKeyStroke(76, 2);
    private KeyStroke skT = KeyStroke.getKeyStroke(84, 2);
    public static final int PRINTMODE_TEXT = 0;
    public static final int PRINTMODE_GRAPHICS = 1;
    private int printMode = 0;
    private boolean enableChoosePrintMode = true;
    private boolean isVoid = false;
    private boolean useInnerHelpAction;
    private ArrayList<JDropDownButton> expandDropDownList = new ArrayList();
    private ArrayList<JComponent> expandComponentList = new ArrayList();
    private ArrayList<JComponent> expandMainComponentList = new ArrayList();
    private EventListenerList listenerList = new EventListenerList();
    private List<BToolbarExtensionAction> extensionActionList;
    private boolean newOpen = true;
    private JButton btnCancel;
    private JButton btnDelete;
    private JButton btnEdit;
    private JButton btnHelp;
    private JButton btnNew;
    private JButton btnOpen;
    private JButton btnPrint;
    private JButton btnRefresh;
    private JButton btnSave;
    private JButton btnSaveDraft;
    private JButton btnVoid;
    private JButton btnXLS;
    private JMenuItem mnGraphicRpt;
    private JMenuItem mnTextRpt;
    private JPopupMenu popupMenu;
    private JSeparator separatorHelp;

    public JBToolbarCustom() {
        this.initComponents();
        this.btnHelp.addPropertyChangeListener("ancestor", this);
        this.setEditStyle("O");
        this.initFlag();
        this.initShortcut();
        this.setFloatable(false);
        this.setUseInnerHelpAction(true);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.add(this.separatorHelp);
        this.add(this.getBtnXLS());
        this.add(this.getBtnHelp());
        if (System.getProperty("default.printmode") != null) {
            this.printMode = Integer.parseInt(System.getProperty("default.printmode"));
        }
        this.getBtnXLS().setPreferredSize(new Dimension(101, 24));
        this.addAncestorListener(new ToolbarAncestorListener());
    }

    public boolean checkHelpFile() {
        boolean enabled = false;
        Component frame = BUtil.getComponentFrame((Component)this);
        if (frame != null) {
            String className = frame.getClass().getSimpleName();
            enabled = HelpMgr.getInstance().checkHelpFile(className);
        }
        return enabled;
    }

    private void initShortcut() {
        AbstractAction actCtrl_C = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doCancel();
            }
        };
        AbstractAction actCtrl_D = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doDelete();
            }
        };
        AbstractAction actCtrl_E = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doEdit();
            }
        };
        AbstractAction actCtrl_N = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doNew();
            }
        };
        AbstractAction actCtrl_O = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doOpen();
            }
        };
        AbstractAction actCtrl_P = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JBToolbarCustom.this.isEnableChoosePrintMode()) {
                    JBToolbarCustom.this.doChoosePrint();
                } else {
                    JBToolbarCustom.this.doPrint();
                }
            }
        };
        AbstractAction actCtrl_R = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doRefresh();
            }
        };
        AbstractAction actCtrl_S = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doSaveDraft();
            }
        };
        AbstractAction actCtrl_T = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doSaveDraft();
            }
        };
        AbstractAction actCtrl_V = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doVoid();
            }
        };
        AbstractAction actCtrl_H = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doHelp();
            }
        };
        AbstractAction actCtrl_L = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBToolbarCustom.this.doXLS();
            }
        };
        this.getInputMap(2).put(this.skC, "Ctrl-C");
        this.getActionMap().put("Ctrl-C", actCtrl_C);
        this.getInputMap(2).put(this.skD, "Ctrl-D");
        this.getActionMap().put("Ctrl-D", actCtrl_D);
        this.getInputMap(2).put(this.skE, "Ctrl-E");
        this.getActionMap().put("Ctrl-E", actCtrl_E);
        this.getInputMap(2).put(this.skN, "Ctrl-N");
        this.getActionMap().put("Ctrl-N", actCtrl_N);
        this.getInputMap(2).put(this.skO, "Ctrl-O");
        this.getActionMap().put("Ctrl-O", actCtrl_O);
        this.getInputMap(2).put(this.skP, "Ctrl-P");
        this.getActionMap().put("Ctrl-P", actCtrl_P);
        this.getInputMap(2).put(this.skR, "Ctrl-R");
        this.getActionMap().put("Ctrl-R", actCtrl_R);
        this.getInputMap(2).put(this.skS, "Ctrl-S");
        this.getActionMap().put("Ctrl-S", actCtrl_S);
        this.getInputMap(2).put(this.skT, "Ctrl-T");
        this.getActionMap().put("Ctrl-T", actCtrl_T);
        this.getInputMap(2).put(this.skV, "Ctrl-V");
        this.getActionMap().put("Ctrl-V", actCtrl_V);
        this.getInputMap(2).put(this.skH, "Ctrl-H");
        this.getActionMap().put("Ctrl-H", actCtrl_H);
        this.getInputMap(2).put(this.skH, "Ctrl-L");
        this.getActionMap().put("Ctrl-L", actCtrl_L);
    }

    private void initFlag() {
        this.setEnableCancel(true);
        this.setEnableDelete(true);
        this.setEnableEdit(false);
        this.setEnableNew(true);
        this.setEnableOpen(true);
        this.setEnablePrint(true);
        this.setEnableRefresh(true);
        this.setEnableSave(true);
        this.setEnableSaveDraft(false);
        this.setEnableVoid(true);
        this.setEnableHelp(true);
        this.setEnableXLS(false);
        this.setEnableChoosePrintMode(false);
    }

    public String getObjid() {
        return this.objid;
    }

    public void setObjid(String objid) {
        this.objid = objid;
        this.initializeAccess();
    }

    public void setAuthMgr(AuthMgr authMgr) {
        this.authMgr = authMgr;
        this.initializeAccess();
    }

    public void setMediator(JBToolbarMediator mediator) {
        this.mediator = mediator;
    }

    public BdbState getState() {
        return this.state;
    }

    public void setState(BdbState state) {
        this.state = state;
        this.state.addPropertyChangeListener("state", (PropertyChangeListener)this.stateadapter);
        if (null != this.extensionActionList && !this.extensionActionList.isEmpty()) {
            for (BToolbarExtensionAction extensionAction : this.extensionActionList) {
                extensionAction.setToolbar(this);
            }
        }
    }

    public void addJBToolbarListener(JBToolbarListener listener) {
        this.listenerList.add(JBToolbarListener.class, listener);
    }

    public void removeJBToolbarListener(JBToolbarListener listener) {
        this.listenerList.remove(JBToolbarListener.class, listener);
    }

    public void addJBToolbarHelpListener(JBToolbarHelpListener listener) {
        this.listenerList.add(JBToolbarHelpListener.class, listener);
    }

    public void removeJBToolbarHelpListener(JBToolbarHelpListener listener) {
        this.listenerList.remove(JBToolbarHelpListener.class, listener);
    }

    public void addJBToolbarXLSListener(JBToolbarXLSListener listener) {
        this.listenerList.add(JBToolbarXLSListener.class, listener);
    }

    public void removeJBToolbarXLSListener(JBToolbarXLSListener listener) {
        this.listenerList.remove(JBToolbarXLSListener.class, listener);
    }

    public void addJBToolbarDraftListener(JBToolbarDraftListener listener) {
        this.listenerList.add(JBToolbarDraftListener.class, listener);
    }

    public void removeJBToolbarDraftListener(JBToolbarDraftListener listener) {
        this.listenerList.remove(JBToolbarDraftListener.class, listener);
    }

    public JBToolbarListener[] getMyToolbarListeners() {
        return (JBToolbarListener[])this.listenerList.getListenerList();
    }

    private void doCancel() {
        if (this.enableCancel && this.getBtnCancel().isVisible()) {
            this.fireCancelPerformed();
        }
    }

    private void doDelete() {
        if (this.enableDelete && this.getBtnDelete().isVisible()) {
            if (this.mediator != null) {
                this.mediator.checkDateAccess();
            }
            if (this.authMgr == null || this.objid == null || this.authMgr.getAuthDlg(this.objid, "DEL")) {
                this.fireDeletePerformed();
            }
        }
    }

    private void doEdit() {
        if (this.enableEdit && this.getBtnEdit().isVisible()) {
            if (this.mediator != null) {
                this.mediator.checkDateAccess();
            }
            if (this.authMgr == null || this.objid == null || this.authMgr.getAuthDlg(this.objid, "OPN")) {
                this.fireEditPerformed();
            }
        }
    }

    private void doNew() {
        if (this.enableNew && this.getBtnNew().isVisible() && (this.authMgr == null || this.objid == null || this.authMgr.getAuthDlg(this.objid, "NEW"))) {
            this.fireNewPerformed();
        }
    }

    private void doOpen() {
        if (this.enableOpen && this.getBtnOpen().isVisible() && (this.authMgr == null || this.objid == null || this.authMgr.getAuthDlg(this.objid, "OPN"))) {
            this.fireOpenPerformed();
        }
    }

    private void doPrint() {
        if (this.enablePrint && this.getBtnPrint().isVisible()) {
            if (this.mediator != null) {
                this.mediator.checkDateAccess();
            }
            if (this.checkPrintAccess()) {
                this.firePrintPerformed();
            }
        }
    }

    private void doChoosePrint() {
        if (this.popupMenu != null && this.getBtnPrint().isVisible()) {
            Point pt = this.getLocationOnScreen();
            pt.translate(0, this.getHeight());
            this.popupMenu.setLocation(pt);
            this.popupMenu.show(this.getBtnPrint(), 0, this.getHeight());
        }
    }

    private void doRefresh() {
        if (this.enableRefresh && this.getBtnRefresh().isVisible()) {
            this.fireRefreshPerformed();
        }
    }

    private void doHelp() {
        if (this.enableHelp && this.getBtnHelp().isVisible()) {
            this.fireHelpPerformed();
        }
    }

    private void doXLS() {
        if (this.enableXLS && this.getBtnXLS().isVisible()) {
            this.fireXLSPerformed();
        }
    }

    private void doSave() {
        if (this.enableSave && this.getBtnSave().isVisible()) {
            if (this.mediator != null) {
                this.mediator.checkDateAccess();
            }
            if (this.authMgr == null || this.objid == null || this.state == null || this.state.getState() == 1 && this.authMgr.getAuthDlg(this.objid, "NEW") || this.state.getState() == 2 && this.authMgr.getAuthDlg(this.objid, "UPD")) {
                this.fireSavePerformed();
            }
        }
    }

    private void doSaveDraft() {
        if (this.enableDraft && this.getBtnSaveDraft().isVisible()) {
            if (this.mediator != null) {
                this.mediator.checkDateAccess();
            }
            if (this.authMgr == null || this.objid == null || this.state == null || this.state.getState() == 1 || this.state.getState() == 2 && this.authMgr.getAuthDlg(this.objid, "DRAFT")) {
                this.fireSaveDraftPerformed();
            }
        }
    }

    private void doVoid() {
        if (this.enableVoid && this.getBtnVoid().isVisible()) {
            if (this.mediator != null) {
                this.mediator.checkDateAccess();
            }
            if (this.authMgr == null || this.objid == null || this.authMgr.getAuthDlg(this.objid, "VOI")) {
                this.fireVoidPerformed();
            }
        }
    }

    public void addExpandDropDownButton(String text, Icon icon, JPopupMenu menu) {
        JDropDownButton button = new JDropDownButton(text, icon);
        button.setPopupMenu(menu);
        button.setFont(new Font("Dialog", 1, 11));
        button.setMargin(new Insets(2, 2, 2, 2));
        this.remove(this.separatorHelp);
        this.remove(this.getBtnXLS());
        this.remove(this.getBtnHelp());
        this.add((Component)button);
        this.add(this.separatorHelp);
        this.add(this.getBtnXLS());
        this.add(this.getBtnHelp());
        this.expandDropDownList.add(button);
    }

    public void removeExpandDropDownButton(int index) {
        this.expandDropDownList.remove(index);
    }

    public JDropDownButton getExpandDropDownButton(int index) {
        return this.expandDropDownList.get(index);
    }

    public void addExpandButton(JButton button) {
        this.remove(this.separatorHelp);
        this.remove(this.getBtnXLS());
        this.remove(this.getBtnHelp());
        button.setFont(new Font("Dialog", 1, 11));
        this.add(button);
        this.add(this.separatorHelp);
        this.add(this.getBtnXLS());
        this.add(this.getBtnHelp());
    }

    public void addExpandComponent(JComponent comp) {
        this.remove(this.getBtnHelp());
        this.add(comp);
        this.add(this.getBtnXLS());
        this.add(this.getBtnHelp());
    }

    public void removeExpandComponent(int index) {
        this.expandComponentList.remove(index);
    }

    public JComponent getExpandComponent(int index) {
        return this.expandComponentList.get(index);
    }

    public void addExpandMainComponent(JComponent comp) {
        this.remove(this.getBtnCancel());
        this.remove(this.getBtnDelete());
        this.remove(this.getBtnVoid());
        this.remove(this.getBtnPrint());
        this.remove(this.getBtnRefresh());
        this.remove(this.separatorHelp);
        this.remove(this.getBtnXLS());
        this.remove(this.getBtnHelp());
        this.add(comp);
        this.add(this.getBtnCancel());
        this.add(this.getBtnDelete());
        this.add(this.getBtnVoid());
        this.add(this.getBtnPrint());
        this.add(this.getBtnRefresh());
        this.add(this.separatorHelp);
        this.add(this.getBtnXLS());
        this.add(this.getBtnHelp());
        this.expandMainComponentList.add(comp);
    }

    public void removeExpandMainComponent(int index) {
        this.expandMainComponentList.remove(index);
    }

    public JComponent getExpandMainComponent(int index) {
        return this.expandMainComponentList.get(index);
    }

    private void fireNewPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarNewPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.NEW));
        }
    }

    private void fireOpenPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarOpenPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.OPEN));
        }
    }

    private void fireEditPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarEditPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.EDIT));
        }
    }

    private void fireSavePerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarSavePerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.SAVE));
        }
    }

    private void fireCancelPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarCancelPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.CANCEL));
        }
    }

    private void fireDeletePerformed() {
        boolean force = true;
        if (validator != null) {
            force = validator.isDeleteConfirmed();
        }
        if (force) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != JBToolbarListener.class) continue;
                ((JBToolbarListener)listeners[i + 1]).toolbarDeletePerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.DELETE));
            }
        }
    }

    private void fireVoidPerformed() {
        boolean force = true;
        if (validator != null) {
            force = validator.isVoidConfirmed();
        }
        if (force) {
            this.isVoid = true;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != JBToolbarListener.class) continue;
                ((JBToolbarListener)listeners[i + 1]).toolbarVoidPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.VOID));
            }
            if (this.state != null && this.state.getState() != 0) {
                this.isVoid = false;
            }
        }
    }

    private void firePrintPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarPrintPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.PRINT));
        }
    }

    private void fireRefreshPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarListener.class) continue;
            ((JBToolbarListener)listeners[i + 1]).toolbarRefreshPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.REFRESH));
        }
    }

    private void fireHelpPerformed() {
        if (this.useInnerHelpAction) {
            Component frame = BUtil.getComponentFrame((Component)this);
            if (frame != null) {
                String className = frame.getClass().getSimpleName();
                HelpMgr.getInstance().showHelpWindow(className);
            }
        } else {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != JBToolbarHelpListener.class) continue;
                ((JBToolbarHelpListener)listeners[i + 1]).toolbarHelpPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.HELP));
            }
        }
    }

    private void fireXLSPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarXLSListener.class) continue;
            ((JBToolbarXLSListener)listeners[i + 1]).toolbarXLSPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.XLS));
        }
    }

    private void fireSaveDraftPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JBToolbarDraftListener.class) continue;
            ((JBToolbarDraftListener)listeners[i + 1]).toolbarSaveDraftPerformed(new JBToolbarEvent((JToolBar)this, JBToolbarEvent.TOOLBAR_EVENTTYPE.DRAFT));
        }
    }

    public void setEnableNew(boolean enabled) {
        this.enableNew = enabled;
        this.getBtnNew().setEnabled(enabled);
        this.getBtnNew().setVisible(enabled);
    }

    public boolean isEnableNew() {
        return this.getBtnNew().isEnabled();
    }

    public void setEnableOpen(boolean enabled) {
        this.enableOpen = enabled;
        this.getBtnOpen().setEnabled(enabled);
        this.getBtnOpen().setVisible(enabled);
    }

    public boolean isEnableOpen() {
        return this.getBtnOpen().isEnabled();
    }

    public void setEnableEdit(boolean enabled) {
        this.enableEdit = this.isVoid ? false : enabled;
        this.getBtnEdit().setEnabled(this.enableEdit);
        this.getBtnEdit().setVisible(this.enableEdit);
        this.isVoid = false;
    }

    public boolean isEnableEdit() {
        return this.getBtnEdit().isEnabled();
    }

    public void setEnableSave(boolean enabled) {
        this.enableSave = enabled;
        this.getBtnSave().setEnabled(enabled);
        this.getBtnSave().setVisible(enabled);
    }

    public boolean isEnableSave() {
        return this.getBtnSave().isEnabled();
    }

    public void setEnableSaveDraft(boolean enabled) {
        this.enableDraft = enabled;
        this.getBtnSaveDraft().setEnabled(enabled);
        this.getBtnSaveDraft().setVisible(enabled);
    }

    public boolean isEnableSaveDraft() {
        return this.getBtnSaveDraft().isEnabled();
    }

    public void setEnableCancel(boolean enabled) {
        this.enableCancel = enabled;
        this.getBtnCancel().setEnabled(this.enableCancel);
        this.getBtnCancel().setVisible(this.enableCancel);
    }

    public boolean isEnableCancel() {
        return this.enableCancel;
    }

    public void setEnableDelete(boolean enabled) {
        this.enableDelete = enabled;
        this.getBtnDelete().setEnabled(this.enableDelete);
        this.getBtnDelete().setVisible(this.enableDelete);
    }

    public boolean isEnableDelete() {
        return this.enableDelete;
    }

    public void setEnableVoid(boolean enabled) {
        this.enableVoid = enabled;
        this.getBtnVoid().setEnabled(this.enableVoid);
        this.getBtnVoid().setVisible(this.enableVoid);
    }

    public boolean isEnableVoid() {
        return this.enableVoid;
    }

    public void setEnablePrint(boolean enabled) {
        this.enablePrint = enabled;
        if (this.authMgr == null || this.objid == null) {
            this.getBtnPrint().setEnabled(this.enablePrint);
            this.getBtnPrint().setVisible(this.enablePrint);
        } else {
            this.getBtnPrint().setEnabled(this.enablePrint && this.checkEnablePrint());
            this.getBtnPrint().setVisible(this.enablePrint && this.checkEnablePrint());
        }
    }

    public boolean isEnablePrint() {
        return this.enablePrint;
    }

    private boolean checkEnablePrint() {
        boolean retval = false;
        retval = this.state == null || this.oldState == 1 && this.authMgr.getAuth(this.objid, "PRN") && this.authMgr.getAuth(this.objid, "REPRN") || (this.oldState == 2 || this.state.getState() == 2) && this.authMgr.getAuth(this.objid, "PRN");
        return retval;
    }

    public void setEnableRefresh(boolean enabled) {
        this.enableRefresh = enabled;
        this.getBtnRefresh().setVisible(this.enableRefresh);
        this.getBtnRefresh().setEnabled(this.enableRefresh);
    }

    public boolean isEnableRefresh() {
        return this.enableRefresh;
    }

    public void setEditStyle(String editstyle) {
        if (editstyle.equalsIgnoreCase("B") || editstyle.equalsIgnoreCase("O")) {
            this.editstyle = editstyle;
            this.getBtnOpen().setVisible(editstyle.equalsIgnoreCase("O"));
        }
    }

    public String getEditStyle() {
        return this.editstyle;
    }

    public int getPrintMode() {
        return this.printMode;
    }

    public void setPrintMode(int printMode) {
        this.printMode = printMode;
    }

    public boolean isEnableChoosePrintMode() {
        return this.enableChoosePrintMode;
    }

    public void setEnableChoosePrintMode(boolean enableChoosePrintMode) {
        this.enableChoosePrintMode = enableChoosePrintMode;
    }

    public boolean isEnableHelp() {
        return this.enableHelp;
    }

    public void setEnableHelp(boolean enableHelp) {
        this.enableHelp = enableHelp;
        this.getBtnHelp().setVisible(enableHelp);
        this.getBtnHelp().setEnabled(enableHelp);
    }

    public static void setValidator(JBToolbarValidator aValidator) {
        validator = aValidator;
    }

    public boolean isEnableXLS() {
        return this.enableXLS;
    }

    public void setEnableXLS(boolean enableXLS) {
        this.enableXLS = enableXLS;
        this.getBtnXLS().setVisible(enableXLS);
        this.getBtnXLS().setEnabled(enableXLS);
    }

    public boolean isUseInnerHelpAction() {
        return this.useInnerHelpAction;
    }

    public void setUseInnerHelpAction(boolean useInnerHelpAction) {
        this.useInnerHelpAction = useInnerHelpAction;
    }

    public JButton getBtnCancel() {
        return this.btnCancel;
    }

    public JButton getBtnDelete() {
        return this.btnDelete;
    }

    public JButton getBtnEdit() {
        return this.btnEdit;
    }

    public JButton getBtnHelp() {
        return this.btnHelp;
    }

    public JButton getBtnNew() {
        return this.btnNew;
    }

    public JButton getBtnOpen() {
        return this.btnOpen;
    }

    public JButton getBtnPrint() {
        return this.btnPrint;
    }

    public JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    public JButton getBtnSave() {
        return this.btnSave;
    }

    public JButton getBtnVoid() {
        return this.btnVoid;
    }

    public JButton getBtnXLS() {
        return this.btnXLS;
    }

    public JButton getBtnSaveDraft() {
        return this.btnSaveDraft;
    }

    private void initializeAccess() {
        if (this.objid != null && this.objid.length() > 0 && this.authMgr != null) {
            this.setEnableSaveDraft(this.authMgr.getAuth(this.objid, "DRAFT"));
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.mnTextRpt = new JMenuItem();
        this.mnGraphicRpt = new JMenuItem();
        this.btnHelp = new JButton();
        this.separatorHelp = new JSeparator();
        this.btnXLS = new JButton();
        this.btnNew = new JButton();
        this.btnOpen = new JButton();
        this.btnEdit = new JButton();
        this.btnSave = new JButton();
        this.btnSaveDraft = new JButton();
        this.btnCancel = new JButton();
        this.btnDelete = new JButton();
        this.btnVoid = new JButton();
        this.btnPrint = new JButton();
        this.btnRefresh = new JButton();
        this.mnTextRpt.setMnemonic('T');
        this.mnTextRpt.setText("Text Report");
        this.mnTextRpt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.mnTextRptActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.mnTextRpt);
        this.mnGraphicRpt.setMnemonic('G');
        this.mnGraphicRpt.setText("Grafik Report");
        this.mnGraphicRpt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.mnGraphicRptActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.mnGraphicRpt);
        this.btnHelp.setFont(new Font("Dialog", 1, 11));
        this.btnHelp.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/help.png")));
        this.btnHelp.setMnemonic('H');
        this.btnHelp.setText("Help");
        this.btnHelp.setMargin(new Insets(2, 2, 2, 2));
        this.btnHelp.setPreferredSize(new Dimension(75, 28));
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnHelpActionPerformed(evt);
            }
        });
        this.separatorHelp.setOrientation(1);
        this.btnXLS.setFont(new Font("Dialog", 1, 11));
        this.btnXLS.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/xls.png")));
        this.btnXLS.setMnemonic('L');
        this.btnXLS.setText("XLS");
        this.btnXLS.setMargin(new Insets(2, 2, 2, 2));
        this.btnXLS.setPreferredSize(new Dimension(75, 28));
        this.btnXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnXLSActionPerformed(evt);
            }
        });
        this.setPreferredSize(new Dimension(20, 50));
        this.btnNew.setFont(new Font("Dialog", 1, 11));
        this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/new.png")));
        this.btnNew.setMnemonic('N');
        this.btnNew.setText("New");
        this.btnNew.setMargin(new Insets(2, 2, 2, 2));
        this.btnNew.setPreferredSize(new Dimension(75, 28));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnNewActionPerformed(evt);
            }
        });
        this.add(this.btnNew);
        this.btnOpen.setFont(new Font("Dialog", 1, 11));
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/open.png")));
        this.btnOpen.setMnemonic('O');
        this.btnOpen.setText("Open");
        this.btnOpen.setMargin(new Insets(2, 2, 2, 2));
        this.btnOpen.setPreferredSize(new Dimension(75, 28));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnOpenActionPerformed(evt);
            }
        });
        this.add(this.btnOpen);
        this.btnEdit.setFont(new Font("Dialog", 1, 11));
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/edit.png")));
        this.btnEdit.setMnemonic('E');
        this.btnEdit.setText("Edit");
        this.btnEdit.setMargin(new Insets(2, 2, 2, 2));
        this.btnEdit.setPreferredSize(new Dimension(75, 28));
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnEditActionPerformed(evt);
            }
        });
        this.add(this.btnEdit);
        this.btnSave.setFont(new Font("Dialog", 1, 11));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/save.png")));
        this.btnSave.setMnemonic('S');
        this.btnSave.setText("Save");
        this.btnSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnSave.setPreferredSize(new Dimension(75, 28));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnSaveActionPerformed(evt);
            }
        });
        this.add(this.btnSave);
        this.btnSaveDraft.setFont(new Font("Dialog", 1, 11));
        this.btnSaveDraft.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/modify.png")));
        this.btnSaveDraft.setMnemonic('S');
        this.btnSaveDraft.setText("SaveDraft");
        this.btnSaveDraft.setMargin(new Insets(2, 2, 2, 2));
        this.btnSaveDraft.setPreferredSize(new Dimension(100, 28));
        this.btnSaveDraft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnSaveDraftActionPerformed(evt);
            }
        });
        this.add(this.btnSaveDraft);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/cancel.png")));
        this.btnCancel.setMnemonic('C');
        this.btnCancel.setText("Cancel");
        this.btnCancel.setMargin(new Insets(2, 2, 2, 2));
        this.btnCancel.setPreferredSize(new Dimension(75, 28));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnCancelActionPerformed(evt);
            }
        });
        this.add(this.btnCancel);
        this.btnDelete.setFont(new Font("Dialog", 1, 11));
        this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/delete.png")));
        this.btnDelete.setMnemonic('D');
        this.btnDelete.setText("Delete");
        this.btnDelete.setMargin(new Insets(2, 2, 2, 2));
        this.btnDelete.setPreferredSize(new Dimension(75, 28));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnDeleteActionPerformed(evt);
            }
        });
        this.add(this.btnDelete);
        this.btnVoid.setFont(new Font("Dialog", 1, 11));
        this.btnVoid.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/void.png")));
        this.btnVoid.setMnemonic('V');
        this.btnVoid.setText("Void");
        this.btnVoid.setMargin(new Insets(2, 2, 2, 2));
        this.btnVoid.setPreferredSize(new Dimension(75, 28));
        this.btnVoid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnVoidActionPerformed(evt);
            }
        });
        this.add(this.btnVoid);
        this.btnPrint.setFont(new Font("Dialog", 1, 11));
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/print.png")));
        this.btnPrint.setMnemonic('p');
        this.btnPrint.setText("Print");
        this.btnPrint.setComponentPopupMenu(this.popupMenu);
        this.btnPrint.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrint.setPreferredSize(new Dimension(75, 28));
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnPrintActionPerformed(evt);
            }
        });
        this.add(this.btnPrint);
        this.btnRefresh.setFont(new Font("Dialog", 1, 11));
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/lib/dbswing/images/refresh.png")));
        this.btnRefresh.setMnemonic('R');
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.btnRefresh.setPreferredSize(new Dimension(85, 28));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JBToolbarCustom.this.btnRefreshActionPerformed(evt);
            }
        });
        this.add(this.btnRefresh);
    }

    private void btnSaveDraftActionPerformed(ActionEvent evt) {
        this.doSaveDraft();
    }

    private void btnXLSActionPerformed(ActionEvent evt) {
        this.doXLS();
    }

    private void btnHelpActionPerformed(ActionEvent evt) {
        this.doHelp();
    }

    private void mnGraphicRptActionPerformed(ActionEvent evt) {
        this.setPrintMode(1);
        this.doPrint();
    }

    private void mnTextRptActionPerformed(ActionEvent evt) {
        this.setPrintMode(0);
        this.doPrint();
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        this.doEdit();
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        this.doNew();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.doOpen();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.doSave();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void btnVoidActionPerformed(ActionEvent evt) {
        this.doVoid();
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.doDelete();
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        if (this.isEnableChoosePrintMode()) {
            this.doChoosePrint();
        } else {
            this.doPrint();
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.doRefresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equalsIgnoreCase("ancestor") || evt.getNewValue() != null) {
            // empty if block
        }
    }

    public boolean checkPrintAccess() {
        boolean retval = this.authMgr == null || this.objid == null || this.state == null || this.oldState == 1 && this.authMgr.getAuthDlg(this.objid, "PRN") || (this.oldState == 2 || this.newState == 2) && this.authMgr.getAuthDlg(this.objid, "REPRN") && this.authMgr.getAuthDlg(this.objid, "PRN");
        return retval;
    }

    class ToolbarAncestorListener
    implements AncestorListener {
        ToolbarAncestorListener() {
        }

        private boolean valid(String lowerClassName, String targetKey) {
            if (lowerClassName.contains("fa") && !targetKey.contains("fa") || targetKey.contains("fa") && !lowerClassName.contains("fa")) {
                return false;
            }
            return lowerClassName.contains(targetKey);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            JInternalFrame iFrame = SwingUtil.iFrameForComponent((JComponent)JBToolbarCustom.this);
            if (null != iFrame && iFrame instanceof BToolbarExtensionAware && JBToolbarCustom.this.newOpen) {
                JBToolbarCustom.this.newOpen = false;
                String lowerClassName = iFrame.getClass().getSimpleName().toLowerCase();
                Collection extensionActions = Lookup.getDefault().lookupAll(BToolbarExtensionAction.class);
                for (BToolbarExtensionAction extensionAction : extensionActions) {
                    String[] targetKeys = extensionAction.getTargetKeys();
                    if (null == targetKeys) continue;
                    for (String targetKey : targetKeys) {
                        if (!this.valid(lowerClassName, targetKey)) continue;
                        if (null == JBToolbarCustom.this.extensionActionList) {
                            JBToolbarCustom.this.extensionActionList = new ArrayList();
                        }
                        try {
                            BToolbarExtensionAction newInstance = (BToolbarExtensionAction)extensionAction.getClass().newInstance();
                            newInstance.setExtensionAware((BToolbarExtensionAware)((Object)iFrame));
                            newInstance.setToolbar(JBToolbarCustom.this);
                            newInstance.setIFrame(iFrame);
                            JBToolbarCustom.this.extensionActionList.add(newInstance);
                        }
                        catch (InstantiationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (IllegalAccessException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                if (null != JBToolbarCustom.this.extensionActionList && !JBToolbarCustom.this.extensionActionList.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int separatorIndex = JBToolbarCustom.this.getComponentIndex(JBToolbarCustom.this.separatorHelp);
                            JDropDownButton button = new JDropDownButton("Tools");
                            button.setFont(new Font(BUIResources.getDefaultFontName(), 1, BUIResources.getDefaultFontSize()));
                            button.setMargin(new Insets(2, 2, 2, 2));
                            JBToolbarCustom.this.add((Component)button, separatorIndex);
                            JPopupMenu popupMenu = new JPopupMenu();
                            button.setPopupMenu(popupMenu);
                            for (BToolbarExtensionAction extensionAction : JBToolbarCustom.this.extensionActionList) {
                                JMenuItem menuItem = new JMenuItem(extensionAction);
                                popupMenu.add(menuItem);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    class StateAdapter
    implements PropertyChangeListener {
        StateAdapter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("state")) {
                JBToolbarCustom.this.oldState = (Integer)propertyChangeEvent.getOldValue();
                JBToolbarCustom.this.newState = (Integer)propertyChangeEvent.getNewValue();
                JBToolbarCustom.this.getBtnNew().setVisible(JBToolbarCustom.this.getBtnNew().isEnabled() && JBToolbarCustom.this.state.getState() == 0);
                JBToolbarCustom.this.getBtnOpen().setVisible(JBToolbarCustom.this.getBtnOpen().isEnabled() && JBToolbarCustom.this.state.getState() == 0);
                JBToolbarCustom.this.getBtnEdit().setVisible(JBToolbarCustom.this.getBtnEdit().isEnabled() && JBToolbarCustom.this.state.getState() == 0);
                JBToolbarCustom.this.getBtnSave().setVisible(JBToolbarCustom.this.getBtnSave().isEnabled() && JBToolbarCustom.this.state.getState() != 0);
                JBToolbarCustom.this.getBtnSaveDraft().setVisible(JBToolbarCustom.this.getBtnSaveDraft().isEnabled() && JBToolbarCustom.this.state.getState() != 0);
                JBToolbarCustom.this.getBtnCancel().setVisible(JBToolbarCustom.this.getBtnCancel().isEnabled() && JBToolbarCustom.this.state.getState() != 0);
                JBToolbarCustom.this.getBtnPrint().setVisible(JBToolbarCustom.this.getBtnPrint().isEnabled() && JBToolbarCustom.this.state.getState() != 0);
                JBToolbarCustom.this.getBtnDelete().setVisible(JBToolbarCustom.this.getBtnDelete().isEnabled() && (JBToolbarCustom.this.editstyle.equalsIgnoreCase("B") && JBToolbarCustom.this.state.getState() == 0 || JBToolbarCustom.this.editstyle.equalsIgnoreCase("O") && JBToolbarCustom.this.state.getState() == 2));
                JBToolbarCustom.this.getBtnVoid().setVisible(JBToolbarCustom.this.getBtnVoid().isEnabled() && JBToolbarCustom.this.state.getState() == 2);
                JBToolbarCustom.this.getBtnEdit().setVisible(JBToolbarCustom.this.getBtnEdit().isEnabled() && JBToolbarCustom.this.state.getState() == 0);
            }
        }
    }

    public static enum TOOL_ACT {
        CANCEL,
        DELETE,
        EDIT,
        NEW,
        OPEN,
        PRINT,
        REFRESH,
        SAVE,
        DRAFT,
        VOID,
        HELP,
        NONE,
        XLS;

    }
}

