/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui.mySwing;

import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.abstraction.SalesForm;
import com.bits.bee.ui.factory.form.SalesFormFactory;
import com.bits.beebengkel.bl.BillBengkel;
import com.bits.beebengkel.bl.BillSale;
import com.bits.beebengkel.bl.QueueInfo;
import com.bits.beebengkel.bl.SaleBengkel;
import com.bits.beebengkel.ui.Abstraction.AbstractDlgNewBill;
import com.bits.beebengkel.ui.Abstraction.AntrianForm;
import com.bits.beebengkel.ui.FrmSaleBengkel;
import com.bits.beebengkel.ui.factory.dlg.DlgNewBillFactory;
import com.bits.core.ui.touch.TouchButton;
import com.bits.core.ui.touch.TouchListPanel;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.security.AuthMgr;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.NumberFormat;
import java.util.logging.Level;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuePanel
extends TouchListPanel<QueueInfo> {
    protected BillBengkel bill;
    protected BillSale billSale = (BillSale)BTableProvider.createTable(BillSale.class);
    protected SaleBengkel saleBengkel;
    protected DataRow lookupRow;
    private final NumberFormat formatter = NumberFormat.getInstance();
    private JPopupMenu popUpMenu;
    private AntrianForm form = null;
    private final QueryDataSet qds = new QueryDataSet();
    private String objid = "";
    private String objid_sale = "";
    private AuthMgr authMgr;
    private StringBuilder Filter;
    private static Logger logger = LoggerFactory.getLogger(QueuePanel.class);

    public QueuePanel() {
        this.setMaximumColumn(3);
        this.setMaximumRow(3);
        this.setShowPaging(true);
        this.enableDefaultKeyStroke();
        this.enableNumberKeyStroke();
    }

    private void initPopUp() {
        JMenuItem menuOpenSale = new JMenuItem("Open Penjualan");
        menuOpenSale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QueuePanel.this.authMgr == null || QueuePanel.this.objid_sale == null || QueuePanel.this.authMgr.getAuthDlg(QueuePanel.this.objid_sale, "UPD")) {
                    QueuePanel.this.OpenSale();
                }
            }
        });
        JMenuItem menuEdit = new JMenuItem("Edit PKB");
        menuEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QueuePanel.this.authMgr == null || QueuePanel.this.objid == null || QueuePanel.this.authMgr.getAuthDlg(QueuePanel.this.objid, "UPD")) {
                    QueuePanel.this.EditBill();
                }
            }
        });
        JMenuItem menuDelete = new JMenuItem("Delete PKB");
        menuDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QueuePanel.this.authMgr == null || QueuePanel.this.objid == null || QueuePanel.this.authMgr.getAuthDlg(QueuePanel.this.objid, "UPD")) {
                    QueuePanel.this.DeleteBill();
                }
            }
        });
        this.popUpMenu = new JPopupMenu();
        this.popUpMenu.add(menuOpenSale);
        this.popUpMenu.add(menuEdit);
        this.popUpMenu.add(menuDelete);
    }

    public void setObjid(String objid) {
        this.objid = objid;
    }

    public void setObjid_sale(String objid_sale) {
        this.objid_sale = objid_sale;
    }

    public void setAuthMgr(AuthMgr authMgr) {
        this.authMgr = authMgr;
    }

    public void init() {
        try {
            this.bill = new BillBengkel();
            this.bill.setOrderBy("billno ASC");
            this.setDataSet(this.bill.getDataSet(), "billno", "bpname");
            this.billSale.Load();
            this.Filter = new StringBuilder("paystatus='N' ");
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String formatCurrency(BigDecimal input) {
        String string = this.formatter.format(input.intValue());
        return string;
    }

    public void setFilter(String filter) {
        this.Filter.append(filter);
    }

    public void generateContent() {
        try {
            this.bill.Load(this.Filter.toString());
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(QueuePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.lookupRow = new DataRow(this.bill.getDataSet(), "billno");
        super.generateContent();
    }

    public TouchButton createTouchButton(DataSet dataSet) {
        TouchButton button = super.createTouchButton(dataSet);
        String kode = dataSet.getString("billstatus");
        button.setBackground(this.getBillButtonBackgroundColor(kode));
        button.setForeground(this.getBillButtonForegroundColor(this.getBillButtonBackgroundColor(kode)));
        return button;
    }

    public String modifyText(String text) {
        String carnopol = this.bill.getDataSet().getString("carnopol");
        String name = this.bill.getDataSet().getString("bpname");
        String noAntrian = "(" + Integer.toString(this.bill.getDataSet().getInt("queno")) + ")";
        int ind = this.bill.getDataSet().getRow() + 1;
        int max = this.getMaximumRow() * this.getMaximumColumn();
        ind = (ind %= max) == 0 ? 9 : ind;
        String index = "[Alt + " + Integer.toString(ind) + "]";
        this.billSale = BillSale.getInstance();
        String saleno = this.billSale.getSaleno(this.bill.getDataSet().getString("billno"));
        String itemdesc = "";
        if (saleno != null) {
            String query = "select saled.itemdesc from saled Left join item On saled.itemid = item.itemid Where itemtype = 'SERV' and saleno=" + BHelp.QuoteSingle((String)saleno);
            if (this.qds.isOpen()) {
                this.qds.close();
            }
            this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), query));
            this.qds.open();
            for (int i = 0; i < this.qds.rowCount(); ++i) {
                this.qds.goToRow(i);
                if (i >= 4) break;
                itemdesc = i == 0 ? this.qds.getString(0) : itemdesc + ", " + this.qds.getString(0);
            }
            itemdesc = "[" + itemdesc + "]";
        }
        String total = String.format("Rp.%s", this.formatCurrency(this.bill.getDataSet().getBigDecimal("billtotal")));
        String buttonText = "<html><center><font size=+2>" + noAntrian + " " + carnopol + "</font><br>" + name + "<br>" + itemdesc + "</center></html>";
        return buttonText;
    }

    public QueueInfo createEventService(Object ... os) {
        QueueInfo queueInfo = new QueueInfo((String)os[0], (String)os[1]);
        this.lookupRow.setString("billno", (String)os[0]);
        if (this.bill.getDataSet().locate((ReadRow)this.lookupRow, 32)) {
            try {
                this.initPopUp();
                PointerInfo a = MouseInfo.getPointerInfo();
                Point b = a.getLocation();
                int x = (int)b.getX();
                int y = (int)b.getY();
                this.popUpMenu.show((Component)ScreenManager.getMainFrame(), x - 50, y);
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
        }
        return queueInfo;
    }

    public void EditBill() {
        AbstractDlgNewBill dlg = DlgNewBillFactory.getDefault().getDialog();
        dlg.doEdit(this.bill.getDataSet().getString("billno"));
        if (this.isSaled()) {
            dlg.doEnable(false);
        } else {
            dlg.doEnable(true);
        }
        dlg.setAntrianForm(this.form);
        dlg.setVisible(true);
        if (!dlg.isCancel()) {
            this.init();
            this.generateContent();
            this.repaint();
        }
    }

    public void OpenSale() {
        this.billSale = BillSale.getInstance();
        String saleno = this.billSale.getSaleno(this.bill.getDataSet().getString("billno"));
        if (saleno != null) {
            SalesForm frmSales = SalesFormFactory.getDefault().createSalesForm();
            ScreenManager.getMainFrame().addInternalFrame(frmSales.getFormComponent());
            frmSales.doEdit(saleno);
        } else {
            String billNo = this.bill.getDataSet().getString("billno");
            String custid = this.bill.getDataSet().getString("bpid");
            String carnopol = this.bill.getDataSet().getString("carnopol");
            Date saleDate = this.bill.getDataSet().getDate("billdate");
            String srepid = this.bill.getDataSet().getString("srepid");
            String branchid = this.bill.getDataSet().getString("branchid");
            branchid = !"".equalsIgnoreCase(branchid) ? branchid : null;
            FrmSaleBengkel formBengkel = (FrmSaleBengkel)SalesFormFactory.getDefault().createSalesForm();
            ScreenManager.getMainFrame().addInternalFrame((JInternalFrame)formBengkel);
            formBengkel.doNewFromBill(billNo, carnopol, custid, saleDate, srepid, branchid);
        }
    }

    public void DeleteBill() {
        int choice = UIMgr.YesNo((String)"Hapus PKB");
        if (choice == 0) {
            AbstractDlgNewBill dlg = DlgNewBillFactory.getDefault().getDialog();
            dlg.doDelete(this.bill.getDataSet().getString("billno"));
            this.init();
            this.generateContent();
            this.repaint();
        }
    }

    private Color getButtonBackgroundColor(String kode) {
        if ("Q1".equalsIgnoreCase(kode)) {
            return Color.GREEN;
        }
        if ("Q2".equalsIgnoreCase(kode)) {
            return Color.YELLOW;
        }
        return Color.RED;
    }

    private Color getButtonForegroundColor(Color color) {
        if (color == Color.RED) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private Color getBillButtonBackgroundColor(String kode) {
        if ("N".equalsIgnoreCase(kode)) {
            return Color.GREEN;
        }
        if ("H".equalsIgnoreCase(kode)) {
            return Color.YELLOW;
        }
        return Color.RED;
    }

    private Color getBillButtonForegroundColor(Color color) {
        if (color == Color.RED) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private boolean isSaled() {
        this.billSale = BillSale.getInstance();
        String saleno = this.billSale.getSaleno(this.bill.getDataSet().getString("billno"));
        return saleno != null;
    }

    public void setAntrianForm(AntrianForm form) {
        this.form = form;
    }
}

