/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.util;

import com.bits.bee.bl.Crc;
import com.bits.beebengkel.util.DlgRcvDP;
import com.bits.lib.dx.BTrans;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import java.math.BigDecimal;

public class DPUtil {
    public static DPUtil create() {
        return new DPUtil();
    }

    public void generateDPRow(DataSet source, DataSet destination) {
        destination.emptyAllRows();
        if (source.getRowCount() > 0) {
            DataRow newrow = new DataRow(destination);
            if (source.getString("refno").length() > 0) {
                newrow.setString("refno", source.getString("refno"));
            }
            if (source.getString("note").length() > 0) {
                newrow.setString("note", source.getString("note"));
            }
            if (source.getString("cashid").length() > 0) {
                newrow.setString("cashid", source.getString("cashid"));
            }
            if (source.getString("cbgid").length() > 0) {
                newrow.setString("cbgid", source.getString("cbgid"));
            }
            if (source.getString("mtd").length() > 0) {
                newrow.setString("mtd", source.getString("mtd"));
            }
            newrow.setLong("dpid", source.getBigDecimal("dpid").longValue());
            newrow.setString("paidno", source.getString("paidno"));
            newrow.setString("dppaidno", source.getString("dppaidno"));
            newrow.setString("bpid", source.getString("bpid"));
            newrow.setString("branchid", source.getString("branchid"));
            newrow.setString("crcid", source.getString("crcid"));
            newrow.setString("paidcrcid", source.getString("paidcrcid"));
            newrow.setDate("dpdate", source.getDate("dpdate"));
            newrow.setBigDecimal("dpamt", source.getBigDecimal("dpamt"));
            newrow.setBigDecimal("usedamt", source.getBigDecimal("usedamt"));
            newrow.setBigDecimal("dpbal", source.getBigDecimal("dpbal"));
            newrow.setBigDecimal("paidamt", source.getBigDecimal("paidamt"));
            newrow.setBigDecimal("excrate", source.getBigDecimal("excrate"));
            newrow.setBigDecimal("fisrate", source.getBigDecimal("fisrate"));
            newrow.setBigDecimal("paidexcrate", source.getBigDecimal("paidexcrate"));
            newrow.setBigDecimal("paidfisrate", source.getBigDecimal("paidfisrate"));
            newrow.setBoolean("isautogendp", source.getBoolean("isautogendp"));
            destination.addRow(newrow);
        }
    }

    public void generateDP(boolean doGenerate, DataSet ds, BTrans trans, String bpId) {
        if (doGenerate) {
            DataRow dr = new DataRow(ds);
            DlgRcvDP dlgRcvDP = DlgRcvDP.getInstance();
            dlgRcvDP.setDateColumn("sodate");
            dlgRcvDP.setBTrans(trans);
            dlgRcvDP.setDataset(dr, false, BigDecimal.ZERO);
            dlgRcvDP.setCustID(bpId);
            dlgRcvDP.setVisible(true);
            if (dlgRcvDP.getSelectedID() != null) {
                this.generateFakeDPRow(dlgRcvDP.getDataset(), ds, trans);
            }
        }
    }

    private void generateFakeDPRow(DataRow dr, DataSet ds, BTrans trans) {
        ds.emptyAllRows();
        DataRow newrow = new DataRow(ds);
        if (dr.getString("refno").length() > 0) {
            newrow.setString("refno", dr.getString("refno"));
        }
        if (dr.getString("note").length() > 0) {
            newrow.setString("note", dr.getString("note"));
        }
        if (dr.getString("cashid").length() > 0) {
            newrow.setString("cashid", dr.getString("cashid"));
        }
        if (dr.getString("cbgid").length() > 0) {
            newrow.setString("cbgid", dr.getString("cbgid"));
        }
        if (dr.getString("mtd").length() > 0) {
            newrow.setString("mtd", dr.getString("mtd"));
        }
        newrow.setLong("dpid", BigDecimal.ZERO.longValue());
        newrow.setString("paidno", "AUTO");
        newrow.setString("dppaidno", "AUTO");
        newrow.setString("bpid", trans.getDataSetMaster().getString("custid"));
        newrow.setString("branchid", trans.getDataSetMaster().getString("branchid"));
        newrow.setString("crcid", trans.getDataSetMaster().getString("crcid"));
        newrow.setString("paidcrcid", dr.getString("crcid"));
        if (dr.getDate("dpdate") != null && dr.getDate("dpdate").toString().length() > 0) {
            newrow.setDate("dpdate", dr.getDate("dpdate"));
        } else {
            newrow.setDate("dpdate", trans.getDataSetMaster().getDate("sodate"));
        }
        newrow.setBigDecimal("excrate", trans.getDataSetMaster().getBigDecimal("excrate"));
        newrow.setBigDecimal("fisrate", trans.getDataSetMaster().getBigDecimal("fisrate"));
        if (trans.getDataSetMaster().getString("crcid").equalsIgnoreCase(dr.getString("crcid"))) {
            newrow.setBigDecimal("paidexcrate", trans.getDataSetMaster().getBigDecimal("excrate"));
            newrow.setBigDecimal("paidfisrate", trans.getDataSetMaster().getBigDecimal("fisrate"));
        } else {
            newrow.setBigDecimal("paidexcrate", Crc.getInstance().getExcRate(dr.getString("crcid")));
            newrow.setBigDecimal("paidfisrate", Crc.getInstance().getFisRate(dr.getString("crcid")));
        }
        newrow.setBigDecimal("dpamt", dr.getBigDecimal("paidamt"));
        newrow.setBigDecimal("usedamt", dr.getBigDecimal("paidamt"));
        newrow.setBigDecimal("paidamt", dr.getBigDecimal("paidamt"));
        newrow.setBigDecimal("dpbal", BigDecimal.ZERO);
        newrow.setBoolean("isautogendp", true);
        ds.addRow(newrow);
    }
}

