/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.util;

import com.bits.bee.bl.Cash;
import com.bits.bee.bl.CashList;
import com.bits.bee.bl.CbgList;
import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.conf.InstanceMgr;
import com.bits.bee.ui.DlgBayarPiutang;
import com.bits.bee.ui.DlgSRet;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.BtnCancel;
import com.bits.bee.ui.myswing.BtnOK;
import com.bits.bee.ui.myswing.ComponentResources;
import com.bits.bee.ui.myswing.CrcChangeObserver;
import com.bits.bee.ui.myswing.JBdbCrcTextField;
import com.bits.bee.ui.myswing.JCboCash;
import com.bits.bee.ui.myswing.JCboCrByr;
import com.bits.bee.ui.myswing.PikCbg;
import com.bits.bee.ui.myswing.PikLebihJual;
import com.bits.beebengkel.util.DlgCbgPay;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBDatePicker;
import com.bits.lib.dbswing.JBDialog;
import com.bits.lib.dx.BTrans;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.security.BAuthMgr;
import com.borland.dbswing.JdbTextArea;
import com.borland.dbswing.JdbTextField;
import com.borland.dx.dataset.DataRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgRcvDP
extends JBDialog
implements InstanceObserver,
ResourceGetter {
    private static Logger logger = LoggerFactory.getLogger(com.bits.bee.ui.DlgRcvDP.class);
    private static DlgRcvDP dlg = null;
    private DataRow dataRow = null;
    private String custId;
    private String refno;
    private final LocaleInstance l = LocaleInstance.getInstance();
    private DlgSRet dlgSRet;
    private BigDecimal rcvamt = BigDecimal.ZERO;
    private BTrans btrans;
    private String dateColumn = "saledate";
    private BtnCancel btnCancel2;
    private BtnOK btnOK2;
    private JBDatePicker jBDatePicker1;
    private JBdbCrcTextField jBdbCrcTextField1;
    private JCboCash jCboCash1;
    private JCboCrByr jCboCrByr1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JdbTextArea jdbTextArea1;
    private JdbTextField jdbTextField1;
    private PikCbg pikCbg1;
    private PikLebihJual pikLebihJual1;

    public DlgRcvDP() {
        super((Frame)null, "Dialog Detail Pembayaran");
        this.init();
        this.setTopFocusComponent((JComponent)this.jBdbCrcTextField1);
    }

    public static synchronized DlgRcvDP getInstance() {
        if (dlg == null) {
            dlg = new DlgRcvDP();
            InstanceMgr.getInstance().addObserver((InstanceObserver)dlg);
        }
        return dlg;
    }

    public void setDateColumn(String dateColumn) {
        this.dateColumn = dateColumn;
    }

    private void VisibleAll(boolean state) {
        this.jLabel8.setVisible(state);
        this.pikLebihJual1.setVisible(state);
        this.jLabel2.setVisible(state);
        this.jCboCash1.setVisible(state);
        this.jLabel5.setVisible(state);
        this.jBdbCrcTextField1.setVisible(state);
        this.jLabel6.setVisible(state);
        this.jdbTextArea1.setVisible(state);
        this.jLabel3.setVisible(state);
        this.pikCbg1.setVisible(state);
    }

    public void setDataset(DataRow dr, boolean b, BigDecimal bc) {
        this.dataRow = dr;
        this.jLabel9.setText(BUtil.bigDecimalToString((BigDecimal)this.btrans.getDataSetMaster().getBigDecimal("total")));
        this.jBDatePicker1.setDate((java.util.Date)this.btrans.getDataSetMaster().getDate(this.dateColumn));
        this.jBDatePicker1.setKeyValue((java.util.Date)this.btrans.getDataSetMaster().getDate(this.dateColumn));
        if (b) {
            this.pikLebihJual1.setKeyValue(dr.getString("refno"));
            this.pikCbg1.setKeyValue(dr.getString("cbgid"));
            this.jCboCash1.setKeyValue(dr.getString("cashid"));
            this.jCboCrByr1.setKeyValue(dr.getString("mtd"));
            this.jBdbCrcTextField1.setText(String.valueOf(dr.getBigDecimal("paidamt")));
            this.rcvamt = new BigDecimal(this.jBdbCrcTextField1.getText());
            this.jdbTextArea1.setText(dr.getString("note"));
        } else {
            this.pikLebihJual1.setKeyValue(null);
            this.jCboCash1.setKeyValue(null);
            this.jCboCrByr1.setKeyValue("CASH");
            this.pikCbg1.setKeyValue(null);
            if (bc.compareTo(BigDecimal.ZERO) < 0) {
                this.jBdbCrcTextField1.setText(String.valueOf(bc.abs()));
                this.rcvamt = new BigDecimal(this.jBdbCrcTextField1.getText());
            } else {
                this.jBdbCrcTextField1.setText(null);
            }
            this.jdbTextArea1.setText(null);
        }
    }

    public DataRow getDataset() {
        DlgBayarPiutang dlgBayarPiutang = DlgBayarPiutang.getInstance();
        if (this.pikLebihJual1.getKeyValue() != null) {
            this.dataRow.setString("refno", this.pikLebihJual1.getKeyValue());
        } else {
            this.dataRow.setString("refno", null);
        }
        this.dataRow.setString("cashid", this.jCboCash1.getKeyValue());
        this.dataRow.setDate("dpdate", new Date(this.jBDatePicker1.getKeyValue().getTime()));
        if (!this.dataRow.isNull("cashid")) {
            this.dataRow.setString("crcid", Cash.getInstance().getCrcID(this.dataRow.getString("cashid")));
        } else if (this.pikLebihJual1.getKeyValue() != null) {
            this.dataRow.setString("crcid", dlgBayarPiutang.getCrcID());
        } else if (this.pikCbg1.getKeyValue() != null) {
            this.dataRow.setString("crcid", DlgCbgPay.getInstance().getCrcID());
        }
        this.dataRow.setString("mtd", this.jCboCrByr1.getKeyValue());
        this.dataRow.setBigDecimal("paidamt", new BigDecimal(this.jBdbCrcTextField1.getText()));
        this.rcvamt = new BigDecimal(this.jBdbCrcTextField1.getText());
        this.dataRow.setString("note", this.jdbTextArea1.getText());
        this.dataRow.setString("cbgid", this.pikCbg1.getKeyValue());
        return this.dataRow;
    }

    private void resetSecondaryField() {
        this.pikLebihJual1.setKeyValue(null);
        this.pikCbg1.setKeyValue(null);
        this.jCboCash1.setKeyValue(null);
        this.jBdbCrcTextField1.setText(this.rcvamt.toString());
    }

    public void setCustID(String custId) {
        this.custId = custId;
        this.pikCbg1.setCustID(custId);
    }

    public void setRefno(String refno) {
        this.refno = refno;
    }

    private boolean validateCash() {
        if (this.jCboCrByr1.getKeyValue() == null) {
            UIMgr.showErrorDialog((String)this.getResourcesUI("ex.carabayarisnull"));
            return false;
        }
        if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CASH") || this.jCboCrByr1.getKeyValue().equalsIgnoreCase("BTRF") || this.jCboCrByr1.getKeyValue().equalsIgnoreCase("DBC") || this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CRC")) {
            if (this.jCboCash1.getKeyValue() == null) {
                UIMgr.showErrorDialog((String)this.getResourcesUI("ex.cash"));
                return false;
            }
        } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CHQ") || this.jCboCrByr1.getKeyValue().equalsIgnoreCase("GIRO")) {
            if (this.pikCbg1.getKeyValue() == null) {
                UIMgr.showErrorDialog((String)this.getResourcesUI("ex.cbg"));
                return false;
            }
        } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("OVER") && this.pikLebihJual1.getKeyValue() == null) {
            UIMgr.showErrorDialog((String)this.getResourcesUI("ex.ref"));
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            String usrid = BAuthMgr.getDefault().getUserID();
            CashList.getInstance((String)usrid).Load(usrid);
            this.dateColumn = "saledate";
        }
        super.setVisible(visible);
    }

    private void initComponents() {
        this.jdbTextField1 = new JdbTextField();
        this.jPanel2 = new JPanel();
        this.jPanel8 = new JPanel();
        this.btnCancel2 = new BtnCancel();
        this.btnOK2 = new BtnOK();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jCboCash1 = new JCboCash();
        this.jScrollPane1 = new JScrollPane();
        this.jdbTextArea1 = new JdbTextArea();
        this.jCboCrByr1 = new JCboCrByr();
        this.jLabel8 = new JLabel();
        this.pikLebihJual1 = new PikLebihJual();
        this.jLabel3 = new JLabel();
        this.pikCbg1 = new PikCbg();
        this.jBdbCrcTextField1 = new JBdbCrcTextField();
        this.jLabel4 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jBDatePicker1 = new JBDatePicker();
        this.jdbTextField1.setHorizontalAlignment(4);
        this.jdbTextField1.setText("jdbTextField1");
        this.jdbTextField1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.setDefaultCloseOperation(2);
        this.jPanel2.setBackground(new Color(204, 204, 204));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel8.setOpaque(false);
        this.jPanel8.setLayout(new FlowLayout(2, 5, 0));
        this.btnCancel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgRcvDP.this.btnCancel2ActionPerformed(evt);
            }
        });
        this.jPanel8.add((Component)this.btnCancel2);
        this.btnOK2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgRcvDP.this.btnOK2ActionPerformed(evt);
            }
        });
        this.jPanel8.add((Component)this.btnOK2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255))));
        this.jPanel1.setOpaque(false);
        this.jLabel1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel1.setText("Cara Bayar:");
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setText("Kas / Bank:");
        this.jLabel5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setText("Nominal:");
        this.jLabel6.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel6.setText("Keterangan:");
        this.jdbTextArea1.setColumns(20);
        this.jdbTextArea1.setRows(5);
        this.jdbTextArea1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jScrollPane1.setViewportView((Component)this.jdbTextArea1);
        this.jCboCrByr1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgRcvDP.this.jCboCrByr1ActionPerformed(evt);
            }
        });
        this.jLabel8.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel8.setText("Ref No:");
        this.pikLebihJual1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikLebihJual1.setOpaque(false);
        this.pikLebihJual1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgRcvDP.this.pikLebihJual1ActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("ID Cbg:");
        this.pikCbg1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikCbg1.setOpaque(false);
        this.pikCbg1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgRcvDP.this.pikCbg1ActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel4.setText("Total:");
        this.jLabel9.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel9.setText("Total");
        this.jLabel7.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel7.setText("Tanggal:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.jLabel7).add(2, (Component)this.jLabel4).add(2, (Component)this.jLabel5).add(2, (Component)this.jLabel1).add(2, (Component)this.jLabel8).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel3).add(2, (Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.pikCbg1, -1, -1, Short.MAX_VALUE).add(2, (Component)this.pikLebihJual1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jLabel9).add((Component)this.jBDatePicker1, -2, -1, -2).add((Component)this.jCboCrByr1, -1, -1, Short.MAX_VALUE).add((Component)this.jBdbCrcTextField1, -1, -1, Short.MAX_VALUE).add((Component)this.jCboCash1, -2, 200, -2)).add((Component)this.jScrollPane1, -2, -1, -2)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.jBDatePicker1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel5).add((Component)this.jBdbCrcTextField1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jCboCrByr1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.pikLebihJual1, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCboCash1, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.pikCbg1, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -2, 95, -2).add((Component)this.jLabel6)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jPanel8, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel8, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void pikCbg1ActionPerformed(ActionEvent evt) {
        if (this.pikCbg1.getKeyValue() != null) {
            this.jBdbCrcTextField1.setText(CbgList.getInstance().getCbgAmt(this.pikCbg1.getKeyValue()).toString());
        }
    }

    private void pikLebihJual1ActionPerformed(ActionEvent evt) {
        DlgBayarPiutang dlgBayarPiutang = DlgBayarPiutang.getInstance();
        this.jBdbCrcTextField1.setText(dlgBayarPiutang.getOVerPay().toString());
        dlgBayarPiutang.setBPID(this.custId);
    }

    private void jCboCrByr1ActionPerformed(ActionEvent evt) {
        if (this.jCboCrByr1.getKeyValue() != null) {
            this.VisibleAll(false);
            this.resetSecondaryField();
            String usrid = BAuthMgr.getDefault().getUserID();
            CashList.getInstance((String)usrid).Load(usrid);
            if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CASH")) {
                this.jLabel2.setVisible(true);
                this.jCboCash1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
                CashList.getInstance((String)usrid).Load(usrid, "cashtype='C'");
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("BTRF")) {
                this.jLabel2.setVisible(true);
                this.jCboCash1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
                CashList.getInstance((String)usrid).Load(usrid, "cashtype='B'");
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CHQ")) {
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
                this.jLabel3.setVisible(true);
                this.pikCbg1.setVisible(true);
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("OVER")) {
                this.jLabel8.setVisible(true);
                this.pikLebihJual1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CTRA")) {
                this.dlgSRet.setCustID(this.custId);
                this.dlgSRet.setDNType("R");
                this.dlgSRet.setContra("N");
                this.dlgSRet.Load("dn.iscontra=false AND dn.dntype='R'");
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("DBC")) {
                this.jLabel2.setVisible(true);
                this.jCboCash1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CRC")) {
                this.jLabel2.setVisible(true);
                this.jCboCash1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("VOUC")) {
                this.jLabel2.setVisible(true);
                this.jCboCash1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
            } else if (this.jCboCrByr1.getKeyValue().equalsIgnoreCase("MISC")) {
                this.jLabel2.setVisible(true);
                this.jCboCash1.setVisible(true);
                this.jLabel5.setVisible(true);
                this.jBdbCrcTextField1.setVisible(true);
                this.jLabel6.setVisible(true);
                this.jdbTextArea1.setVisible(true);
            }
        } else {
            this.VisibleAll(true);
        }
    }

    private void btnCancel2ActionPerformed(ActionEvent evt) {
        this.Cancel();
    }

    private void btnOK2ActionPerformed(ActionEvent evt) {
        if (this.validateCash()) {
            if (!this.jCboCrByr1.getKeyValue().equalsIgnoreCase("CASH")) {
                if (this.jdbTextArea1.getText().length() > 0) {
                    this.setSelectedID("OK");
                    this.OK();
                } else {
                    UIMgr.showMessageDialog((String)this.getResourcesUI("ex.keterangan"), (Component)((Object)this));
                }
            } else {
                this.setSelectedID("OK");
                this.OK();
            }
        }
    }

    public void doUpdate() {
        dlg = null;
    }

    private void initLang() {
        this.setTitle(this.getResourcesUI("title"));
        this.jLabel1.setText(this.getResourcesUI("jLabel1.text"));
        this.jLabel8.setText(this.getResourcesUI("jLabel8.text"));
        this.jLabel2.setText(this.getResourcesUI("jLabel2.text"));
        this.jLabel3.setText(this.getResourcesUI("jLabel3.text"));
        this.jLabel5.setText(this.getResourcesUI("jLabel5.text"));
        this.jLabel6.setText(this.getResourcesUI("jLabel6.text"));
        this.jLabel7.setText(this.getResourcesUI("jLabel7.text"));
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(((Object)((Object)this)).getClass(), key);
    }

    private void init() {
        this.initComponents();
        this.initLang();
        ScreenManager.setCenter((JDialog)((Object)this));
        this.pikCbg1.setFromTrans("RCV");
        this.setBackground(ComponentResources.DIALOG_BACKGROUND);
        this.jCboCash1.addCrcChangeObserver((CrcChangeObserver)this.jBdbCrcTextField1);
        this.pikCbg1.addCrcChangeObserver((CrcChangeObserver)this.jBdbCrcTextField1);
    }

    public BTrans getBTrans() {
        return this.btrans;
    }

    public void setBTrans(BTrans btrans) {
        this.btrans = btrans;
    }
}

