/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.swing.appointment;

import com.bits.bee.ui.ScreenManager;
import com.bits.beebengkel.formfactory.MakeAppointmentFormFactory;
import com.bits.beebengkel.swing.appointment.CalendarListenerApp;
import com.bits.beebengkel.swing.appointment.HTMLGeneratorApp;
import com.bits.beebengkel.swing.appointment.PnlButtonListenerApp;
import com.bits.beebengkel.ui.Abstraction.MakeAppointmentForm;
import com.bits.lib.BUtil;
import com.bits.lib.security.AuthMgr;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;

public class JBCalendarPnlButtonApp
extends JPanel
implements Accessible,
ActionListener,
MouseListener {
    public static final Color FOCUS_COLOR = Color.GRAY;
    private CalendarListenerApp calendarListener;
    private PnlButtonListenerApp actionListener;
    private Color defaultBackground;
    int date;
    private Date sqlDate;
    private JPopupMenu popupMenu;
    private HTMLGeneratorApp htmlGen = new HTMLGeneratorApp();
    private boolean isNow;
    private BFocusListener focusListener = new BFocusListener();
    private StringBuffer listTodo = new StringBuffer();
    private String objid = "";
    private AuthMgr authMgr;
    private JLabel lblDate;
    private JScrollPane scrollPane;
    private JTextPane txtEvent;

    public JBCalendarPnlButtonApp() {
        this.initComponents();
        this.setFocusable(true);
        this.lblDate.setText("");
        this.initForm();
    }

    public JBCalendarPnlButtonApp(String text) {
        this.initComponents();
        this.setFocusable(true);
        this.lblDate.setText(text);
        this.initForm();
    }

    private void initForm() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.defaultBackground = new Color(204, 204, 255);
        this.setBackground(this.defaultBackground);
        this.setEventBackground(this.defaultBackground);
        this.setDateBackground(this.defaultBackground);
        this.addFocusListener(this.focusListener);
        this.lblDate.addFocusListener(this.focusListener);
        this.txtEvent.addFocusListener(this.focusListener);
        this.txtEvent.setFont(new Font("Dialog", 1, 9));
        this.addMouseListener(this);
        this.lblDate.addMouseListener(this);
        this.txtEvent.addMouseListener(this);
        this.initPopupMenu();
    }

    public void setObjid(String objid) {
        this.objid = objid;
    }

    public void setAuthMgr(AuthMgr authMgr) {
        this.authMgr = authMgr;
    }

    public void setPnlButtonListener(PnlButtonListenerApp actionListener) {
        this.actionListener = actionListener;
    }

    public void setText(String text) {
        this.lblDate.setText(text);
        try {
            this.txtEvent.setDocument(this.getHTMLGenerator().getStyledDocument());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void updateText(boolean showAppointment) {
        this.getHTMLGenerator().setShowAppointment(showAppointment);
        try {
            this.txtEvent.setDocument(this.getHTMLGenerator().getStyledDocument());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void setDateBackground(Color color) {
        this.lblDate.setBackground(color);
    }

    public Color getDateBackground() {
        return this.lblDate.getBackground();
    }

    public void setEventBackground(Color color) {
        this.txtEvent.setBackground(color);
    }

    public Color getEventBackground() {
        return this.txtEvent.getBackground();
    }

    public void setDateForeground(Color color) {
        this.lblDate.setForeground(color);
    }

    public Color getDateForeground() {
        return this.lblDate.getForeground();
    }

    public void setEventForeground(Color color) {
        this.txtEvent.setForeground(color);
    }

    public Color getEventForeground() {
        return this.txtEvent.getForeground();
    }

    private void initPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem todo = new JMenuItem("Buat Appointment");
        todo.setName("Buat Appointment");
        todo.addActionListener(this);
        this.popupMenu.add(todo);
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public Date getSqlDate() {
        return this.sqlDate;
    }

    public void setSqlDate(Date sqlDate) {
        this.sqlDate = sqlDate;
    }

    public void setIsNow(boolean isNow) {
        this.isNow = isNow;
    }

    public HTMLGeneratorApp getHTMLGenerator() {
        return this.htmlGen;
    }

    public CalendarListenerApp getCalendarListener() {
        return this.calendarListener;
    }

    public void setCalendarListener(CalendarListenerApp calendarListener) {
        this.calendarListener = calendarListener;
    }

    public void doClick() {
        if (this.actionListener != null) {
            this.actionListener.doEvent(this);
        }
    }

    public void setEnabledPanel(boolean enabled) {
        BUtil.setEnabledPanel((JPanel)this, (boolean)enabled);
    }

    private void initComponents() {
        this.lblDate = new JLabel();
        this.scrollPane = new JScrollPane();
        this.txtEvent = new JTextPane();
        this.lblDate.setFont(new Font("Dialog", 1, 9));
        this.lblDate.setText("1");
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.txtEvent.setBorder(null);
        this.txtEvent.setEditable(false);
        this.scrollPane.setViewportView(this.txtEvent);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDate, GroupLayout.Alignment.TRAILING, -1, 64, Short.MAX_VALUE).addComponent(this.scrollPane, -1, 64, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 43, Short.MAX_VALUE)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.authMgr == null || this.objid == null || this.authMgr.getAuthDlg(this.objid, "NEW")) {
            MakeAppointmentForm form = MakeAppointmentFormFactory.getDefault().createMakeAppointmentForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doNew();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && this.lblDate.isEnabled() && this.isComponentFocused()) {
            this.requestFocusInWindow();
            Point pt = this.getLocationOnScreen();
            this.popupMenu.setLocation(pt);
            this.popupMenu.show(this.lblDate, e.getX(), e.getY());
        } else if (e.getButton() == 1 && this.lblDate.isEnabled()) {
            this.calendarListener.eventClicked(this);
            if (this.actionListener != null) {
                this.actionListener.doEvent(this);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean isComponentFocused() {
        return this.lblDate.isFocusOwner() || this.txtEvent.isFocusOwner() || this.isFocusOwner();
    }

    public StringBuffer getListTodo() {
        return this.listTodo;
    }

    public void setListTodo(StringBuffer listTodo) {
        this.listTodo = listTodo;
    }

    private class BFocusListener
    implements FocusListener {
        private BFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JBCalendarPnlButtonApp.this.setBackground(FOCUS_COLOR);
            JBCalendarPnlButtonApp.this.setEventBackground(FOCUS_COLOR);
            JBCalendarPnlButtonApp.this.setDateBackground(FOCUS_COLOR);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!JBCalendarPnlButtonApp.this.isNow) {
                JBCalendarPnlButtonApp.this.setBackground(JBCalendarPnlButtonApp.this.defaultBackground);
                JBCalendarPnlButtonApp.this.setEventBackground(JBCalendarPnlButtonApp.this.defaultBackground);
                JBCalendarPnlButtonApp.this.setDateBackground(JBCalendarPnlButtonApp.this.defaultBackground);
            } else {
                JBCalendarPnlButtonApp.this.setBackground(FOCUS_COLOR);
                JBCalendarPnlButtonApp.this.setEventBackground(FOCUS_COLOR);
                JBCalendarPnlButtonApp.this.setDateBackground(FOCUS_COLOR);
            }
        }
    }
}

