/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui.factory.util;

import com.bits.bee.bl.RecurTrans;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.abstraction.CsTrForm;
import com.bits.bee.ui.abstraction.JnlForm;
import com.bits.bee.ui.abstraction.PayForm;
import com.bits.bee.ui.abstraction.PurcForm;
import com.bits.bee.ui.abstraction.RcvForm;
import com.bits.bee.ui.abstraction.SalesForm;
import com.bits.bee.ui.abstraction.StTrForm;
import com.bits.bee.ui.factory.form.CsTrFormFactory;
import com.bits.bee.ui.factory.form.JnlFormFactory;
import com.bits.bee.ui.factory.form.PayFormFactory;
import com.bits.bee.ui.factory.form.PurcFormFactory;
import com.bits.bee.ui.factory.form.RcvFormFactory;
import com.bits.bee.ui.factory.form.SalesFormFactory;
import com.bits.bee.ui.factory.form.StTrFormFactory;
import com.bits.bee.ui.factory.recurring.RecurringAction;
import com.bits.beebengkel.ui.mySwing.JBToolbarCustom;
import com.bits.lib.dx.BTrans;
import java.awt.Font;
import java.sql.Date;
import javax.swing.Action;
import javax.swing.JButton;

public class RecurringUtilCustom {
    public static void createToolbarButton(JBToolbarCustom toolbar, RecurringAction recurringAction) {
        JButton button = new JButton((Action)recurringAction);
        button.setFont(new Font("Dialog", 1, 11));
        toolbar.addExpandComponent(button);
    }

    public static void identifyTrans(String refType, String transNo, BTrans trans) {
        trans.getDataSetMaster().setString("recurno", transNo);
    }

    public static void processRecurring(RecurTrans recurTrans) {
        String refType = recurTrans.getDataSetMaster().getString("reftype");
        String refNo = recurTrans.getDataSetMaster().getString("refno");
        Date recurDDate = recurTrans.getDataSetDetail().getDate("recurddate");
        String recurNo = recurTrans.getDataSetMaster().getString("recurno");
        short recurDNo = recurTrans.getDataSetDetail().getShort("recurdno");
        RecurringUtilCustom.processRecurring(refType, refNo, recurDDate, recurNo, recurDNo);
    }

    public static void openRecurringExecution(RecurTrans recurTrans) {
        String refType = recurTrans.getDataSetMaster().getString("reftype");
        String refNo = recurTrans.getDataSetMaster().getString("refno");
        String recurDref = recurTrans.getDataSetDetail().getString("recurdref");
        if ("PURC".equals(refType)) {
            PurcForm form = PurcFormFactory.getDefault().createPurcForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEdit(recurDref);
        } else if ("CSTR".equals(refType)) {
            CsTrForm form = CsTrFormFactory.getDefault().createCsTrForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEdit(recurDref);
        } else if ("JNL".equals(refType)) {
            JnlForm form = JnlFormFactory.getDefault().createJnlForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEdit(recurDref);
        } else if ("PAY".equals(refType)) {
            PayForm form = PayFormFactory.getDefault().createPayForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEdit(recurDref);
        } else if ("RCV".equals(refType)) {
            RcvForm form = RcvFormFactory.getDefault().createRcvForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEdit(recurDref);
        } else if ("SALE".equals(refType)) {
            SalesForm f = SalesFormFactory.getDefault().createSalesForm();
            ScreenManager.getMainFrame().addInternalFrame(f.getFormComponent());
            f.doEdit(recurDref);
        } else if ("STTR".equals(refType)) {
            StTrForm form = StTrFormFactory.getDefault().createStTrForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEdit(recurDref);
        }
    }

    public static void processRecurring(String refType, String refNo, Date recurDDate, String recurNo, short recurDNo) {
        if ("PURC".equals(refType)) {
            PurcForm form = PurcFormFactory.getDefault().createPurcForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        } else if ("CSTR".equals(refType)) {
            CsTrForm form = CsTrFormFactory.getDefault().createCsTrForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        } else if ("JNL".equals(refType)) {
            JnlForm form = JnlFormFactory.getDefault().createJnlForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        } else if ("PAY".equals(refType)) {
            PayForm form = PayFormFactory.getDefault().createPayForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        } else if ("RCV".equals(refType)) {
            RcvForm form = RcvFormFactory.getDefault().createRcvForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        } else if ("SALE".equals(refType)) {
            SalesForm form = SalesFormFactory.getDefault().createSalesForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        } else if ("STTR".equals(refType)) {
            StTrForm form = StTrFormFactory.getDefault().createStTrForm();
            ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
            form.doEditAsNew(refNo, recurDDate, recurNo, recurDNo);
        }
    }
}

