/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.bl.DPList;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DPListBengkel
implements ResourceGetter {
    private static Logger logger = LoggerFactory.getLogger(DPList.class);
    private QueryDataSet qds;
    private DataSetView dsv;
    private DP_MODE dpMode;

    public DPListBengkel(DP_MODE dpMode) {
        this.dpMode = dpMode;
        this.qds = new QueryDataSet();
        this.dsv = new DataSetView();
    }

    public void initLang() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setEditable(false);
        }
        this.qds.getColumn("paidno").setCaption(this.getResourcesBL("col.paidno"));
        this.qds.getColumn("dpdate").setCaption(this.getResourcesBL("col.dpdate"));
        this.qds.getColumn("dpamt").setCaption(this.getResourcesBL("col.dpamt"));
        this.qds.getColumn("usedamt").setCaption(this.getResourcesBL("col.usedamt"));
        this.qds.getColumn("dpbal").setCaption(this.getResourcesBL("col.dpbal"));
        this.qds.getColumn("crcid").setCaption(this.getResourcesBL("col.crcsymbol"));
        this.qds.getColumn("crcid").setWidth(3);
    }

    public DP_MODE getDPMode() {
        return this.dpMode;
    }

    public void setDPMode(DP_MODE dpMode) {
        this.dpMode = dpMode;
    }

    public void load() throws Exception {
        this.loadID(null, null);
    }

    public void loadID(String reftype, String refno) throws Exception {
        StringBuffer queryBuff = new StringBuffer();
        StringBuffer filterBuff = new StringBuffer();
        queryBuff.append("SELECT paidno, dpdate, crcid, dpamt, usedamt, dpbal FROM dp");
        if (this.getDPMode() == DP_MODE.PO_DP) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.paidtype=%s", BHelp.QuoteSingle((String)"PAY")));
        } else if (this.getDPMode() == DP_MODE.SO_DP) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.paidtype=%s", BHelp.QuoteSingle((String)"RCV")));
        }
        if (reftype != null && reftype.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.reftype=%s", BHelp.QuoteSingle((String)reftype)));
        }
        if (refno != null && refno.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.refno=%s", BHelp.QuoteSingle((String)refno)));
        }
        JBSQL.setWHERE((StringBuffer)queryBuff, (StringBuffer)filterBuff);
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), queryBuff.toString()));
        this.qds.open();
        this.initLang();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    public void loadByDPID(String dpid) throws Exception {
        StringBuffer queryBuff = new StringBuffer();
        StringBuffer filterBuff = new StringBuffer();
        queryBuff.append("SELECT paidno, dpdate, crcid, dpamt, usedamt, dpbal FROM dp");
        if (this.getDPMode() == DP_MODE.PO_DP) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.paidtype=%s", BHelp.QuoteSingle((String)"PAY")));
        } else if (this.getDPMode() == DP_MODE.SO_DP) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.paidtype=%s", BHelp.QuoteSingle((String)"RCV")));
        }
        if (dpid != null && dpid.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filterBuff, (String)String.format("dp.dpid=%s", BHelp.QuoteSingle((String)dpid)));
        }
        JBSQL.setWHERE((StringBuffer)queryBuff, (StringBuffer)filterBuff);
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), queryBuff.toString()));
        this.qds.open();
        this.initLang();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    public DataSet getDataSet() {
        return this.dsv;
    }

    public String getResourcesUI(String key) {
        return null;
    }

    public String getResourcesBL(String key) {
        return LocaleInstance.getInstance().getMessageBL(this.getClass(), key);
    }

    public String getResourcesLib(String key) {
        return null;
    }

    public static enum DP_MODE {
        SO_DP,
        PO_DP;

    }
}

