/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.bl.exception.PKExceptionFactory;
import com.bits.bee.conf.InstanceMgr;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.Column;
import com.borland.dx.dataset.DataRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPCar
extends BTable
implements InstanceObserver {
    private static Logger logger = LoggerFactory.getLogger(BPCar.class);
    private static BPCar bpcar = null;
    private DataRow lookuprow;
    private DataRow resultrow;
    private DataRow lookuprowBP;
    private DataRow resultrowBP;

    public BPCar() {
        super(BDM.getDefault(), "car", "bpid, carid");
        Column[] cols = new Column[]{new Column("bpid", "bpid", 16), new Column("carid", "carid", 4), new Column("carno", "carno", 16), new Column("carnopol", "carnopol", 16), new Column("cbrandid", "cbrandid", 16), new Column("cmodelid", "cmodelid", 16), new Column("caryear", "caryear", 3), new Column("carcol", "carcol", 16), new Column("nomesin", "nomesin", 16), new Column("norangka", "norangka", 16), new Column("cardesc", "cardesc", 16), new Column("carkm", "carkm", 10), new Column("prclvlid", "prclvlid", 16)};
        this.setOrderBy("carid");
        this.createDataSet((com.borland.dx.dataset.Column[])cols);
        this.dataset.open();
    }

    public static synchronized BPCar getInstance() {
        if (bpcar == null) {
            bpcar = new BPCar();
            try {
                bpcar.Load();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            InstanceMgr.getInstance().addObserver((InstanceObserver)bpcar);
        }
        return bpcar;
    }

    private void initLookup() {
        this.lookuprow = new DataRow(this.getDataSet(), "carid");
        this.resultrow = new DataRow(this.getDataSet());
    }

    private void initLookupBP() {
        this.lookuprowBP = new DataRow(this.getDataSet(), "bpid");
        this.resultrowBP = new DataRow(this.getDataSet());
    }

    public void doUpdate() {
        bpcar = null;
    }

    public void Load() throws Exception {
        super.Load(null, this.orderBy);
        this.initLookup();
        this.initLookupBP();
    }

    private void validate() throws Exception {
        if (this.getDataSet().getString("carno").length() > 0 && (this.getDataSet().isNull("carnopol") || this.getDataSet().getString("carnopol").trim().length() <= 0)) {
            throw new Exception("Masukkan Nomor Polisi Kendaraan Mitra Bisnis !");
        }
    }

    public void saveChanges() throws Exception {
        try {
            this.validate();
            super.saveChanges();
        }
        catch (Exception ex) {
            throw PKExceptionFactory.INSTANCE.createException(BHelp.getExceptionDetail((Exception)ex), ex, "Kode Kendaraan Mitra Bisnis Sudah ada !");
        }
    }

    public String getNopol(int carid) {
        return this.resultrow.getString("carnopol");
    }
}

