/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.swing.appointment;

import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.myswing.CalendarListener;
import com.bits.bee.ui.myswing.JBCalendarButton;
import com.bits.beebengkel.formfactory.MakeAppointmentFormFactory;
import com.bits.beebengkel.swing.appointment.HTMLGeneratorApp;
import com.bits.beebengkel.ui.Abstraction.MakeAppointmentForm;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.DataSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBCalendarButtonApp
extends JButton
implements AccessListener,
MouseListener,
ActionListener {
    private static Logger logger = LoggerFactory.getLogger(JBCalendarButton.class);
    public static final Color FOCUS_COLOR = Color.GRAY;
    private CalendarListener calendarListener;
    private DataSet dataSet;
    private String objid;
    private String columnName;
    private Color defaultBackground;
    int date;
    private Date sqlDate;
    private JPopupMenu popupMenu;
    private HTMLGeneratorApp htmlGen = new HTMLGeneratorApp();
    private boolean isNow;

    public JBCalendarButtonApp() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.defaultBackground = new Color(204, 204, 255);
        this.setBackground(this.defaultBackground);
        this.setFont(new Font("Dialog", 1, 9));
        this.initListener();
        this.initPopupMenu();
    }

    public JBCalendarButtonApp(String text) {
        this.initText();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.defaultBackground = new Color(204, 204, 255);
        this.setBackground(this.defaultBackground);
        this.setFont(new Font("Dialog", 1, 9));
        this.initListener();
        this.initPopupMenu();
    }

    @Override
    public void setText(String text) {
        super.setText(this.getHTMLGenerator().getHTMLCode());
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    private void initPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem app = new JMenuItem("Buat Appointment");
        app.setName("app");
        app.addActionListener(this);
        this.popupMenu.add(app);
    }

    public void accessChange(AccessEvent accessEvent) {
        if (accessEvent.getID() == 1) {
            this.datasetChanged();
        }
    }

    protected void datasetChanged() {
        this.setText("");
    }

    protected void BindListener() {
        if (this.dataSet != null && this.columnName != null && this.columnName.length() > 0) {
            this.dataSet.addAccessListener((AccessListener)this);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        this.BindListener();
    }

    public String getObjid() {
        return this.objid;
    }

    public void setObjid(String objid) {
        this.objid = objid;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
        this.BindListener();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.requestFocusInWindow();
            Point pt = this.getLocationOnScreen();
            this.popupMenu.setLocation(pt);
            this.popupMenu.show(this, 0, this.getHeight());
        } else if (e.getButton() == 1) {
            // empty if block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MakeAppointmentForm form = MakeAppointmentFormFactory.getDefault().createMakeAppointmentForm();
        ScreenManager.getMainFrame().addInternalFrame(form.getFormComponent());
        form.doNew();
    }

    private void initListener() {
        this.addFocusListener(new BFocusListener());
        this.addMouseListener(this);
    }

    private void initText() {
        this.setText(this.getHTMLGenerator().getHTMLCode());
    }

    public Date getSqlDate() {
        return this.sqlDate;
    }

    public void setSqlDate(Date sqlDate) {
        this.sqlDate = sqlDate;
    }

    public void setIsNow(boolean isNow) {
        this.isNow = isNow;
    }

    public HTMLGeneratorApp getHTMLGenerator() {
        return this.htmlGen;
    }

    public CalendarListener getCalendarListener() {
        return this.calendarListener;
    }

    public void setCalendarListener(CalendarListener calendarListener) {
        this.calendarListener = calendarListener;
    }

    private class BFocusListener
    implements FocusListener {
        private BFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JBCalendarButtonApp.this.setBackground(FOCUS_COLOR);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!JBCalendarButtonApp.this.isNow) {
                JBCalendarButtonApp.this.setBackground(JBCalendarButtonApp.this.defaultBackground);
            } else {
                JBCalendarButtonApp.this.setBackground(FOCUS_COLOR);
            }
        }
    }
}

