/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui;

import com.bits.bee.bl.XLSGenerator;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.lib.dbswing.JBPeriode;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import java.awt.Component;
import java.io.File;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportExcelBengkel
extends JFrame
implements ResourceGetter {
    private final JFileChooser xlsChooser;
    private final XLSGenerator xlsGen = new XLSGenerator();
    private static FrmExportExcelBengkel exportExcel = null;
    private QueryDataSet qds;
    private List<QueryDataSet> qdss;
    private final LocaleInstance l = LocaleInstance.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(FrmExportExcelBengkel.class);
    private List<Map<String, Object>> dataSummary;

    public FrmExportExcelBengkel() {
        this.xlsChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XLS(*.xls)", "xls");
        this.xlsChooser.setFileFilter(filter);
        this.xlsChooser.setAcceptAllFileFilterUsed(false);
    }

    public static synchronized FrmExportExcelBengkel getInstance() {
        if (exportExcel == null) {
            exportExcel = new FrmExportExcelBengkel();
        }
        return exportExcel;
    }

    public void doExport(String name, JBPeriode jBOSPeriode, String[] header, QueryDataSet qds, String sheet, List<Map<String, Object>> dataSummary) {
        this.setFileName(name, jBOSPeriode);
        this.doExport(header, qds, sheet, dataSummary);
    }

    public void doExport(String name, JBPeriode jBOSPeriode, String[] header, QueryDataSet qds, String sheet) {
        this.doExport(name, jBOSPeriode, header, qds, sheet, null);
    }

    public void doExport(String name, QueryDataSet qds) {
        this.doExport(name, null, null, qds, null);
    }

    public void doExport(String name, JBPeriode jBOSPeriode, QueryDataSet qds) {
        this.doExport(name, jBOSPeriode, null, qds, null);
    }

    public void setFileName(String name, JBPeriode jBOSPeriode) {
        String title = name;
        if (jBOSPeriode != null && (jBOSPeriode.getStartDate() != null || jBOSPeriode.getEndDate() != null)) {
            title = name + "-" + new Date(jBOSPeriode.getStartDate().getTime()).toString() + "-sd-" + new Date(jBOSPeriode.getEndDate().getTime()).toString();
        }
        this.xlsChooser.setSelectedFile(new File(title + ".xls"));
    }

    public void doExport(String[] header, QueryDataSet qds, String sheet) {
        this.doExport(header, qds, sheet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport(String[] header, QueryDataSet qds, String sheet, List<Map<String, Object>> dataSummary) {
        try {
            this.qds = qds;
            this.dataSummary = dataSummary;
            this.validateData();
            int retval = this.xlsChooser.showSaveDialog(this.getParent());
            if (retval == 0) {
                ScreenManager.setCursorThinking((JFrame)this);
                String namafile = this.xlsChooser.getSelectedFile().getAbsolutePath();
                if (namafile != null && namafile.length() > 0) {
                    File tmpDir;
                    boolean exists;
                    if (namafile.indexOf(".xls") < 0) {
                        namafile = namafile + ".xls";
                    }
                    if (exists = (tmpDir = new File(namafile)).exists()) {
                        if (UIMgr.YesNo((String)"Save", (String)"The file already exists. Do you want to replace it?") == 0) {
                            this.generateToExcelByDirectory(header, sheet, namafile);
                            UIMgr.showMessageDialog((String)"Export ke Excel, OK!", (Component)this);
                        }
                    } else {
                        this.generateToExcelByDirectory(header, sheet, namafile);
                        UIMgr.showMessageDialog((String)"Export ke Excel, OK!", (Component)this);
                    }
                }
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal Export Data ke Excel", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JFrame)this);
        }
    }

    private void validateData() throws Exception {
        if (this.qds.getRowCount() <= 0) {
            throw new Exception(this.getResourcesUI("ex.rowcount"));
        }
    }

    private void generateToExcelByDirectory(String[] header, String sheet, String fileLocation) {
        if (sheet == null) {
            sheet = "Worksheet";
        }
        this.xlsGen.createWorkBook(sheet);
        String[] headers = header;
        if (headers == null) {
            headers = this.qds.getColumnNames(this.qds.getColumnCount());
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = headers[i].replace("_", " ");
                headers[i] = WordUtils.capitalize((String)headers[i]);
            }
        }
        this.xlsGen.createHeader(headers);
        this.xlsGen.generateDataFromDataSet((DataSet)this.qds);
        if (this.dataSummary != null) {
            this.xlsGen.createSummary(this.dataSummary);
        }
        if (fileLocation.indexOf(".xls") >= 0) {
            this.xlsGen.writeToChoosenDirectory(fileLocation);
        } else {
            this.xlsGen.writeToChoosenDirectory(fileLocation + ".xls");
        }
    }

    public void doExportMS(String name, JBPeriode jBOSPeriode, String[][] header, List<QueryDataSet> qds, String sheet) {
        this.setFileName(name, jBOSPeriode);
        this.doExportMS(header, qds, sheet);
    }

    public void doExportMS(String name, List<QueryDataSet> qds) {
        this.doExportMS(name, null, null, qds, null);
    }

    public void doExportMS(String name, JBPeriode jBOSPeriode, List<QueryDataSet> qds) {
        this.doExportMS(name, jBOSPeriode, null, qds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExportMS(String[][] header, List<QueryDataSet> qds, String sheet) {
        try {
            this.qdss = qds;
            this.validateDataMS();
            int retval = this.xlsChooser.showSaveDialog(this.getParent());
            if (retval == 0) {
                ScreenManager.setCursorThinking((JFrame)this);
                String namafile = this.xlsChooser.getSelectedFile().getAbsolutePath();
                if (namafile != null && namafile.length() > 0) {
                    File tmpDir;
                    boolean exists;
                    if (namafile.indexOf(".xls") < 0) {
                        namafile = namafile + ".xls";
                    }
                    if (exists = (tmpDir = new File(namafile)).exists()) {
                        if (UIMgr.YesNo((String)"Save", (String)"The file already exists. Do you want to replace it?") == 0) {
                            this.generateToExcelByDirectoryMS(header, sheet, namafile);
                            UIMgr.showMessageDialog((String)"Export ke Excel, OK!", (Component)this);
                        }
                    } else {
                        this.generateToExcelByDirectoryMS(header, sheet, namafile);
                        UIMgr.showMessageDialog((String)"Export ke Excel, OK!", (Component)this);
                    }
                }
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal Export Data ke Excel", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JFrame)this);
        }
    }

    private void generateToExcelByDirectoryMS(String[][] header, String sheet, String fileLocation) {
        if (sheet == null) {
            sheet = "Worksheet";
        }
        this.xlsGen.createWorkBook(sheet + 1);
        if (header == null) {
            String[] headers = this.qdss.get(0).getColumnNames(this.qdss.get(0).getColumnCount());
            for (int j = 0; j < headers.length; ++j) {
                headers[j] = headers[j].replace("_", " ");
                headers[j] = WordUtils.capitalize((String)headers[j]);
            }
            this.xlsGen.createHeader(headers);
            this.xlsGen.generateDataFromDataSet((DataSet)this.qdss.get(0));
            for (int i = 1; i < this.qdss.size(); ++i) {
                headers = this.qdss.get(i).getColumnNames(this.qdss.get(i).getColumnCount());
                for (int j = 0; j < headers.length; ++j) {
                    headers[j] = headers[j].replace("_", " ");
                    headers[j] = WordUtils.capitalize((String)headers[j]);
                }
                this.xlsGen.createSheet(sheet + (i + 1));
                this.xlsGen.createHeader(headers);
                this.xlsGen.generateDataFromDataSet((DataSet)this.qdss.get(i));
            }
        } else {
            this.xlsGen.createHeader(header[0]);
            this.xlsGen.generateDataFromDataSet((DataSet)this.qdss.get(0));
            for (int i = 0; i < this.qdss.size(); ++i) {
                this.xlsGen.createSheet(sheet + (i + 1));
                this.xlsGen.createHeader(header[i]);
                this.xlsGen.generateDataFromDataSet((DataSet)this.qdss.get(i));
            }
        }
        if (fileLocation.indexOf(".xls") >= 0) {
            this.xlsGen.writeToChoosenDirectory(fileLocation);
        } else {
            this.xlsGen.writeToChoosenDirectory(fileLocation + ".xls");
        }
    }

    private void validateDataMS() throws Exception {
        if (this.qdss.get(0).getRowCount() <= 0) {
            throw new Exception("Tidak ada data yang akan di Export ke Excel !");
        }
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(this.getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(this.getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(this.getClass(), key);
    }
}

