/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui;

import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.JFormLabel;
import com.bits.beebengkel.bl.TimeTrans;
import com.bits.beebengkel.bl.procedure.spTimeDesigner_Remove;
import com.bits.beebengkel.swing.appointment.JIntTimeSpinner;
import com.bits.beebengkel.ui.Abstraction.TimeDesignerForm;
import com.bits.beebengkel.ui.DlgTimeDsg;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.BdbState;
import com.bits.lib.dbswing.JBStatusbar;
import com.bits.lib.dbswing.JBToolbar;
import com.bits.lib.dbswing.JBToolbarEvent;
import com.bits.lib.dbswing.JBToolbarListener;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BTrans;
import com.bits.lib.security.AuthMgr;
import com.bits.lib.security.BAuthMgr;
import com.borland.dbswing.JdbTextArea;
import com.borland.dbswing.JdbTextField;
import com.borland.dx.dataset.DataRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmTimeDesigner
extends JInternalFrame
implements TimeDesignerForm,
PropertyChangeListener {
    BdbState state = new BdbState();
    private TimeTrans trans = null;
    private spTimeDesigner_Remove spRemove = new spTimeDesigner_Remove();
    private int interval = 0;
    private DlgTimeDsg dlg;
    private static Logger logger = LoggerFactory.getLogger(FrmTimeDesigner.class);
    private static final String OBJID = "999981";
    private JButton btnProcess;
    private ButtonGroup buttonGroup1;
    private JBStatusbar jBStatusbar1;
    private JBToolbar jBToolbar1;
    private JBdbTable jBdbTable1;
    private JFormLabel jFormLabel1;
    private JIntTimeSpinner jIntTimeSpinnerEnd;
    private JIntTimeSpinner jIntTimeSpinnerStart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JdbTextArea jdbTextArea1;
    private JdbTextField jdbTextField1;

    public FrmTimeDesigner() {
        this.initTrans();
        this.initComponents();
        this.initForm();
        this.initListener();
        this.initTable();
        this.initLang();
    }

    private void initTrans() {
        this.trans = new TimeTrans();
    }

    private void initForm() {
        Time t = Time.valueOf("00:00:00");
        this.jIntTimeSpinnerStart.setTime(t);
        this.jIntTimeSpinnerEnd.setTime(t);
        this.jdbTextField1.setEnabled(true);
        this.jBToolbar1.setObjid(OBJID);
        this.jBToolbar1.setAuthMgr((AuthMgr)BAuthMgr.getDefault());
    }

    private void initListener() {
        this.jBToolbar1.setState(this.state);
        this.state.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.state.setState(0);
    }

    private void initTable() {
        for (int i = 0; i < this.trans.getDataSetDetail().columnCount(); ++i) {
            this.trans.getDataSetDetail().getColumn(i).setEditable(false);
        }
        this.trans.getDataSetDetail().getColumn("timename").setVisible(0);
        this.trans.getDataSetDetail().getColumn("timedetail").setVisible(0);
        this.trans.getDataSetDetail().getColumn("timeno").setVisible(1);
        this.trans.getDataSetDetail().getColumn("timeno").setWidth(10);
        this.trans.getDataSetDetail().getColumn("timeno").setCaption("Nomor");
        this.trans.getDataSetDetail().getColumn("timedesc").setVisible(1);
        this.trans.getDataSetDetail().getColumn("timedesc").setWidth(20);
        this.trans.getDataSetDetail().getColumn("timedesc").setCaption("Jam");
    }

    private void initLang() {
        this.setTitle("Desain Jam Kerja | Bengkel");
    }

    public int getStartHour() {
        return this.jIntTimeSpinnerStart.getHour();
    }

    public int getStartMinute() {
        return this.jIntTimeSpinnerStart.getMinute();
    }

    public int getEndHour() {
        return this.jIntTimeSpinnerEnd.getHour();
    }

    public int getEndMinute() {
        return this.jIntTimeSpinnerEnd.getMinute();
    }

    private void enabledSpinner(boolean bool) {
        this.jIntTimeSpinnerStart.setEnabled(bool);
        this.jIntTimeSpinnerEnd.setEnabled(bool);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jBToolbar1 = new JBToolbar();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.btnProcess = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jdbTextArea1 = new JdbTextArea();
        this.jIntTimeSpinnerStart = new JIntTimeSpinner();
        this.jIntTimeSpinnerEnd = new JIntTimeSpinner();
        this.jdbTextField1 = new JdbTextField();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jFormLabel1 = new JFormLabel();
        this.jBStatusbar1 = new JBStatusbar();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        this.jBToolbar1.setEnableDelete(false);
        this.jBToolbar1.setEnablePrint(false);
        this.jBToolbar1.setEnableRefresh(false);
        this.jBToolbar1.addJBToolbarListener(new JBToolbarListener(){

            public void toolbarNewPerformed(JBToolbarEvent evt) {
                FrmTimeDesigner.this.jBToolbar1ToolbarNewPerformed(evt);
            }

            public void toolbarOpenPerformed(JBToolbarEvent evt) {
                FrmTimeDesigner.this.jBToolbar1ToolbarOpenPerformed(evt);
            }

            public void toolbarEditPerformed(JBToolbarEvent evt) {
                FrmTimeDesigner.this.jBToolbar1ToolbarEditPerformed(evt);
            }

            public void toolbarSavePerformed(JBToolbarEvent evt) {
                FrmTimeDesigner.this.jBToolbar1ToolbarSavePerformed(evt);
            }

            public void toolbarCancelPerformed(JBToolbarEvent evt) {
                FrmTimeDesigner.this.jBToolbar1ToolbarCancelPerformed(evt);
            }

            public void toolbarDeletePerformed(JBToolbarEvent evt) {
            }

            public void toolbarVoidPerformed(JBToolbarEvent evt) {
                FrmTimeDesigner.this.jBToolbar1ToolbarVoidPerformed(evt);
            }

            public void toolbarPrintPerformed(JBToolbarEvent evt) {
            }

            public void toolbarRefreshPerformed(JBToolbarEvent evt) {
            }
        });
        this.jPanel1.setBackground(new Color(204, 204, 204));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel2.setOpaque(false);
        this.jLabel1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jLabel1.text"));
        this.jLabel1.setRequestFocusEnabled(false);
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jLabel2.text"));
        this.jLabel2.setRequestFocusEnabled(false);
        this.btnProcess.setFont(new Font("Dialog", 1, 11));
        this.btnProcess.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/leftarror.png")));
        this.btnProcess.setText(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.btnProcess.text"));
        this.btnProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTimeDesigner.this.btnProcessActionPerformed(evt);
            }
        });
        this.jPanel3.setOpaque(false);
        this.jLabel4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jLabel4.text"));
        this.jLabel4.setRequestFocusEnabled(false);
        this.jdbTextArea1.setColumns(20);
        this.jdbTextArea1.setRows(5);
        this.jdbTextArea1.setColumnName(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jdbTextArea1.columnName"));
        this.jScrollPane2.setViewportView((Component)this.jdbTextArea1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, -1, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jIntTimeSpinnerStart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jIntTimeSpinnerEnd, -2, -1, -2))).addContainerGap(36, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jIntTimeSpinnerStart, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jIntTimeSpinnerEnd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jdbTextField1.setColumnName(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jdbTextField1.columnName"));
        this.jdbTextField1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jLabel5.text"));
        this.jLabel5.setRequestFocusEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnProcess).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -2, 58, -2).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jdbTextField1, -2, 142, -2).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(190, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnProcess, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.jdbTextField1, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(12, 12, 12).addComponent(this.jLabel5)).addComponent(this.jPanel3, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setOpaque(false);
        this.jBdbTable1.setDataSet(this.trans.getDataSetDetail());
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 194, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jFormLabel1.setText(NbBundle.getMessage(FrmTimeDesigner.class, (String)"FrmTimeDesigner.jFormLabel1.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent((Component)this.jFormLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent((Component)this.jBStatusbar1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jBToolbar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jBToolbar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jFormLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addGap(12, 12, 12).addComponent((Component)this.jBStatusbar1, -2, -1, -2)));
        this.pack();
    }

    private void btnProcessActionPerformed(ActionEvent evt) {
        this.doProcess();
    }

    private void jBToolbar1ToolbarNewPerformed(JBToolbarEvent evt) {
        this.doNew();
    }

    private void jBToolbar1ToolbarSavePerformed(JBToolbarEvent evt) {
        this.doSave();
    }

    private void jBToolbar1ToolbarCancelPerformed(JBToolbarEvent evt) {
        this.doCancel();
    }

    private void jBToolbar1ToolbarVoidPerformed(JBToolbarEvent evt) {
        this.doVoid();
    }

    private void jBToolbar1ToolbarOpenPerformed(JBToolbarEvent evt) {
        this.doOpen();
    }

    private void jBToolbar1ToolbarEditPerformed(JBToolbarEvent evt) {
        this.doEdit();
    }

    public void setFormDataset() {
        this.jdbTextField1.setDataSet(this.trans.getDataSetMaster());
        this.jdbTextArea1.setDataSet(this.trans.getDataSetMaster());
        this.jBdbTable1.setDataSet(this.trans.getDataSetDetail());
    }

    public BigDecimal getDuration(int sh, int sm, int eh, int em) {
        int Time1 = sh * 3600 + sm * 60;
        int Time2 = eh * 3600 + em * 60;
        int Duration2 = Time2 - Time1;
        BigDecimal bd = new BigDecimal(Duration2).divide(new BigDecimal(3600), 2, RoundingMode.HALF_UP);
        return bd.abs();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.state.getState() == 1 || this.state.getState() == 2) {
            BUtil.setEnabledPanel((JPanel)this.jPanel1, (boolean)true);
            this.enabledSpinner(true);
            this.jBToolbar1.setEnableVoid(true);
            this.jBToolbar1.setEnableEdit(false);
            if (this.state.getState() == 1) {
                this.jBToolbar1.setEnableVoid(false);
                this.jBToolbar1.setEnablePrint(false);
                this.setFormDataset();
                this.initForm();
            }
            if (this.state.getState() == 2) {
                this.jIntTimeSpinnerStart.setTime(this.trans.getDataSetMaster().getTime("timestart"));
                this.jIntTimeSpinnerEnd.setTime(this.trans.getDataSetMaster().getTime("timeend"));
                this.jdbTextField1.setEnabled(false);
            }
        } else {
            BUtil.setEnabledPanel((JPanel)this.jPanel1, (boolean)false);
            this.jBToolbar1.setEnableVoid(false);
            this.enabledSpinner(false);
            if (this.jdbTextField1.getText().length() > 0) {
                this.jBToolbar1.setEnableEdit(true);
            }
        }
    }

    @Override
    public void doProcess() {
        this.trans.getDataSetDetail().deleteAllRows();
        ArrayList<String> time = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("kk:mm:ss");
        int startH = this.getStartHour();
        int startM = this.getStartMinute();
        Date dateStart = new Date(0L);
        dateStart.setHours(startH);
        dateStart.setMinutes(startM);
        dateStart.setSeconds(0);
        int endH = this.getEndHour();
        int endM = this.getEndMinute();
        Date dateEnd = new Date(0L);
        dateEnd.setHours(endH);
        dateEnd.setMinutes(endM);
        dateEnd.setSeconds(0);
        time.add(sdf.format(dateStart).toString());
        int iterasi = 1;
        while (!sdf.format(dateStart).toString().equalsIgnoreCase(sdf.format(dateEnd).toString())) {
            dateStart = new Date(0L);
            dateStart.setHours(startH);
            dateStart.setMinutes(iterasi * 1);
            dateStart.setSeconds(0);
            time.add(sdf.format(dateStart).toString());
            ++iterasi;
        }
        for (int i = 0; i < time.size(); ++i) {
            DataRow dr = new DataRow(this.trans.getDataSetDetail());
            dr.setString("timename", this.trans.getDataSetMaster().getString("timename"));
            dr.setInt("timeno", i + 1);
            dr.setString("timedesc", (String)time.get(i));
            dr.setTime("timedetail", Time.valueOf((String)time.get(i)));
            this.trans.getDataSetDetail().addRow(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNew() {
        try {
            ScreenManager.setCursorThinking((JInternalFrame)this);
            this.trans.New();
            this.state.setState(1);
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    public void doOpen() {
        this.dlg = DlgTimeDsg.getInstance();
        this.dlg.Refresh();
        this.dlg.setVisible(true);
        String retval = this.dlg.getSelectedID();
        if (null != retval) {
            this.doEdit(retval);
        }
    }

    public void doEdit() {
        this.doEdit(this.trans.getDataSetMaster().getString("timename"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEdit(String string) {
        try {
            ScreenManager.setCursorThinking((JInternalFrame)this);
            this.setFormDataset();
            this.trans.LoadID(string);
            this.state.setState(2);
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    public void doSave() {
        try {
            Time timeStart = new Time(this.getStartHour(), this.getStartMinute(), 0);
            Time timeEnd = new Time(this.getEndHour(), this.getEndMinute(), 0);
            BigDecimal duration = this.getDuration(this.getStartHour(), this.getStartMinute(), this.getEndHour(), this.getEndMinute());
            this.trans.getDataSetMaster().setTime("timestart", timeStart);
            this.trans.getDataSetMaster().setTime("timeend", timeEnd);
            this.trans.getDataSetMaster().setBigDecimal("duration", duration);
            this.trans.Save();
            this.state.setState(0);
            UIMgr.showMessageDialog((String)"Saved, OK !", (Component)this);
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Save Gagal", (Exception)ex, (Component)this, (Logger)logger);
        }
    }

    public void doCancel() {
        try {
            this.trans.Cancel();
            this.state.setState(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doDelete() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVoid() {
        try {
            ScreenManager.setCursorThinking((JInternalFrame)this);
            this.spRemove.execute(this.trans.getDataSetMaster().getString("timename"));
            this.trans.Void();
            this.state.setState(0);
            UIMgr.showMessageDialog((String)"Void, OK !", (Component)this);
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Void Gagal", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    public void doPrint() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doRefresh() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTransState(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JInternalFrame getFormComponent() {
        return this;
    }

    public BTrans getTrans() {
        return this.trans;
    }
}

