/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.ui.toolbar;

import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Reg;
import com.bits.bee.ui.myswing.BTitledSeparator;
import com.bits.bee.ui.myswing.BtnOK;
import com.bits.lib.dbswing.JBDialog;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BSimpleData;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.Variant;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.TooManyListenersException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.util.Exceptions;

public class DlgBarcodeScan
extends JBDialog {
    private static DlgBarcodeScan singleton;
    private static final boolean USE_BARCODE;
    private final BLastData lastData = new BLastData();
    private BTrans trans;
    private DataSet dsDetail;
    private DataRow locateRow;
    private BTitledSeparator bTitledSeparator1;
    private BtnOK btnOK1;
    private JBdbTable jBdbTable1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField txtScan;

    private DlgBarcodeScan() {
        super((Frame)null, "Scan Barcode");
        this.initialize();
    }

    private void initialize() {
        this.initComponents();
    }

    public static synchronized DlgBarcodeScan getInstance() {
        if (null == singleton) {
            singleton = new DlgBarcodeScan();
        }
        return singleton;
    }

    public void setTrans(BTrans trans) {
        this.trans = trans;
        if (null != trans) {
            this.dsDetail = trans.getDataSetDetail();
            this.locateRow = new DataRow(this.dsDetail, "itemid");
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.txtScan.setText("");
            this.txtScan.requestFocus();
            this.lastData.resetData();
        }
        super.setVisible(visible);
    }

    private void processScan(String keyValue) {
        String itemId = keyValue;
        if (USE_BARCODE && null != keyValue) {
            itemId = ItemList.getInstance().getItemIDByBarCode(keyValue);
        }
        if (null != itemId && null != this.dsDetail) {
            this.handleTrans(itemId);
            this.lastData.updateData(itemId);
            this.txtScan.setText(null);
            this.txtScan.requestFocus();
        }
    }

    private void handleTrans(String itemid) {
        this.locateRow.setString("itemid", itemid);
        if (this.dsDetail.locate((ReadRow)this.locateRow, 32)) {
            this.dsDetail.setBigDecimal("qty", this.dsDetail.getBigDecimal("qty").add(BigDecimal.ONE));
        } else {
            this.dsDetail.insertRow(false);
            this.dsDetail.setString("itemid", itemid);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnOK1 = new BtnOK();
        this.jPanel2 = new JPanel();
        this.txtScan = new JTextField();
        this.jLabel1 = new JLabel();
        this.bTitledSeparator1 = new BTitledSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new FlowLayout(1, 5, 0));
        this.btnOK1.setText("DONE");
        this.btnOK1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgBarcodeScan.this.btnOK1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.btnOK1);
        this.txtScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgBarcodeScan.this.txtScanActionPerformed(evt);
            }
        });
        this.txtScan.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DlgBarcodeScan.this.txtScanFocusGained(evt);
            }
        });
        this.jLabel1.setText("Scan Barcode");
        this.bTitledSeparator1.setTitled("Data Scan Terakhir");
        this.jBdbTable1.setDataSet(this.lastData.getDataSet());
        this.jBdbTable1.setEditable(false);
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtScan).addComponent((Component)this.bTitledSeparator1, -1, 376, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 86, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addGap(0, 0, 0)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtScan, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.bTitledSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 42, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void txtScanActionPerformed(ActionEvent evt) {
        this.processScan(this.txtScan.getText());
    }

    private void btnOK1ActionPerformed(ActionEvent evt) {
        this.OK();
    }

    private void txtScanFocusGained(FocusEvent evt) {
        this.txtScan.selectAll();
    }

    static {
        USE_BARCODE = Reg.getInstance().getValueBooleanDefaultFalse("USE_BC");
    }

    class BLastData
    extends BSimpleData
    implements ColumnChangeListener {
        public BLastData() {
            super("data", "itemid");
            this.initBTable();
        }

        private void initBTable() {
            com.bits.lib.dx.Column[] cols = new com.bits.lib.dx.Column[]{new com.bits.lib.dx.Column("itemid", "Kode", 16), new com.bits.lib.dx.Column("itemdesc", "Nama Item", 16)};
            this.createDataSet((Column[])cols);
            HashMap hm = JBSQL.ColumnsToHashMap((Column[])cols);
            ((Column)hm.get("itemid")).setWidth(8);
            ((Column)hm.get("itemdesc")).setWidth(22);
            try {
                this.dataset.addColumnChangeListener((ColumnChangeListener)this);
            }
            catch (TooManyListenersException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataSetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.dataset.open();
            this.dataset.insertRow(false);
        }

        public void resetData() {
            this.dataset.emptyAllRows();
            this.dataset.insertRow(false);
        }

        public void updateData(String itemid) {
            this.dataset.setString("itemid", itemid);
        }

        public void changed(DataSet ds, Column column, Variant vrnt) {
            this.dataset.setString("itemdesc", ItemList.getInstance().getItemDesc(ds.getString("itemid")));
        }

        public void validate(DataSet ds, Column column, Variant vrnt) throws Exception, DataSetException {
        }
    }
}

