/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.confui.ConfMgr;
import com.bits.beebengkel.bl.BPContactList;
import com.bits.beebengkel.bl.CarNopolList;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.TooManyListenersException;
import org.openide.util.Exceptions;

public class BillBengkel
extends BTable
implements ColumnChangeListener {
    private static BillBengkel singleton;
    private static QueryDataSet qdsQ;

    public BillBengkel() {
        super(BDM.getDefault(), "bill", "billno");
        Column[] cols = new Column[]{new Column("billno", "billno", 16), new Column("bpid", "bpid", 16), new Column("bpname", "bpname", 16), new Column("carid", "carid", 4), new Column("carnopol", "carnopol", 16), new Column("custx", "custx", 16), new Column("carkm", "carkm", 10), new Column("carkmpast", "carkmpast", 10), new Column("problem", "problem", 16), new Column("bpphone", "bpphone", 16), new Column("billtype", "billtype", 16), new Column("billdate", "billdate", 13), new Column("billoutdate", "billoutdate", 13), new Column("arrivetime", "arrivetime", 14), new Column("leavetime", "leavetime", 14), new Column("billnote", "billnote", 16), new Column("billtotal", "billtotal", 10), new Column("paystatus", "paystatus", 16), new Column("billstatus", "billstatus", 16), new Column("srepid", "srepid", 16), new Column("srepname", "srepname", 16), new Column("dpamt", "dpamt", 10), new Column("queno", "queno", 4), new Column("waitid", "waitid", 16), new Column("servstatusid", "servstatusid", 16), new Column("branchid", "branchid", 16), new Column("estimateday", "estimateday", 5), new Column("estimatedate", "estimatedate", 13), new Column("apprefno", "apprefno", 16)};
        this.createDataSet(cols);
        try {
            this.dataset.addColumnChangeListener((ColumnChangeListener)this);
        }
        catch (DataSetException ex) {
            ex.printStackTrace();
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
        this.dataset.open();
    }

    public static synchronized BillBengkel getInstance() {
        if (null == singleton) {
            try {
                singleton = new BillBengkel();
                singleton.Load();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return singleton;
    }

    private void DefaultValues() throws Exception {
        super.setTransCode("BILL");
        this.getDataSet().setString("billno", "AUTO");
        this.getDataSet().setString("branchid", ConfMgr.getInstance().getValByTag("BranchID"));
        this.getDataSet().setDate("billdate", BHelp.getCurrentDate_SQL());
        this.getDataSet().setTime("arrivetime", BHelp.getCurrentTime());
        this.getDataSet().setInt("queno", this.getNoAntrian(this.getDataSet().getDate("billdate")));
        this.getDataSet().setString("bpid", "CASH");
        this.getDataSet().setString("servstatusid", "N");
        this.getDataSet().setString("Waitid", "W");
    }

    public void validateBill() throws Exception {
        if (this.getDataSet().isNull("bpid") || this.getDataSet().getString("bpid").length() == 0) {
            throw new Exception("Kode Customer belum diisi !");
        }
        if (this.getDataSet().isNull("billno") || this.getDataSet().getString("billno").length() == 0) {
            throw new Exception("Kode bill belum diisi !");
        }
        if (this.getDataSet().getBigDecimal("carkmpast").compareTo(this.getDataSet().getBigDecimal("carkm")) == 1) {
            throw new Exception("Km lalu tidak boleh lebih besar dari Km kini !");
        }
    }

    public String getBillNo(String saleno) {
        return this.find("saleno", saleno, "billno");
    }

    public String getSaleNo(String billno) {
        return this.find("billno", billno, "saleno");
    }

    public void New() {
        super.New();
        try {
            this.DefaultValues();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void saveChanges() throws Exception {
        this.validateBill();
        super.saveChanges();
    }

    public int getNoAntrian(Date date) {
        StringBuffer query = new StringBuffer("SELECT max(queno) as nomor FROM bill ");
        StringBuffer filter = new StringBuffer();
        filter.append(" billdate = '" + date + "'");
        filter.append(" and queno is not null");
        if (ConfMgr.getInstance().getValByTag("BranchID") != null) {
            filter.append(" and branchid = " + BHelp.QuoteSingle((String)ConfMgr.getInstance().getValByTag("BranchID")));
        }
        JBSQL.setWHERE((StringBuffer)query, (StringBuffer)filter);
        if (qdsQ.isOpen()) {
            qdsQ.close();
        }
        qdsQ.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), query.toString()));
        qdsQ.open();
        if (qdsQ.rowCount() > 0 || qdsQ.getInt("nomor") > 0) {
            return qdsQ.getInt("nomor") + 1;
        }
        return 1;
    }

    public void changed(DataSet ds, Column column, Variant vrnt) {
        String columnName = column.getColumnName();
        if ("carnopol".equalsIgnoreCase(columnName) && !"".equalsIgnoreCase(this.getDataSet().getString("carnopol"))) {
            CarNopolList.getInstance().doUpdate();
            String custid = CarNopolList.getInstance().getBpID(this.getDataSet().getString("carnopol"));
            String bpName = CarNopolList.getInstance().getBpName(this.getDataSet().getString("carnopol"));
            int carid = CarNopolList.getInstance().getCarID(this.getDataSet().getString("carnopol"));
            BigDecimal carkmpast = CarNopolList.getInstance().getCarKm(this.getDataSet().getString("carnopol"));
            String mainContact = BPContactList.getInstance().getBPPhone(custid);
            this.getDataSet().setString("bpid", custid);
            this.getDataSet().setString("bpname", bpName);
            this.getDataSet().setInt("carid", carid);
            this.getDataSet().setBigDecimal("carkmpast", carkmpast);
            this.getDataSet().setString("bpphone", mainContact);
        }
    }

    public void validate(DataSet ds, Column column, Variant vrnt) throws Exception, DataSetException {
    }

    static {
        qdsQ = new QueryDataSet();
    }
}

