/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.bl.Edc;
import com.bits.bee.bl.InstanceObserver;
import com.bits.bee.conf.InstanceMgr;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.Column;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdcCustom
extends BTable
implements InstanceObserver,
ResourceGetter {
    private static Logger logger = LoggerFactory.getLogger(EdcCustom.class);
    private LocaleInstance l = LocaleInstance.getInstance();
    private static EdcCustom edc;

    public EdcCustom() {
        super(BDM.getDefault(), "edc", "edcid");
        this.initBTable();
    }

    private void initBTable() {
        Column[] cols = new Column[]{new Column("edcid", this.getResourcesBL("col.edcid"), 16), new Column("cashid", this.getResourcesBL("col.cashid"), 16), new Column("edcname", this.getResourcesBL("col.edcname"), 16), new Column("edcnote", this.getResourcesBL("col.edcnote"), 16), new Column("edctype", this.getResourcesBL("col.edctype"), 16)};
        cols[0].setWidth(8);
        cols[1].setWidth(10);
        cols[2].setWidth(12);
        cols[3].setWidth(12);
        cols[4].setWidth(10);
        this.createDataSet((com.borland.dx.dataset.Column[])cols);
        this.dataset.open();
    }

    public static synchronized EdcCustom getInstance() {
        if (edc == null) {
            edc = new EdcCustom();
            try {
                edc.Load();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            InstanceMgr.getInstance().addObserver((InstanceObserver)edc);
        }
        return edc;
    }

    public String getDesc(String id) {
        return this.find("edcid", id, "edcname");
    }

    public String getCashID(String id) {
        return this.find("edcid", id, "cashid");
    }

    public String getEDCType(String id) {
        return this.find("edcid", id, "edctype");
    }

    public boolean isEDCValid(String edcid) {
        String localEDC = this.find("edcid", edcid, "edcid");
        return localEDC != null && localEDC.length() > 0;
    }

    public void doUpdate() {
        edc = null;
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(Edc.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(Edc.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(Edc.class, key);
    }
}

