/*
 * Decompiled with CFR 0.152.
 */
package com.bits.beebengkel.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.Rekap;
import com.bits.beebengkel.bl.SRepListBengkel;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RekapBengkel
extends BTable
implements ResourceGetter {
    private static Logger logger = LoggerFactory.getLogger(Rekap.class);
    private String[] lookupcols = new String[]{"itemid", "listprice"};
    private DataRow lookup;
    private DataRow lastmatch;
    private int pidcount = 0;
    private static int MAXCOL = 75;
    private String QTY_COLUMNNAME = "Qty";
    private String QTYX_COLUMNNAME = "QtyX";
    private LocaleInstance l = LocaleInstance.getInstance();
    private long lastmatch_pid_start;
    private long lastmatch_pid_end;
    private StringBuffer lastmatch_buff;

    public RekapBengkel() {
        super(BDM.getDefault(), "rekap", "itemid");
        this.initBTable();
    }

    private void initBTable() {
        com.bits.lib.dx.Column[] cols = new com.bits.lib.dx.Column[]{new com.bits.lib.dx.Column("no", this.getResourcesBL("col.no"), 3), new com.bits.lib.dx.Column("whid", this.getResourcesBL("col.whid"), 16), new com.bits.lib.dx.Column("itemid", this.getResourcesBL("col.itemid"), 16), new com.bits.lib.dx.Column("itemdesc", this.getResourcesBL("col.itemdesc"), 16), new com.bits.lib.dx.Column("qty", this.getResourcesBL("col.qty"), 10), new com.bits.lib.dx.Column("qtyx", this.getResourcesBL("col.qtyx"), 10), new com.bits.lib.dx.Column("unit", this.getResourcesBL("col.unit"), 16), new com.bits.lib.dx.Column("baseprice", this.getResourcesBL("col.baseprice"), 10), new com.bits.lib.dx.Column("listprice", this.getResourcesBL("col.listprice"), 10), new com.bits.lib.dx.Column("discexp", this.getResourcesBL("col.discexp"), 16), new com.bits.lib.dx.Column("discamt", this.getResourcesBL("col.discamt"), 10), new com.bits.lib.dx.Column("taxid", this.getResourcesBL("col.taxid"), 16), new com.bits.lib.dx.Column("taxamt", this.getResourcesBL("col.taxamt"), 10), new com.bits.lib.dx.Column("subtotal", this.getResourcesBL("col.subtotal"), 10), new com.bits.lib.dx.Column("note", this.getResourcesBL("col.note"), 16), new com.bits.lib.dx.Column("noterow", this.getResourcesBL("col.noterow"), 4), new com.bits.lib.dx.Column("mekanikidlist", "mekanikidlist", 16), new com.bits.lib.dx.Column("mekaniklist", "mekaniklist", 16)};
        cols = this.addAdditionalColumn(cols);
        BLUtil.setDataPreferredOrdinal((Column[])cols);
        HashMap hm = JBSQL.ColumnsToHashMap((Column[])cols);
        this.setOrderBy("whid,itemid");
        ((com.bits.lib.dx.Column)hm.get("noterow")).setVisible(0);
        ((com.bits.lib.dx.Column)hm.get("taxamt")).setVisible(0);
        ((com.bits.lib.dx.Column)hm.get("no")).setWidth(2);
        this.createDataSet((Column[])cols);
        this.dataset.open();
        this.lastmatch = new DataRow((DataSet)this.dataset);
        this.lookup = new DataRow((DataSet)this.dataset, this.lookupcols);
        MAXCOL = Reg.getInstance().getValueInt("DETAILM_MAXCOL") > 0 ? Reg.getInstance().getValueInt("DETAILM_MAXCOL") : 75;
    }

    private void concatenate(StringBuffer string1, String string2) {
        if (string2 != null && string2.length() > 0) {
            if (string1.length() > 0) {
                string1.append(", ");
            }
            if (string1.length() - string1.lastIndexOf("\n") + string2.length() > MAXCOL) {
                string1.append("\n");
                int row = this.dataset.getInt("noterow");
                this.dataset.setInt("noterow", row + 1);
            }
            string1.append(string2);
        }
    }

    private void lastmatch_flush() {
        if (this.lastmatch.getString("ItemID") != null && this.lastmatch.getString("ItemID").length() > 0) {
            this.put_buff();
            DataRow row = new DataRow((DataSet)this.dataset);
            row.setShort("no", this.lastmatch.getShort("no"));
            row.setString("ItemID", this.lastmatch.getString("ItemID"));
            row.setString("ItemDesc", ItemList.getInstance().getItemDesc(this.lastmatch.getString("ItemID")));
            row.setString("WhID", this.lastmatch.getString("WhID"));
            row.setBigDecimal("Qty", this.lastmatch.getBigDecimal("Qty"));
            row.setBigDecimal("QtyX", this.lastmatch.getBigDecimal("QtyX"));
            row.setString("Unit", this.lastmatch.getString("Unit"));
            row.setBigDecimal("BasePrice", this.lastmatch.getBigDecimal("BasePrice"));
            row.setBigDecimal("ListPrice", this.lastmatch.getBigDecimal("ListPrice"));
            row.setString("DiscExp", this.lastmatch.getString("DiscExp"));
            row.setBigDecimal("DiscAmt", this.lastmatch.getBigDecimal("DiscAmt"));
            row.setString("TaxID", this.lastmatch.getString("TaxID"));
            row.setBigDecimal("TaxAmt", this.lastmatch.getBigDecimal("TaxAmt"));
            row.setString("note", this.lastmatch_buff.toString());
            String[] idmekanik = this.lastmatch.getString("mekanikidlist").split(",");
            BigDecimal subtotal = this.lastmatch.getBigDecimal("Qty").multiply(this.lastmatch.getBigDecimal("BasePrice").subtract(this.lastmatch.getBigDecimal("DiscAmt")));
            if (Reg.getInstance().getValueBoolean("ROUND_SUBTOTAL").booleanValue()) {
                subtotal = subtotal.setScale(0, RoundingMode.DOWN);
            }
            row.setBigDecimal("SubTotal", subtotal);
            this.dataset.addRow(row);
        }
    }

    private void put_buff() {
        if (this.lastmatch_pid_start != -1L) {
            if (this.lastmatch_pid_end - this.lastmatch_pid_start > 1L) {
                this.concatenate(this.lastmatch_buff, String.format("%d s/d %d (%d)", this.lastmatch_pid_start, this.lastmatch_pid_end, this.lastmatch_pid_end - this.lastmatch_pid_start + 1L));
            } else if (this.lastmatch_pid_end - this.lastmatch_pid_start == 1L) {
                this.concatenate(this.lastmatch_buff, String.valueOf(this.lastmatch_pid_start));
                this.concatenate(this.lastmatch_buff, String.valueOf(this.lastmatch_pid_end));
            } else {
                this.concatenate(this.lastmatch_buff, String.valueOf(this.lastmatch_pid_start));
            }
            this.lastmatch_pid_start = -1L;
            this.lastmatch_pid_end = -1L;
        }
    }

    private void pid_add(long newpid, BigDecimal newqty, BigDecimal newqtyx) {
        if (newpid == this.lastmatch_pid_end + 1L) {
            this.lastmatch_pid_end = newpid;
        } else {
            this.put_buff();
            this.lastmatch_pid_start = newpid;
            this.lastmatch_pid_end = newpid;
        }
        this.lastmatch.setBigDecimal("Qty", this.lastmatch.getBigDecimal("Qty").add(newqty));
        this.lastmatch.setBigDecimal("QtyX", this.lastmatch.getBigDecimal("QtyX").add(newqtyx));
    }

    private void pid_add(String newpid, BigDecimal newqty, BigDecimal newqtyx) {
        this.lastmatch_pid_start = -1L;
        this.lastmatch.setBigDecimal("Qty", this.lastmatch.getBigDecimal("Qty").add(newqty));
        this.lastmatch.setBigDecimal("QtyX", this.lastmatch.getBigDecimal("QtyX").add(newqtyx));
        this.concatenate(this.lastmatch_buff, newpid);
    }

    private void pid_reset() {
        this.dataset.emptyAllRows();
        this.lastmatch_buff = new StringBuffer();
        this.lastmatch.setBigDecimal("Qty", BigDecimal.ZERO);
        this.lastmatch.setBigDecimal("QtyX", BigDecimal.ZERO);
        this.lastmatch.setString("ItemID", "");
        this.lastmatch_pid_start = -1L;
        this.lastmatch_pid_end = -1L;
    }

    public void RekapDetail(DataSet ds) {
        this.RekapDetail(ds, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RekapDetail(DataSet ds, String qtycolumnname, String qtyxcolumnname) {
        boolean usePrice;
        boolean useWhID = false;
        this.QTY_COLUMNNAME = qtycolumnname != null ? qtycolumnname : "Qty";
        this.QTYX_COLUMNNAME = qtyxcolumnname != null ? qtyxcolumnname : "QtyX";
        try {
            useWhID = ds.getColumn("WhID") != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            usePrice = ds.getColumn("ListPrice") != null;
        }
        catch (Exception e) {
            usePrice = false;
        }
        this.pid_reset();
        this.dataset.enableDataSetEvents(false);
        ds.enableDataSetEvents(false);
        int bookmarkds = ds.getRow();
        try {
            for (int i = 0; i < ds.getRowCount(); ++i) {
                ds.goToRow(i);
                if (!ds.getString("ItemID").equalsIgnoreCase(this.lastmatch.getString("ItemID")) || useWhID && !ds.getString("WhID").equalsIgnoreCase(this.lastmatch.getString("WhID")) || usePrice && ds.getBigDecimal("ListPrice").compareTo(this.lastmatch.getBigDecimal("ListPrice")) != 0 || usePrice && !ds.getString("DiscExp").equalsIgnoreCase(this.lastmatch.getString("DiscExp")) || usePrice && !ds.getString("TaxID").equalsIgnoreCase(this.lastmatch.getString("TaxID"))) {
                    this.lastmatch_flush();
                    this.addMekanikid(ds);
                    this.lastmatch.setShort("no", (short)(i + 1));
                    this.lastmatch.setString("ItemID", ds.getString("ItemID"));
                    this.lastmatch.setBigDecimal("Qty", BigDecimal.ZERO);
                    this.lastmatch.setBigDecimal("QtyX", BigDecimal.ZERO);
                    this.lastmatch.setString("Unit", ds.getString("Unit"));
                    if (useWhID) {
                        this.lastmatch.setString("WhID", ds.getString("WhID"));
                    }
                    if (usePrice) {
                        this.lastmatch.setBigDecimal("BasePrice", ds.getBigDecimal("BasePrice"));
                        this.lastmatch.setBigDecimal("ListPrice", ds.getBigDecimal("ListPrice"));
                        this.lastmatch.setString("DiscExp", ds.getString("DiscExp"));
                        this.lastmatch.setString("TaxID", ds.getString("TaxID"));
                        this.lastmatch.setBigDecimal("DiscAmt", ds.getBigDecimal("DiscAmt"));
                        this.lastmatch.setBigDecimal("TaxAmt", ds.getBigDecimal("TaxAmt"));
                    }
                    this.lastmatch_pid_start = -1L;
                    this.lastmatch_pid_end = -1L;
                    this.lastmatch_buff.delete(0, this.lastmatch_buff.length());
                }
                try {
                    this.pid_add(Long.valueOf(ds.getString("PID")), ds.getBigDecimal(this.QTY_COLUMNNAME), ds.getBigDecimal(this.QTYX_COLUMNNAME));
                    continue;
                }
                catch (Exception e) {
                    if (this.lastmatch_pid_end != -1L) {
                        this.put_buff();
                    }
                    this.pid_add(ds.getString("PID"), ds.getBigDecimal(this.QTY_COLUMNNAME), ds.getBigDecimal(this.QTYX_COLUMNNAME));
                }
            }
            this.lastmatch_flush();
        }
        finally {
            this.dataset.first();
            ds.goToRow(bookmarkds);
            this.dataset.enableDataSetEvents(true);
            ds.enableDataSetEvents(true);
        }
    }

    private void addMekanikid(DataSet ds) {
        String[] dsMekanikId = ds.getString("mekanikidlist").split(", ");
        String[] lastmatchMekanikId = this.lastmatch.getString("mekanikidlist").split(", ");
        StringBuilder srepidlist = new StringBuilder();
        StringBuilder sreplist = new StringBuilder();
        ArrayList ID = (ArrayList)Arrays.asList(dsMekanikId);
        for (int y = 0; y < lastmatchMekanikId.length; ++y) {
            this.checkAndAdd(ID, lastmatchMekanikId[y]);
        }
        boolean first = true;
        for (String string : ID) {
            if (first) {
                srepidlist.append(string);
                sreplist.append(SRepListBengkel.getInstance().getSRepName(string));
                first = false;
                continue;
            }
            srepidlist.append(", ").append(string);
            sreplist.append(", ").append(SRepListBengkel.getInstance().getSRepName(string));
        }
        this.dataset.setString("mekanikidlist", srepidlist.length() > 0 ? srepidlist.toString() : null);
        this.dataset.setString("mekaniklist", sreplist.length() > 0 ? sreplist.toString() : null);
    }

    public void checkAndAdd(ArrayList<String> al, String data) {
        if (al.indexOf(data) < 0) {
            al.add(data);
        }
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(Rekap.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(Rekap.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(Rekap.class, key);
    }
}

