/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.opnamecsvimport.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.SAdjD;
import com.bits.bee.bl.SaveSetter;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.exception.BDBExceptionHandler;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.CalcFieldsListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.Variant;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAdjDCSV
extends BTable
implements CalcFieldsListener,
ColumnChangeListener,
DataChangeListener,
SaveSetter,
ResourceGetter {
    private static Logger logger = LoggerFactory.getLogger(SAdjDCSV.class);
    private boolean data_change;
    private BDBExceptionHandler handler;
    private LocaleInstance l = LocaleInstance.getInstance();
    private boolean saving = false;
    private boolean useQtyX = Reg.getInstance().getValueBoolean("QTYX_ENABLED");

    public SAdjDCSV() {
        super(BDM.getDefault(), "sadjdcsv", "sadjno, sadjdcsvno");
        com.bits.lib.dx.Column[] cols = new com.bits.lib.dx.Column[]{new com.bits.lib.dx.Column("sadjno", this.getResourcesBL("sadjno"), 16), new com.bits.lib.dx.Column("sadjdcsvno", this.getResourcesBL("sadjdcsvno"), 3), new com.bits.lib.dx.Column("whid", this.getResourcesBL("whid"), 16), new com.bits.lib.dx.Column("itemid", this.getResourcesBL("itemid"), 16), new com.bits.lib.dx.Column("itemdesc", this.getResourcesBL("itemdesc"), 16), new com.bits.lib.dx.Column("pid", this.getResourcesBL("pid"), 16), new com.bits.lib.dx.Column("qtyin", this.getResourcesBL("qtyin"), 10), new com.bits.lib.dx.Column("qtystock", this.getResourcesBL("qtystock"), 10), new com.bits.lib.dx.Column("qtydiff", this.getResourcesBL("qtydiff"), 10), new com.bits.lib.dx.Column("unit", this.getResourcesBL("unit"), 16), new com.bits.lib.dx.Column("conv", this.getResourcesBL("conv"), 10), new com.bits.lib.dx.Column("qtyx", this.getResourcesBL("qtyx"), 10), new com.bits.lib.dx.Column("oldcost", this.getResourcesBL("oldcost"), 10), new com.bits.lib.dx.Column("cost", this.getResourcesBL("cost"), 10), new com.bits.lib.dx.Column("prjid", this.getResourcesBL("prjid"), 16), new com.bits.lib.dx.Column("deptid", this.getResourcesBL("deptid"), 16)};
        cols = this.addAdditionalColumn(cols);
        BLUtil.setBigDecimalScale((Column[])cols);
        BLUtil.setDataPreferredOrdinal((Column[])cols);
        HashMap hm = JBSQL.ColumnsToHashMap((Column[])cols);
        JBSQL.setCalc((Column)((com.bits.lib.dx.Column)hm.get("itemdesc")));
        this.setOrderBy("sadjdcsvno");
        this.createDataSet((Column[])cols);
        try {
            this.dataset.addCalcFieldsListener((CalcFieldsListener)this);
            this.dataset.addColumnChangeListener((ColumnChangeListener)this);
            this.dataset.addDataChangeListener((DataChangeListener)this);
        }
        catch (DataSetException ex) {
            logger.error("DataSet Exception", (Throwable)ex);
        }
        catch (TooManyListenersException ex) {
            logger.error("TooManyListenerException", (Throwable)ex);
        }
        this.setOrderBy("SadjNo, sadjdcsvno");
        this.dataset.open();
    }

    public void calcFields(ReadRow readRow, DataRow dataRow, boolean isPosted) {
        dataRow.setString("itemdesc", ItemList.getInstance().getItemDesc(readRow.getString("itemid")));
    }

    public void changed(DataSet dataSet, Column column, Variant variant) {
        if (this.data_change || this.bypass) {
            return;
        }
        this.data_change = true;
        if (column.getColumnName().equalsIgnoreCase("itemid") && dataSet.getString("itemid").length() > 0) {
            this.ItemID_Changed();
        }
        this.data_change = false;
    }

    public void validate(DataSet dataSet, Column column, Variant variant) throws Exception, DataSetException {
        String columnName = column.getColumnName();
        if (this.bypass) {
            return;
        }
        if ("qtyx".equalsIgnoreCase(columnName) && this.useQtyX && !ItemList.getInstance().useQtyX(dataSet.getString("itemid"))) {
            dataSet.setBigDecimal("qtyx", null);
            if (this.handler != null) {
                BDBExceptionHandler.handleException((DataSet)dataSet, null, (Exception)new Exception(this.getResourcesBL("ex.notuseqtyx")));
            }
        }
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        if (this.getDataSet().isNull("itemid") || this.getDataSet().getString("itemid").length() <= 0) {
            this.getDataSet().emptyRow();
        }
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void setBDBExceptionHandler(BDBExceptionHandler handler) {
        this.handler = handler;
    }

    private void ItemID_Changed() {
        BigDecimal qty = BigDecimal.ONE;
        String itemid = this.getString("itemid");
        if (itemid.indexOf("*") > 0) {
            String[] itemSplit = itemid.split("\\*");
            try {
                qty = new BigDecimal(itemSplit[0]);
                this.getDataSet().setBigDecimal("qtyin", qty);
                itemid = itemSplit[1];
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (Reg.getInstance().getValueBoolean("USE_BC").booleanValue()) {
            itemid = ItemList.getInstance().getItemIDByBarCode(itemid);
        }
        if (itemid != null && itemid.length() > 0 && !ItemList.getInstance().isStock(itemid)) {
            if (this.handler != null) {
                if (!ItemList.getInstance().isItemValid(itemid)) {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(this.getResourcesBL("ex.itemnotfound")));
                } else {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(this.getResourcesBL("ex.notforstock")));
                }
            }
            this.setString("itemid", null);
        } else if (ItemList.getInstance().isItemValid(itemid)) {
            this.setString("itemid", itemid);
            this.setBigDecimal("qtyin", qty);
            this.setString("unit", ItemList.getInstance().getUnit1(itemid));
            this.dataset.post();
        }
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(SAdjD.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(SAdjD.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(SAdjD.class, key);
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isSaving() {
        return this.saving;
    }
}

