/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.opnamecsvimport.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.City;
import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.Defa;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Modul;
import com.bits.bee.bl.Per;
import com.bits.bee.bl.Pid;
import com.bits.bee.bl.QtyExplode;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.SAdjTrans;
import com.bits.bee.bl.WhList;
import com.bits.bee.bl.constants.RegConstants;
import com.bits.bee.bl.exception.PKExceptionFactory;
import com.bits.bee.bl.procedure.spLogTrans_New;
import com.bits.bee.bl.util.memorized.SPMemorizedUtil;
import com.bits.bee.opnamecsvimport.bl.SAdjCustom;
import com.bits.bee.opnamecsvimport.bl.SAdjDCSV;
import com.bits.bee.opnamecsvimport.bl.procedure.spSAdjCSV_New;
import com.bits.bee.opnamecsvimport.bl.procedure.spSAdjCSV_Void;
import com.bits.lib.BHelp;
import com.bits.lib.annotation.PreVoidEvent;
import com.bits.lib.dbswing.BdbState;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BProcSimple;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAdjTransCustom
extends BTrans
implements RegConstants {
    private static Logger logger = LoggerFactory.getLogger(SAdjTransCustom.class);
    protected SAdjCustom sadj = (SAdjCustom)BTableProvider.createTable(SAdjCustom.class);
    protected SAdjDCSV sadjd = (SAdjDCSV)BTableProvider.createTable(SAdjDCSV.class);
    private String tipe = null;
    private BdbState state = new BdbState();
    private String OBJID;
    private LocaleInstance l = LocaleInstance.getInstance();
    protected String lastWHID;
    protected String usrid = BAuthMgr.getDefault().getUserID();
    private QueryDataSet qds = new QueryDataSet();
    private SPMemorizedUtil spMemorizedUtil = new SPMemorizedUtil();

    public SAdjTransCustom(String tipe) {
        super(BDM.getDefault(), "SADJ", "sadjdate", "branchid", "sadjno", "Penyesuaian Stock");
        this.setMaster((BTable)this.sadj);
        this.addDetail(this.sadjd);
        this.getDataSetDetail().addDataChangeListener((DataChangeListener)new SAdjAdapter());
        this.setspNew(new spSAdjCSV_New());
        this.setspVoid(new spSAdjCSV_Void());
        this.setspLog((BProcSimple)new spLogTrans_New());
        this.setRefType("SADJ");
        this.setCrtBy(BAuthMgr.getDefault().getUserID());
        this.tipe = tipe;
    }

    public void New() {
        super.New();
        this.NewDefaultValues();
    }

    public void Save() throws Exception {
        try {
            this.validate();
            this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
            this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
            BLUtil.renumberDetail((BTrans)this, (String)"sadjdcsvno");
            super.Save();
        }
        catch (Exception ex) {
            throw PKExceptionFactory.INSTANCE.createException(BHelp.getExceptionDetail((Exception)ex), ex, this.getResourcesBL("ex.pk"));
        }
    }

    private void NewDefaultValues() {
        this.getDataSetMaster().setString("sadjno", "AUTO");
        this.getDataSetMaster().setDate("sadjdate", BHelp.getCurrentDate_SQL());
        this.getDataSetMaster().setString("sadjtype", this.tipe);
        this.getDataSetMaster().setString("sadjaccno", Defa.getInstance().getValue("PKSTOCK"));
        this.getDataSetMaster().setString("perid", Per.getInstance().getPeriodeActive());
        this.getDataSetMaster().setString("crtby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setTimestamp("crtdate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setString("sadjmtd", "PL");
        this.getDataSetMaster().setBoolean("iscsv", true);
        if (this.tipe.equals("BEG")) {
            this.getDataSetMaster().setString("sadjnote", "Saldo awal stock");
            this.getDataSetMaster().setBoolean("isautogen", true);
        }
    }

    public void initPrint() {
        DataSet drcmp = Cmp.getInstance().getDataSet();
        this.getDataSetMaster().setString("cmpname", drcmp.getString("cmpname"));
        this.getDataSetMaster().setString("cmpownername", drcmp.getString("ownername"));
        this.getDataSetMaster().setString("cmpaddr", drcmp.getString("cmpaddr"));
        this.getDataSetMaster().setString("cmpphone", drcmp.getString("phone"));
        this.getDataSetMaster().setString("cmpcity", City.getInstance().getCityName(drcmp.getString("cityid")));
        this.getDataSetMaster().setString("cmptaxregno", drcmp.getString("taxregno"));
        this.getDataSetMaster().setString("cmpvatregno", drcmp.getString("vatregno"));
        this.getDataSetMaster().setDate("cmpvatregdate", drcmp.getDate("vatregdate"));
        this.getDataSetMaster().setString("formserno", drcmp.getString("formserno"));
    }

    public void setOBJID(String OBJID) {
        this.OBJID = OBJID;
    }

    public void setState(int StateType) {
        this.state.setState(StateType);
    }

    public boolean checkIsLocked() {
        boolean status = this.getDataSetMaster().getColumn("isLocked") == null ? true : (this.getDataSetMaster().getBoolean("isLocked") && this.state.getState() == 2 ? BAuthMgr.getDefault().getAuth(this.OBJID, "UNLOCK") : true);
        return status;
    }

    public void validate() throws Exception {
        ItemList itemList = ItemList.getInstance();
        DataSet master = this.getDataSetMaster();
        if (master.isNull("sadjno") || master.getString("sadjno").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.sadjno"));
        }
        if (master.isNull("sadjdate") || master.getDate("sadjdate").toString().length() == 0) {
            throw new Exception(this.getResourcesBL("ex.sadjdate"));
        }
        if (master.isNull("sadjtype") || master.getString("sadjtype").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.sadjtype"));
        }
        if (master.isNull("sadjmtd") || master.getString("sadjmtd").length() == 0) {
            throw new Exception(this.getResourcesBL("ex.sadjmtd"));
        }
        DataSet detail = this.getDataSetDetail();
        if (detail.getRowCount() <= 0) {
            throw new Exception("Tidak ada transaksi yang diinputkan !");
        }
        if (!master.getString("sadjmtd").equalsIgnoreCase("RPL")) {
            int len = detail.rowCount();
            for (int i = 0; i < len; ++i) {
                detail.goToRow(i);
                if (detail.getBigDecimal("qtydiff").compareTo(BigDecimal.ZERO) == 0) {
                    throw new Exception(this.getResourcesBL("ex.isbegandqtyzero"));
                }
                if (!Reg.getInstance().getValueBoolean("QTYX_ENABLED").booleanValue() || !Reg.getInstance().getValueBooleanDefaultTrue("CHECK_QTYX").booleanValue() || ItemList.getInstance().checkQtyX(detail.getString("itemid"), detail.getBigDecimal("qtyx"))) continue;
                throw new Exception(this.getResourcesBL("ex.isbegandqtyxzero"));
            }
        }
        if (Modul.getInstance().isInstalled("ACC") && (master.getString("sadjmtd").equalsIgnoreCase("PL") || master.getString("sadjmtd").equalsIgnoreCase("RPL")) && (master.isNull("sadjaccno") || master.getString("sadjaccno").length() == 0)) {
            throw new Exception(this.getResourcesBL("ex.accinstalledanaccno"));
        }
    }

    public void addItem(String itemid) {
        this.addItem(itemid, BigDecimal.ZERO);
    }

    public void addItem(String itemid, BigDecimal qty1) {
        this.addItem(itemid, qty1, Reg.getInstance().getValueString("WHSTOCK"));
    }

    public void addItem(String itemid, BigDecimal qty1, String whid) {
        this.addItem(itemid, qty1, whid, null);
    }

    public void addItem(String itemid, BigDecimal qty1, String whid, String pid) {
        if (this.getDataSetMaster().getRowCount() == 0) {
            this.New();
        }
        QtyExplode qtyexplode = ItemList.getInstance().getQtyExplode(itemid, qty1);
        for (int j = 1; j <= 3; ++j) {
            boolean satu = false;
            boolean dua = false;
            boolean tiga = false;
            if (j == 1) {
                if (qtyexplode.getQty1().compareTo(BigDecimal.ZERO) == 0) continue;
                satu = true;
            }
            if (j == 2) {
                if (qtyexplode.getQty2().compareTo(BigDecimal.ZERO) == 0) continue;
                dua = true;
            }
            if (j == 3) {
                if (qtyexplode.getQty3().compareTo(BigDecimal.ZERO) == 0) continue;
                tiga = true;
            }
            DataRow row = new DataRow(this.getDataSetDetail());
            row.setString("sadjno", this.getDataSetMaster().getString("sadjno"));
            row.setShort("sadjdcsvno", (short)(this.getDataSetDetail().getRowCount() + 1));
            row.setString("whid", whid);
            row.setString("itemid", itemid);
            if (pid != null) {
                row.setString("pid", pid);
            }
            if (satu) {
                row.setBigDecimal("qtydiff", qtyexplode.getQty1());
                row.setString("unit", ItemList.getInstance().getUnit1(itemid));
            }
            if (dua) {
                row.setBigDecimal("qtydiff", qtyexplode.getQty2());
                row.setString("unit", ItemList.getInstance().getUnit2(itemid));
            }
            if (tiga) {
                row.setBigDecimal("qtydiff", qtyexplode.getQty3());
                row.setString("unit", ItemList.getInstance().getUnit3(itemid));
            }
            this.getDataSetDetail().addRow(row);
        }
    }

    public void addItemQtyX(String itemid, BigDecimal qty1, BigDecimal qtyx, String whid, String pid) {
        if (this.getDataSetMaster().getRowCount() == 0) {
            this.New();
        }
        DataRow row = new DataRow(this.getDataSetDetail());
        row.setString("sadjno", this.getDataSetMaster().getString("sadjno"));
        row.setShort("sadjdcsvno", (short)(this.getDataSetDetail().getRowCount() + 1));
        row.setString("whid", whid);
        row.setString("itemid", itemid);
        if (pid != null) {
            row.setString("pid", pid);
        }
        row.setBigDecimal("qtydiff", qty1);
        row.setString("unit", ItemList.getInstance().getUnit1(itemid));
        row.setBigDecimal("qtyx", qtyx);
        this.getDataSetDetail().addRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBulkPID(Pid pid) {
        try {
            int count = pid.getDataSet().getRowCount();
            this.setBypass(true);
            for (int i = 0; i < count; ++i) {
                pid.getDataSet().goToRow(i);
                this.getDetail().New();
                this.getDataSetDetail().setString("sadjno", this.getDataSetMaster().getString("sadjno"));
                this.getDataSetDetail().setShort("sadjdcsvno", (short)(this.getDataSetDetail(0).getRow() + 1));
                this.getDataSetDetail().setString("itemid", pid.getString("itemid"));
                this.getDataSetDetail().setString("pid", pid.getString("pid"));
                this.getDataSetDetail().setString("unit", pid.getString("unit"));
                this.getDataSetDetail().setBigDecimal("qtydiff", pid.getBigDecimal("qtydiff"));
                if (this.tipe.equals("BEG") || this.getDataSetMaster().getString("sadjmtd").equalsIgnoreCase("RPL")) {
                    this.getDataSetDetail().setBigDecimal("cost", pid.getBigDecimal("avgcost"));
                }
                this.getDataSetDetail().setString("whid", pid.getString("whid"));
            }
        }
        finally {
            this.setBypass(false);
        }
    }

    private String getWHID() {
        if (this.getLastWHID() != null && this.getLastWHID().length() > 0) {
            return this.getLastWHID();
        }
        String whid_default = WhList.getInstance((String)this.usrid).isMatchLastResult(Reg.getInstance().getValueString("WHSTOCK")) ? Reg.getInstance().getValueString("WHSTOCK") : null;
        return whid_default;
    }

    public String getLastWHID() {
        return this.lastWHID;
    }

    public void setLastWHID(String lastWHID) {
        this.lastWHID = lastWHID;
    }

    protected Class getSubclass() {
        return ((Object)((Object)this)).getClass();
    }

    @PreVoidEvent
    public void checkVersioning() throws Exception {
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), String.format("SELECT version FROM sadj WHERE sadjno=%s", BHelp.QuoteSingle((String)this.getDataSetMaster().getString("sadjno")))));
        this.qds.open();
        Long version = this.qds.getLong("version");
        if (version.compareTo(this.getDataSetMaster().getLong("version")) > 0) {
            throw new IllegalArgumentException(LocaleInstance.getInstance().getMessageBL(null, "ex.version"));
        }
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(SAdjTrans.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(SAdjTrans.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(SAdjTrans.class, key);
    }

    class SAdjAdapter
    implements DataChangeListener {
        SAdjAdapter() {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (dataChangeEvent.getID() == 1 && SAdjTransCustom.this.getDataSetDetail().isNull("sadjno")) {
                SAdjTransCustom.this.getDetail().setString("sadjno", SAdjTransCustom.this.getMaster().getString("sadjno"));
                SAdjTransCustom.this.getDetail().setShort("sadjdcsvno", (short)(SAdjTransCustom.this.getDataSetDetail(0).getRow() + 1));
            }
        }

        public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        }
    }
}

