/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.opnamecsvimport.bl;

import com.bits.bee.bl.Reg;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BQuerySimple;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.ReadRow;
import java.math.BigDecimal;

public class StockQtyList
extends BQuerySimple {
    private DataRow lookuprow;
    private DataRow resultrow;
    private BigDecimal qty;
    private boolean isCached = Reg.getInstance().getValueBooleanDefaultTrue("CACHEDLIST");

    public StockQtyList() {
        super(BDM.getDefault(), "stock", "itemid", "itemid,whid,pid,qty", null);
    }

    private boolean isMatchLastResult(String itemid) {
        return this.resultrow != null && itemid != null && this.resultrow.getString("itemid").equalsIgnoreCase(itemid);
    }

    public boolean lookup(String itemid, String whid, String pid) {
        if (this.isMatchLastResult(itemid)) {
            this.qty = this.resultrow.getBigDecimal("qty");
            return true;
        }
        if (this.isCached) {
            this.lookuprow.setString("itemid", itemid);
            this.lookuprow.setString("whid", whid);
            if (pid == null) {
                pid = "";
            }
            this.lookuprow.setString("pid", pid);
            if (this.dataset.lookup((ReadRow)this.lookuprow, this.resultrow, 32)) {
                this.qty = this.resultrow.getBigDecimal("qty");
                return true;
            }
            return false;
        }
        if (this.dataset.getRowCount() > 0) {
            this.dataset.getDataRow(this.resultrow);
            this.qty = this.resultrow.getBigDecimal("qty");
            return true;
        }
        return false;
    }

    public BigDecimal getQtyValue(String itemid, String whid, String pid) {
        this.lookuprow = new DataRow((DataSet)this.dataset, new String[]{"itemid", "whid", "pid"});
        this.resultrow = new DataRow((DataSet)this.dataset);
        if (this.lookup(itemid, whid, pid)) {
            return this.resultrow.getBigDecimal("qty");
        }
        return BigDecimal.ZERO;
    }
}

