/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.opnamecsvimport.ui;

import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Pid;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.Rekap;
import com.bits.bee.bl.WhList;
import com.bits.bee.confui.ConfMgr;
import com.bits.bee.opnamecsvimport.ProcessOpnameCSV;
import com.bits.bee.opnamecsvimport.bl.ExtensionFileFilter;
import com.bits.bee.opnamecsvimport.bl.SAdjDCSV;
import com.bits.bee.opnamecsvimport.bl.SAdjTransCustom;
import com.bits.bee.opnamecsvimport.bl.StockQtyList;
import com.bits.bee.opnamecsvimport.ui.DlgSADJCustom;
import com.bits.bee.ui.DlgAuth;
import com.bits.bee.ui.DlgEmpList;
import com.bits.bee.ui.DlgPIDBulkEntry;
import com.bits.bee.ui.DlgPidEntryItem;
import com.bits.bee.ui.DlgPrint;
import com.bits.bee.ui.DlgSearchItemPID;
import com.bits.bee.ui.FrmSADJ;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.abstraction.SAdjForm;
import com.bits.bee.ui.abstraction.dlg.AbstractItemDialog;
import com.bits.bee.ui.factory.DialogFactoryUtil;
import com.bits.bee.ui.factory.memorized.MemorizedCustomFilter;
import com.bits.bee.ui.listener.ItemHintFilter;
import com.bits.bee.ui.listener.StockItemHintFilter;
import com.bits.bee.ui.myswing.DetailMessageDialog;
import com.bits.bee.ui.myswing.HelpBrowseStarter;
import com.bits.bee.ui.myswing.JCboWh;
import com.bits.bee.ui.myswing.JNoteBranch;
import com.bits.bee.ui.myswing.PanelErrorDetail;
import com.bits.bee.ui.myswing.PikEmp;
import com.bits.bee.ui.myswing.TextUtil;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.HelpMgr;
import com.bits.lib.dbswing.BdbState;
import com.bits.lib.dbswing.JBDatePicker;
import com.bits.lib.dbswing.JBStatusbar;
import com.bits.lib.dbswing.JBToolbar;
import com.bits.lib.dbswing.JBToolbarEvent;
import com.bits.lib.dbswing.JBToolbarHelpListener;
import com.bits.lib.dbswing.JBToolbarListener;
import com.bits.lib.dbswing.JBToolbarMediator;
import com.bits.lib.dbswing.JBToolbarXLSListener;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.exception.BDBExceptionHandler;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.report.BTextReport;
import com.bits.lib.report.TextPrinting;
import com.bits.lib.security.AuthMgr;
import com.bits.lib.security.BAuthMgr;
import com.borland.dbswing.JdbTextField;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmSADJCustom
extends JInternalFrame
implements SAdjForm,
PropertyChangeListener,
JBToolbarMediator,
ActionListener,
ResourceGetter,
MemorizedCustomFilter {
    private static Logger logger = LoggerFactory.getLogger(FrmSADJCustom.class);
    private SAdjTransCustom sadjtrans = null;
    private BdbState state = new BdbState();
    private String objid = null;
    private String type = null;
    private boolean begbal = false;
    private boolean bypass = false;
    private Rekap rekap = (Rekap)BTableProvider.createTable(Rekap.class);
    private JCboWh whCellEditor;
    private JButton btnImportCSV;
    private JFileChooser csvChooser = new JFileChooser();
    String dotExtension;
    private LocaleInstance l = LocaleInstance.getInstance();
    private boolean PID_ENABLED = Reg.getInstance().getValueBoolean("PID_ENABLED");
    private JBDatePicker jBDatePicker1;
    private JBStatusbar jBStatusbar1;
    private JBToolbar jBToolbar1;
    private JBdbTable jBdbTable4;
    private JButton jButton3;
    private JCboWh jCboWh1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JNoteBranch jNoteBranch1;
    private JPanel jPanel1;
    private JPanel jPanel17;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane7;
    private JTabbedPane jTabbedPane1;
    private JdbTextField jdbTextField1;
    private PikEmp pikEmp1;
    private JPanel tabRekap;
    private JBdbTable tblSADj;

    public FrmSADJCustom() {
        this.initSADJ("SADJ");
        this.sadjtrans.getDataSetMaster().setString("sadjmtd", "PL");
    }

    private void initExpandToolbar() {
        this.btnImportCSV = new JButton();
        this.btnImportCSV.setText("Import CSV");
        this.btnImportCSV.setToolTipText("Pilih File CSV");
        this.btnImportCSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrmSADJCustom.this.doImportCSV();
            }
        });
        this.jBToolbar1.addExpandButton(this.btnImportCSV);
    }

    private void initChooser() {
        this.csvChooser.setMultiSelectionEnabled(false);
        this.csvChooser.setDialogType(0);
        this.csvChooser.setFileSelectionMode(0);
        this.csvChooser.setAcceptAllFileFilterUsed(false);
        this.csvChooser.addChoosableFileFilter(new ExtensionFileFilter(new String[]{".TXT", ".CSV"}, "Text Documents (*.CSV|TXT)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportCSV() {
        int retval = this.csvChooser.showSaveDialog(this.getParent());
        try {
            if (retval == 0) {
                ScreenManager.setCursorThinking((JInternalFrame)this);
                String namafile = this.csvChooser.getSelectedFile().getAbsolutePath();
                this.importCSVProcess(namafile);
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.getResourcesUI("ex.savexls"), (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    private String ItemID_Changed(String itemid) {
        String itemidNew = Reg.getInstance().getValueBoolean("USE_BC") != false ? ItemList.getInstance().getItemIDByBarCode(itemid) : itemid;
        return itemidNew;
    }

    private void importCSVProcess(String fileCSV) {
        ArrayList<String[]> isi = ProcessOpnameCSV.parseUsingOpenCSV(fileCSV);
        StringBuffer itemids = new StringBuffer();
        StockQtyList qtyList = new StockQtyList();
        ArrayList<String[]> dump = new ArrayList<String[]>();
        StringBuffer errorlogmain = new StringBuffer();
        StringBuffer errlogqtysame = new StringBuffer();
        StringBuffer errlogitmsame = new StringBuffer();
        for (int i = 0; i < isi.size(); ++i) {
            BigDecimal qtyin = new BigDecimal(BigInteger.ZERO);
            String pid = null;
            qtyin = new BigDecimal(isi.get(i)[1].replaceAll("\"", ""));
            String itemid = this.ItemID_Changed(isi.get(i)[0]);
            try {
                pid = isi.get(i)[2];
                if (pid == null || pid.equalsIgnoreCase("")) {
                    qtyList.Load("itemid IN (" + BHelp.QuoteSingle((String)itemid) + ") " + " AND whid=" + BHelp.QuoteSingle((String)this.jCboWh1.getKeyValue()));
                } else {
                    qtyList.Load("itemid IN (" + BHelp.QuoteSingle((String)itemid) + ") " + "AND pid=" + BHelp.QuoteSingle((String)pid) + " AND whid=" + BHelp.QuoteSingle((String)this.jCboWh1.getKeyValue()));
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            BigDecimal diff = qtyList.getQtyValue(itemid, this.jCboWh1.getKeyValue(), pid);
            for (int j = 0; j < dump.size(); ++j) {
                if (!((String[])dump.get(j))[0].equals(isi.get(i)[0]) || ((String[])dump.get(j))[2] != isi.get(i)[2] && !((String[])dump.get(j))[2].equals(isi.get(i)[2])) continue;
                if (errlogitmsame.length() == 0) {
                    errlogitmsame.append("Item ditemukan sama! Harap cek file csv !");
                }
                if (isi.get(i)[2].equals("")) {
                    errlogitmsame.append(String.format("\n Kode/Barcode Item : %s , Qty: %s", isi.get(i)[0], isi.get(i)[1]));
                    continue;
                }
                errlogitmsame.append(String.format("\n Kode/Barcode Item : %s ,PID: %s, Qty: %s", isi.get(i)[0], isi.get(i)[2], isi.get(i)[1]));
            }
            this.sadjtrans.getDetail().New();
            this.sadjtrans.getDataSetDetail().setString("itemid", itemid);
            if (!this.PID_ENABLED) {
                itemids.append(BHelp.QuoteSingle((String)itemid) + ",");
            }
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtyin", qtyin);
            this.sadjtrans.getDataSetDetail().setString("pid", isi.get(i)[2]);
            this.sadjtrans.setBypass(true);
            this.sadjtrans.enableDataSetEvents(false);
            this.sadjtrans.getDataSetDetail().setString("whid", this.jCboWh1.getKeyValue());
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtystock", qtyList.getQtyValue(this.sadjtrans.getDataSetDetail().getString("itemid"), this.jCboWh1.getKeyValue(), isi.get(i)[2]));
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtydiff", this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin").subtract(this.sadjtrans.getDataSetDetail().getBigDecimal("qtystock")));
            this.sadjtrans.enableDataSetEvents(true);
            this.sadjtrans.setBypass(false);
            this.sadjtrans.getDataSetDetail().post();
            dump.add(new String[]{isi.get(i)[0], isi.get(i)[1], isi.get(i)[2]});
        }
        if (errlogitmsame.length() > 0 && errlogqtysame.length() > 0) {
            errorlogmain.append(String.format("%s \n \n%s", errlogitmsame.toString(), errlogqtysame.toString()));
        } else if (errlogitmsame.length() > 0) {
            errorlogmain.append(String.format("%s", errlogitmsame.toString()));
        } else if (errlogqtysame.length() > 0) {
            errorlogmain.append(String.format("%s", errlogqtysame.toString()));
        }
        if (errorlogmain.length() > 0) {
            UIMgr.showErrorDialog((String)"Error!", (Exception)new Exception(errorlogmain.toString()));
            this.sadjtrans.getDataSetDetail().deleteAllRows();
        }
    }

    private void calcQtyDiff() throws Exception {
        StockQtyList qtyList = new StockQtyList();
        StringBuffer queryfilter = new StringBuffer();
        int bookmark = this.sadjtrans.getDataSetDetail().getRow();
        queryfilter.append("  (itemid,whid,pid) in (values ");
        DataSet dsDetail = this.sadjtrans.getDataSetDetail();
        String whid = BHelp.QuoteSingle((String)this.jCboWh1.getKeyValue());
        for (int i = 0; i < dsDetail.getRowCount(); ++i) {
            dsDetail.goToRow(i);
            String pid = dsDetail.getString("pid");
            pid = !pid.equals("") ? BHelp.QuoteSingle((String)pid) : "''";
            if (i == dsDetail.getRowCount() - 1) {
                queryfilter.append(String.format("(%s,%s,%s)", BHelp.QuoteSingle((String)dsDetail.getString("itemid")), whid, pid));
                continue;
            }
            queryfilter.append(String.format("(%s,%s,%s),", BHelp.QuoteSingle((String)dsDetail.getString("itemid")), whid, pid));
        }
        queryfilter.append(" )");
        try {
            qtyList.Load(queryfilter.toString());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.sadjtrans.setBypass(true);
        this.sadjtrans.enableDataSetEvents(false);
        int count = 0;
        for (int i = 0; i < this.sadjtrans.getDataSetDetail().getRowCount(); ++i) {
            this.sadjtrans.getDataSetDetail().goToRow(i);
            this.sadjtrans.getDataSetDetail().setString("whid", this.jCboWh1.getKeyValue());
            BigDecimal qtystock = qtyList.getQtyValue(this.sadjtrans.getDataSetDetail().getString("itemid"), this.jCboWh1.getKeyValue(), this.sadjtrans.getDataSetDetail().getString("pid"));
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtystock", qtystock);
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtydiff", this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin").subtract(this.sadjtrans.getDataSetDetail().getBigDecimal("qtystock")));
            if (qtystock.compareTo(this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin")) != 0) continue;
            ++count;
        }
        boolean err = false;
        if (count != this.sadjtrans.getDataSetDetail().getRowCount()) {
            for (int i = 0; i < this.sadjtrans.getDataSetDetail().getRowCount(); ++i) {
                this.sadjtrans.getDataSetDetail().goToRow(i);
                if (this.sadjtrans.getDataSetDetail().getBigDecimal("qtystock").compareTo(this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin")) != 0) continue;
                this.sadjtrans.getDataSetDetail().deleteRow();
                --i;
            }
        } else if (this.sadjtrans.getDataSetDetail().getRowCount() != 0) {
            err = true;
        }
        this.sadjtrans.enableDataSetEvents(true);
        this.sadjtrans.setBypass(false);
        if (err) {
            throw new Exception("Qty Opname sama dengan Qty Stock !");
        }
    }

    private void calcQtyDiffEditTrx(String sadjno, boolean issave) throws Exception {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer query = new StringBuffer();
        query.append("select s.itemid, s.whid, s.pid, s.qty-COALESCE(sc.qtydiff, 0) AS qty from stock s LEFT JOIN (select itemid, whid, COALESCE(pid,'') AS pid, SUM(qtydiff) AS qtydiff FROM sadjdcsv WHERE sadjno = " + BHelp.QuoteSingle((String)sadjno) + " GROUP by itemid, whid, pid " + ") sc " + "ON sc.itemid=s.itemid AND s.whid=sc.whid AND s.pid=sc.pid ");
        query.append("WHERE (s.itemid, s.whid, s.pid) in (values ");
        DataSet dsDetail = this.sadjtrans.getDataSetDetail();
        String whid = BHelp.QuoteSingle((String)this.jCboWh1.getKeyValue());
        for (int i = 0; i < dsDetail.getRowCount(); ++i) {
            dsDetail.goToRow(i);
            String pid = dsDetail.getString("pid");
            pid = !pid.equals("") ? BHelp.QuoteSingle((String)pid) : "''";
            if (i == dsDetail.getRowCount() - 1) {
                query.append(String.format("(%s,%s,%s)", BHelp.QuoteSingle((String)dsDetail.getString("itemid")), whid, pid));
                continue;
            }
            query.append(String.format("(%s,%s,%s),", BHelp.QuoteSingle((String)dsDetail.getString("itemid")), whid, pid));
        }
        query.append(" )");
        try {
            if (qds.isOpen()) {
                qds.close();
            }
            qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), query.toString()));
            qds.open();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.sadjtrans.setBypass(true);
        this.sadjtrans.enableDataSetEvents(false);
        int count = 0;
        DataRow lookuprow = new DataRow((DataSet)qds, new String[]{"itemid", "whid", "pid"});
        DataRow resultrow = new DataRow((DataSet)qds);
        for (int i = 0; i < this.sadjtrans.getDataSetDetail().getRowCount(); ++i) {
            this.sadjtrans.getDataSetDetail().goToRow(i);
            this.sadjtrans.getDataSetDetail().setString("whid", this.jCboWh1.getKeyValue());
            lookuprow.setString("itemid", this.sadjtrans.getDataSetDetail().getString("itemid"));
            lookuprow.setString("whid", this.jCboWh1.getKeyValue());
            lookuprow.setString("pid", this.sadjtrans.getDataSetDetail().getString("pid"));
            BigDecimal qtystock = BigDecimal.ZERO;
            if (qds.lookup((ReadRow)lookuprow, resultrow, 32)) {
                qtystock = resultrow.getBigDecimal("qty");
            }
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtystock", qtystock);
            this.sadjtrans.getDataSetDetail().setBigDecimal("qtydiff", this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin").subtract(this.sadjtrans.getDataSetDetail().getBigDecimal("qtystock")));
            if (qtystock.compareTo(this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin")) != 0) continue;
            ++count;
        }
        boolean err = false;
        if (issave) {
            if (count != this.sadjtrans.getDataSetDetail().getRowCount()) {
                for (int i = 0; i < this.sadjtrans.getDataSetDetail().getRowCount(); ++i) {
                    this.sadjtrans.getDataSetDetail().goToRow(i);
                    if (this.sadjtrans.getDataSetDetail().getBigDecimal("qtystock").compareTo(this.sadjtrans.getDataSetDetail().getBigDecimal("qtyin")) != 0) continue;
                    this.sadjtrans.getDataSetDetail().deleteRow();
                    --i;
                }
            } else if (this.sadjtrans.getDataSetDetail().getRowCount() != 0) {
                err = true;
            }
        }
        this.sadjtrans.enableDataSetEvents(true);
        this.sadjtrans.setBypass(false);
        if (err) {
            throw new Exception("Qty Opname sama dengan Qty Stock !");
        }
    }

    private boolean validateStock() throws Exception {
        int bookmark = this.sadjtrans.getDataSetDetail().getRow();
        DataSet dsDetail = this.sadjtrans.getDataSetDetail();
        String whid = this.jCboWh1.getKeyValue();
        QueryDataSet qds = new QueryDataSet();
        StringBuffer query = new StringBuffer();
        StringBuffer errstock = new StringBuffer();
        HashMap<String, String> mapErrItemID = new HashMap<String, String>();
        int count = 0;
        for (int i = 0; i < dsDetail.getRowCount(); ++i) {
            dsDetail.goToRow(i);
            String itemid = dsDetail.getString("itemid");
            String pid = dsDetail.getString("pid");
            pid = !pid.equals("") ? BHelp.QuoteSingle((String)pid) : "''";
            query = new StringBuffer();
            query.append("SELECT 1 FROM stockad d JOIN stocka h ON d.stockano=h.stockano WHERE (h.reftype<>'SADJ' AND h.reftype<>'SIN' AND h.reftype<>'SOUT') AND (d.itemid,d.whid,d.pid) in (values ");
            query.append(String.format("(%s,%s,%s)", BHelp.QuoteSingle((String)itemid), BHelp.QuoteSingle((String)whid), pid));
            query.append(" ) LIMIT 1");
            if (qds.isOpen()) {
                qds.close();
            }
            qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), query.toString()));
            qds.open();
            if (qds.getRowCount() != 0) continue;
            if (errstock.length() == 0) {
                errstock.append("List item belum pernah di stok");
            }
            String itemdesc = dsDetail.getString("itemdesc");
            pid = dsDetail.getString("pid");
            ++count;
            if (pid.length() > 0) {
                errstock.append(String.format("\n%s. %s - %s, PID : %s, Gudang : %s", count, itemid, itemdesc, pid, whid));
            } else {
                errstock.append(String.format("\n%s. %s - %s, Gudang : %s", count, itemid, itemdesc, whid));
            }
            mapErrItemID.put(itemid, pid);
        }
        if (errstock.length() > 0) {
            String msg = "Tetap lanjutkan simpan data. \nAbaikan item yang belum pernah di stok";
            if (this.showConfirmDialog(msg, errstock, this)) {
                for (int i = 0; i < dsDetail.getRowCount(); ++i) {
                    dsDetail.goToRow(i);
                    String itemid = dsDetail.getString("itemid");
                    String pid = dsDetail.getString("pid");
                    if (!mapErrItemID.containsKey(itemid) || !((String)mapErrItemID.get(itemid)).equals(pid)) continue;
                    dsDetail.deleteRow();
                    --i;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean showConfirmDialog(String msg, StringBuffer trace, Component parent) {
        Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (parent != null) {
            comp = parent;
        }
        PanelErrorDetail pnlError = new PanelErrorDetail();
        JOptionPane errorPane = new JOptionPane(msg, 3, 0);
        JDialog errorDialog = errorPane.createDialog(parent, "Confirm");
        Container dialogContainer = errorDialog.getContentPane();
        DetailMessageDialog detailMsg = new DetailMessageDialog((Component)dialogContainer, (Component)pnlError);
        JTextArea textArea = pnlError.getTextArea();
        textArea.setBackground(Color.WHITE);
        if (trace.length() > 0) {
            detailMsg.showBottom(true);
        }
        textArea.setText(trace.toString());
        textArea.setWrapStyleWord(true);
        errorDialog.setContentPane((Container)detailMsg);
        textArea.setSize(new Dimension(400, 150));
        errorDialog.pack();
        errorDialog.setResizable(true);
        errorDialog.setVisible(true);
        Object selectedValue = errorPane.getValue();
        boolean val = false;
        if (selectedValue == null) {
            val = false;
        }
        val = selectedValue instanceof Integer ? (Integer)selectedValue == 0 : false;
        if (comp != null) {
            comp.requestFocus();
        }
        return val;
    }

    private void initComponents() {
        this.jBToolbar1 = new JBToolbar();
        this.jBStatusbar1 = new JBStatusbar();
        this.jLabel20 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jdbTextField1 = new JdbTextField();
        this.jLabel2 = new JLabel();
        this.jBDatePicker1 = new JBDatePicker();
        this.jLabel3 = new JLabel();
        this.jCboWh1 = new JCboWh();
        this.pikEmp1 = new PikEmp();
        this.jLabel4 = new JLabel();
        this.jNoteBranch1 = new JNoteBranch();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblSADj = new JBdbTable();
        this.tabRekap = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jBdbTable4 = new JBdbTable();
        this.jPanel17 = new JPanel();
        this.jButton3 = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Stock Opname via CSV | Plugin");
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            public void internalFrameClosing(InternalFrameEvent evt) {
                FrmSADJCustom.this.formInternalFrameClosing(evt);
            }

            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jBToolbar1.setEnableDelete(false);
        this.jBToolbar1.setEnableRefresh(false);
        this.jBToolbar1.setEnableXLS(true);
        this.jBToolbar1.setUseInnerHelpAction(false);
        this.jBToolbar1.addJBToolbarXLSListener(new JBToolbarXLSListener(){

            public void toolbarXLSPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarXLSPerformed(evt);
            }
        });
        this.jBToolbar1.addJBToolbarHelpListener(new JBToolbarHelpListener(){

            public void toolbarHelpPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarHelpPerformed(evt);
            }
        });
        this.jBToolbar1.addJBToolbarListener(new JBToolbarListener(){

            public void toolbarSavePerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarSavePerformed(evt);
            }

            public void toolbarOpenPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarOpenPerformed(evt);
            }

            public void toolbarPrintPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarPrintPerformed(evt);
            }

            public void toolbarCancelPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarCancelPerformed(evt);
            }

            public void toolbarDeletePerformed(JBToolbarEvent evt) {
            }

            public void toolbarNewPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarNewPerformed(evt);
            }

            public void toolbarEditPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarEditPerformed(evt);
            }

            public void toolbarVoidPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarVoidPerformed(evt);
            }

            public void toolbarRefreshPerformed(JBToolbarEvent evt) {
                FrmSADJCustom.this.jBToolbar1ToolbarRefreshPerformed(evt);
            }
        });
        this.jBStatusbar1.setDataSet(this.sadjtrans.getDataSetMaster());
        this.jLabel20.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel20.setForeground(new Color(102, 102, 102));
        this.jLabel20.setText("STOCK OPNAME VIA CSV");
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel1.setBackground(new Color(204, 204, 204));
        this.jLabel1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel1.setText("No. Transaksi:");
        this.jdbTextField1.setColumnName("sadjno");
        this.jdbTextField1.setDataSet(this.sadjtrans.getDataSetMaster());
        this.jdbTextField1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setText("Tanggal:");
        this.jBDatePicker1.setColumnName("sadjdate");
        this.jBDatePicker1.setDataSet(this.sadjtrans.getDataSetMaster());
        this.jBDatePicker1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("Gudang:");
        this.jCboWh1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FrmSADJCustom.this.jCboWh1ItemStateChanged(evt);
            }
        });
        this.pikEmp1.setColumnName("empid");
        this.pikEmp1.setDataSet(this.sadjtrans.getDataSetMaster());
        this.pikEmp1.setOpaque(false);
        this.jLabel4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel4.setText("Pegawai:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboWh1, -2, -1, -2).addComponent((Component)this.jBDatePicker1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.jdbTextField1, -2, 143, -2).addGap(91, 91, 91).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.pikEmp1, -2, 305, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jdbTextField1, -2, -1, -2).addComponent(this.jLabel4)).addComponent(this.jLabel1).addComponent((Component)this.pikEmp1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBDatePicker1, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.jCboWh1, -2, -1, -2)).addContainerGap()));
        jPanel1Layout.linkSize(1, new Component[]{this.jBDatePicker1, this.jdbTextField1});
        this.jNoteBranch1.setColumnNameBranch("branchid");
        this.jNoteBranch1.setColumnNameNote("sadjnote");
        this.jNoteBranch1.setDataSet(this.sadjtrans.getDataSetMaster());
        this.jTabbedPane1.setTabPlacement(3);
        this.jTabbedPane1.setFont(new Font("Dialog", 1, 11));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.tblSADj.setDataSet(this.sadjtrans.getDataSetDetail());
        this.tblSADj.setEnableDeleteAction(false);
        this.tblSADj.setEnabledAppendRow(false);
        this.tblSADj.setPopupMenuEnabled(false);
        this.tblSADj.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmSADJCustom.this.tblSADjKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.tblSADj);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 656, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 167, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Item", this.jPanel4);
        this.jScrollPane7.setBackground(new Color(255, 255, 255));
        this.jBdbTable4.setDataSet(this.rekap.getDataSet());
        this.jBdbTable4.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmSADJCustom.this.jBdbTable4KeyPressed(evt);
            }
        });
        this.jScrollPane7.setViewportView((Component)this.jBdbTable4);
        this.jButton3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jButton3.setText("Rekap");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmSADJCustom.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel17Layout = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton3).addContainerGap(562, Short.MAX_VALUE)));
        jPanel17Layout.setVerticalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3));
        GroupLayout tabRekapLayout = new GroupLayout(this.tabRekap);
        this.tabRekap.setLayout(tabRekapLayout);
        tabRekapLayout.setHorizontalGroup(tabRekapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel17, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane7, -1, 656, Short.MAX_VALUE));
        tabRekapLayout.setVerticalGroup(tabRekapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tabRekapLayout.createSequentialGroup().addComponent(this.jScrollPane7, -1, 137, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel17, -2, -1, -2)));
        this.jTabbedPane1.addTab("PID Rekap", this.tabRekap);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent((Component)this.jNoteBranch1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jTabbedPane1)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jNoteBranch1, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBToolbar1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jBStatusbar1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel20)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.jBToolbar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jBStatusbar1, -2, -1, -2)));
        this.pack();
    }

    private void jBToolbar1ToolbarPrintPerformed(JBToolbarEvent evt) {
        this.doPrint();
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.ExitForm();
    }

    private void ExitForm() {
        if (this.sadjtrans != null) {
            if (this.sadjtrans.getDataSetDetail().getRowCount() > 0 && (this.state.getState() == 1 || this.state.getState() == 2)) {
                int option = UIMgr.YesNoCancel((String)this.l.getMessageUI(null, "conf.exitform"));
                if (option == 0) {
                    String acstype = this.state.getState() == 1 ? "NEW" : "UPD";
                    DlgAuth dlgAuth = DlgAuth.getInstance();
                    dlgAuth.showAuth(this.l.getMessageUI(null, "obj.edit"), this.objid, acstype, this.sadjtrans.getDataSetMaster().getDate("sadjdate"));
                    if (dlgAuth.getSelectedID() == null) {
                        return;
                    }
                    this.doSave();
                } else if (option == 1) {
                    this.setDefaultCloseOperation(2);
                } else if (option == 2) {
                    this.setDefaultCloseOperation(0);
                }
            } else {
                this.setDefaultCloseOperation(2);
            }
        }
    }

    private void jBToolbar1ToolbarHelpPerformed(JBToolbarEvent evt) {
        if (this.type.equalsIgnoreCase("SADJ")) {
            HelpMgr.getInstance().showHelpWindow("FrmSADJCustom");
        } else if (this.type.equalsIgnoreCase("SIN")) {
            HelpMgr.getInstance().showHelpWindow("FrmStockIn");
        } else if (this.type.equalsIgnoreCase("SOUT")) {
            HelpMgr.getInstance().showHelpWindow("FrmStockOut");
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.rekap.RekapDetail(this.sadjtrans.getDataSetDetail());
    }

    private void jBdbTable4KeyPressed(KeyEvent evt) {
    }

    private void tblSADjKeyPressed(KeyEvent evt) {
        if ((evt.getKeyChar() == '+' || evt.getKeyChar() == '-') && this.tblSADj.getSelectedColumnName().equalsIgnoreCase("Satuan")) {
            String newunit;
            this.sadjtrans.getDataSetDetail().enableDataSetEvents(false);
            int bookmark = this.sadjtrans.getDataSetDetail(0).getRow();
            String cols = this.sadjtrans.getDataSetDetail(0).getLastColumnVisited();
            int kol = this.tblSADj.getSelectedColumn();
            String itemid = this.sadjtrans.getDataSetDetail(0).getString("ItemID");
            if (ItemList.getInstance().isItemValid(itemid) && (newunit = ItemList.getInstance().UnitScroll(itemid, this.sadjtrans.getDataSetDetail().getString("Unit"), evt.getKeyChar())) != null) {
                this.sadjtrans.getDataSetDetail(0).setString("Unit", newunit);
            }
            this.sadjtrans.getDataSetDetail().enableDataSetEvents(true);
            this.sadjtrans.getDataSetDetail().goToRow(bookmark);
            this.sadjtrans.getDataSetDetail().setLastColumnVisited(cols);
            this.tblSADj.setColumnSelectionInterval(kol, kol);
        } else if ((evt.getKeyChar() == '+' || evt.getKeyChar() == '-') && this.tblSADj.getSelectedColumnName().equalsIgnoreCase("Gd") && Reg.getInstance().getValueBoolean("WH_PLUSMINUS").booleanValue()) {
            String cols = this.sadjtrans.getDataSetDetail().getLastColumnVisited();
            int kol = this.tblSADj.getSelectedColumn();
            String newwhid = WhList.getInstance().whScroll(this.sadjtrans.getDataSetDetail().getString("whid"), evt.getKeyChar());
            if (newwhid != null) {
                this.sadjtrans.getDataSetDetail().setString("whid", newwhid);
            }
            this.sadjtrans.getDataSetDetail().setLastColumnVisited(cols);
            this.tblSADj.setColumnSelectionInterval(kol, kol);
        } else if (evt.getKeyCode() == 112) {
            AbstractItemDialog dlg = DialogFactoryUtil.getItemDialog(SAdjForm.class);
            if (dlg == null) {
                return;
            }
            dlg.setVisible(true);
            String retval = dlg.getSelectedID();
            if (retval != null) {
                this.sadjtrans.getDataSetDetail().setString("itemid", retval);
            }
        } else if (evt.getKeyCode() == 113 && !this.type.equalsIgnoreCase("BEG")) {
            DlgPidEntryItem dlgPidEntryItem = DlgPidEntryItem.getInstance();
            dlgPidEntryItem.setBTrans((BTrans)this.sadjtrans);
            dlgPidEntryItem.setUseDefaWHID(false);
            dlgPidEntryItem.setVisible(true);
            Pid pid = (Pid)dlgPidEntryItem.getSelectedObject();
            if (pid != null) {
                try {
                    this.sadjtrans.addBulkPID(pid);
                }
                catch (Exception ex) {
                    UIMgr.showErrorDialog((String)this.getResourcesUI("ex.import"), (Exception)ex, (Component)this, (Logger)logger);
                }
            }
            dlgPidEntryItem.Reset();
        } else if (evt.getKeyCode() == 114) {
            DlgPIDBulkEntry dlgPIDBulkEntry = DlgPIDBulkEntry.getInstance();
            dlgPIDBulkEntry.setBegBal(this.begbal || this.sadjtrans.getDataSetMaster().getString("sadjmtd").equalsIgnoreCase("RPL"));
            dlgPIDBulkEntry.setType(DlgPIDBulkEntry.TYPE_NOPRICEDISC);
            dlgPIDBulkEntry.setVisible(true);
            Pid pid = (Pid)dlgPIDBulkEntry.getSelectedObject();
            if (pid != null) {
                this.sadjtrans.addBulkPID(pid);
            }
            dlgPIDBulkEntry.Clean();
        } else if (evt.getKeyCode() == 119) {
            DlgSearchItemPID dlgSearchItemPID = DlgSearchItemPID.getInstance();
            dlgSearchItemPID.setItemid(this.sadjtrans.getDataSetDetail().getString("itemid"));
            dlgSearchItemPID.setBTrans((BTrans)this.sadjtrans);
            dlgSearchItemPID.setUsePrice(false);
            dlgSearchItemPID.setDetails(this.sadjtrans.getDataSetDetail());
            dlgSearchItemPID.setVisible(true);
            Pid localPID = (Pid)dlgSearchItemPID.getSelectedObject();
            if (localPID != null) {
                try {
                    this.sadjtrans.addBulkPID(localPID);
                }
                catch (Exception ex) {
                    UIMgr.showErrorDialog((String)this.getResourcesUI("ex.importitem"), (Exception)ex, (Logger)logger);
                }
            }
            dlgSearchItemPID.Reset();
        } else if (evt.getKeyCode() == 10) {
            this.addNewRow();
            this.focusOnCol0();
        }
    }

    public void addNewRow() {
        block8: {
            if (this.tblSADj.isEditable() && this.tblSADj.getDataSet() != null && this.tblSADj.getDataSet().isEnableInsert() && !this.tblSADj.getDataSet().isEditingNewRow() && this.tblSADj.getDataSet().isEditable()) {
                boolean readOnly = false;
                if (this.tblSADj.getDataSet() instanceof StorageDataSet) {
                    readOnly = ((StorageDataSet)this.tblSADj.getDataSet()).isReadOnly();
                }
                if (!readOnly) {
                    try {
                        if (this.tblSADj.getDataSet().atLast()) {
                            this.tblSADj.getDataSet().insertRow(false);
                            break block8;
                        }
                        this.tblSADj.getDataSet().next();
                    }
                    catch (DataSetException ex) {
                        BDBExceptionHandler.handleException((DataSet)this.tblSADj.getDataSet(), (Component)this.tblSADj, (Exception)((Object)ex));
                    }
                }
            } else if (!this.tblSADj.getDataSet().atLast()) {
                this.tblSADj.getDataSet().next();
            }
        }
    }

    private void focusOnCol0() {
        this.tblSADj.changeSelection(this.tblSADj.getSelectedRow(), 1, false, false);
        this.tblSADj.requestFocus();
    }

    private void jBToolbar1ToolbarEditPerformed(JBToolbarEvent evt) {
        this.doEdit();
    }

    private void jBToolbar1ToolbarRefreshPerformed(JBToolbarEvent evt) {
        this.doRefresh();
    }

    private void jBToolbar1ToolbarVoidPerformed(JBToolbarEvent evt) {
        this.doVoid();
    }

    private void initLockTrans() {
        this.sadjtrans.setOBJID(this.objid);
        this.sadjtrans.setState(this.state.getState());
    }

    private void validateData() throws Exception {
        if (null == this.jCboWh1.getKeyValue()) {
            throw new Exception("Gudang tidak boleh kosong !");
        }
    }

    private void jBToolbar1ToolbarCancelPerformed(JBToolbarEvent evt) {
        this.doCancel();
    }

    private void jBToolbar1ToolbarSavePerformed(JBToolbarEvent evt) {
        this.doSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave() {
        this.initLockTrans();
        try {
            if (this.Opname_Check_Emp()) {
                this.validateData();
                if (this.state.getState() == 2) {
                    this.calcQtyDiffEditTrx(this.sadjtrans.getDataSetMaster().getString("sadjno"), true);
                } else {
                    this.calcQtyDiff();
                }
                if (this.validateStock()) {
                    this.sadjtrans.Save();
                    UIMgr.showMessageDialog((String)this.l.getMessageUI(null, "ok.save"), (Component)this);
                    this.state.setState(0);
                }
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.save"), (Exception)ex, (Component)this, (Logger)logger);
        }
    }

    private void jBToolbar1ToolbarOpenPerformed(JBToolbarEvent evt) {
        this.doOpen();
    }

    private void jBToolbar1ToolbarNewPerformed(JBToolbarEvent evt) {
        this.doNew();
    }

    private void jCboWh1ItemStateChanged(ItemEvent evt) {
    }

    private void jBToolbar1ToolbarXLSPerformed(JBToolbarEvent evt) {
        try {
            HelpBrowseStarter.showHelpBrowser((String)"plugins/opname-csv-import/ImportOpname-CSV.csv");
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal menampilkan contoh file csv", (Exception)ex, (Logger)logger);
        }
    }

    private void initTable() {
        this.tblSADj.setAppendFocusColumn(2);
        DataSet ds = this.sadjtrans.getDataSetDetail();
        for (int i = 0; i < ds.getColumnCount(); ++i) {
            ds.getColumn(i).setVisible(0);
            ds.getColumn(i).setEditable(false);
        }
        HashMap<String, JBdbTable> map = new HashMap<String, JBdbTable>();
        map.put("itemid", this.tblSADj);
        map.put("deptid", this.tblSADj);
        map.put("prjid", this.tblSADj);
        UIMgr.setDataSetDetailTrans((DataSet)ds, map, (ActionListener)this, (ItemHintFilter)new StockItemHintFilter());
        ds.getColumn("itemid").setEditable(false);
        ds.getColumn("whid").setEditable(false);
        ds.getColumn("sadjdcsvno").setVisible(1);
        ds.getColumn("sadjdcsvno").setWidth(2);
        ds.getColumn("sadjdcsvno").setCaption("No");
        ds.getColumn("qtyin").setVisible(1);
        ds.getColumn("qtyin").setWidth(7);
        ds.getColumn("qtyin").setCaption("Qty Input");
        ds.getColumn("qtyin").setEditable(false);
        ds.getColumn("qtystock").setVisible(1);
        ds.getColumn("qtystock").setWidth(7);
        ds.getColumn("qtystock").setCaption("Qty Stock");
        ds.getColumn("qtystock").setEditable(false);
        ds.getColumn("qtydiff").setVisible(1);
        ds.getColumn("qtydiff").setWidth(7);
        ds.getColumn("qtydiff").setCaption("Selisih");
        ds.getColumn("qtyx").setVisible(0);
        ds.getColumn("deptid").setVisible(0);
        ds.getColumn("prjid").setVisible(0);
        DialogFactoryUtil.setColumnItemDialog((DataSet)ds, SAdjForm.class);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.state.getState() == 2 || this.state.getState() == 1) {
            this.initPanel(true);
            this.jBToolbar1.setEnableEdit(false);
            this.jBToolbar1.setEnableVoid(true);
            if (!this.type.equalsIgnoreCase("BEG")) {
                this.jBToolbar1.setEnablePrint(true);
            } else {
                this.jBToolbar1.setEnablePrint(false);
            }
            if (this.state.getState() == 1) {
                this.jBToolbar1.setEnableSave(true);
                this.jBToolbar1.setEnableVoid(false);
                this.jBToolbar1.setEnablePrint(false);
            } else if (this.state.getState() == 2) {
                this.setAutogen();
            }
        } else {
            this.initPanel(false);
            if (this.jdbTextField1.getText().length() > 0) {
                this.jBToolbar1.setEnableEdit(true);
            }
        }
        this.btnImportCSV.setEnabled(this.state.getState() == 1);
    }

    public void checkDateAccess() {
        BAuthMgr.getDefault().setTransDate(this.sadjtrans.getDataSetMaster().getDate("sadjdate"));
    }

    private void initPanel(boolean b) {
        BUtil.setEnabledPanel((JPanel)this.jPanel1, (boolean)b);
        BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)b);
        this.jNoteBranch1.setEnabled(b);
        if (this.state.getState() == 1) {
            this.jdbTextField1.setEditable(Reg.getInstance().getValueBoolean("AUTONO_LOCK") == false);
        } else {
            this.jdbTextField1.setEditable(false);
        }
    }

    private void initMnemonic() {
        this.jTabbedPane1.setMnemonicAt(0, 73);
        this.jTabbedPane1.setMnemonicAt(1, 80);
    }

    private void initSADJ(String type) {
        this.type = type;
        if (!this.bypass) {
            this.sadjtrans = new SAdjTransCustom(type);
        }
        this.initComponents();
        this.initExpandToolbar();
        this.initChooser();
        this.objid = "SO999910";
        this.jBToolbar1.setObjid(this.objid);
        this.jBToolbar1.setAuthMgr((AuthMgr)BAuthMgr.getDefault());
        this.jBToolbar1.setMediator((JBToolbarMediator)this);
        this.jBToolbar1.setState(this.state);
        this.state.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.state.setState(0);
        this.initPanel(false);
        this.initTable();
        this.initMnemonic();
        ((SAdjDCSV)this.sadjtrans.getDetail()).setBDBExceptionHandler(BDBExceptionHandler.getInstance());
        TextUtil.setIDDocumentFilter((JTextField)this.jdbTextField1);
        this.jTabbedPane1.setEnabledAt(1, Reg.getInstance().getValueBooleanDefaultFalse("PID_ENABLED"));
        this.jTabbedPane1.remove(1);
        this.initExpandComponent();
        this.jBToolbar1.getBtnXLS().setText("Download Contoh");
        this.jBToolbar1.getBtnXLS().setSize(new Dimension(130, this.jBToolbar1.getBtnXLS().getHeight()));
        this.jBToolbar1.getBtnXLS().setPreferredSize(new Dimension(130, this.jBToolbar1.getBtnXLS().getHeight()));
    }

    private void initExpandComponent() {
    }

    public void setNote(String note) {
    }

    private void setAutogen() {
    }

    public void actionPerformed(ActionEvent e) {
        if (this.whCellEditor == null) {
            this.whCellEditor = (JCboWh)e.getSource();
        }
        if (this.whCellEditor != null) {
            this.sadjtrans.setLastWHID(this.whCellEditor.getKeyValue());
        }
    }

    private void showPrint() {
        DlgPrint dlg = DlgPrint.getInstance();
        dlg.setDefault();
        dlg.setTextInvoice(this.getResourcesUI("dlgprint1"));
        dlg.setTextRekapInvoice(this.getResourcesUI("dlgprint2"));
        dlg.enabledInvPerf(false);
        dlg.setVisible(true);
        if (dlg.getDoPrint()) {
            this.siapkanReport(dlg.getInvoice(), dlg.getRekapInvoice(), dlg.getPrv());
        }
        dlg.reset();
    }

    public void siapkanReport(boolean inv, boolean rkp, boolean prv) {
        String sadj_rpt = "";
        String sadj_rpt_reg = "";
        String sadjd_rpt = "";
        String sadjd_rpt_reg = "";
        String sadj_rkp_rpt = "";
        String sadj_rkp_rpt_reg = "";
        String sadjd_rkp_rpt = "";
        String sadjd_rkp_rpt_reg = "";
        Reg reg = Reg.getInstance();
        try {
            TextPrinting p;
            BTextReport btrd;
            BTextReport btrp;
            this.sadjtrans.initPrint();
            if (inv) {
                if (this.type.equalsIgnoreCase("SADJ")) {
                    sadj_rpt = reg.getValueString("SADJ_CSV_RPT");
                    sadj_rpt_reg = "SADJ_CSV_RPT";
                    sadjd_rpt = reg.getValueString("SADJD_CSV_RPT");
                    sadjd_rpt_reg = "SADJD_CSV_RPT";
                } else if (this.type.equalsIgnoreCase("SIN")) {
                    sadj_rpt = reg.getValueString("SIN_RPT");
                    sadj_rpt_reg = "SIN_RPT";
                    sadjd_rpt = reg.getValueString("SIND_RPT");
                    sadjd_rpt_reg = "SIND_RPT";
                } else if (this.type.equalsIgnoreCase("SOUT")) {
                    sadj_rpt = reg.getValueString("SOUT_RPT");
                    sadj_rpt_reg = "SOUT_RPT";
                    sadjd_rpt = reg.getValueString("SOUTD_RPT");
                    sadjd_rpt_reg = "SOUT_RPT";
                }
                btrp = new BTextReport(BDM.getDefault(), sadj_rpt_reg, sadj_rpt, this.sadjtrans.getDataSetMaster());
                btrd = new BTextReport(BDM.getDefault(), sadjd_rpt_reg, sadjd_rpt, this.sadjtrans.getDataSetDetail());
                btrp.addSubReport(btrd);
                btrp.process();
                if (prv) {
                    btrp.Preview();
                } else if (!reg.getValueBoolean("PRNTDLG_ENABLED").booleanValue()) {
                    p = new TextPrinting(btrp.getTextString());
                    if (Boolean.valueOf(ConfMgr.getConfig().getValByTag("autoprint")).booleanValue()) {
                        p.setPrint(ConfMgr.getConfig().getValByTag("text1"));
                        p.setshowPrintDialog(false);
                    }
                    p.print();
                } else {
                    btrp.Print();
                }
            }
            if (rkp) {
                this.rekap.RekapDetail(this.sadjtrans.getDataSetDetail(), "qtydiff", null);
                if (this.type.equalsIgnoreCase("SADJ")) {
                    sadj_rkp_rpt = reg.getValueString("SADJ_CSV_RKP_RPT");
                    sadj_rkp_rpt_reg = "SADJ_CSV_RKP_RPT";
                    sadjd_rkp_rpt = reg.getValueString("SADJD_CSV_RKP_RPT");
                    sadjd_rkp_rpt_reg = "SADJD_CSV_RKP_RPT";
                } else if (this.type.equalsIgnoreCase("SIN")) {
                    sadj_rkp_rpt = reg.getValueString("SIN_RKP_RPT");
                    sadj_rkp_rpt_reg = "SIN_RKP_RPT";
                    sadjd_rkp_rpt = reg.getValueString("SIND_RKP_RPT");
                    sadjd_rkp_rpt_reg = "SIND_RKP_RPT";
                } else if (this.type.equalsIgnoreCase("SOUT")) {
                    sadj_rkp_rpt = reg.getValueString("SOUT_RKP_RPT");
                    sadj_rkp_rpt_reg = "SOUT_RKP_RPT";
                    sadjd_rkp_rpt = reg.getValueString("SOUTD_RKP_RPT");
                    sadjd_rkp_rpt_reg = "SOUTD_RKP_RPT";
                }
                btrp = new BTextReport(BDM.getDefault(), sadj_rkp_rpt_reg, sadj_rkp_rpt, this.sadjtrans.getDataSetMaster());
                btrd = new BTextReport(BDM.getDefault(), sadjd_rkp_rpt_reg, sadjd_rkp_rpt, this.rekap.getDataSet());
                btrp.addSubReport(btrd);
                btrp.process();
                if (prv) {
                    btrp.Preview();
                } else if (!reg.getValueBoolean("PRNTDLG_ENABLED").booleanValue()) {
                    p = new TextPrinting(btrp.getTextString());
                    if (Boolean.valueOf(ConfMgr.getConfig().getValByTag("autoprint")).booleanValue()) {
                        p.setPrint(ConfMgr.getConfig().getValByTag("text1"));
                        p.setshowPrintDialog(false);
                    }
                    p.print();
                } else {
                    btrp.Print();
                }
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.siapkanreport"), (Exception)ex, (Component)this, (Logger)logger);
        }
    }

    private void initLang() {
        if (this.type.equalsIgnoreCase("SADJ")) {
            this.setTitle(this.getResourcesUI("sadj.title"));
            this.jLabel20.setText(this.getResourcesUI("sadj.jLabel20.text"));
        } else if (this.type.equalsIgnoreCase("SIN")) {
            this.setTitle(this.getResourcesUI("sin.title"));
            this.jLabel20.setText(this.getResourcesUI("sin.jLabel20.text"));
        } else if (this.type.equalsIgnoreCase("SOUT")) {
            this.setTitle(this.getResourcesUI("sout.title"));
            this.jLabel20.setText(this.getResourcesUI("sout.jLabel20.text"));
        } else if (this.type.equalsIgnoreCase("BEG")) {
            this.setTitle(this.getResourcesUI("beg.title"));
            this.jLabel20.setText(this.getResourcesUI("beg.jLabel20.text"));
        }
        this.jLabel1.setText(this.getResourcesUI("jLabel1.text"));
        this.jLabel2.setText(this.getResourcesUI("jLabel2.text"));
        this.jButton3.setText(this.getResourcesUI("jButton3.text"));
        this.jTabbedPane1.setTitleAt(0, this.getResourcesUI("jPanel4.TabTitle"));
        this.jTabbedPane1.setTitleAt(1, this.getResourcesUI("tabRekap.TabTitle"));
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(FrmSADJ.class, key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(FrmSADJ.class, key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(FrmSADJ.class, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNew() {
        try {
            ScreenManager.setCursorThinking((JInternalFrame)this);
            this.sadjtrans.emptyAllRows();
            this.sadjtrans.New();
            this.state.setState(1);
            this.jdbTextField1.requestFocus();
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOpen() {
        DlgSADJCustom dlg = DlgSADJCustom.getInstance();
        dlg.setSADjType(this.type);
        dlg.setVisible(true);
        String retval = dlg.getSelectedID();
        if (retval != null && retval.length() > 0) {
            try {
                ScreenManager.setCursorThinking((JInternalFrame)this);
                this.sadjtrans.LoadID(retval);
                this.jCboWh1.setKeyValue(this.sadjtrans.getDataSetDetail().getString("whid"));
                this.state.setState(2);
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            finally {
                ScreenManager.setCursorDefault((JInternalFrame)this);
            }
        }
    }

    public void doEdit() {
        this.doEdit(this.jdbTextField1.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEdit(String transNo) {
        try {
            ScreenManager.setCursorThinking((JInternalFrame)this);
            this.sadjtrans.LoadID(transNo);
            this.jCboWh1.setKeyValue(this.sadjtrans.getDataSetDetail().getString("whid"));
            this.state.setState(2);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
        }
    }

    public void doCancel() {
        this.sadjtrans.Cancel();
        this.state.setState(0);
    }

    public void doDelete() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doVoid() {
        this.initLockTrans();
        String acstype = "VOI";
        if (this.sadjtrans.checkIsLocked()) {
            try {
                this.sadjtrans.Void();
                UIMgr.showMessageDialog((String)this.l.getMessageUI(null, "ok.void"), (Component)this);
                this.state.setState(0);
            }
            catch (Exception e) {
                UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.void"), (Exception)e, (Component)this, (Logger)logger);
            }
        } else {
            UIMgr.showErrorDialog((String)this.l.getMessageUI(null, "ex.locktrans"));
        }
        this.state.setState(0);
    }

    public void doPrint() {
        this.showPrint();
    }

    public void doRefresh() {
        try {
            this.sadjtrans.LoadID(this.sadjtrans.getDataSetMaster().getString("sadjno"));
            this.jCboWh1.setKeyValue(this.sadjtrans.getDataSetDetail().getString("whid"));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public void setTransState(int state) {
        this.state.setState(state);
    }

    public JInternalFrame getFormComponent() {
        return this;
    }

    public String getCustomFilter() {
        return String.format("sadjtype=%s", BHelp.QuoteSingle((String)this.sadjtrans.getDataSetMaster().getString("sadjtype")));
    }

    public BTrans getTrans() {
        return this.sadjtrans;
    }

    private boolean Opname_Check_Emp() {
        boolean return_value = false;
        DlgEmpList dlgEmpList = DlgEmpList.getInstance();
        if (this.sadjtrans.getDataSetMaster().isNull("empid") || this.sadjtrans.getDataSetMaster().getString("empid").equals("")) {
            dlgEmpList.setVisible(true);
            if (dlgEmpList.getSelectedID() != null && !"".equalsIgnoreCase(dlgEmpList.getSelectedID())) {
                this.sadjtrans.getDataSetMaster().setString("empid", dlgEmpList.getSelectedID());
                return_value = true;
                return return_value;
            }
            UIMgr.showErrorDialog((String)"Pegawai harus di isi");
            return_value = false;
            return return_value;
        }
        return_value = true;
        return return_value;
    }
}

