/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.bl.BPAddress;
import com.bits.bee.exportefaktur.bl.BPEFaktur;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.JCboCity;
import com.bits.bee.ui.myswing.JCboState;
import com.bits.bee.ui.myswing.PikCust;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.provider.BTableProvider;
import com.borland.dbswing.JdbTextArea;
import com.borland.dbswing.JdbTextField;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmBPEFaktur
extends JInternalFrame
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmBPEFaktur.class);
    private final BPAddress bpa = (BPAddress)BTableProvider.createTable(BPAddress.class);
    private final BPEFaktur bpe = (BPEFaktur)BTableProvider.createTable(BPEFaktur.class);
    private JButton btnSave;
    private JButton btnVoid;
    private JCboCity jCboCity1;
    private JCboState jCboState1;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel8;
    private JScrollPane jScrollPane3;
    private JLabel lblCbgID;
    private JLabel lblCbgID1;
    private JLabel lblCbgID10;
    private JLabel lblCbgID11;
    private JLabel lblCbgID12;
    private JLabel lblCbgID2;
    private JLabel lblCbgID3;
    private JLabel lblCbgID4;
    private JLabel lblCbgID5;
    private JLabel lblCbgID6;
    private JLabel lblCbgID7;
    private JLabel lblCbgID8;
    private JLabel lblCbgID9;
    private PikCust pikCust1;
    private JdbTextArea txtAddr;
    private JdbTextField txtBlok;
    private JdbTextField txtDesc;
    private JdbTextField txtFax;
    private JdbTextField txtKecamatan;
    private JdbTextField txtKelurahan;
    private JdbTextField txtNomor;
    private JdbTextField txtRT;
    private JdbTextField txtRW;
    private JdbTextField txtTelp;
    private JdbTextField txtZipCode;

    public FrmBPEFaktur() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.initBP();
        this.txtDesc.setEditable(false);
        this.txtAddr.setEditable(false);
        this.jCboCity1.setEnabled(false);
        this.txtTelp.setEditable(false);
        this.txtFax.setEditable(false);
        this.txtZipCode.setEditable(false);
        this.txtBlok.setEditable(false);
        this.txtNomor.setEditable(false);
        this.txtRT.setEditable(false);
        this.txtRW.setEditable(false);
        this.txtKecamatan.setEditable(false);
        this.txtKelurahan.setEditable(false);
        this.jCboState1.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.btnVoid.setEnabled(false);
    }

    private void setEditableField(boolean b) {
        this.txtBlok.setEditable(b);
        this.txtNomor.setEditable(b);
        this.txtRT.setEditable(b);
        this.txtRW.setEditable(b);
        this.txtKecamatan.setEditable(b);
        this.txtKelurahan.setEditable(b);
        this.jCboState1.setEnabled(b);
    }

    private void initBP() {
        this.pikCust1.addPropertyChangeListener("pickerkey", (PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("pickerkey")) {
            this.loadData();
            if (this.pikCust1.getKeyValue() != null) {
                this.setEditableField(true);
                this.setEnableBtnSave(true);
            } else {
                this.setEditableField(false);
                this.setEnableBtnSave(false);
                this.setEnableBtnVoid(false);
            }
        }
    }

    private void loadData() {
        String retval = this.pikCust1.getKeyValue();
        if (retval != null && retval.length() > 0) {
            try {
                this.clearAll();
                this.bpa.Load(String.format("bpid = %s", BHelp.QuoteSingle((String)retval)));
                if (!this.getBPEFaktur(retval).isEmpty() && this.getBPEFaktur(retval).length() > 0) {
                    this.setEnableBtnVoid(true);
                } else {
                    this.setEnableBtnVoid(false);
                }
                this.bpe.LoadID(retval);
                this.bpe.addNewRow(retval);
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
        }
    }

    private void clearAll() {
        this.bpe.getDataSet().setString("blok", null);
        this.bpe.getDataSet().setString("nomor", null);
        this.bpe.getDataSet().setString("rt", null);
        this.bpe.getDataSet().setString("rw", null);
        this.bpe.getDataSet().setString("kecamatan", null);
        this.bpe.getDataSet().setString("kelurahan", null);
        this.bpe.getDataSet().setString("propinsi", null);
    }

    public String getBPEFaktur(String bpid) {
        QueryDataSet qds = new QueryDataSet();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bpid FROM bpefaktur WHERE bpid = ").append(BHelp.QuoteSingle((String)bpid));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getString("bpid");
    }

    private void doSave() {
        try {
            if (this.validateData()) {
                if (this.isBPEfakturNull()) {
                    UIMgr.showErrorDialog((String)"Minimal satu Data Tambahan harus diinput!");
                    return;
                }
                this.bpe.saveChanges();
            } else {
                UIMgr.showErrorDialog((String)"Tidak ada customer dipilih!");
            }
            UIMgr.showMessageDialog((String)"Saved, OK!");
            this.bpe.LoadID(this.pikCust1.getKeyValue());
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            UIMgr.showErrorDialog((String)"Error", (Exception)ex);
        }
    }

    private void doVoid() {
        try {
            this.bpe.getDataSet().deleteRow();
            this.bpe.saveChanges();
            UIMgr.showMessageDialog((String)"Void, Ok!");
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)("Gagal hapus data!" + ex));
        }
    }

    private boolean isBPEfakturNull() {
        String[] column = new String[]{"blok", "nomor", "rt", "rw", "kecamatan", "kelurahan", "propinsi"};
        boolean retval = true;
        for (String column1 : column) {
            if (this.bpe.getDataSet().getString(column1).isEmpty()) continue;
            retval = false;
            break;
        }
        return retval;
    }

    private boolean validateData() {
        return this.pikCust1.getKeyValue() != null && !this.pikCust1.getKeyValue().isEmpty();
    }

    private void setEnableBtnSave(boolean b) {
        this.btnSave.setEnabled(b);
    }

    private void setEnableBtnVoid(boolean b) {
        this.btnVoid.setEnabled(b);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.pikCust1 = new PikCust();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblCbgID = new JLabel();
        this.txtDesc = new JdbTextField();
        this.lblCbgID1 = new JLabel();
        this.lblCbgID2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.txtAddr = new JdbTextArea();
        this.jCboCity1 = new JCboCity();
        this.txtTelp = new JdbTextField();
        this.txtFax = new JdbTextField();
        this.txtZipCode = new JdbTextField();
        this.lblCbgID3 = new JLabel();
        this.lblCbgID4 = new JLabel();
        this.lblCbgID5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblCbgID6 = new JLabel();
        this.txtBlok = new JdbTextField();
        this.lblCbgID7 = new JLabel();
        this.txtNomor = new JdbTextField();
        this.lblCbgID8 = new JLabel();
        this.txtRT = new JdbTextField();
        this.lblCbgID9 = new JLabel();
        this.txtRW = new JdbTextField();
        this.lblCbgID10 = new JLabel();
        this.txtKecamatan = new JdbTextField();
        this.lblCbgID11 = new JLabel();
        this.txtKelurahan = new JdbTextField();
        this.jCboState1 = new JCboState();
        this.lblCbgID12 = new JLabel();
        this.btnSave = new JButton();
        this.btnVoid = new JButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Alamat Tambahan Mitra Bisnis");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("ALAMAT TAMBAHAN MITRA BISNIS");
        this.jPanel8.setBackground(new Color(204, 204, 204));
        this.jPanel8.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.pikCust1.setColumnName("bpid");
        this.pikCust1.setDataSet(this.bpe.getDataSet());
        this.pikCust1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmBPEFaktur.this.pikCust1ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Customer:");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)), "Data Customer", 0, 0, null, new Color(0, 0, 0)));
        this.lblCbgID.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID.setText("Deskripsi:");
        this.txtDesc.setColumnName("addrname");
        this.txtDesc.setDataSet(this.bpa.getDataSet());
        this.txtDesc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmBPEFaktur.this.txtDescActionPerformed(evt);
            }
        });
        this.lblCbgID1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID1.setText("Alamat:");
        this.lblCbgID2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID2.setText("Kota:");
        this.txtAddr.setColumns(20);
        this.txtAddr.setRows(3);
        this.txtAddr.setColumnName("addr");
        this.txtAddr.setDataSet(this.bpa.getDataSet());
        this.txtAddr.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jScrollPane3.setViewportView((Component)this.txtAddr);
        this.jCboCity1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jCboCity1.setColumnName("cityid");
        this.jCboCity1.setDataSet(this.bpa.getDataSet());
        this.jCboCity1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmBPEFaktur.this.jCboCity1ActionPerformed(evt);
            }
        });
        this.txtTelp.setColumnName("phone");
        this.txtTelp.setDataSet(this.bpa.getDataSet());
        this.txtTelp.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.txtFax.setColumnName("fax");
        this.txtFax.setDataSet(this.bpa.getDataSet());
        this.txtZipCode.setColumnName("zipcode");
        this.txtZipCode.setDataSet(this.bpa.getDataSet());
        this.lblCbgID3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID3.setText("Telepon:");
        this.lblCbgID4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID4.setText("Fax:");
        this.lblCbgID5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID5.setText("Kode Pos:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCbgID5, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID4, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID3, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID2, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID1, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.txtDesc, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 215, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.txtZipCode, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.txtFax, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.txtTelp, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCboCity1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID).addComponent((Component)this.txtDesc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCbgID1).addComponent(this.jScrollPane3, -2, 57, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jCboCity1, -2, -1, -2).addComponent(this.lblCbgID2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.txtTelp, -2, -1, -2).addComponent(this.lblCbgID3)).addGap(7, 7, 7).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.txtFax, -2, -1, -2).addComponent(this.lblCbgID4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.txtZipCode, -2, -1, -2).addComponent(this.lblCbgID5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)), "Data Tambahan"));
        this.lblCbgID6.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID6.setText("Blok:");
        this.txtBlok.setColumnName("blok");
        this.txtBlok.setDataSet(this.bpe.getDataSet());
        this.lblCbgID7.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID7.setText("Nomor:");
        this.txtNomor.setColumnName("nomor");
        this.txtNomor.setDataSet(this.bpe.getDataSet());
        this.lblCbgID8.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID8.setText("RT:");
        this.txtRT.setColumnName("rt");
        this.txtRT.setDataSet(this.bpe.getDataSet());
        this.lblCbgID9.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID9.setText("RW:");
        this.txtRW.setColumnName("rw");
        this.txtRW.setDataSet(this.bpe.getDataSet());
        this.lblCbgID10.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID10.setText("Kecamatan:");
        this.txtKecamatan.setColumnName("kecamatan");
        this.txtKecamatan.setDataSet(this.bpe.getDataSet());
        this.lblCbgID11.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID11.setText("Kelurahan:");
        this.txtKelurahan.setColumnName("Kelurahan");
        this.txtKelurahan.setDataSet(this.bpe.getDataSet());
        this.jCboState1.setColumnName("propinsi");
        this.jCboState1.setDataSet(this.bpe.getDataSet());
        this.lblCbgID12.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblCbgID12.setText("Propinsi:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCbgID12, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID11, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID10, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID9, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID8, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID7, GroupLayout.Alignment.TRAILING).addComponent(this.lblCbgID6, GroupLayout.Alignment.TRAILING)).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboState1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.txtKelurahan, -1, -1, Short.MAX_VALUE).addComponent((Component)this.txtKecamatan, -2, 140, -2).addComponent((Component)this.txtRW, -2, 140, -2).addComponent((Component)this.txtRT, -1, -1, Short.MAX_VALUE).addComponent((Component)this.txtNomor, -2, 140, -2).addComponent((Component)this.txtBlok, -2, 140, -2)).addContainerGap(43, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID6).addComponent((Component)this.txtBlok, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID7).addComponent((Component)this.txtNomor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID8).addComponent((Component)this.txtRT, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID9).addComponent((Component)this.txtRW, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID10).addComponent((Component)this.txtKecamatan, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCbgID11).addComponent((Component)this.txtKelurahan, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jCboState1, -2, -1, -2).addComponent(this.lblCbgID12)).addContainerGap(25, Short.MAX_VALUE)));
        this.btnSave.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/simpan.png")));
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmBPEFaktur.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnVoid.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.btnVoid.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/del.png")));
        this.btnVoid.setText("Void");
        this.btnVoid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmBPEFaktur.this.btnVoidActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.pikCust1, -2, 336, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnVoid, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave, -2, 112, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.pikCust1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSave, -2, 26, -2).addComponent(this.btnVoid, -2, 26, -2)).addGap(14, 14, 14)));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 658, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void pikCust1ActionPerformed(ActionEvent evt) {
    }

    private void txtDescActionPerformed(ActionEvent evt) {
    }

    private void jCboCity1ActionPerformed(ActionEvent evt) {
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.doSave();
    }

    private void btnVoidActionPerformed(ActionEvent evt) {
        this.doVoid();
    }
}

