/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.bl.BP;
import com.bits.bee.exportefaktur.util.EFakturUtil;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.lib.BHelp;
import com.bits.lib.dbswing.BdbState;
import com.bits.lib.dbswing.JBToolbar;
import com.bits.lib.dbswing.JBToolbarEvent;
import com.bits.lib.dbswing.JBToolbarListener;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.security.AuthMgr;
import com.bits.lib.security.BAuthMgr;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmBulkUpdateNpwpBP
extends JInternalFrame
implements PropertyChangeListener,
ResourceGetter {
    private static final Logger logger = LoggerFactory.getLogger(FrmBulkUpdateNpwpBP.class);
    private final QueryDataSet qds = new QueryDataSet();
    private final DataSetView dsv = new DataSetView();
    private static final String OBJID = "110001";
    private final LocaleInstance l = LocaleInstance.getInstance();
    private final BdbState state = new BdbState();
    private String bpidSumComa;
    boolean isExistNIKOrNPWPBP;
    private JBToolbar jBToolbar1;
    private JBdbTable jBdbTable1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public FrmBulkUpdateNpwpBP() {
        this.init(null);
    }

    public FrmBulkUpdateNpwpBP(String bpidSumComa) {
        this.init(bpidSumComa);
    }

    private void init(String bpidSumComa) {
        this.initComponents();
        this.jBdbTable1.addPropertyChangeListener("componentPopupMenu", (PropertyChangeListener)new JTableAdapter());
        this.jBToolbar1.setState(this.state);
        this.jBToolbar1.setObjid(OBJID);
        this.jBToolbar1.setAuthMgr((AuthMgr)BAuthMgr.getDefault());
        this.initListener();
        this.state.setState(0);
        this.isExistNIKOrNPWPBP = EFakturUtil.isExistNIKOrNPWPBP();
        this.setBpidSumComa(bpidSumComa);
        this.doRefresh();
    }

    private void initListener() {
        this.state.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    public void initPanel(boolean enabled) {
        this.jBdbTable1.setEditable(enabled);
        this.jBdbTable1.setPopupMenuEnabled(enabled);
    }

    public void setBpidSumComa(String bpidSumComa) {
        this.bpidSumComa = bpidSumComa;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.state.getState() == 2) {
            this.initPanel(true);
        } else {
            this.initPanel(false);
            this.jBToolbar1.setEnableEdit(true);
        }
        this.jBToolbar1.setEnableChoosePrintMode(false);
        this.jBToolbar1.setEnableSaveDraft(false);
        this.jBToolbar1.setEnablePrint(false);
        this.jBToolbar1.setEnableOpen(false);
        this.jBToolbar1.setEnableVoid(false);
        this.jBToolbar1.setEnableNew(false);
        this.jBToolbar1.setEnableDelete(false);
    }

    public void doEdit() {
        this.doRefresh();
        this.state.setState(2);
    }

    public void doCancel() {
        this.doRefresh();
        this.state.setState(0);
    }

    private void doRefresh() {
        this.doLoadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() {
        int bookmark = this.dsv.getRow();
        try {
            if (this.dsv.getRowCount() <= 0) {
                UIMgr.showErrorDialog((String)"Tidak ada data yang akan di proses !");
                return;
            }
            boolean first = true;
            StringBuilder sbBpId = new StringBuilder();
            for (int i = 0; i < this.dsv.getRowCount(); ++i) {
                this.dsv.goToRow(i);
                String bpid = this.dsv.getString("bpid");
                String taxregno = this.dsv.getString("taxregno");
                String taxnikno = this.dsv.getString("taxnikno");
                if (!(taxregno != null && taxregno.length() > 0 || taxnikno != null && taxnikno.length() > 0)) {
                    throw new Exception("NPWP atau NIK Mitra Bisnis #" + bpid + " tidak boleh kosong !");
                }
                if (first) {
                    sbBpId.append(BHelp.QuoteSingle((String)bpid));
                    first = false;
                    continue;
                }
                sbBpId.append(",").append(BHelp.QuoteSingle((String)bpid));
            }
            BP bp = (BP)BTableProvider.createTable(BP.class);
            bp.setBypass(true);
            bp.Load("bpid IN (" + sbBpId.toString() + ")");
            DataRow lookupRow = new DataRow((DataSet)this.dsv, "bpid");
            for (int i = 0; i < bp.getRowCount(); ++i) {
                bp.getDataSet().goToRow(i);
                String bpid = bp.getDataSet().getString("bpid");
                lookupRow.setString("bpid", bpid);
                if (!this.dsv.locate((ReadRow)lookupRow, 32)) continue;
                if (!this.dsv.isNull("taxregno") && this.dsv.getString("taxregno").length() > 0) {
                    bp.getDataSet().setString("taxregno", this.dsv.getString("taxregno"));
                } else {
                    bp.getDataSet().setString("taxregno", null);
                }
                if (!this.isExistNIKOrNPWPBP) continue;
                if (!this.dsv.isNull("taxregname") && this.dsv.getString("taxregname").length() > 0) {
                    bp.getDataSet().setString("taxregname", this.dsv.getString("taxregname"));
                } else {
                    bp.getDataSet().setString("taxregname", null);
                }
                if (!this.dsv.isNull("taxnikno") && this.dsv.getString("taxnikno").length() > 0) {
                    bp.getDataSet().setString("taxnikno", this.dsv.getString("taxnikno"));
                } else {
                    bp.getDataSet().setString("taxnikno", null);
                }
                if (!this.dsv.isNull("taxnikname") && this.dsv.getString("taxnikname").length() > 0) {
                    bp.getDataSet().setString("taxnikname", this.dsv.getString("taxnikname"));
                    continue;
                }
                bp.getDataSet().setString("taxnikname", null);
            }
            bp.saveChanges();
            UIMgr.showMessageDialog((String)String.format("Saved, OK !", new Object[0]), (Component)this);
            this.doLoadData();
            this.state.setState(0);
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Gagal Simpan Data !", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
            this.dsv.goToRow(bookmark);
        }
    }

    public void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setVisible(0);
            this.qds.getColumn(i).setEditable(false);
        }
        Column column = this.qds.getColumn("bpid");
        column.setCaption("Kode");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("bpname");
        column.setCaption("Nama");
        column.setVisible(1);
        column.setWidth(20);
        column = this.qds.getColumn("addr");
        column.setCaption("Alamat");
        column.setVisible(1);
        column.setWidth(20);
        column = this.qds.getColumn("phone");
        column.setCaption("Telepon");
        column.setVisible(1);
        column.setWidth(12);
        column = this.qds.getColumn("taxregno");
        column.setCaption("N.P.W.P");
        column.setVisible(1);
        column.setWidth(14);
        column.setEditable(true);
        if (this.isExistNIKOrNPWPBP) {
            column = this.qds.getColumn("taxregname");
            column.setCaption("Atas Nama N.P.W.P");
            column.setVisible(1);
            column.setWidth(20);
            column.setEditable(true);
            column = this.qds.getColumn("taxnikno");
            column.setCaption("No. NIK");
            column.setVisible(1);
            column.setWidth(14);
            column.setEditable(true);
            column = this.qds.getColumn("taxnikname");
            column.setCaption("Atas Nama NIK");
            column.setVisible(1);
            column.setWidth(20);
            column.setEditable(true);
        }
    }

    public void doLoadData() {
        String kolomNikNpwp = this.isExistNIKOrNPWPBP ? ", taxregname, taxnikno, taxnikname " : ", CAST(NULL AS VARCHAR) AS taxregname, CAST(NULL AS VARCHAR) AS taxnikno, CAST(NULL AS VARCHAR) AS taxnikname ";
        StringBuffer sql = new StringBuffer("SELECT bpid, bpname,  fmainaddr(bpid) AS addr, fmaincontphone(bpid) AS phone, taxregno" + kolomNikNpwp + "FROM bp ");
        StringBuffer filter = new StringBuffer();
        if (this.bpidSumComa != null && this.bpidSumComa.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)("bpid IN (" + this.bpidSumComa + ")"));
        }
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setORDERBY((StringBuffer)sql, (String)"bpname");
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.qds.setRowId("bpid", true);
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(this.getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(this.getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(this.getClass(), key);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jBToolbar1 = new JBToolbar();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Update Mitra Bisnis");
        this.setPreferredSize(new Dimension(875, 380));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("UPDATE MITRA BISNIS");
        this.jPanel1.setBackground(new Color(204, 204, 204));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jBdbTable1.setEnableDeleteAction(false);
        this.jBdbTable1.setEnabledAppendRow(false);
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 817, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 259, Short.MAX_VALUE).addContainerGap()));
        this.jBToolbar1.setEnableDelete(false);
        this.jBToolbar1.setEnableHelp(false);
        this.jBToolbar1.setEnableNew(false);
        this.jBToolbar1.setEnableOpen(false);
        this.jBToolbar1.setEnablePrint(false);
        this.jBToolbar1.setEnableVoid(false);
        this.jBToolbar1.addJBToolbarListener(new JBToolbarListener(){

            public void toolbarNewPerformed(JBToolbarEvent evt) {
            }

            public void toolbarEditPerformed(JBToolbarEvent evt) {
                FrmBulkUpdateNpwpBP.this.jBToolbar1ToolbarEditPerformed(evt);
            }

            public void toolbarVoidPerformed(JBToolbarEvent evt) {
            }

            public void toolbarOpenPerformed(JBToolbarEvent evt) {
            }

            public void toolbarDeletePerformed(JBToolbarEvent evt) {
            }

            public void toolbarRefreshPerformed(JBToolbarEvent evt) {
                FrmBulkUpdateNpwpBP.this.jBToolbar1ToolbarRefreshPerformed(evt);
            }

            public void toolbarSavePerformed(JBToolbarEvent evt) {
                FrmBulkUpdateNpwpBP.this.jBToolbar1ToolbarSavePerformed(evt);
            }

            public void toolbarPrintPerformed(JBToolbarEvent evt) {
            }

            public void toolbarCancelPerformed(JBToolbarEvent evt) {
                FrmBulkUpdateNpwpBP.this.jBToolbar1ToolbarCancelPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBToolbar1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent((Component)this.jBToolbar1, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jBToolbar1ToolbarEditPerformed(JBToolbarEvent evt) {
        this.doEdit();
    }

    private void jBToolbar1ToolbarSavePerformed(JBToolbarEvent evt) {
        this.doSave();
    }

    private void jBToolbar1ToolbarCancelPerformed(JBToolbarEvent evt) {
        this.doCancel();
    }

    private void jBToolbar1ToolbarRefreshPerformed(JBToolbarEvent evt) {
        this.doRefresh();
    }

    class JTableAdapter
    implements PropertyChangeListener {
        JTableAdapter() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("componentPopupMenu".equalsIgnoreCase(propertyName) && FrmBulkUpdateNpwpBP.this.jBdbTable1.getComponentPopupMenu() != null && FrmBulkUpdateNpwpBP.this.jBdbTable1.getComponentPopupMenu().getComponents() != null) {
                for (Component c : FrmBulkUpdateNpwpBP.this.jBdbTable1.getComponentPopupMenu().getComponents()) {
                    if (c instanceof JMenu) {
                        if (((JMenu)c).getText() == null || ((JMenu)c).getText().equals(Res._SortBy)) continue;
                        FrmBulkUpdateNpwpBP.this.jBdbTable1.getComponentPopupMenu().remove(c);
                        continue;
                    }
                    if (c instanceof JMenuItem) {
                        if (((JMenuItem)c).getText() == null || ((JMenuItem)c).getText().equals(Res._SortBy)) continue;
                        FrmBulkUpdateNpwpBP.this.jBdbTable1.getComponentPopupMenu().remove(c);
                        continue;
                    }
                    if (!(c instanceof JPopupMenu.Separator)) continue;
                    FrmBulkUpdateNpwpBP.this.jBdbTable1.getComponentPopupMenu().remove(c);
                }
            }
        }
    }
}

