/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.exportefaktur.bl.TaxStatus;
import com.bits.bee.exportefaktur.ui.DlgDetailPajakKeluaran;
import com.bits.bee.exportefaktur.ui.myswing.JCboAllocatedType;
import com.bits.bee.exportefaktur.ui.myswing.JFolderChooser;
import com.bits.bee.exportefaktur.util.EFakturUtil;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.JBOSPeriode;
import com.bits.bee.ui.myswing.JCboBPGrp;
import com.bits.bee.ui.myswing.JCboBranch;
import com.bits.bee.ui.myswing.JCboCanvas;
import com.bits.bee.ui.myswing.JCboIsDraft;
import com.bits.bee.ui.myswing.JCboLunas;
import com.bits.bee.ui.myswing.JCboPOS;
import com.bits.bee.ui.myswing.JCboTermType;
import com.bits.bee.ui.myswing.PikCust;
import com.bits.bee.ui.myswing.PikSrep;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBComboBox;
import com.bits.lib.dbswing.JBPeriode;
import com.bits.lib.dbswing.JBPicker;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportFakturKeluaran
extends JInternalFrame
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmExportFakturKeluaran.class);
    private final QueryDataSet qds = new QueryDataSet();
    private final DataSetView dsv = new DataSetView();
    private final QueryDataSet qdsMaster = new QueryDataSet();
    private QueryDataSet qdsSub;
    private final TaxStatus taxstatus = new TaxStatus();
    private final KeyStroke key_F1 = KeyStroke.getKeyStroke(112, 0, false);
    private final KeyStroke key_F5 = KeyStroke.getKeyStroke(116, 0, false);
    private int error;
    private int success;
    boolean isPOS = false;
    boolean isYesAll = false;
    private FileWriter writer;
    private String path;
    private String saleno;
    private String tipe;
    private boolean includeLT = false;
    private final String[] buttons = new String[]{"Yes", "Yes to all", "No"};
    private boolean exportToSingleFile = true;
    private boolean addTaxStatus = true;
    private static final String PROHIBITED_CHARS = "[\\\\/:*?\"<>|/]";
    private JButton btnRefreshForm;
    private JCheckBox chkCSV;
    private JCheckBox chkLT;
    private JCheckBox chkSingleFile;
    private JCheckBox chkTaxNo;
    private JCheckBox chkXML;
    private JBOSPeriode jBOSPeriode1;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBdbTable jBdbTable1;
    private JButton jButton1;
    private JButton jButton2;
    private JCboAllocatedType jCboAllocatedType1;
    private JCboBPGrp jCboBPGrp1;
    private JCboBranch jCboBranch1;
    private JCboCanvas jCboCanvas1;
    private JCboIsDraft jCboIsDraft1;
    private JCboLunas jCboLunas1;
    private JCboPOS jCboPOS1;
    private JCboTermType jCboTermType1;
    private JFolderChooser jFolderChooser1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel lblKeterangan;
    private PikCust pikCust1;
    private PikSrep pikSrep1;
    private JTextArea txtLog;

    public FrmExportFakturKeluaran() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.jFolderChooser1.addPropertyChangeListener("fileName", this);
        this.jButton1.setEnabled(false);
        this.btnRefreshForm.setEnabled(false);
        BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)false);
        UIMgr.setPeriode((JBPeriode)this.jBOSPeriode1, (int)0);
        this.chkTaxNo.setSelected(true);
        this.doLoadData();
        this.initOption();
    }

    private void initOption() {
        this.jCboAllocatedType1.setKeyValue("B");
        this.lblKeterangan.setText("<html><p align=justify><font color=blue>Belum Dialokasikan</font> &#8594; Opsi untuk menampilkan data yang belum diexport <br /><font color=red>Sudah Dialokasikan</font> &#8594; Opsi untuk menampilkan data yang sudah diexport <br /></p><hr /><p align=justify>Pilih status <b><font color=red>Sudah Dialokasikan</font></b> lalu klik tombol <b>Proses</b>, maka status data akan berubah kembali menjadi <b><font color=blue>Belum Dialokasikan</font></b> </p></html>");
    }

    private boolean checkNpwp() {
        if (this.chkXML.isSelected()) {
            boolean npwpCmpEmpty = true;
            StringBuilder bpidSumComa_NpwpEmpty = new StringBuilder();
            boolean first = true;
            ArrayList<String> listBpNpwpempty = new ArrayList<String>();
            for (int i = 0; i < this.qdsMaster.getRowCount(); ++i) {
                String bpid;
                this.qdsMaster.goToRow(i);
                String TIN = EFakturUtil.getTIN(this.qdsMaster.getString("cmp_npwp"), false);
                String ltTin = EFakturUtil.getTIN(this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp"), false);
                if (TIN != null && TIN.length() > 0) {
                    npwpCmpEmpty = false;
                }
                if (ltTin != null && ltTin.length() > 0 || listBpNpwpempty.contains(bpid = this.qdsMaster.getString("bpid"))) continue;
                listBpNpwpempty.add(bpid);
                if (first) {
                    bpidSumComa_NpwpEmpty.append(BHelp.QuoteSingle((String)bpid));
                    first = false;
                    continue;
                }
                bpidSumComa_NpwpEmpty.append(",").append(BHelp.QuoteSingle((String)bpid));
            }
            boolean isExport = EFakturUtil.checkEmptyNpwp(npwpCmpEmpty, bpidSumComa_NpwpEmpty.toString());
            if (!isExport) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prosesExport() {
        this.success = 0;
        this.error = 0;
        this.exportToSingleFile = this.chkSingleFile.isSelected();
        int bookmark = this.dsv.getRow();
        try {
            if (!this.validasi() && this.qds.getRowCount() > 0) {
                UIMgr.showErrorDialog((String)"Mohon centang data yang akan di proses !");
                return;
            }
            if (this.qds.getRowCount() <= 0) {
                UIMgr.showErrorDialog((String)"Tidak ada data yang akan di proses !");
                return;
            }
            if ("B".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
                boolean doCreateSingleCsv;
                if (!this.chkCSV.isSelected() && !this.chkXML.isSelected()) {
                    UIMgr.showErrorDialog((String)"Mohon pilih tipe format export !");
                    return;
                }
                boolean first = true;
                StringBuilder trxnoSumComa = new StringBuilder();
                int rowCount = this.dsv.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    this.dsv.goToRow(i);
                    if (!this.dsv.getBoolean("check")) continue;
                    String trxno = this.dsv.getString("referensi");
                    if (first) {
                        trxnoSumComa.append(BHelp.QuoteSingle((String)trxno));
                        first = false;
                        continue;
                    }
                    trxnoSumComa.append(",").append(BHelp.QuoteSingle((String)trxno));
                }
                this.doLoadMaster(trxnoSumComa.toString());
                if (!this.checkNpwp()) {
                    return;
                }
                this.includeLT = this.chkLT.isSelected();
                this.addTaxStatus = true;
                if (this.chkCSV.isSelected() && this.chkXML.isSelected() && this.exportToSingleFile) {
                    this.addTaxStatus = false;
                    doCreateSingleCsv = this.doCreateSingleCsv();
                    if (!doCreateSingleCsv) {
                        return;
                    }
                    this.addTaxStatus = true;
                    boolean doCreateSingleXML = this.doCreateSingleXML();
                    if (!doCreateSingleXML) {
                        return;
                    }
                } else if (this.chkCSV.isSelected() && this.chkXML.isSelected() && !this.exportToSingleFile) {
                    this.addTaxStatus = false;
                    this.doCreateMultiCsv();
                    this.addTaxStatus = true;
                    this.doCreateMultiXML();
                } else if (this.chkCSV.isSelected() && this.exportToSingleFile) {
                    doCreateSingleCsv = this.doCreateSingleCsv();
                    if (!doCreateSingleCsv) {
                        return;
                    }
                } else if (this.chkXML.isSelected() && this.exportToSingleFile) {
                    boolean doCreateSingleXML = this.doCreateSingleXML();
                    if (!doCreateSingleXML) {
                        return;
                    }
                } else if (this.chkCSV.isSelected() && !this.exportToSingleFile) {
                    this.doCreateMultiCsv();
                } else if (this.chkXML.isSelected() && !this.exportToSingleFile) {
                    this.doCreateMultiXML();
                } else {
                    this.addTaxStatus = false;
                    doCreateSingleCsv = this.doCreateSingleCsv();
                    if (!doCreateSingleCsv) {
                        return;
                    }
                    this.addTaxStatus = true;
                    boolean doCreateSingleXML = this.doCreateSingleXML();
                    if (!doCreateSingleXML) {
                        return;
                    }
                }
                this.jTabbedPane1.setSelectedIndex(1);
            } else if ("S".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
                int rowCount = this.dsv.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    this.dsv.goToRow(i);
                    if (!this.dsv.getBoolean("check")) continue;
                    this.taxstatus.LoadID(this.dsv.getString("referensi"));
                    this.taxstatus.addNewRow(this.dsv.getString("referensi"), "B");
                    this.taxstatus.saveChanges();
                }
            } else {
                UIMgr.showErrorDialog((String)"Option status harus dipilih !");
            }
            this.jButton1.setEnabled(false);
            this.doLoadData();
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
            this.dsv.goToRow(bookmark);
        }
    }

    private void showMessageProsesExport(String type) {
        this.txtLog.append(String.format("\n\nExport " + type + "\nJumlah :\nBerhasil : %d baris, Gagal : %d baris\n\n", this.success, this.error));
        UIMgr.showMessageDialog((String)String.format("Exported " + type + ", OK ! \nBerhasil : %d baris, Gagal : %d baris\n", this.success, this.error), (Component)this);
    }

    private void initKeyStroke() {
        AbstractAction actF1 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportFakturKeluaran.this.f1Action();
            }
        };
        AbstractAction actF5 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportFakturKeluaran.this.f5Action();
            }
        };
        this.getRootPane().getInputMap(2).put(this.key_F1, "f1");
        this.getRootPane().getActionMap().put("f1", actF1);
        this.getRootPane().getInputMap(2).put(this.key_F5, "f5");
        this.getRootPane().getActionMap().put("f5", actF5);
    }

    private void f1Action() {
        this.saleno = JOptionPane.showInputDialog(this, (Object)"Masukkan nomor penjualan: ");
        if (this.saleno != null) {
            this.doRefresh();
        }
        this.saleno = null;
    }

    private void f5Action() {
        this.doRefresh();
    }

    public void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setVisible(0);
            this.qds.getColumn(i).setEditable(false);
        }
        Column column = this.qds.getColumn("check");
        column.setCaption("#");
        column.setVisible(1);
        column.setEditable(true);
        column.setWidth(3);
        column = this.qds.getColumn("referensi");
        column.setCaption("No. Penjualan");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("nomor_faktur");
        column.setCaption("No. Faktur Pajak");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("bpname");
        column.setCaption("Customer");
        column.setVisible(1);
        column.setWidth(20);
        column = this.qds.getColumn("tanggal_faktur");
        column.setCaption("Tanggal");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("jumlah_dpp");
        column.setCaption("Nilai DPP");
        column.setVisible(1);
        column = this.qds.getColumn("jumlah_ppn");
        column.setCaption("Nilai PPn");
        column.setVisible(1);
        column = this.qds.getColumn("totaldiscount");
        column.setCaption("Diskon");
        column.setVisible(1);
    }

    public void doLoadData() {
        String kolomTanggal = "(CASE WHEN s.taxsaledate IS NULL THEN s.saledate ELSE s.taxsaledate END)";
        StringBuffer sql = new StringBuffer("SELECT false AS check, s.saleno AS referensi, to_char(" + kolomTanggal + ", 'dd/MM/yyyy') AS tanggal_faktur, " + "bpname, s.taxsaleno AS nomor_faktur, " + "CAST(SUM(CAST((COALESCE(sd.taxableamt, 0)*COALESCE(s.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS jumlah_dpp, " + "CAST(SUM(COALESCE(sd.basftotaltaxamt, 0)) AS NUMERIC(19,4)) AS jumlah_ppn, " + "CAST(SUM(CAST(((COALESCE(sd.totaldiscamt, 0) + COALESCE(sd.totaldisc2amt, 0))*COALESCE(s.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS totaldiscount " + "FROM sale s " + "JOIN saled sd ON s.saleno=sd.saleno " + "JOIN bp ON s.custid=bp.bpid " + "JOIN crc c ON s.crcid=c.crcid " + "LEFT JOIN branch br ON s.branchid=br.branchid " + "LEFT JOIN taxstatus ts ON ts.refno = s.saleno ");
        StringBuffer filter = new StringBuffer();
        if (this.saleno != null && this.saleno.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"s.saleno", (String)this.saleno));
        }
        JBSQL.ANDFilterPeriode((StringBuffer)filter, (String)"s.saledate", (JBPeriode)this.jBOSPeriode1);
        if (this.jCboIsDraft1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.isdraft", (JBComboBox)this.jCboIsDraft1);
        }
        if (this.jCboPOS1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.posid", (JBComboBox)this.jCboPOS1);
        }
        if (this.jCboTermType1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.termtype", (JBComboBox)this.jCboTermType1);
        }
        if (this.pikSrep1.getKeyValue() != null) {
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"s.srepid", (JBPicker)this.pikSrep1);
        }
        if (this.jCboBranch1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.branchid", (JBComboBox)this.jCboBranch1);
        }
        if (this.jCboCanvas1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.canvasid", (JBComboBox)this.jCboCanvas1);
        }
        JBSQL.ANDFilter((StringBuffer)filter, (String)"s.istaxed=true");
        JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"s.custid", (JBPicker)this.pikCust1);
        JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"bp.bpgrpid", (JBComboBox)this.jCboBPGrp1);
        if (this.jCboLunas1.getKeyValue() != null && this.jCboLunas1.getSelectedIndex() != -1) {
            if (this.jCboLunas1.getKeyValue().equalsIgnoreCase("F")) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)"s.paystatus='F'");
            } else {
                JBSQL.ANDFilter((StringBuffer)filter, (String)"s.paystatus<>'F'");
            }
        }
        if (this.isPOS) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"s.posid IS NOT NULL");
        } else if (this.tipe != null && this.tipe.equals("K")) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"s.canvasid is null AND fsaleusecons(s.saleno)=TRUE");
        } else if (this.tipe != null && this.tipe.equals("C")) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"s.canvasid is not null AND fsaleusecons(s.saleno)=FALSE");
        } else if (this.tipe != null && this.tipe.equals("S")) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"s.canvasid is null AND fsaleusecons(s.saleno)=FALSE");
        } else if (this.tipe != null && this.tipe.equals("CK")) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"s.canvasid is not null AND fsaleusecons(s.saleno)=TRUE");
        }
        JBSQL.ANDFilter((StringBuffer)filter, (String)"s.saletype='S'");
        if ("B".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"(is_allocated IS NULL OR is_allocated = 'B')");
        } else if ("S".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"(is_allocated = 'S')");
        }
        if (this.chkTaxNo.isSelected()) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"COALESCE(s.taxsaleno,'') <> ''");
        } else {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"COALESCE(s.taxsaleno,'') = ''");
        }
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setGROUPBY((StringBuffer)sql, (String)"s.saleno, s.saledate, s.taxsaleno, s.taxsaledate, s.excrate, bp.bpname");
        JBSQL.setORDERBY((StringBuffer)sql, (String)"s.saledate desc, s.saleno desc");
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        System.out.println(sql.toString());
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setAllRowIds(true);
        this.qds.setMetaDataUpdate(0);
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    private String getZipCode(String addrno) {
        if (addrno != null) {
            QueryDataSet qdsZipCode = new QueryDataSet();
            String sql = "SELECT zipcode FROM addr WHERE addrno = " + BHelp.QuoteSingle((String)addrno);
            if (qdsZipCode.isOpen()) {
                qdsZipCode.close();
            }
            qdsZipCode.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql));
            qdsZipCode.open();
            return qdsZipCode.getString("zipcode");
        }
        return "";
    }

    private void doLoadMaster(String salenoSumComa) {
        String kolomNikNpwpGroupBy;
        String kolomNikNpwp;
        boolean isExistNIKOrNPWPBP = EFakturUtil.isExistNIKOrNPWPBP();
        if (isExistNIKOrNPWPBP) {
            kolomNikNpwp = ", bp.taxnikno, bp.taxnikname, bp.taxregname ";
            kolomNikNpwpGroupBy = ", bp.taxnikno, bp.taxnikname, bp.taxregname ";
        } else {
            kolomNikNpwp = ", CAST(NULL AS VARCHAR) AS taxnikno, CAST(NULL AS VARCHAR) AS taxnikname, CAST(NULL AS VARCHAR) AS taxregname ";
            kolomNikNpwpGroupBy = "";
        }
        String kolomTanggal = "(CASE WHEN s.taxsaledate IS NULL THEN s.saledate ELSE s.taxsaledate END)";
        StringBuffer sql = new StringBuffer("SELECT s.saleno AS referensi, to_char(" + kolomTanggal + ", 'dd/MM/yyyy') AS tanggal_faktur, " + "CAST('FK' AS VARCHAR(2)) AS fk, " + "CAST('01' AS VARCHAR(2)) AS kd_jenis_transaksi, " + "CAST(0 AS int) AS fg_pengganti, " + "bpname, " + "s.taxsaleno AS nomor_faktur, " + "CAST(date_part('month', " + kolomTanggal + ") AS INT) AS masa_pajak, " + "CAST(date_part('year', " + kolomTanggal + ") AS INT) AS tahun_pajak, " + "bp.taxregno AS npwp,  " + "bp.bpname AS nama, " + "fMainAddr(s.custid) AS alamat, " + "CAST(SUM(CAST((COALESCE(sd.taxableamt, 0)*COALESCE(s.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS jumlah_dpp, " + "CAST(SUM(COALESCE(sd.basftotaltaxamt, 0)) AS NUMERIC(19,4)) AS jumlah_ppn, " + "CAST(0 AS NUMERIC(19, 4)) AS jumlah_ppnbm, " + "CAST(0 AS int) AS id_keterangan_tambahan, " + "CAST(0 AS int) AS fg_uang_muka, " + "CAST(0 AS int) AS uang_muka_dpp, " + "CAST(0 AS int) AS uang_muka_ppn, " + "CAST(0 AS int) AS uang_muka_ppnbm, " + "CAST(SUM(CAST(((COALESCE(sd.totaldiscamt, 0) + COALESCE(sd.totaldisc2amt, 0))*COALESCE(s.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS totaldiscount" + kolomNikNpwp + ", (SELECT taxregno FROM cmp LIMIT 1) AS cmp_npwp, s.custid AS bpid " + "FROM sale s " + "JOIN saled sd ON s.saleno=sd.saleno " + "JOIN bp ON s.custid=bp.bpid ");
        StringBuffer filter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)filter, (String)("s.saleno IN (" + salenoSumComa + ")"));
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setGROUPBY((StringBuffer)sql, (String)("s.saleno, s.saledate, s.custid, s.taxsaleno, s.taxsaledate, s.excrate, bp.bpname, bp.taxregno" + kolomNikNpwpGroupBy));
        JBSQL.setORDERBY((StringBuffer)sql, (String)"s.saledate desc, s.saleno desc");
        if (this.qdsMaster.isOpen()) {
            this.qdsMaster.close();
        }
        this.qdsMaster.setMetaDataUpdate(0);
        this.qdsMaster.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qdsMaster.open();
        this.qdsMaster.setAllRowIds(true);
    }

    private void doLoadLT(String saleno) {
        boolean isExistNIKOrNPWPBP = EFakturUtil.isExistNIKOrNPWPBP();
        String kolomNikNpwp = isExistNIKOrNPWPBP ? ", bp.taxnikno, bp.taxnikname, bp.taxregname " : ", CAST(NULL AS VARCHAR) AS taxnikno, CAST(NULL AS VARCHAR) AS taxnikname, CAST(NULL AS VARCHAR) AS taxregname ";
        this.qdsSub = new QueryDataSet();
        String sqlLT = "SELECT CAST('LT' AS VARCHAR(2)) AS lt, bpname, fmainaddr(bp.bpid) AS addr, blok, nomor, rt, rw, kecamatan, kelurahan, fmainaddrcity(bp.bpid) AS kabupaten, statename AS propinsi, fmaincontphone(bp.bpid) AS nomor_telepon, a.addrno, bp.taxregno AS npwp" + kolomNikNpwp + ", c.email " + "FROM bp " + "JOIN sale s ON s.custid=bp.bpid " + "LEFT JOIN addr a ON a.bpid=bp.bpid AND a.isbillto=TRUE " + "LEFT JOIN bpefaktur bpe ON bpe.bpid=bp.bpid " + "LEFT JOIN state st ON st.stateid=bpe.propinsi " + "LEFT JOIN (SELECT DISTINCT ON (bpid) bpid, email FROM cont ORDER BY bpid, contid) c ON c.bpid=bp.bpid " + "WHERE saleno=" + BHelp.QuoteSingle((String)saleno);
        if (this.qdsSub.isOpen()) {
            this.qdsSub.close();
        }
        this.qdsSub.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sqlLT));
        this.qdsSub.open();
    }

    private void doLoadOF(String saleno) {
        this.qdsSub = new QueryDataSet();
        String sqlOF = "SELECT CAST('OF' AS VARCHAR(2)) AS of, saled.itemid, saled.itemdesc, CAST((baseprice*excrate) AS NUMERIC(19,4)) AS baseprice, qty, CAST((CAST((baseprice*excrate) AS NUMERIC(19,4))*qty) AS NUMERIC(19, 4)) AS cost_total, CAST(((saled.totaldiscamt + saled.totaldisc2amt)*excrate) AS NUMERIC(19,4)) AS totaldiscamt, CAST(0 AS NUMERIC(19, 4)) AS tarif_ppnbm, CAST(0 AS NUMERIC(19, 4)) AS ppnbm, i.itemtype, CAST((saled.taxableamt*excrate) AS NUMERIC(19,4)) AS taxableamt, saled.basftotaltaxamt AS totaltaxamt, CAST(REPLACE(COALESCE(tx.taxexp, '0'), '%', '') AS NUMERIC) AS taxexp FROM saled JOIN sale s ON s.saleno=saled.saleno LEFT JOIN item i ON i.itemid=saled.itemid LEFT JOIN tax tx ON saled.taxid=tx.taxid WHERE COALESCE(saled.taxid,'')<>'' AND saled.saleno = " + BHelp.QuoteSingle((String)saleno) + " " + "ORDER BY saledno ASC";
        if (this.qdsSub.isOpen()) {
            this.qdsSub.close();
        }
        this.qdsSub.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sqlOF));
        this.qdsSub.open();
    }

    private void setFKHeader() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)"FK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KD_JENIS_TRANSAKSI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"FG_PENGGANTI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR_FAKTUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"MASA_PAJAK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"TAHUN_PAJAK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"TANGGAL_FAKTUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NPWP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NAMA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"ALAMAT_LENGKAP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"JUMLAH_DPP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"JUMLAH_PPN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"JUMLAH_PPNBM"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"ID_KETERANGAN_TAMBAHAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"FG_UANG_MUKA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"UANG_MUKA_DPP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"UANG_MUKA_PPN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"UANG_MUKA_PPNBM"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"REFERENSI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KODE_DOKUMEN_PENDUKUNG"));
        this.writer.append('\n');
    }

    private void setLTHeader() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)"LT"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NPWP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NAMA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"JALAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"BLOK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"RT"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"RW"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KECAMATAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KELURAHAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KABUPATEN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"PROPINSI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KODE_POS"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR_TELEPON"));
        this.writer.append('\n');
    }

    private void setOFHeader() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)"OF"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KODE_OBJEK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NAMA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"HARGA_SATUAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"JUMLAH_BARANG"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"HARGA_TOTAL"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"DISKON"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"DPP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"PPN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"TARIF_PPNBM"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"PPNBM"));
        this.writer.append('\n');
    }

    private void setFK(int i) throws IOException {
        this.qdsMaster.goToRow(i);
        try {
            if (this.addTaxStatus) {
                this.taxstatus.LoadID(this.qdsMaster.getString("referensi"));
                this.taxstatus.addNewRow(this.qdsMaster.getString("referensi"), "S");
            }
            this.writer.append(BHelp.QuoteDouble((String)this.qdsMaster.getString("fk")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNumericValue(this.qdsMaster.getString("kd_jenis_transaksi")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNumericValue("" + this.qdsMaster.getInt("fg_pengganti")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNPWPOrFP(this.qdsMaster.getString("nomor_faktur")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("masa_pajak"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("tahun_pajak"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)this.qdsMaster.getString("tanggal_faktur")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNPWP(this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.formatName(this.qdsMaster.getString("nama"), this.qdsMaster.getString("taxnikname"), this.qdsMaster.getString("taxregname"), this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)this.qdsMaster.getString("alamat")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.roundDownBigDecimalValue(this.qdsMaster.getBigDecimal("jumlah_dpp")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.roundDownBigDecimalValue(this.qdsMaster.getBigDecimal("jumlah_ppn")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.roundDownBigDecimalValue(this.qdsMaster.getBigDecimal("jumlah_ppnbm")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("id_keterangan_tambahan"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("fg_uang_muka"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("uang_muka_dpp"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("uang_muka_ppn"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("uang_muka_ppnbm"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)("No. Invoice " + this.qdsMaster.getString("referensi"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)"0"));
            this.writer.append('\n');
            this.setLTandOF(this.qdsMaster.getString("referensi"));
            this.txtLog.append(String.format("Export CSV baris ke-%s, %s ... BERHASIL\n", i + 1, this.qdsMaster.getString("referensi")));
            ++this.success;
            if (this.addTaxStatus) {
                this.taxstatus.saveChanges();
            }
        }
        catch (Exception ex) {
            this.txtLog.append(String.format("Export CSV baris ke-%s, %s ... GAGAL\n", i, BHelp.getExceptionDetail((Exception)ex)));
            logger.error(String.format("Baris %d, ERROR: %s\n", i, BHelp.getExceptionDetail((Exception)ex)));
            ++this.error;
        }
    }

    private boolean validasi() {
        boolean retval = false;
        int rowCount = this.dsv.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("check")) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private void setLTandOF(String saleno) throws IOException {
        if (this.includeLT) {
            this.setLT(saleno);
        }
        this.setOF(saleno);
    }

    private void setLT(String saleno) throws IOException {
        this.doLoadLT(saleno);
        if ("LT".equalsIgnoreCase(this.qdsSub.getString("lt"))) {
            this.writer.append(BHelp.QuoteDouble((String)this.qdsSub.getString("lt")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNPWP(this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.formatName(this.qdsSub.getString("bpname"), this.qdsSub.getString("taxnikname"), this.qdsSub.getString("taxregname"), this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("addr")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("blok")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("nomor")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithZero(this.qdsSub.getString("rt")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithZero(this.qdsSub.getString("rw")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("kecamatan")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("kelurahan")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("kabupaten")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("propinsi")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeZipCode(this.getZipCode(this.qdsSub.getString("addrno"))));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.qdsSub.getString("nomor_telepon")));
            this.writer.append('\n');
        }
    }

    private void setOF(String saleno) throws IOException {
        this.doLoadOF(saleno);
        for (int row = 0; row < this.qdsSub.getRowCount(); ++row) {
            this.qdsSub.goToRow(row);
            this.writer.append(BHelp.QuoteDouble((String)this.qdsSub.getString("of")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeCode(this.qdsSub.getString("itemid")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)this.qdsSub.getString("itemdesc")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("baseprice"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("qty"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("cost_total"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("totaldiscamt"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("taxableamt"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("totaltaxamt"))));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("tarif_ppnbm").intValue())));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsSub.getBigDecimal("ppnbm"))));
            this.writer.append('\n');
        }
    }

    private void doRefresh() {
        this.success = 0;
        this.error = 0;
        if (this.jFolderChooser1.getFilePath() != null) {
            this.jButton1.setEnabled(true);
        } else {
            this.jButton1.setEnabled(false);
        }
        this.doLoadData();
        this.txtLog.setText(null);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckboxDetail(boolean b, DataSetView ds) {
        int bookmark = ds.getRow();
        try {
            int rowCount = ds.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ds.goToRow(i);
                ds.setBoolean("check", b);
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
    }

    private void setDlg(DlgDetailPajakKeluaran dlg) {
        dlg.setSaleNo(this.dsv.getString("referensi"));
        dlg.Load();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jButton2 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel2 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jCboIsDraft1 = new JCboIsDraft();
        this.jLabel6 = new JLabel();
        this.jCboCanvas1 = new JCboCanvas();
        this.jLabel19 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jCboBranch1 = new JCboBranch();
        this.jPanel13 = new JPanel();
        this.jBOSPeriode1 = new JBOSPeriode();
        this.jLabel9 = new JLabel();
        this.jLabel3 = new JLabel();
        this.pikCust1 = new PikCust();
        this.pikSrep1 = new PikSrep();
        this.jLabel10 = new JLabel();
        this.jPanel12 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jCboPOS1 = new JCboPOS();
        this.jLabel8 = new JLabel();
        this.jCboTermType1 = new JCboTermType();
        this.jLabel2 = new JLabel();
        this.jCboLunas1 = new JCboLunas();
        this.jPanel8 = new JPanel();
        this.jLabel20 = new JLabel();
        this.jCboBPGrp1 = new JCboBPGrp();
        this.chkTaxNo = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jCboAllocatedType1 = new JCboAllocatedType();
        this.jLabel11 = new JLabel();
        this.lblKeterangan = new JLabel();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.jButton1 = new JButton();
        this.btnRefreshForm = new JButton();
        this.jFolderChooser1 = new JFolderChooser();
        this.chkLT = new JCheckBox();
        this.chkSingleFile = new JCheckBox();
        this.chkCSV = new JCheckBox();
        this.chkXML = new JCheckBox();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Export Faktur Pajak Keluaran");
        this.setPreferredSize(new Dimension(1209, 565));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("EXPORT FAKTUR PAJAK KELUARAN");
        this.jPanel4.setBackground(new Color(204, 204, 204));
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel1.setOpaque(false);
        this.jLabel22.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel22.setText("<html><u>Jangan Centang Semua</u></html>");
        this.jLabel22.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportFakturKeluaran.this.jLabel22MouseClicked(evt);
            }
        });
        this.jLabel21.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel21.setText("<html><u>Centang Semua</u></html>");
        this.jLabel21.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportFakturKeluaran.this.jLabel21MouseClicked(evt);
            }
        });
        this.jButton2.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton2.setText("Lihat Detail");
        this.jButton2.setPreferredSize(new Dimension(141, 26));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2, -2, 146, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21, -2, -1, -2).addComponent(this.jLabel22, -2, -1, -2).addComponent(this.jButton2, -2, 26, -2)).addContainerGap()));
        this.jBdbTable1.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[0]));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        this.jBdbTable1.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Filter", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel2.setOpaque(false);
        this.jPanel7.setOpaque(false);
        this.jLabel6.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel6.setText("Draft:");
        this.jLabel19.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel19.setText("Kanvas:");
        this.jLabel5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setText("Cabang:");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.jLabel6)).addComponent(this.jLabel5)).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.jCboCanvas1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCboBranch1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCboIsDraft1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel19).addComponent((Component)this.jCboCanvas1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent((Component)this.jCboIsDraft1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboBranch1, -2, -1, -2).addComponent(this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel13.setOpaque(false);
        this.jBOSPeriode1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel9.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Periode:");
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("Customer:");
        this.pikCust1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikCust1.setOpaque(false);
        this.pikSrep1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikSrep1.setOpaque(false);
        this.jLabel10.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel10.setText("Sales:");
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel10, GroupLayout.Alignment.TRAILING)).addGap(12, 12, 12).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikCust1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.pikSrep1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jBOSPeriode1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBOSPeriode1, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.pikCust1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent((Component)this.pikSrep1, -2, -1, -2)).addContainerGap(33, Short.MAX_VALUE)));
        this.jPanel12.setOpaque(false);
        this.jLabel7.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel7.setText("Kasir:");
        this.jLabel8.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel8.setText("Termin:");
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setText("Lunas:");
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel7)).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel8))).addGap(12, 12, 12).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboTermType1, -1, 150, Short.MAX_VALUE).addComponent((Component)this.jCboPOS1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCboLunas1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent((Component)this.jCboPOS1, -2, -1, -2)).addGap(8, 8, 8).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent((Component)this.jCboTermType1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent((Component)this.jCboLunas1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel8.setOpaque(false);
        this.jLabel20.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel20.setText("Grup Customer:");
        this.chkTaxNo.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.chkTaxNo.setText("Hanya punya No. Faktur Pajak");
        this.chkTaxNo.setOpaque(false);
        this.chkTaxNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.chkTaxNoActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkTaxNo).addComponent((Component)this.jCboBPGrp1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent((Component)this.jCboBPGrp1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkTaxNo).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel13, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel12, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, 263, -2).addContainerGap(57, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel12, -2, 84, -2).addComponent(this.jPanel13, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Option", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel6.setOpaque(false);
        this.jCboAllocatedType1.setEnableRightClickEvent(false);
        this.jCboAllocatedType1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FrmExportFakturKeluaran.this.jCboAllocatedType1ItemStateChanged(evt);
            }
        });
        this.jCboAllocatedType1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.jCboAllocatedType1ActionPerformed(evt);
            }
        });
        this.jLabel11.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel11.setText("Status: ");
        this.lblKeterangan.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.lblKeterangan.setHorizontalAlignment(4);
        this.lblKeterangan.setText("Keterangan");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblKeterangan, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)((Object)this.jCboAllocatedType1), -2, 161, -2))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.jCboAllocatedType1), -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblKeterangan, -1, 142, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(6, 6, 6)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 855, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 26, -2).addContainerGap()));
        this.jTabbedPane1.addTab("Data", this.jPanel3);
        this.jPanel5.setBackground(new Color(204, 204, 204));
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.jScrollPane2.setViewportView(this.txtLog);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 1114, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 353, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Log", this.jPanel5);
        this.jButton1.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/export.png")));
        this.jButton1.setText("Proses");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.jButton1ActionPerformed(evt);
            }
        });
        this.btnRefreshForm.setFont(new Font("Dialog", 1, 11));
        this.btnRefreshForm.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/refresh.png")));
        this.btnRefreshForm.setText("Refresh");
        this.btnRefreshForm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.btnRefreshFormActionPerformed(evt);
            }
        });
        this.jFolderChooser1.setFont(new Font("Dialog", 1, 12));
        this.jFolderChooser1.setOpaque(false);
        this.chkLT.setText("Export Lawan Transaksi");
        this.chkLT.setOpaque(false);
        this.chkSingleFile.setText("Export 1 File");
        this.chkSingleFile.setOpaque(false);
        this.chkCSV.setText("Format CSV");
        this.chkCSV.setOpaque(false);
        this.chkCSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.chkCSVActionPerformed(evt);
            }
        });
        this.chkXML.setText("Format XML");
        this.chkXML.setOpaque(false);
        this.chkXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturKeluaran.this.chkXMLActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTabbedPane1).addGap(8, 8, 8)).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jFolderChooser1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkLT).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSingleFile).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkXML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCSV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 112, -2))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btnRefreshForm, -2, 26, -2).addComponent(this.jButton1, -2, 26, -2).addComponent(this.jFolderChooser1, -2, -1, -2).addComponent(this.chkLT).addComponent(this.chkSingleFile).addComponent(this.chkXML).addComponent(this.chkCSV)).addGap(14, 14, 14).addComponent(this.jTabbedPane1).addContainerGap()));
        this.jBStatusbarDialog1.setShowF2(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBStatusbarDialog1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.prosesExport();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        DlgDetailPajakKeluaran dlg = DlgDetailPajakKeluaran.getInstance();
        this.setDlg(dlg);
        dlg.setVisible(true);
    }

    private void jLabel22MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(false, this.dsv);
    }

    private void jLabel21MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(true, this.dsv);
    }

    private void btnRefreshFormActionPerformed(ActionEvent evt) {
        this.doRefresh();
    }

    private void jCboAllocatedType1ItemStateChanged(ItemEvent evt) {
        this.doLoadData();
    }

    private void jCboAllocatedType1ActionPerformed(ActionEvent evt) {
    }

    private void chkCSVActionPerformed(ActionEvent evt) {
    }

    private void chkXMLActionPerformed(ActionEvent evt) {
    }

    private void chkTaxNoActionPerformed(ActionEvent evt) {
    }

    private String filterFileName(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be Null!");
        }
        return filename.replaceAll(PROHIBITED_CHARS, "-").trim();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("filename")) {
            this.jButton1.setEnabled(true);
            this.btnRefreshForm.setEnabled(true);
            BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)true);
            this.path = this.jFolderChooser1.getFilePath();
            this.initKeyStroke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCreateSingleCsv() throws IOException {
        int answer;
        this.success = 0;
        this.error = 0;
        String namaFile = UIMgr.showInputDialog(null, (Object)"Masukkan nama file export CSV (tanpa .csv)");
        if (namaFile != null && namaFile.matches(".*[\\\\/:*?\"<>|/].*")) {
            throw new IllegalArgumentException("Nama file tidak boleh mengandung karakter '/', '\\', ':', '*', '?', '\"', '<', '>', atau '|'");
        }
        if (namaFile != null && "".equals(namaFile)) {
            throw new IllegalArgumentException("Nama file tidak boleh kosong !");
        }
        if (namaFile == null) {
            return false;
        }
        File fileName = new File(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + namaFile + ".csv");
        if (fileName.exists() && (answer = UIMgr.YesNo((String)"Konfirmasi Replace File", (String)"Replace file yang sudah ada?")) == 1) {
            return false;
        }
        try {
            this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + namaFile + ".csv");
            this.setFKHeader();
            this.setLTHeader();
            this.setOFHeader();
            int rowCount = this.qdsMaster.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.qdsMaster.goToRow(i);
                this.setFK(i);
            }
        }
        finally {
            this.writer.flush();
            this.writer.close();
        }
        this.showMessageProsesExport("CSV");
        return true;
    }

    private void doCreateMultiCsv() throws IOException {
        this.success = 0;
        this.error = 0;
        int rowCount = this.qdsMaster.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.qdsMaster.goToRow(i);
            File fileName = new File(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".csv");
            if (fileName.exists()) {
                if (!this.isYesAll) {
                    int option = JOptionPane.showOptionDialog(null, "Export Format CSV, Replace file yang sudah ada?", "Konfirmasi Replace File", -1, 3, null, this.buttons, this.buttons[0]);
                    if (option == 0) {
                        this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".csv");
                        this.setFKHeader();
                        this.setLTHeader();
                        this.setOFHeader();
                        this.setFK(i);
                        this.writer.flush();
                        this.writer.close();
                        continue;
                    }
                    if (option != 1) continue;
                    this.isYesAll = true;
                    this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".csv");
                    this.setFKHeader();
                    this.setLTHeader();
                    this.setOFHeader();
                    this.setFK(i);
                    this.writer.flush();
                    this.writer.close();
                    continue;
                }
                this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".csv");
                this.setFKHeader();
                this.setLTHeader();
                this.setOFHeader();
                this.setFK(i);
                this.writer.flush();
                this.writer.close();
                continue;
            }
            this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".csv");
            this.setFKHeader();
            this.setLTHeader();
            this.setOFHeader();
            this.setFK(i);
            this.writer.flush();
            this.writer.close();
        }
        this.isYesAll = false;
        this.showMessageProsesExport("CSV");
    }

    public String convertDate(String inputDate) throws Exception {
        SimpleDateFormat inputFormat = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = inputFormat.parse(inputDate);
        return outputFormat.format(date);
    }

    private void writeTagXML(FileWriter writer, String tag, String value) throws IOException {
        this.writeTagXML(writer, tag, value, true);
    }

    private void writeTagXML(FileWriter writer, String tag, String value, boolean endWithEnter) throws IOException {
        if (value != null && value.length() > 0) {
            writer.append("<" + tag + ">");
            writer.append(EFakturUtil.formatXML(value));
            writer.append("</" + tag + ">");
        } else {
            writer.append("<" + tag + "/>");
        }
        if (endWithEnter) {
            writer.append('\n');
        }
    }

    private void setLTandOFXML(String saleno) throws IOException {
        this.setLTXML(saleno);
        this.setOFXML(saleno);
    }

    private void setLTXML(String saleno) throws IOException {
        this.doLoadLT(saleno);
        String ltTin = this.getBuyerTin(this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp"));
        this.writeTagXML(this.writer, "BuyerTin", ltTin);
        this.writeTagXML(this.writer, "BuyerDocument", this.getBuyerDocument(this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp")));
        this.writeTagXML(this.writer, "BuyerCountry", "IDN");
        this.writeTagXML(this.writer, "BuyerDocumentNumber", this.getBuyerDocumentNumber(this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp")));
        this.writeTagXML(this.writer, "BuyerName", this.getBuyerName(this.qdsSub.getString("bpname"), this.qdsSub.getString("taxnikname"), this.qdsSub.getString("taxregname"), this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp")));
        this.writeTagXML(this.writer, "BuyerAdress", this.qdsSub.getString("addr"));
        this.writeTagXML(this.writer, "BuyerEmail", this.qdsSub.getString("email"));
        this.writeTagXML(this.writer, "BuyerIDTKU", this.getBuyerIDTKU(this.qdsSub.getString("taxnikno"), this.qdsSub.getString("npwp")));
    }

    private String getBuyerTin(String nik, String npwp) {
        if (null != npwp && npwp.trim().length() > 0) {
            return EFakturUtil.getTIN(npwp, false);
        }
        if (null != nik && nik.trim().length() > 0) {
            return "0000000000000000";
        }
        return "0000000000000000";
    }

    private String getBuyerDocument(String nik, String npwp) {
        if (null != npwp && npwp.trim().length() > 0) {
            return "TIN";
        }
        if (null != nik && nik.trim().length() > 0) {
            return "National ID";
        }
        return "National ID";
    }

    private String getBuyerDocumentNumber(String nik, String npwp) {
        if (null != npwp && npwp.trim().length() > 0) {
            return null;
        }
        if (null != nik && nik.trim().length() > 0) {
            return nik;
        }
        return null;
    }

    private String getBuyerName(String bpname, String taxnikname, String taxregname, String nik, String npwp) {
        String type = "BP";
        if (npwp != null && npwp.trim().length() > 0) {
            if (null != taxregname && taxregname.trim().length() > 0) {
                type = "NPWP";
            } else if (null != taxnikname && taxnikname.trim().length() > 0) {
                type = "NIK";
            }
        } else if (nik != null && nik.trim().length() > 0) {
            if (null != taxnikname && taxnikname.trim().length() > 0) {
                type = "NIK";
            } else if (null != taxregname && taxregname.trim().length() > 0) {
                type = "NPWP";
            }
        } else if (null != taxregname && taxregname.trim().length() > 0) {
            type = "NPWP";
        } else if (null != taxnikname && taxnikname.trim().length() > 0) {
            type = "NIK";
        }
        if (type.equals("NPWP") && null != taxregname && taxregname.trim().length() > 0) {
            return taxregname;
        }
        if (type.equals("NIK") && null != taxnikname && taxnikname.trim().length() > 0) {
            return taxnikname;
        }
        return bpname;
    }

    private String getBuyerIDTKU(String nik, String npwp) {
        if (null != npwp && npwp.trim().length() > 0) {
            return EFakturUtil.getNITKU(npwp, true);
        }
        if (null != nik && nik.trim().length() > 0) {
            return "000000";
        }
        return "000000";
    }

    private void setOFXML(String saleno) throws IOException {
        this.doLoadOF(saleno);
        if (this.qdsSub.getRowCount() > 0) {
            this.writer.append("<ListOfGoodService>");
            this.writer.append('\n');
        } else {
            this.writeTagXML(this.writer, "ListOfGoodService", null);
        }
        for (int row = 0; row < this.qdsSub.getRowCount(); ++row) {
            this.qdsSub.goToRow(row);
            this.writer.append("<GoodService>");
            this.writer.append('\n');
            this.writeTagXML(this.writer, "Opt", EFakturUtil.getOptGoodService(this.qdsSub.getString("itemtype")));
            this.writeTagXML(this.writer, "Code", "000000");
            this.writeTagXML(this.writer, "Name", this.qdsSub.getString("itemdesc"));
            this.writeTagXML(this.writer, "Unit", EFakturUtil.getUnitGoodService(this.qdsSub.getString("itemtype")));
            this.writeTagXML(this.writer, "Price", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("baseprice")));
            this.writeTagXML(this.writer, "Qty", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("qty")));
            this.writeTagXML(this.writer, "TotalDiscount", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("totaldiscamt")));
            this.writeTagXML(this.writer, "TaxBase", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("taxableamt")));
            this.writeTagXML(this.writer, "OtherTaxBase", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("taxableamt")));
            this.writeTagXML(this.writer, "VATRate", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("taxexp")));
            this.writeTagXML(this.writer, "VAT", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("totaltaxamt")));
            this.writeTagXML(this.writer, "STLGRate", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("tarif_ppnbm")));
            this.writeTagXML(this.writer, "STLG", EFakturUtil.formatNumericXML(this.qdsSub.getBigDecimal("ppnbm")));
            this.writer.append("</GoodService>");
            this.writer.append('\n');
        }
        if (this.qdsSub.getRowCount() > 0) {
            this.writer.append("</ListOfGoodService>");
            this.writer.append('\n');
        }
    }

    private void setFKXML(int i) throws IOException {
        this.qdsMaster.goToRow(i);
        try {
            if (this.addTaxStatus) {
                this.taxstatus.LoadID(this.qdsMaster.getString("referensi"));
                this.taxstatus.addNewRow(this.qdsMaster.getString("referensi"), "S");
            }
            String trxCode = "04";
            String addInfo = null;
            String CustomDoc = null;
            String CustomDocMonthYear = null;
            String facilityStamp = null;
            String selleridtku = EFakturUtil.getNITKU(null, this.qdsMaster.getString("cmp_npwp"), false);
            this.writer.append("<TaxInvoice>");
            this.writer.append('\n');
            this.writeTagXML(this.writer, "TaxInvoiceDate", this.convertDate(this.qdsMaster.getString("tanggal_faktur")));
            this.writeTagXML(this.writer, "TaxInvoiceOpt", "Normal");
            this.writeTagXML(this.writer, "TrxCode", trxCode);
            this.writeTagXML(this.writer, "AddInfo", addInfo);
            this.writeTagXML(this.writer, "CustomDoc", CustomDoc);
            this.writeTagXML(this.writer, "CustomDocMonthYear", CustomDocMonthYear);
            this.writeTagXML(this.writer, "RefDesc", this.qdsMaster.getString("referensi"));
            this.writeTagXML(this.writer, "FacilityStamp", facilityStamp);
            this.writeTagXML(this.writer, "SellerIDTKU", selleridtku);
            this.setLTandOFXML(this.qdsMaster.getString("referensi"));
            this.writer.append("</TaxInvoice>");
            this.writer.append('\n');
            this.txtLog.append(String.format("Export XML baris ke-%s, %s ... BERHASIL\n", i + 1, this.qdsMaster.getString("referensi")));
            ++this.success;
            if (this.addTaxStatus) {
                this.taxstatus.saveChanges();
            }
        }
        catch (Exception ex) {
            this.txtLog.append(String.format("Export XML baris ke-%s, %s ... GAGAL\n", i, BHelp.getExceptionDetail((Exception)ex)));
            logger.error(String.format("Baris %d, ERROR: %s\n", i, BHelp.getExceptionDetail((Exception)ex)));
            ++this.error;
        }
    }

    private void writeXML(int row) throws IOException {
        this.initWriteXML();
        this.setFKXML(row);
        this.endWriteXML();
    }

    private void initWriteXML() throws IOException {
        this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.append('\n');
        this.writer.append("<TaxInvoiceBulk xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"TaxInvoice.xsd\">");
        this.writer.append('\n');
        String TIN = EFakturUtil.getTIN(this.qdsMaster.getString("cmp_npwp"), false);
        this.writeTagXML(this.writer, "TIN", TIN);
        this.writer.append("<ListOfTaxInvoice>");
        this.writer.append('\n');
    }

    private void endWriteXML() throws IOException {
        this.writer.append("</ListOfTaxInvoice>");
        this.writer.append('\n');
        this.writer.append("</TaxInvoiceBulk>");
        this.writer.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCreateSingleXML() throws IOException {
        int answer;
        this.success = 0;
        this.error = 0;
        String namaFile = UIMgr.showInputDialog(null, (Object)"Masukkan nama file export XML (tanpa .xml)");
        if (namaFile != null && namaFile.matches(".*[\\\\/:*?\"<>|/].*")) {
            throw new IllegalArgumentException("Nama file tidak boleh mengandung karakter '/', '\\', ':', '*', '?', '\"', '<', '>', atau '|'");
        }
        if (namaFile != null && "".equals(namaFile)) {
            throw new IllegalArgumentException("Nama file tidak boleh kosong !");
        }
        if (namaFile == null) {
            return false;
        }
        File fileName = new File(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + namaFile + ".xml");
        if (fileName.exists() && (answer = UIMgr.YesNo((String)"Konfirmasi Replace File", (String)"Replace file yang sudah ada?")) == 1) {
            return false;
        }
        try {
            this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(namaFile) + ".xml");
            int rowCount = this.qdsMaster.getRowCount();
            this.initWriteXML();
            for (int i = 0; i < rowCount; ++i) {
                this.qdsMaster.goToRow(i);
                this.setFKXML(i);
            }
            this.endWriteXML();
        }
        finally {
            this.writer.flush();
            this.writer.close();
        }
        this.showMessageProsesExport("XML");
        return true;
    }

    private void doCreateMultiXML() throws IOException {
        this.success = 0;
        this.error = 0;
        int rowCount = this.qdsMaster.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.qdsMaster.goToRow(i);
            File fileName = new File(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".xml");
            if (fileName.exists()) {
                if (!this.isYesAll) {
                    int option = JOptionPane.showOptionDialog(null, "Export Format XML, Replace file yang sudah ada?", "Konfirmasi Replace File", -1, 3, null, this.buttons, this.buttons[0]);
                    if (option == 0) {
                        this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".xml");
                        this.writeXML(i);
                        this.writer.flush();
                        this.writer.close();
                        continue;
                    }
                    if (option != 1) continue;
                    this.isYesAll = true;
                    this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".xml");
                    this.writeXML(i);
                    this.writer.flush();
                    this.writer.close();
                    continue;
                }
                this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".xml");
                this.writeXML(i);
                this.writer.flush();
                this.writer.close();
                continue;
            }
            this.writer = new FileWriter(this.path + (SystemUtils.IS_OS_LINUX ? "/" : "\\") + this.filterFileName(this.qdsMaster.getString("referensi")) + ".xml");
            this.writeXML(i);
            this.writer.flush();
            this.writer.close();
        }
        this.isYesAll = false;
        this.showMessageProsesExport("XML");
    }
}

