/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.confui.FileInfo;
import com.bits.bee.exportefaktur.bl.TaxStatus;
import com.bits.bee.exportefaktur.ui.DlgDetailPajakReturMasukan;
import com.bits.bee.exportefaktur.ui.myswing.JCboAllocatedType;
import com.bits.bee.exportefaktur.util.EFakturUtil;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.JBOSPeriode;
import com.bits.bee.ui.myswing.JCboBranch;
import com.bits.bee.ui.myswing.JCboContraStatus;
import com.bits.bee.ui.myswing.JCboIsDraft;
import com.bits.bee.ui.myswing.JCboTermType;
import com.bits.bee.ui.myswing.JPanelChooser;
import com.bits.bee.ui.myswing.PikVendor;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBComboBox;
import com.bits.lib.dbswing.JBPeriode;
import com.bits.lib.dbswing.JBPicker;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportFakturReturMasukan
extends JInternalFrame
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmExportFakturReturMasukan.class);
    private final DataSetView dsv = new DataSetView();
    private final QueryDataSet qds = new QueryDataSet();
    private final QueryDataSet qdsMaster = new QueryDataSet();
    private final QueryDataSet qdsDetail = new QueryDataSet();
    private FileWriter writer;
    private int success = 0;
    private int error = 0;
    private String path;
    private final KeyStroke key_F1 = KeyStroke.getKeyStroke(112, 0, false);
    private final KeyStroke key_F5 = KeyStroke.getKeyStroke(116, 0, false);
    private String pretno;
    private final TaxStatus taxstatus = new TaxStatus();
    private static final String PROHIBITED_CHARS = "[\\\\/:*?\"<>|/]";
    private BigDecimal totalTaxableamt;
    private BigDecimal totalTotalTaxamt;
    private BigDecimal totalPPnBM;
    private JLabel LblKeterangan;
    private JButton btnRefreshForm;
    private JCheckBox chkCSV;
    private JCheckBox chkXML;
    private JBOSPeriode jBOSPeriode1;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBdbTable jBdbTable1;
    private JButton jButton3;
    private JButton jButton5;
    private JCboAllocatedType jCboAllocatedType1;
    private JCboBranch jCboBranch1;
    private JCboContraStatus jCboContraStatus1;
    private JCboIsDraft jCboIsDraft1;
    private JCboTermType jCboTermType1;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanelChooser jPanelChooser1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private PikVendor pikVendor1;
    private JTextArea txtLog;

    public FrmExportFakturReturMasukan() {
        this.initComponents();
        this.jCboAllocatedType1.setKeyValue("B");
        this.initChooser();
        this.chkXML.setSelected(true);
        this.jButton3.setEnabled(false);
        this.btnRefreshForm.setEnabled(false);
        BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)false);
        UIMgr.setPeriode((JBPeriode)this.jBOSPeriode1, (int)0);
        this.LoadData();
        this.LblKeterangan.setText("<html><p align=justify><<font color=blue>Belum Dialokasikan</font> &#8594; Opsi untuk menampilkan data yang belum diexport <br /><font color=red>Sudah Dialokasikan</font> &#8594; Opsi untuk menampilkan data yang sudah diexport <br /></p><hr /><p align=justify>Pilih status <b><font color=red>Sudah Dialokasikan</font></b> lalu klik tombol <b>Proses</b>, maka status data akan berubah kembali menjadi <b><font color=blue>Belum Dialokasikan</font></b> </p></html>");
    }

    private void initChooser() {
        this.jPanelChooser1.setFileFilter("XML", "xml", true);
        this.jPanelChooser1.getBtnBrowse().setText("Pilih File");
        this.jPanelChooser1.getFileChooser().setApproveButtonText("Save");
        this.jPanelChooser1.addPropertyChangeListener("fileName", (PropertyChangeListener)this);
    }

    public void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setVisible(0);
            this.qds.getColumn(i).setEditable(false);
        }
        Column column = this.qds.getColumn("pilih");
        column.setCaption("#");
        column.setVisible(1);
        column.setWidth(3);
        column.setEditable(true);
        column = this.qds.getColumn("nama");
        column.setCaption("Nama Vendor");
        column.setVisible(1);
        column.setWidth(20);
        column = this.qds.getColumn("tanggal_retur");
        column.setCaption("Tanggal Retur");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("nomor_dokumen_retur");
        column.setCaption("No. Retur");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("nilai_retur_dpp");
        column.setCaption("Nilai Retur DPP");
        column.setVisible(1);
        column = this.qds.getColumn("nilai_retur_ppn");
        column.setCaption("Nilai Retur PPn");
        column.setVisible(1);
    }

    private void LoadData() {
        StringBuffer sql = new StringBuffer("SELECT FALSE AS pilih, p.pretno AS nomor_dokumen_retur, to_char(pretdate, 'dd/MM/yyyy') AS tanggal_retur,  b.bpname AS nama, CAST(SUM(CAST((COALESCE(d.taxableamt, 0)*COALESCE(p.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS nilai_retur_dpp, CAST(SUM(COALESCE(d.basftotaltaxamt, 0)) AS NUMERIC(19,4)) AS nilai_retur_ppn FROM pret p JOIN pretd d ON (p.pretno = d.pretno) JOIN bp b ON (p.vendorid = b.bpid) LEFT JOIN taxstatus ts ON (p.pretno = ts.refno) ");
        StringBuffer filter = new StringBuffer();
        if (this.pretno != null && this.pretno.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"p.pretno", (String)this.pretno));
        }
        JBSQL.ANDFilterPeriode((StringBuffer)filter, (String)"p.pretdate", (JBPeriode)this.jBOSPeriode1);
        if (this.pikVendor1.getKeyValue() != null) {
            JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"p.vendorid", (JBPicker)this.pikVendor1);
        }
        if (this.jCboIsDraft1.getKeyValue() != null) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)("p.isdraft=" + this.jCboIsDraft1.getKeyValue()));
        }
        if (this.jCboContraStatus1.getKeyValue() != null) {
            if (this.jCboContraStatus1.getKeyValue().equalsIgnoreCase("Y")) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)"iscontra=true");
            } else {
                JBSQL.ANDFilter((StringBuffer)filter, (String)"iscontra=false");
            }
        }
        if (this.jCboTermType1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"p.termtype", (JBComboBox)this.jCboTermType1);
        }
        if (this.jCboBranch1.getKeyValue() != null) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"p.branchid", (JBComboBox)this.jCboBranch1);
        }
        if ("B".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"(is_allocated IS NULL OR is_allocated = 'B')");
        } else if ("S".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"is_allocated = 'S'");
        }
        JBSQL.ANDFilter((StringBuffer)filter, (String)"p.istaxed=true");
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setGROUPBY((StringBuffer)sql, (String)"b.bpname, p.pretno, p.pretdate, p.excrate");
        JBSQL.setORDERBY((StringBuffer)sql, (String)"p.pretdate desc, p.pretno desc");
        System.out.println(sql.toString());
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.qds.setRowId("NOMOR_DOKUMEN_RETUR", true);
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    private void LoadMaster(String pretnoSumComa) {
        String kolomNikNpwpGroupBy;
        String kolomNikNpwp;
        boolean isExistNIKOrNPWPBP = EFakturUtil.isExistNIKOrNPWPBP();
        if (isExistNIKOrNPWPBP) {
            kolomNikNpwp = ", b.taxnikno, b.taxnikname, b.taxregname ";
            kolomNikNpwpGroupBy = ", b.taxnikno, b.taxnikname, b.taxregname ";
        } else {
            kolomNikNpwp = ", CAST(NULL AS VARCHAR) AS taxnikno, CAST(NULL AS VARCHAR) AS taxnikname, CAST(NULL AS VARCHAR) AS taxregname ";
            kolomNikNpwpGroupBy = "";
        }
        String kolomTanggal = "(CASE WHEN taxpretdate IS NULL THEN pretdate ELSE taxpretdate END)";
        StringBuffer sql = new StringBuffer("SELECT p.pretno AS nomor_dokumen_retur, to_char(pretdate, 'dd/MM/yyyy') AS tanggal_retur, CAST('RM' AS VARCHAR) AS rm, b.bpname AS nama, b.taxregno AS npwp, CAST('01' AS VARCHAR(2)) AS kd_jenis_transaksi, CAST(0 AS INT) AS fg_pengganti, taxpretno AS nomor_faktur, to_char(" + kolomTanggal + ", 'dd/MM/yyyy') AS tanggal_faktur, " + "CAST(date_part('month', " + kolomTanggal + ") AS INT) AS masa_pajak_retur, " + "CAST(date_part('year', " + kolomTanggal + ") AS INT) AS tahun_pajak_retur, " + "CAST(SUM(CAST((COALESCE(d.taxableamt, 0)*COALESCE(p.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS nilai_retur_dpp, " + "CAST(SUM(COALESCE(d.basftotaltaxamt, 0)) AS NUMERIC(19,4)) AS nilai_retur_ppn, " + "CAST(0 AS NUMERIC(19, 4)) AS nilai_retur_ppnbm" + kolomNikNpwp + ", (SELECT taxregno FROM cmp LIMIT 1) AS cmp_npwp, p.vendorid AS bpid " + "FROM pret p " + "JOIN pretd d ON (p.pretno = d.pretno) " + "JOIN bp b ON (p.vendorid = b.bpid) ");
        StringBuffer filter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)filter, (String)("p.pretno IN (" + pretnoSumComa + ")"));
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setGROUPBY((StringBuffer)sql, (String)("b.taxregno, p.vendorid, b.bpname, p.pretno, p.pretdate, p.taxpretno, p.taxpretdate, p.excrate" + kolomNikNpwpGroupBy));
        JBSQL.setORDERBY((StringBuffer)sql, (String)"p.pretdate desc, p.pretno desc");
        System.out.println(sql.toString());
        if (this.qdsMaster.isOpen()) {
            this.qdsMaster.close();
        }
        this.qdsMaster.setMetaDataUpdate(0);
        this.qdsMaster.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qdsMaster.open();
        this.qdsMaster.setRowId("NOMOR_DOKUMEN_RETUR", true);
    }

    private void LoadDetail(String pretno) {
        String sql = "SELECT pd.itemid, CAST(0 AS NUMERIC(19, 4)) AS PPnBM, i.itemtype, pd.itemdesc, (CASE WHEN purcd.qty IS NULL THEN pd.qty ELSE purcd.qty END) as quantity, CAST((pd.baseprice*excrate) AS NUMERIC(19,4)) AS baseprice, pd.qty, CAST(((pd.totaldiscamt + pd.totaldisc2amt)*excrate) AS NUMERIC(19,4)) AS totaldiscamt, CAST((pd.taxableamt*excrate) AS NUMERIC(19,4)) AS taxableamt, CAST(0 AS NUMERIC(19, 4)) AS tarif_ppnbm, pd.basftotaltaxamt AS totaltaxamt FROM pretd pd JOIN pret p ON p.pretno=pd.pretno LEFT JOIN purcd ON purcd.purcno=pd.purcno and purcd.purcdno=pd.purcdno LEFT JOIN item i ON i.itemid=pd.itemid WHERE pd.pretno = " + BHelp.QuoteSingle((String)pretno) + " " + "AND COALESCE(pd.taxid,'')<>'' " + "ORDER BY pd.pretdno ASC";
        if (this.qdsDetail.isOpen()) {
            this.qdsDetail.close();
        }
        System.out.println(sql);
        this.qdsDetail.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql));
        this.qdsDetail.open();
        this.totalTaxableamt = BigDecimal.ZERO;
        this.totalTotalTaxamt = BigDecimal.ZERO;
        this.totalPPnBM = BigDecimal.ZERO;
        for (int index = 0; index < this.qdsDetail.getRowCount(); ++index) {
            this.qdsDetail.goToRow(index);
            BigDecimal taxableamt = EFakturUtil.setScalingXML(this.qdsDetail.getBigDecimal("taxableamt"));
            this.totalTaxableamt = this.totalTaxableamt.add(taxableamt);
            BigDecimal totaltaxamt = EFakturUtil.setScalingXML(this.qdsDetail.getBigDecimal("totaltaxamt"));
            this.totalTotalTaxamt = this.totalTotalTaxamt.add(totaltaxamt);
            BigDecimal ppnbm = EFakturUtil.setScalingXML(this.qdsDetail.getBigDecimal("ppnbm"));
            this.totalPPnBM = this.totalPPnBM.add(ppnbm);
        }
    }

    private void initKeyStroke() {
        AbstractAction actF1 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportFakturReturMasukan.this.f1Action();
            }
        };
        AbstractAction actF5 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportFakturReturMasukan.this.f5Action();
            }
        };
        this.getRootPane().getInputMap(2).put(this.key_F1, "f1");
        this.getRootPane().getActionMap().put("f1", actF1);
        this.getRootPane().getInputMap(2).put(this.key_F5, "f5");
        this.getRootPane().getActionMap().put("f5", actF5);
    }

    private void f1Action() {
        this.pretno = JOptionPane.showInputDialog(this, (Object)"Masukkan nomor retur pembelian: ");
        if (this.pretno != null) {
            this.refresh();
        }
        this.pretno = null;
    }

    private void f5Action() {
        this.refresh();
    }

    private void getRMHeader() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)"RM"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NPWP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NAMA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KD_JENIS_TRANSAKSI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"FG_PENGGANTI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR_FAKTUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"TANGGAL_FAKTUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"IS_CREDITABLE"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR_DOKUMEN_RETUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"TANGGAL_RETUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"MASA_PAJAK_RETUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"TAHUN_PAJAK_RETUR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NILAI_RETUR_DPP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NILAI_RETUR_PPN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NILAI_RETUR_PPNBM"));
        this.writer.append('\n');
    }

    private void getRM() throws IOException {
        int baris = 0;
        int rowCount = this.qdsMaster.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.qdsMaster.goToRow(i);
            try {
                this.taxstatus.LoadID(this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR"));
                this.taxstatus.addNewRow(this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR"), "S");
                this.generateDetailRetur();
                this.txtLog.append(String.format("Export baris ke-%s, %s ... BERHASIL\n", ++baris, this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR")));
                ++this.success;
                this.taxstatus.saveChanges();
                continue;
            }
            catch (Exception ex) {
                this.txtLog.append(String.format("Export baris ke-%s, %s ... GAGAL\n", i, BHelp.getExceptionDetail((Exception)ex)));
                logger.error(String.format("Baris %d, ERROR: %s\n", i, BHelp.getExceptionDetail((Exception)ex)));
                ++this.error;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void generateDetailRetur() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)this.qdsMaster.getString("rm")));
        this.writer.append(',');
        this.writer.append(EFakturUtil.normalizeNPWP(this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp")));
        this.writer.append(',');
        this.writer.append(EFakturUtil.formatName(this.qdsMaster.getString("nama"), this.qdsMaster.getString("taxnikname"), this.qdsMaster.getString("taxregname"), this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp")));
        this.writer.append(',');
        this.writer.append(EFakturUtil.normalizeNumericValue(this.qdsMaster.getString("kd_jenis_transaksi")));
        this.writer.append(',');
        this.writer.append(EFakturUtil.normalizeNumericValue(String.valueOf(this.qdsMaster.getInt("fg_pengganti"))));
        this.writer.append(',');
        this.writer.append(EFakturUtil.normalizeNPWPOrFP(this.qdsMaster.getString("nomor_faktur")));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)this.qdsMaster.getString("tanggal_faktur")));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"1"));
        this.writer.append(',');
        this.writer.append(EFakturUtil.normalizeCode(this.qdsMaster.getString("nomor_dokumen_retur")));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)this.qdsMaster.getString("tanggal_retur")));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("masa_pajak_retur"))));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.qdsMaster.getInt("tahun_pajak_retur"))));
        this.writer.append(',');
        this.writer.append(EFakturUtil.roundDownBigDecimalValue(this.qdsMaster.getBigDecimal("nilai_retur_dpp")));
        this.writer.append(',');
        this.writer.append(EFakturUtil.roundDownBigDecimalValue(this.qdsMaster.getBigDecimal("nilai_retur_ppn")));
        this.writer.append(',');
        this.writer.append(EFakturUtil.roundDownBigDecimalValue(this.qdsMaster.getBigDecimal("nilai_retur_ppnbm")));
        this.writer.append('\n');
    }

    private void refresh() {
        this.success = 0;
        this.error = 0;
        if (this.jPanelChooser1 != null) {
            this.jButton3.setEnabled(true);
        } else {
            this.jButton3.setEnabled(false);
        }
        this.LoadData();
        this.txtLog.setText(null);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private boolean validasi() {
        boolean retval = false;
        int rowCount = this.dsv.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("pilih")) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private boolean checkNpwp() {
        if (this.chkXML.isSelected()) {
            boolean npwpCmpEmpty = true;
            StringBuilder bpidSumComa_NpwpEmpty = new StringBuilder();
            boolean first = true;
            ArrayList<String> listBpNpwpempty = new ArrayList<String>();
            for (int i = 0; i < this.qdsMaster.getRowCount(); ++i) {
                String bpid;
                this.qdsMaster.goToRow(i);
                String TIN = EFakturUtil.getTIN(this.qdsMaster.getString("cmp_npwp"), false);
                String ltTin = EFakturUtil.getTIN(this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp"), false);
                if (TIN != null && TIN.length() > 0) {
                    npwpCmpEmpty = false;
                }
                if (ltTin != null && ltTin.length() > 0 || listBpNpwpempty.contains(bpid = this.qdsMaster.getString("bpid"))) continue;
                listBpNpwpempty.add(bpid);
                if (first) {
                    bpidSumComa_NpwpEmpty.append(BHelp.QuoteSingle((String)bpid));
                    first = false;
                    continue;
                }
                bpidSumComa_NpwpEmpty.append(",").append(BHelp.QuoteSingle((String)bpid));
            }
            boolean isExport = EFakturUtil.checkEmptyNpwp(npwpCmpEmpty, bpidSumComa_NpwpEmpty.toString());
            if (!isExport) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prosesExport() {
        this.success = 0;
        this.error = 0;
        int bookmark = this.dsv.getRow();
        try {
            if (!this.validasi() && this.qds.getRowCount() > 0) {
                UIMgr.showErrorDialog((String)"Mohon centang data yang akan di proses !");
                return;
            }
            if (this.qds.getRowCount() <= 0) {
                UIMgr.showErrorDialog((String)"Tidak ada data yang akan di proses !");
                return;
            }
            File fileName = new File(this.path);
            if ("B".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
                if (!this.chkCSV.isSelected() && !this.chkXML.isSelected()) {
                    UIMgr.showErrorDialog((String)"Mohon pilih tipe format export !");
                    return;
                }
                if (this.chkCSV.isSelected() && this.path.endsWith(".xml")) {
                    UIMgr.showErrorDialog((String)"Kesalahan format file !", (Exception)new Exception("Silahkan pilih file dengan format csv"), (Component)this, (Logger)logger);
                    return;
                }
                if (this.chkXML.isSelected() && this.path.endsWith(".csv")) {
                    UIMgr.showErrorDialog((String)"Kesalahan format file !", (Exception)new Exception("Silahkan pilih file dengan format xml"), (Component)this, (Logger)logger);
                    return;
                }
                boolean first = true;
                StringBuilder trxnoSumComa = new StringBuilder();
                int rowCount = this.dsv.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    this.dsv.goToRow(i);
                    if (!this.dsv.getBoolean("pilih")) continue;
                    String trxno = this.dsv.getString("NOMOR_DOKUMEN_RETUR");
                    if (first) {
                        trxnoSumComa.append(BHelp.QuoteSingle((String)trxno));
                        first = false;
                        continue;
                    }
                    trxnoSumComa.append(",").append(BHelp.QuoteSingle((String)trxno));
                }
                this.LoadMaster(trxnoSumComa.toString());
                if (!this.checkNpwp()) {
                    return;
                }
                if (fileName.exists()) {
                    if (UIMgr.YesNo((String)"Replace file yang sudah ada?") != 0) return;
                    if (this.chkXML.isSelected()) {
                        this.generateXML();
                    } else {
                        this.generateCSV();
                    }
                } else if (this.chkXML.isSelected()) {
                    this.generateXML();
                } else {
                    this.generateCSV();
                }
                this.txtLog.append(String.format("\n\nJumlah :\nBerhasil : %d baris, Gagal : %d baris\n\n", this.success, this.error));
                UIMgr.showMessageDialog((String)String.format("Exported, OK ! \nBerhasil : %d baris, Gagal : %d baris\n", this.success, this.error), (Component)this);
                this.jTabbedPane1.setSelectedIndex(1);
            } else if ("S".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
                int rowCount = this.dsv.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    this.dsv.goToRow(i);
                    if (!this.dsv.getBoolean("pilih")) continue;
                    this.taxstatus.LoadID(this.dsv.getString("NOMOR_DOKUMEN_RETUR"));
                    this.taxstatus.addNewRow(this.dsv.getString("NOMOR_DOKUMEN_RETUR"), "B");
                    this.taxstatus.saveChanges();
                }
            }
            this.jButton3.setEnabled(false);
            this.LoadData();
            return;
        }
        catch (Exception ex) {
            String filename;
            try {
                JFileChooser fileChooser = this.jPanelChooser1.getFileChooser();
                String parentDir = fileChooser.getCurrentDirectory().getPath() + FileInfo.getInstance().getFileSeparator();
                String path = fileChooser.getSelectedFile().getPath();
                filename = path.substring(parentDir.length());
            }
            catch (Exception e) {
                filename = this.jPanelChooser1.getFileName();
            }
            if (filename.matches(".*[\\\\/:*?\"<>|/].*")) {
                UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)new Exception("Nama file tidak boleh mengandung karakter '/', '\\', ':', '*', '?', '\"', '<', '>', atau '|'", ex), (Component)this, (Logger)logger);
                return;
            } else {
                UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)ex, (Component)this, (Logger)logger);
            }
            return;
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
            this.dsv.goToRow(bookmark);
        }
    }

    private void generateCSV() throws IOException {
        this.writer = new FileWriter(this.path);
        this.getRMHeader();
        this.getRM();
        this.writer.flush();
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckboxDetail(boolean b, DataSetView ds) {
        int bookmark = ds.getRow();
        try {
            int rowCount = ds.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ds.goToRow(i);
                ds.setBoolean("pilih", b);
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("filename")) {
            this.jButton3.setEnabled(true);
            this.btnRefreshForm.setEnabled(true);
            BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)true);
            this.path = this.jPanelChooser1.getFilePath();
            this.initKeyStroke();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnRefreshForm = new JButton();
        this.jButton3 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jButton5 = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jBOSPeriode1 = new JBOSPeriode();
        this.jLabel9 = new JLabel();
        this.jLabel3 = new JLabel();
        this.pikVendor1 = new PikVendor();
        this.jCboContraStatus1 = new JCboContraStatus();
        this.jLabel7 = new JLabel();
        this.jPanel12 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jCboIsDraft1 = new JCboIsDraft();
        this.jLabel5 = new JLabel();
        this.jCboBranch1 = new JCboBranch();
        this.jLabel8 = new JLabel();
        this.jCboTermType1 = new JCboTermType();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel7 = new JPanel();
        this.jCboAllocatedType1 = new JCboAllocatedType();
        this.jLabel11 = new JLabel();
        this.LblKeterangan = new JLabel();
        this.jPanel6 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.jPanelChooser1 = new JPanelChooser();
        this.chkCSV = new JCheckBox();
        this.chkXML = new JCheckBox();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Export Retur Faktur Pajak Masukan");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("EXPORT FAKTUR RETUR PAJAK MASUKAN");
        this.jPanel2.setBackground(new Color(204, 204, 204));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.btnRefreshForm.setFont(new Font("Dialog", 1, 11));
        this.btnRefreshForm.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/refresh.png")));
        this.btnRefreshForm.setText("Refresh");
        this.btnRefreshForm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturReturMasukan.this.btnRefreshFormActionPerformed(evt);
            }
        });
        this.jButton3.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/export.png")));
        this.jButton3.setText("Proses");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturReturMasukan.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel4.setOpaque(false);
        this.jLabel22.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel22.setText("<html><u>Jangan Centang Semua</u></html>");
        this.jLabel22.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportFakturReturMasukan.this.jLabel22MouseClicked(evt);
            }
        });
        this.jLabel21.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel21.setText("<html><u>Centang Semua</u></html>");
        this.jLabel21.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportFakturReturMasukan.this.jLabel21MouseClicked(evt);
            }
        });
        this.jButton5.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton5.setText("Lihat Detail");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturReturMasukan.this.jButton5ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 571, Short.MAX_VALUE).addComponent(this.jButton5, -2, 146, -2).addGap(27, 27, 27)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21, -2, -1, -2).addComponent(this.jLabel22, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton5, -2, 24, -2)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Filter", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel5.setOpaque(false);
        this.jPanel13.setOpaque(false);
        this.jBOSPeriode1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel9.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Periode:");
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("Vendor:");
        this.pikVendor1.setOpaque(false);
        this.jLabel7.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Status:");
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboContraStatus1, -2, -1, -2).addComponent((Component)this.pikVendor1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jBOSPeriode1, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBOSPeriode1, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.pikVendor1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboContraStatus1, -2, -1, -2).addComponent(this.jLabel7)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel12.setOpaque(false);
        this.jLabel6.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel6.setText("Draft:");
        this.jLabel5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setText("Cabang:");
        this.jLabel8.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel8.setText("Termin:");
        this.jCboTermType1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturReturMasukan.this.jCboTermType1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboIsDraft1, -1, 150, Short.MAX_VALUE).addComponent((Component)this.jCboBranch1, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jCboTermType1, -1, -1, Short.MAX_VALUE)).addGap(21, 21, 21)));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)this.jCboTermType1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jCboIsDraft1, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jCboBranch1, -2, -1, -2).addComponent(this.jLabel5)).addGap(0, 12, Short.MAX_VALUE)));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel13, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel12, -2, -1, -2).addContainerGap(307, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel13, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel12, -1, -1, Short.MAX_VALUE));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Option", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel7.setOpaque(false);
        this.jCboAllocatedType1.setEnableRightClickEvent(false);
        this.jCboAllocatedType1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FrmExportFakturReturMasukan.this.jCboAllocatedType1ItemStateChanged(evt);
            }
        });
        this.jLabel11.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel11.setText("Status: ");
        this.LblKeterangan.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.LblKeterangan.setHorizontalAlignment(4);
        this.LblKeterangan.setText("Keterangan");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LblKeterangan, -2, 218, -2).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)((Object)this.jCboAllocatedType1), -2, 161, -2))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.jCboAllocatedType1), -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LblKeterangan, -1, 152, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -2, -1, -2).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -1, -1, -2)).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -2, -1, -2))).addGap(187, 187, 187)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 223, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
        this.jTabbedPane1.addTab("Data", this.jPanel3);
        this.jPanel6.setBackground(new Color(204, 204, 204));
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.jScrollPane3.setViewportView(this.txtLog);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 919, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 367, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Log", this.jPanel6);
        this.jPanelChooser1.setLabelText("File");
        this.jPanelChooser1.setOpaque(false);
        this.chkCSV.setText("Format CSV");
        this.chkCSV.setOpaque(false);
        this.chkCSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturReturMasukan.this.chkCSVActionPerformed(evt);
            }
        });
        this.chkXML.setText("Format XML");
        this.chkXML.setOpaque(false);
        this.chkXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportFakturReturMasukan.this.chkXMLActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent((Component)this.jPanelChooser1, -2, 403, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkXML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCSV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3, -2, 112, -2)).addComponent(this.jTabbedPane1, -2, 948, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btnRefreshForm, -2, 26, -2).addComponent(this.jButton3, -2, 26, -2).addComponent((Component)this.jPanelChooser1, -2, -1, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.chkXML).addComponent(this.chkCSV))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jBStatusbarDialog1.setShowF2(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent((Component)this.jBStatusbarDialog1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void btnRefreshFormActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.prosesExport();
    }

    private void jLabel22MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(false, this.dsv);
    }

    private void jLabel21MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(true, this.dsv);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        DlgDetailPajakReturMasukan dlg = DlgDetailPajakReturMasukan.getInstance();
        dlg.setPretno(this.dsv.getString("NOMOR_DOKUMEN_RETUR"));
        dlg.Load();
        dlg.setVisible(true);
    }

    private void jCboTermType1ActionPerformed(ActionEvent evt) {
    }

    private void jCboAllocatedType1ItemStateChanged(ItemEvent evt) {
        this.LoadData();
    }

    private void chkCSVActionPerformed(ActionEvent evt) {
        if (this.chkCSV.isSelected()) {
            this.chkXML.setSelected(false);
            this.jPanelChooser1.setFileFilter("Comma-separated values", "csv", true);
        } else {
            this.chkXML.setSelected(true);
            this.jPanelChooser1.setFileFilter("XML", "xml", true);
        }
    }

    private void chkXMLActionPerformed(ActionEvent evt) {
        if (this.chkXML.isSelected()) {
            this.chkCSV.setSelected(false);
            this.jPanelChooser1.setFileFilter("XML", "xml", true);
        } else {
            this.chkCSV.setSelected(true);
            this.jPanelChooser1.setFileFilter("Comma-separated values", "csv", true);
        }
    }

    public void doNew() {
    }

    public void doOpen() {
    }

    public void doEdit() {
    }

    public void doEdit(String string) {
    }

    public void doSave() {
    }

    public void doCancel() {
    }

    public void doDelete() {
    }

    public void doVoid() {
    }

    public void doPrint() {
    }

    public void doRefresh() {
    }

    public void setTransState(int i) {
    }

    private void writeTagXML(FileWriter writer, String tag, String value) throws IOException {
        this.writeTagXML(writer, tag, value, true);
    }

    private void writeTagXML(FileWriter writer, String tag, String value, boolean endWithEnter) throws IOException {
        if (value != null && value.length() > 0) {
            writer.append("<" + tag + ">");
            writer.append(EFakturUtil.formatXML(value));
            writer.append("</" + tag + ">");
        } else {
            writer.append("<" + tag + "/>");
        }
        if (endWithEnter) {
            writer.append('\n');
        }
    }

    private void getRMXML() throws IOException {
        int baris = 0;
        int rowCount = this.qdsMaster.getRowCount();
        this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.append('\n');
        this.writer.append("<InputTaxInvoiceReturn>");
        this.writer.append('\n');
        String TIN = EFakturUtil.getTIN(this.qdsMaster.getString("cmp_npwp"), false);
        this.writeTagXML(this.writer, "TIN", TIN);
        this.writer.append("<InputReturnDataList>");
        this.writer.append('\n');
        for (int i = 0; i < rowCount; ++i) {
            this.qdsMaster.goToRow(i);
            try {
                this.taxstatus.LoadID(this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR"));
                this.taxstatus.addNewRow(this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR"), "S");
                this.generateDetailReturXML(this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR"));
                this.txtLog.append(String.format("Export baris ke-%s, %s ... BERHASIL\n", ++baris, this.qdsMaster.getString("NOMOR_DOKUMEN_RETUR")));
                ++this.success;
                this.taxstatus.saveChanges();
                continue;
            }
            catch (Exception ex) {
                this.txtLog.append(String.format("Export baris ke-%s, %s ... GAGAL\n", i, BHelp.getExceptionDetail((Exception)ex)));
                logger.error(String.format("Baris %d, ERROR: %s\n", i, BHelp.getExceptionDetail((Exception)ex)));
                ++this.error;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.writer.append("</InputReturnDataList>");
        this.writer.append('\n');
        this.writer.append("</InputTaxInvoiceReturn>");
        this.writer.append('\n');
    }

    public String convertDate(String inputDate) {
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd-MM-yyyy");
            Date date = inputFormat.parse(inputDate);
            return outputFormat.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    private void generateDetailReturXML(String pretno) throws IOException {
        this.LoadDetail(pretno);
        String sellerTin = EFakturUtil.getTIN(this.qdsMaster.getString("taxnikno"), this.qdsMaster.getString("npwp"), true);
        String ReturnTaxBase = EFakturUtil.formatNumericXML(this.totalTaxableamt);
        String ReturnOtherTaxBase = EFakturUtil.formatNumericXML(this.totalTaxableamt);
        String ReturnVAT = EFakturUtil.formatNumericXML(this.totalTotalTaxamt);
        String ReturnSTLG = EFakturUtil.formatNumericXML(this.totalPPnBM);
        this.writer.append("<InputReturnData>");
        this.writer.append('\n');
        this.writer.append("<TransactionDocumentData>");
        this.writer.append('\n');
        this.writeTagXML(this.writer, "InvoiceNumber", this.qdsMaster.getString("nomor_faktur"));
        this.writeTagXML(this.writer, "SellerTIN", sellerTin);
        this.writeTagXML(this.writer, "ReturnDate", this.convertDate(this.qdsMaster.getString("tanggal_retur")));
        this.writeTagXML(this.writer, "ReturnTaxBase", ReturnTaxBase);
        this.writeTagXML(this.writer, "ReturnOtherTaxBase", ReturnOtherTaxBase);
        this.writeTagXML(this.writer, "ReturnVAT", ReturnVAT);
        this.writeTagXML(this.writer, "ReturnSTLG", ReturnSTLG);
        this.writer.append("</TransactionDocumentData>");
        this.writer.append('\n');
        this.writer.append("<TransactionDetailsData>");
        this.writer.append('\n');
        for (int index = 0; index < this.qdsDetail.getRowCount(); ++index) {
            this.qdsDetail.goToRow(index);
            this.writer.append("<Rows>");
            this.writer.append('\n');
            this.writeTagXML(this.writer, "Type", EFakturUtil.getOptGoodService(this.qdsDetail.getString("itemtype")));
            this.writeTagXML(this.writer, "Name", this.qdsDetail.getString("itemdesc"));
            this.writeTagXML(this.writer, "Code", "000000");
            this.writeTagXML(this.writer, "Quantity", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("quantity")));
            this.writeTagXML(this.writer, "Unit", EFakturUtil.getUnitGoodService(this.qdsDetail.getString("itemtype")));
            this.writeTagXML(this.writer, "UnitPrice", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("baseprice")));
            this.writeTagXML(this.writer, "STLGRate", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("tarif_ppnbm")));
            this.writeTagXML(this.writer, "ReturnQuantity", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("qty")));
            this.writeTagXML(this.writer, "ReturnDiscount", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("totaldiscamt")));
            this.writeTagXML(this.writer, "ReturnTaxBase", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("taxableamt")));
            this.writeTagXML(this.writer, "ReturnOtherTaxBase", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("taxableamt")));
            this.writeTagXML(this.writer, "ReturnOtherTaxBaseCheck", "False");
            this.writeTagXML(this.writer, "ReturnVAT", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("totaltaxamt")));
            this.writeTagXML(this.writer, "ReturnSTLG", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("ppnbm")));
            this.writer.append("</Rows>");
            this.writer.append('\n');
        }
        this.writer.append("<FooterRow>");
        this.writer.append('\n');
        this.writeTagXML(this.writer, "ReturnTaxBaseTotal", ReturnTaxBase);
        this.writeTagXML(this.writer, "ReturnOtherTaxBaseTotal", ReturnOtherTaxBase);
        this.writeTagXML(this.writer, "ReturnVATTotal", ReturnVAT);
        this.writeTagXML(this.writer, "ReturnSTLGTotal", ReturnSTLG);
        this.writer.append("</FooterRow>");
        this.writer.append('\n');
        this.writer.append("</TransactionDetailsData>");
        this.writer.append('\n');
        this.writer.append("</InputReturnData>");
        this.writer.append('\n');
    }

    private void generateXML() throws IOException {
        this.writer = new FileWriter(this.path);
        this.getRMXML();
        this.writer.flush();
        this.writer.close();
    }
}

