/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.bl.Reg;
import com.bits.bee.exportefaktur.util.EFakturUtil;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.InternalFrameTrans;
import com.bits.bee.ui.myswing.JCboBrand;
import com.bits.bee.ui.myswing.JCboItemType;
import com.bits.bee.ui.myswing.JCboModel;
import com.bits.bee.ui.myswing.JPanelChooser;
import com.bits.bee.ui.myswing.PikItGrp;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBComboBox;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportItem
extends InternalFrameTrans
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmExportItem.class);
    private final DataSetView dsv = new DataSetView();
    private final QueryDataSet qds = new QueryDataSet();
    private FileWriter writer;
    private final int bookmarkLimit = 0;
    private int error;
    private int success;
    private String path;
    private String itemid;
    private String itemDesc;
    private final KeyStroke key_F1 = KeyStroke.getKeyStroke(112, 0, false);
    private final KeyStroke key_F2 = KeyStroke.getKeyStroke(113, 0, false);
    private final KeyStroke key_F5 = KeyStroke.getKeyStroke(116, 0, false);
    private final boolean isCached = Reg.getInstance().getValueBooleanDefaultTrue("CACHEDLIST");
    private final boolean showHiddenItem = Reg.getInstance().getValueBooleanDefaultTrue("SHOW_HIDDENITEM");
    private JButton btnRefreshForm;
    private JCboItemType cboItemType;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBdbTable jBdbTable1;
    private JButton jButton2;
    private JButton jButton4;
    private JCboBrand jCboBrand1;
    private JCboModel jCboModel1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JPanel jPanel13;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanelChooser jPanelChooser1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JCheckBox jcbActive;
    private PikItGrp pikItGrp1;
    private JTextArea txtLog;

    public FrmExportItem() {
        this.initComponents();
        this.initChooser();
        this.jButton4.setEnabled(false);
        this.btnRefreshForm.setEnabled(false);
        BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)false);
        this.LoadData();
    }

    private void initChooser() {
        this.jPanelChooser1.setFileFilter("Comma-separated values", "csv", true);
        this.jPanelChooser1.getBtnBrowse().setText("Pilih File");
        this.jPanelChooser1.getFileChooser().setApproveButtonText("Save");
        this.jPanelChooser1.addPropertyChangeListener("fileName", (PropertyChangeListener)this);
    }

    public void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setVisible(0);
            this.qds.getColumn(i).setEditable(false);
        }
        Column column = this.qds.getColumn("pilih");
        column.setCaption("#");
        column.setVisible(1);
        column.setWidth(3);
        column.setEditable(true);
        column = this.qds.getColumn("itemid");
        column.setCaption("Kode Barang");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("itemdesc");
        column.setCaption("Nama Item");
        column.setVisible(1);
        column.setWidth(30);
        column = this.qds.getColumn("unit1");
        column.setCaption("Satuan");
        column.setVisible(1);
        column.setWidth(8);
    }

    private void initKeyStroke() {
        AbstractAction actF1 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportItem.this.f1Action();
            }
        };
        AbstractAction actF2 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportItem.this.F2_Action();
            }
        };
        AbstractAction actF5 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportItem.this.f5Action();
            }
        };
        this.getRootPane().getInputMap(2).put(this.key_F1, "f1");
        this.getRootPane().getActionMap().put("f1", actF1);
        this.getRootPane().getInputMap(2).put(this.key_F2, "f2");
        this.getRootPane().getActionMap().put("f2", actF2);
        this.getRootPane().getInputMap(2).put(this.key_F5, "f5");
        this.getRootPane().getActionMap().put("f5", actF5);
    }

    private void F2_Action() {
        this.itemid = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Masukkan kode barang: ");
        if (this.itemid != null) {
            this.refresh();
        }
        this.itemid = null;
    }

    private void f1Action() {
        this.itemDesc = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Masukkan nama barang: ");
        if (this.itemDesc != null) {
            this.refresh();
        }
        this.itemDesc = null;
    }

    private void f5Action() {
        this.refresh();
    }

    private void refresh() {
        this.success = 0;
        this.error = 0;
        if (this.jPanelChooser1 != null) {
            this.jButton4.setEnabled(true);
        } else {
            this.jButton4.setEnabled(false);
        }
        this.LoadData();
        this.txtLog.setText(null);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void LoadData() {
        StringBuffer sql = new StringBuffer("SELECT FALSE AS pilih, CAST('OB' AS VARCHAR) AS OB, i.itemid, i.itemdesc, p.price1, i.unit1 FROM item i JOIN prc p ON (i.itemid = p.itemid)");
        StringBuffer filter = new StringBuffer();
        int limitrow = -1;
        if (this.itemid != null && this.itemid.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"i.itemid", (String)this.itemid));
        }
        if (this.itemDesc != null && this.itemDesc.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"i.itemdesc", (String)this.itemDesc));
        }
        JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"i.brandid", (JBComboBox)this.jCboBrand1);
        JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"i.itemtype", (JBComboBox)this.cboItemType);
        if (this.pikItGrp1.getKeyValue() != null) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)String.format("fitgrpin(i.itemid, %s)", BHelp.QuoteSingle((String)this.pikItGrp1.getKeyValue())));
        }
        if (this.jCboModel1.getSelectedIndex() != -1) {
            JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"i.modelid", (JBComboBox)this.jCboModel1);
        }
        if (!this.showHiddenItem) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"(i._xt!=true OR (i.itemid<>'0' AND i.itemid<>'-1'))");
        }
        if (!this.isCached && filter.length() <= 0) {
            limitrow = 0;
        }
        if (this.jcbActive.isSelected()) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"i.active='true'");
        } else {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"i.active='false'");
        }
        JBSQL.ANDFilter((StringBuffer)filter, (String)" purctaxid IS NOT NULL AND p.prclvlid = '0'");
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setORDERBY((StringBuffer)sql, (String)"i.itemid ASC");
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.qds.setRowId("itemid", true);
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    private void getOBHeader() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)"OB"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KODE_OBJEK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NAMA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"HARGA_SATUAN"));
        this.writer.append('\n');
    }

    private void getOB() throws IOException {
        int baris = 0;
        int rowCount = this.dsv.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("pilih")) continue;
            this.writer.append(BHelp.QuoteDouble((String)this.dsv.getString("ob")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeCode(this.dsv.getString("itemid")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)this.dsv.getString("itemdesc")));
            this.writer.append(',');
            this.writer.append(BHelp.QuoteDouble((String)String.valueOf(this.dsv.getBigDecimal("price1"))));
            this.writer.append('\n');
            this.txtLog.append(String.format("Export baris ke-%s, %s ... BERHASIL\n", ++baris, this.dsv.getString("itemid")));
            ++this.success;
        }
    }

    private void ExportToCsv(String sFileName) {
        try {
            this.writer = new FileWriter(sFileName);
            this.getOBHeader();
            this.getOB();
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            UIMgr.showErrorDialog((String)"Error", (Exception)e);
        }
    }

    private boolean validasi() {
        boolean retval = false;
        int rowCount = this.dsv.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("pilih")) continue;
            retval = true;
            break;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prosesExport() {
        this.success = 0;
        this.error = 0;
        int bookmark = this.dsv.getRow();
        try {
            if (!this.validasi() && this.qds.getRowCount() > 0) {
                UIMgr.showErrorDialog((String)"Mohon centang data yang akan di proses !");
                return;
            }
            if (this.qds.getRowCount() <= 0) {
                UIMgr.showErrorDialog((String)"Tidak ada data yang akan di proses !");
                return;
            }
            File fileName = new File(this.path);
            if (fileName.exists()) {
                if (UIMgr.YesNo((String)"Replace file yang sudah ada?") != 0) return;
                this.generateCSV();
            } else {
                this.generateCSV();
            }
            this.txtLog.append(String.format("\n\nJumlah :\nBerhasil : %d baris, Gagal : %d baris\n\n", this.success, this.error));
            UIMgr.showMessageDialog((String)String.format("Exported, OK ! \nBerhasil : %d baris, Gagal : %d baris\n", this.success, this.error), (Component)((Object)this));
            this.jButton4.setEnabled(false);
            this.jTabbedPane1.setSelectedIndex(1);
            return;
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)ex, (Component)((Object)this), (Logger)logger);
            return;
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)((Object)this));
            this.dsv.goToRow(bookmark);
        }
    }

    private void generateCSV() throws IOException {
        this.writer = new FileWriter(this.path);
        this.getOBHeader();
        this.getOB();
        this.writer.flush();
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckboxDetail(boolean b, DataSetView ds) {
        int bookmark = ds.getRow();
        try {
            int rowCount = ds.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ds.goToRow(i);
                ds.setBoolean("pilih", b);
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel8 = new JPanel();
        this.btnRefreshForm = new JButton();
        this.jButton4 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cboItemType = new JCboItemType();
        this.jLabel3 = new JLabel();
        this.jCboBrand1 = new JCboBrand();
        this.jLabel8 = new JLabel();
        this.jCboModel1 = new JCboModel();
        this.jcbActive = new JCheckBox();
        this.pikItGrp1 = new PikItGrp();
        this.jPanel7 = new JPanel();
        this.jButton2 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel6 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.jPanelChooser1 = new JPanelChooser();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Export Item");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("EXPORT ITEM");
        this.jPanel8.setBackground(new Color(204, 204, 204));
        this.jPanel8.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.btnRefreshForm.setFont(new Font("Dialog", 1, 11));
        this.btnRefreshForm.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/refresh.png")));
        this.btnRefreshForm.setText("Refresh");
        this.btnRefreshForm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportItem.this.btnRefreshFormActionPerformed(evt);
            }
        });
        this.jButton4.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/export.png")));
        this.jButton4.setText("Proses");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportItem.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel4.setOpaque(false);
        this.jLabel22.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel22.setText("<html><u>Jangan Centang Semua</u></html>");
        this.jLabel22.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportItem.this.jLabel22MouseClicked(evt);
            }
        });
        this.jLabel21.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel21.setText("<html><u>Centang Semua</u></html>");
        this.jLabel21.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportItem.this.jLabel21MouseClicked(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21, -2, -1, -2).addComponent(this.jLabel22, -2, -1, -2));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Filter", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel5.setOpaque(false);
        this.jPanel13.setOpaque(false);
        this.jLabel4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel4.setText("Jenis :");
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setText("[F6] Merk:");
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setText("[F3] Group :");
        this.jLabel8.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel8.setText("[F7] Model:");
        this.jcbActive.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jcbActive.setMnemonic('I');
        this.jcbActive.setSelected(true);
        this.jcbActive.setText("Aktif");
        this.jcbActive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jcbActive.setMargin(new Insets(0, 0, 0, 0));
        this.jcbActive.setOpaque(false);
        this.pikItGrp1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikItGrp1.setOpaque(false);
        this.pikItGrp1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportItem.this.pikItGrp1ActionPerformed(evt);
            }
        });
        this.jPanel7.setOpaque(false);
        this.jButton2.setFont(new Font("Dialog", 1, 11));
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/clean.gif")));
        this.jButton2.setText("Reset Filter");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportItem.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jButton2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikItGrp1, -2, -1, -2).addComponent((Component)this.cboItemType, -2, 157, -2)).addGap(26, 26, 26).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboModel1, -2, -1, -2).addComponent((Component)this.jCboBrand1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -2, -1, -2)).addComponent(this.jcbActive)).addContainerGap()));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent((Component)this.jCboBrand1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboModel1, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jcbActive)).addGroup(jPanel13Layout.createSequentialGroup().addComponent((Component)this.pikItGrp1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cboItemType, -2, -1, -2).addComponent(this.jLabel4))).addComponent(this.jLabel3).addComponent(this.jPanel7, -2, -1, -2)).addContainerGap(16, Short.MAX_VALUE)));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel13, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 204, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -2, -1, -2).addGap(24, 24, 24)));
        this.jTabbedPane1.addTab("Data", this.jPanel3);
        this.jPanel6.setBackground(new Color(204, 204, 204));
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.jScrollPane3.setViewportView(this.txtLog);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 718, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 355, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Log", this.jPanel6);
        this.jPanelChooser1.setLabelText("CSV File");
        this.jPanelChooser1.setOpaque(false);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTabbedPane1, -2, 747, -2).addGroup(jPanel8Layout.createSequentialGroup().addComponent((Component)this.jPanelChooser1, -2, 403, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 112, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jPanelChooser1, -2, -1, -2).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4, -2, 26, -2).addComponent(this.btnRefreshForm, -2, 26, -2))).addGap(12, 12, 12).addComponent(this.jTabbedPane1, -2, 406, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jBStatusbarDialog1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap(14, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGap(0, 14, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addGap(10, 10, 10).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void jLabel22MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(false, this.dsv);
    }

    private void jLabel21MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(true, this.dsv);
    }

    private void btnRefreshFormActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.prosesExport();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.pikItGrp1.setKeyValue(null);
        this.jCboBrand1.setKeyValue(null);
        this.jCboModel1.setKeyValue(null);
        this.cboItemType.setKeyValue(null);
        this.jcbActive.setSelected(true);
    }

    private void pikItGrp1ActionPerformed(ActionEvent evt) {
    }

    public void doNew() {
    }

    public void doOpen() {
    }

    public void doEdit() {
    }

    public void doEdit(String string) {
    }

    public void doSave() {
    }

    public void doCancel() {
    }

    public void doDelete() {
    }

    public void doVoid() {
    }

    public void doPrint() {
    }

    public void doRefresh() {
    }

    public void setTransState(int i) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("filename")) {
            this.jButton4.setEnabled(true);
            this.btnRefreshForm.setEnabled(true);
            BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)true);
            this.path = this.jPanelChooser1.getFilePath();
            this.initKeyStroke();
        }
    }
}

