/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.exportefaktur.util.EFakturUtil;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.BtnPreview;
import com.bits.bee.ui.myswing.InternalFrameTrans;
import com.bits.bee.ui.myswing.JPanelChooser;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportLawanTrans
extends InternalFrameTrans
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmExportLawanTrans.class);
    private final DataSetView dsv = new DataSetView();
    private final QueryDataSet qds = new QueryDataSet();
    private FileWriter writer;
    private final int bookmarkLimit = 0;
    private int error;
    private int success;
    private String path;
    private String bpid;
    private final KeyStroke key_F1 = KeyStroke.getKeyStroke(112, 0, false);
    private final KeyStroke key_F5 = KeyStroke.getKeyStroke(116, 0, false);
    private JButton btnClear;
    private BtnPreview btnPreview1;
    private JButton btnRefreshForm;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBdbTable jBdbTable1;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel13;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanelChooser jPanelChooser1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTextField txtAlamat;
    private JTextField txtCP;
    private JTextField txtKota;
    private JTextArea txtLog;
    private JTextField txtNama;

    public FrmExportLawanTrans() {
        this.initComponents();
        this.initChooser();
        this.jButton4.setEnabled(false);
        this.btnRefreshForm.setEnabled(false);
        BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)false);
        this.LoadData(false);
    }

    private void initChooser() {
        this.jPanelChooser1.setFileFilter("Comma-separated values", "csv", true);
        this.jPanelChooser1.getBtnBrowse().setText("Pilih File");
        this.jPanelChooser1.getFileChooser().setApproveButtonText("Save");
        this.jPanelChooser1.addPropertyChangeListener("fileName", (PropertyChangeListener)this);
    }

    public void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setVisible(0);
            this.qds.getColumn(i).setEditable(false);
        }
        Column column = this.qds.getColumn("pilih");
        column.setCaption("#");
        column.setVisible(1);
        column.setWidth(3);
        column.setEditable(true);
        column = this.qds.getColumn("bpid");
        column.setCaption("Kode Customer");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("bpname");
        column.setCaption("Nama Customer");
        column.setVisible(1);
        column.setWidth(20);
        column = this.qds.getColumn("jalan");
        column.setCaption("Alamat");
        column.setVisible(1);
        column.setWidth(20);
        column = this.qds.getColumn("kabupaten");
        column.setCaption("Kota");
        column.setVisible(1);
        column.setWidth(10);
        column = this.qds.getColumn("nomor_telepon");
        column.setCaption("Telepon");
        column.setVisible(1);
        column.setWidth(10);
    }

    private void initKeyStroke() {
        AbstractAction actF1 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportLawanTrans.this.f1Action();
            }
        };
        AbstractAction actF5 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportLawanTrans.this.f5Action();
            }
        };
        this.getRootPane().getInputMap(2).put(this.key_F1, "f1");
        this.getRootPane().getActionMap().put("f1", actF1);
        this.getRootPane().getInputMap(2).put(this.key_F5, "f5");
        this.getRootPane().getActionMap().put("f5", actF5);
    }

    private void f1Action() {
        this.bpid = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Masukkan kode customer: ");
        if (this.bpid != null) {
            this.refresh();
        }
        this.bpid = null;
    }

    private void f5Action() {
        this.refresh();
    }

    private void refresh() {
        this.success = 0;
        this.error = 0;
        if (this.jPanelChooser1 != null) {
            this.jButton4.setEnabled(true);
        } else {
            this.jButton4.setEnabled(false);
        }
        this.LoadData(false);
        this.txtLog.setText(null);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private String getZipCode(String addrno) {
        if (addrno != null) {
            QueryDataSet qdsZipCode = new QueryDataSet();
            String sql = "SELECT zipcode FROM addr WHERE addrno = " + BHelp.QuoteSingle((String)addrno);
            if (qdsZipCode.isOpen()) {
                qdsZipCode.close();
            }
            qdsZipCode.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql));
            qdsZipCode.open();
            return qdsZipCode.getString("zipcode");
        }
        return "";
    }

    private void LoadData(boolean isSearch) {
        StringBuffer sql;
        boolean isExistNIKOrNPWPBP = EFakturUtil.isExistNIKOrNPWPBP();
        String kolomNikNpwp = isExistNIKOrNPWPBP ? ", taxnikno, taxnikname, taxregname " : ", CAST(NULL AS VARCHAR) AS taxnikno, CAST(NULL AS VARCHAR) AS taxnikname, CAST(NULL AS VARCHAR) AS taxregname ";
        if (!isSearch) {
            sql = new StringBuffer("SELECT DISTINCT false AS pilih, CAST('LT' AS VARCHAR) AS lt, bp.bpid, taxregno, bpname, fmainaddr(bp.bpid) as jalan, blok, nomor, rt, rw, kecamatan, kelurahan, fmainaddrcity(bp.bpid) AS kabupaten, statename AS propinsi, fmaincontphone(bp.bpid) AS nomor_telepon, fmainaddrno(bp.bpid) AS addrno" + kolomNikNpwp + "FROM bp " + "LEFT JOIN addr a ON (bp.bpid = a.bpid) " + "JOIN bpbptype bt ON(bp.bpid = bt.bpid) " + "LEFT JOIN bpefaktur be ON (be.bpid = bt.bpid) " + "LEFT JOIN state st ON (st.stateid = propinsi) " + "");
        } else if (this.txtNama.getText().length() > 0 || this.txtAlamat.getText().length() > 0 || this.txtKota.getText().length() > 0 || this.txtCP.getText().length() > 0) {
            sql = new StringBuffer("SELECT false AS pilih, CAST('LT' AS VARCHAR) AS lt, bp.bpid, taxregno, bpname, a.addr as jalan, blok, nomor, rt, rw, kecamatan, kelurahan, c.cityname AS kabupaten, statename AS propinsi, cont.phone AS nomor_telepon, a.addrno" + kolomNikNpwp + "FROM bp " + "LEFT JOIN addr a ON (bp.bpid = a.bpid) " + "JOIN bpbptype bt ON(bp.bpid = bt.bpid) " + "LEFT JOIN city c on c.cityid = a.cityid " + "LEFT JOIN cont on cont.bpid = bp.bpid " + "LEFT JOIN bpefaktur be ON (be.bpid = bt.bpid) " + "LEFT JOIN state st ON (st.stateid = propinsi) " + "");
        } else {
            this.LoadData(false);
            return;
        }
        StringBuffer filter = new StringBuffer();
        if (this.bpid != null && this.bpid.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"bp.bpid", (String)this.bpid));
        }
        if (isSearch) {
            if (this.txtNama.getText().length() > 0) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"bpname", (String)this.txtNama.getText()));
            }
            if (this.txtAlamat.getText().length() > 0) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"a.addr", (String)this.txtAlamat.getText()));
            }
            if (this.txtKota.getText().length() > 0) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"c.cityname", (String)this.txtKota.getText()));
            }
            if (this.txtCP.getText().length() > 0) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"cont.contname", (String)this.txtCP.getText()));
            }
        }
        JBSQL.ANDFilter((StringBuffer)filter, (String)"bptype = 'CUST' AND saleistaxed = 't'");
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setORDERBY((StringBuffer)sql, (String)"bp.bpid ASC");
        System.out.println(sql.toString());
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setMetaDataUpdate(0);
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        this.qds.setRowId("bpid", true);
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    private void getLTHeader() throws IOException {
        this.writer.append(BHelp.QuoteDouble((String)"LT"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NPWP"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NAMA"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"JALAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"BLOK"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"RT"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"RW"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KECAMATAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KELURAHAN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KABUPATEN"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"PROPINSI"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"KODE_POS"));
        this.writer.append(',');
        this.writer.append(BHelp.QuoteDouble((String)"NOMOR_TELEPON"));
        this.writer.append('\n');
    }

    private void getLT() throws IOException {
        int baris = 0;
        int rowCount = this.dsv.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("pilih")) continue;
            this.writer.append(BHelp.QuoteDouble((String)this.dsv.getString("lt")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNPWP(this.dsv.getString("taxnikno"), this.dsv.getString("taxregno")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.formatName(this.dsv.getString("bpname"), this.dsv.getString("taxnikname"), this.dsv.getString("taxregname"), this.dsv.getString("taxnikno"), this.dsv.getString("taxregno")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("jalan")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("blok")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("nomor")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithZero(this.dsv.getString("rt")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithZero(this.dsv.getString("rw")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("kecamatan")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("kelurahan")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("kabupaten")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("propinsi")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeZipCode(this.getZipCode(this.dsv.getString("addrno"))));
            this.writer.append(',');
            this.writer.append(EFakturUtil.replaceEmptyWithDash(this.dsv.getString("nomor_telepon")));
            this.writer.append('\n');
            this.txtLog.append(String.format("Export baris ke-%s, %s ... BERHASIL\n", ++baris, this.dsv.getString("bpid")));
            ++this.success;
        }
    }

    private void ExportToCsv(String sFileName) {
        try {
            this.writer = new FileWriter(sFileName);
            this.getLTHeader();
            this.getLT();
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            UIMgr.showErrorDialog((String)"Error", (Exception)e);
        }
    }

    private boolean validasi() {
        boolean retval = false;
        int rowCount = this.dsv.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("pilih")) continue;
            retval = true;
            break;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prosesExport() {
        this.success = 0;
        this.error = 0;
        int bookmark = this.dsv.getRow();
        try {
            if (!this.validasi() && this.qds.getRowCount() > 0) {
                UIMgr.showErrorDialog((String)"Mohon centang data yang akan di proses !");
                return;
            }
            if (this.qds.getRowCount() <= 0) {
                UIMgr.showErrorDialog((String)"Tidak ada data yang akan di proses !");
                return;
            }
            File fileName = new File(this.path);
            if (fileName.exists()) {
                if (UIMgr.YesNo((String)"Replace file yang sudah ada?") != 0) return;
                this.generateCSV();
            } else {
                this.generateCSV();
            }
            this.txtLog.append(String.format("\n\nJumlah :\nBerhasil : %d baris, Gagal : %d baris\n\n", this.success, this.error));
            UIMgr.showMessageDialog((String)String.format("Exported, OK ! \nBerhasil : %d baris, Gagal : %d baris\n", this.success, this.error), (Component)((Object)this));
            this.jButton4.setEnabled(false);
            this.jTabbedPane1.setSelectedIndex(1);
            return;
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)ex, (Component)((Object)this), (Logger)logger);
            return;
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)((Object)this));
            this.dsv.goToRow(bookmark);
        }
    }

    private void generateCSV() throws IOException {
        this.writer = new FileWriter(this.path);
        this.getLTHeader();
        this.getLT();
        this.writer.flush();
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckboxDetail(boolean b, DataSetView ds) {
        int bookmark = ds.getRow();
        try {
            int rowCount = ds.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ds.goToRow(i);
                ds.setBoolean("pilih", b);
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
    }

    private void resetAll() {
        this.txtAlamat.setText(null);
        this.txtCP.setText(null);
        this.txtKota.setText(null);
        this.txtNama.setText(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel8 = new JPanel();
        this.btnRefreshForm = new JButton();
        this.jButton4 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jLabel2 = new JLabel();
        this.txtNama = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtCP = new JTextField();
        this.jLabel5 = new JLabel();
        this.txtAlamat = new JTextField();
        this.txtKota = new JTextField();
        this.jLabel6 = new JLabel();
        this.btnPreview1 = new BtnPreview();
        this.btnClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel6 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.jPanelChooser1 = new JPanelChooser();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Export Lawan Transaksi");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("EXPORT LAWAN TRANSAKSI");
        this.jPanel8.setBackground(new Color(204, 204, 204));
        this.jPanel8.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.btnRefreshForm.setFont(new Font("Dialog", 1, 11));
        this.btnRefreshForm.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/refresh.png")));
        this.btnRefreshForm.setText("Refresh");
        this.btnRefreshForm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportLawanTrans.this.btnRefreshFormActionPerformed(evt);
            }
        });
        this.jButton4.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/export.png")));
        this.jButton4.setText("Proses");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportLawanTrans.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel4.setOpaque(false);
        this.jLabel22.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel22.setText("<html><u>Jangan Centang Semua</u></html>");
        this.jLabel22.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportLawanTrans.this.jLabel22MouseClicked(evt);
            }
        });
        this.jLabel21.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel21.setText("<html><u>Centang Semua</u></html>");
        this.jLabel21.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportLawanTrans.this.jLabel21MouseClicked(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21, -2, -1, -2).addComponent(this.jLabel22, -2, -1, -2));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Filter", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel5.setOpaque(false);
        this.jPanel13.setOpaque(false);
        this.jLabel2.setText("Nama Perusahaan:");
        this.txtNama.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportLawanTrans.this.txtNamaActionPerformed(evt);
            }
        });
        this.txtNama.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmExportLawanTrans.this.txtNamaKeyPressed(evt);
            }
        });
        this.jLabel7.setText("Nama Kontak:");
        this.txtCP.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmExportLawanTrans.this.txtCPKeyPressed(evt);
            }
        });
        this.jLabel5.setText("Alamat:");
        this.txtAlamat.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmExportLawanTrans.this.txtAlamatKeyPressed(evt);
            }
        });
        this.txtKota.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmExportLawanTrans.this.txtKotaKeyPressed(evt);
            }
        });
        this.jLabel6.setText("Kota:");
        this.btnPreview1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/search.png")));
        this.btnPreview1.setText("Cari");
        this.btnPreview1.setFont(new Font("Dialog", 1, 11));
        this.btnPreview1.setMargin(new Insets(2, 2, 2, 2));
        this.btnPreview1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportLawanTrans.this.btnPreview1ActionPerformed(evt);
            }
        });
        this.btnClear.setFont(new Font("Dialog", 1, 11));
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/clean.gif")));
        this.btnClear.setText("Clear");
        this.btnClear.setMargin(new Insets(2, 2, 2, 2));
        this.btnClear.setPreferredSize(new Dimension(106, 24));
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportLawanTrans.this.btnClearActionPerformed(evt);
            }
        });
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtNama, -1, 217, Short.MAX_VALUE).addComponent(this.txtCP).addComponent(this.txtAlamat)).addGap(32, 32, 32).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel13Layout.createSequentialGroup().addComponent((Component)this.btnPreview1, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnClear, -2, -1, -2)).addComponent(this.txtKota)).addContainerGap(61, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtNama, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCP, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAlamat, -2, -1, -2).addComponent(this.jLabel5))).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.txtKota, -2, -1, -2)).addGap(31, 31, 31).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.btnPreview1, -2, -1, -2).addComponent(this.btnClear, -2, -1, -2)))).addContainerGap(20, Short.MAX_VALUE)));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel13, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel13, -1, -1, Short.MAX_VALUE));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jScrollPane1.setViewportView((Component)this.jBdbTable1);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 917, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addGap(216, 216, 216)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 198, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Data", this.jPanel3);
        this.jPanel6.setBackground(new Color(204, 204, 204));
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.jScrollPane3.setViewportView(this.txtLog);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 919, Short.MAX_VALUE).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 355, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Log", this.jPanel6);
        this.jPanelChooser1.setLabelText("CSV File");
        this.jPanelChooser1.setOpaque(false);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 948, Short.MAX_VALUE).addGroup(jPanel8Layout.createSequentialGroup().addComponent((Component)this.jPanelChooser1, -2, 403, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 112, -2))).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4, -2, 26, -2).addComponent(this.btnRefreshForm, -2, 26, -2)).addComponent((Component)this.jPanelChooser1, -2, -1, -2)).addGap(14, 14, 14).addComponent(this.jTabbedPane1, -2, 406, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jBStatusbarDialog1.setShowF2(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel8, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel1, -2, 753, -2))).addContainerGap()).addComponent((Component)this.jBStatusbarDialog1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addGap(10, 10, 10).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void jLabel22MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(false, this.dsv);
    }

    private void jLabel21MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(true, this.dsv);
    }

    private void btnRefreshFormActionPerformed(ActionEvent evt) {
        this.refresh();
        this.resetAll();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.prosesExport();
    }

    private void txtNamaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.LoadData(true);
        }
    }

    private void txtCPKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.LoadData(true);
        }
    }

    private void txtAlamatKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.LoadData(true);
        }
    }

    private void txtKotaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.LoadData(true);
        }
    }

    private void btnPreview1ActionPerformed(ActionEvent evt) {
        this.LoadData(true);
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.resetAll();
    }

    private void txtNamaActionPerformed(ActionEvent evt) {
    }

    public void doNew() {
    }

    public void doOpen() {
    }

    public void doEdit() {
    }

    public void doEdit(String string) {
    }

    public void doSave() {
    }

    public void doCancel() {
    }

    public void doDelete() {
    }

    public void doVoid() {
    }

    public void doPrint() {
    }

    public void doRefresh() {
    }

    public void setTransState(int i) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("filename")) {
            this.jButton4.setEnabled(true);
            this.btnRefreshForm.setEnabled(true);
            BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)true);
            this.path = this.jPanelChooser1.getFilePath();
            this.initKeyStroke();
        }
    }
}

