/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.ui;

import com.bits.bee.confui.FileInfo;
import com.bits.bee.exportefaktur.bl.TaxStatus;
import com.bits.bee.exportefaktur.ui.DlgDetailPajakReturKeluaran;
import com.bits.bee.exportefaktur.ui.myswing.JCboAllocatedType;
import com.bits.bee.exportefaktur.util.EFakturUtil;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.bee.ui.myswing.JBOSPeriode;
import com.bits.bee.ui.myswing.JCboBranch;
import com.bits.bee.ui.myswing.JCboContraStatus;
import com.bits.bee.ui.myswing.JCboIsDraft;
import com.bits.bee.ui.myswing.JCboTermType;
import com.bits.bee.ui.myswing.JPanelChooser;
import com.bits.bee.ui.myswing.PikCust;
import com.bits.bee.ui.myswing.PikSrep;
import com.bits.lib.BHelp;
import com.bits.lib.BUtil;
import com.bits.lib.dbswing.JBComboBox;
import com.bits.lib.dbswing.JBPeriode;
import com.bits.lib.dbswing.JBPicker;
import com.bits.lib.dbswing.JBStatusbarDialog;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportReturFakturKeluaran
extends JInternalFrame
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(FrmExportReturFakturKeluaran.class);
    private final QueryDataSet qds = new QueryDataSet();
    private final DataSetView dsv = new DataSetView();
    private final QueryDataSet qdsMaster = new QueryDataSet();
    private final QueryDataSet qdsDetail = new QueryDataSet();
    private final KeyStroke key_F1 = KeyStroke.getKeyStroke(112, 0, false);
    private final KeyStroke key_F5 = KeyStroke.getKeyStroke(116, 0, false);
    private final TaxStatus taxstatus = new TaxStatus();
    private FileWriter writer;
    private String path;
    private int success;
    private int error;
    private String sretno;
    private static final String PROHIBITED_CHARS = "[\\\\/:*?\"<>|/]";
    private BigDecimal totalTaxableamt;
    private BigDecimal totalTotalTaxamt;
    private BigDecimal totalPPnBM;
    private JLabel LblKeterangan;
    private JTextArea TxtLog;
    private JButton btnRefreshForm;
    private JCheckBox chkCSV;
    private JCheckBox chkXML;
    private JBOSPeriode jBOSPeriode1;
    private JBStatusbarDialog jBStatusbarDialog1;
    private JBdbTable jBdbTable1;
    private JButton jButton1;
    private JButton jButton2;
    private JCboAllocatedType jCboAllocatedType1;
    private JCboBranch jCboBranch1;
    private JCboContraStatus jCboContraStatus1;
    private JCboIsDraft jCboIsDraft1;
    private JCboTermType jCboTermType1;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanelChooser jPanelChooser1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private PikCust pikCust1;
    private PikSrep pikSrep1;

    public FrmExportReturFakturKeluaran() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.jCboAllocatedType1.setKeyValue("B");
        this.chkXML.setSelected(true);
        this.jPanelChooser1.setFileFilter("XML", "xml", true);
        this.jPanelChooser1.getBtnBrowse().setText("Pilih File");
        this.jPanelChooser1.getFileChooser().setApproveButtonText("Save");
        this.jPanelChooser1.addPropertyChangeListener("fileName", (PropertyChangeListener)this);
        this.jButton1.setEnabled(false);
        this.btnRefreshForm.setEnabled(false);
        BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)false);
        UIMgr.setPeriode((JBPeriode)this.jBOSPeriode1, (int)0);
        this.Load();
        this.LblKeterangan.setText("<html><p align=justify><<font color=blue>Belum Dialokasikan</font> &#8594; Opsi untuk menampilkan data yang belum diexport <br /><font color=red>Sudah Dialokasikan</font> &#8594; Opsi untuk menampilkan data yang sudah diexport <br /></p><hr /><p align=justify>Pilih status <b><font color=red>Sudah Dialokasikan</font></b> lalu klik tombol <b>Proses</b>, maka status data akan berubah kembali menjadi <b><font color=blue>Belum Dialokasikan</font></b> </p></html>");
    }

    private void initKeyStroke() {
        AbstractAction actF1 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportReturFakturKeluaran.this.f1Action();
            }
        };
        AbstractAction actF5 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmExportReturFakturKeluaran.this.f5Action();
            }
        };
        this.getRootPane().getInputMap(2).put(this.key_F1, "f1");
        this.getRootPane().getActionMap().put("f1", actF1);
        this.getRootPane().getInputMap(2).put(this.key_F5, "f5");
        this.getRootPane().getActionMap().put("f5", actF5);
    }

    private void f1Action() {
        this.sretno = JOptionPane.showInputDialog(this, (Object)"Masukkan nomor retur penjualan: ");
        if (this.sretno != null) {
            this.doRefresh();
        }
        this.sretno = null;
    }

    private void f5Action() {
        this.doRefresh();
    }

    private void initTable() {
        int columnCount = this.qds.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.qds.getColumn(i).setVisible(0);
            this.qds.getColumn(i).setEditable(false);
        }
        Column column = this.qds.getColumn("check");
        column.setCaption("#");
        column.setWidth(3);
        column.setVisible(1);
        column.setEditable(true);
        column = this.qds.getColumn("bpname");
        column.setCaption("Customer");
        column.setWidth(20);
        column.setVisible(1);
        column = this.qds.getColumn("sretno");
        column.setCaption("No. Retur");
        column.setVisible(1);
        column = this.qds.getColumn("sretdate");
        column.setCaption("Tanggal Retur");
        column.setWidth(10);
        column.setVisible(1);
        column = this.qds.getColumn("jumlah_dpp");
        column.setCaption("Nilai Retur DPP");
        column.setVisible(1);
        column = this.qds.getColumn("jumlah_ppn");
        column.setCaption("Nilai Retur PPn");
        column.setVisible(1);
    }

    private void doRefresh() {
        this.success = 0;
        this.error = 0;
        if (this.jPanelChooser1.getFileName() != null) {
            this.jButton1.setEnabled(true);
        } else {
            this.jButton1.setEnabled(false);
        }
        this.Load();
        this.TxtLog.setText(null);
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void LoadDetail(String sretno) {
        boolean isExistNIKOrNPWPBP = EFakturUtil.isExistNIKOrNPWPBP();
        String kolomNikNpwp = isExistNIKOrNPWPBP ? ", bp.taxnikno, bp.taxnikname, bp.taxregname " : ", CAST(NULL AS VARCHAR) AS taxnikno, CAST(NULL AS VARCHAR) AS taxnikname, CAST(NULL AS VARCHAR) AS taxregname ";
        String sql = "SELECT FALSE AS check, CAST('RK' AS VARCHAR(2)) AS rk, taxregno, bpname, CAST('01' AS VARCHAR(2)) AS kd_jenis_transaksi, CAST('0' AS VARCHAR(1)) AS fg_pengganti, to_char(sretdate, 'dd/MM/yyyy') AS faktur_date, termtype AS IS_CREDITABLE, sd.saleno, s.sretno, to_char(sretdate, 'dd/MM/yyyy') AS sretdate, CAST(date_part('month', sretdate) AS INT) AS masa_pajak, CAST(date_part('year', sretdate) AS INT) AS tahun_pajak, CAST((COALESCE(sd.taxableamt, 0)*s.excrate) AS NUMERIC(19,4)) AS taxableamt, CAST(COALESCE(sd.basftotaltaxamt, 0) AS NUMERIC(19,4)) as totaltaxamt, CAST(0 AS NUMERIC(19, 4)) AS PPnBM" + kolomNikNpwp + ", (SELECT taxregno FROM cmp LIMIT 1) AS cmp_npwp, " + "taxsretno, " + "sd.itemid, i.itemtype, sd.itemdesc, " + "(CASE WHEN saled.qty IS NULL THEN sd.qty ELSE saled.qty END) as quantity, " + "CAST((sd.baseprice*s.excrate) AS NUMERIC(19,4)) AS baseprice, " + "sd.qty, " + "CAST(((sd.totaldiscamt + sd.totaldisc2amt)*s.excrate) AS NUMERIC(19,4)) AS totaldiscamt, " + "CAST(0 AS NUMERIC(19, 4)) AS tarif_ppnbm " + "FROM sret s " + "JOIN bp ON s.custid = bp.bpid " + "JOIN crc c ON c.crcid=s.crcid " + "LEFT JOIN branch br ON br.branchid=s.branchid " + "LEFT JOIN sretd sd ON sd.sretno = s.sretno AND COALESCE(sd.taxid,'')<>'' " + "LEFT JOIN saled ON saled.saleno=sd.saleno and saled.saledno=sd.saledno " + "LEFT JOIN item i ON i.itemid=sd.itemid " + "WHERE s.sretno = " + BHelp.QuoteSingle((String)sretno) + " " + "ORDER BY s.sretdate DESC, s.sretno DESC, sd.sretdno ASC";
        if (this.qdsDetail.isOpen()) {
            this.qdsDetail.close();
        }
        System.out.println(sql);
        this.qdsDetail.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql));
        this.qdsDetail.open();
        this.totalTaxableamt = BigDecimal.ZERO;
        this.totalTotalTaxamt = BigDecimal.ZERO;
        this.totalPPnBM = BigDecimal.ZERO;
        for (int index = 0; index < this.qdsDetail.getRowCount(); ++index) {
            this.qdsDetail.goToRow(index);
            BigDecimal taxableamt = EFakturUtil.setScalingXML(this.qdsDetail.getBigDecimal("taxableamt"));
            this.totalTaxableamt = this.totalTaxableamt.add(taxableamt);
            BigDecimal totaltaxamt = EFakturUtil.setScalingXML(this.qdsDetail.getBigDecimal("totaltaxamt"));
            this.totalTotalTaxamt = this.totalTotalTaxamt.add(totaltaxamt);
            BigDecimal ppnbm = EFakturUtil.setScalingXML(this.qdsDetail.getBigDecimal("ppnbm"));
            this.totalPPnBM = this.totalPPnBM.add(ppnbm);
        }
    }

    private void Load() {
        StringBuffer sql = new StringBuffer("SELECT FALSE AS check,s.sretno, to_char(sretdate, 'dd/MM/yyyy') AS sretdate, bpname, CAST(SUM(CAST((COALESCE(sd.taxableamt, 0)*COALESCE(s.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS jumlah_dpp, CAST(SUM(COALESCE(sd.basftotaltaxamt, 0)) AS NUMERIC(19,4)) AS jumlah_ppn FROM sret s JOIN bp ON s.custid = bp.bpid JOIN crc c ON c.crcid=s.crcid LEFT JOIN branch br ON br.branchid=s.branchid JOIN sretd sd ON sd.sretno = s.sretno LEFT JOIN taxstatus ts ON ts.refno = s.sretno ");
        StringBuffer filter = new StringBuffer();
        if (this.sretno != null && this.sretno.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)JBSQL.filterUpperLike((String)"s.sretno", (String)this.sretno));
        }
        JBSQL.ANDFilterPeriode((StringBuffer)filter, (String)"s.sretdate", (JBPeriode)this.jBOSPeriode1);
        JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"s.custid", (JBPicker)this.pikCust1);
        JBSQL.ANDFilterPicker((StringBuffer)filter, (String)"s.srepid", (JBPicker)this.pikSrep1);
        if (this.jCboIsDraft1.getKeyValue() != null) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)("s.isdraft=" + this.jCboIsDraft1.getKeyValue()));
        }
        JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.termtype", (JBComboBox)this.jCboTermType1);
        if (this.jCboContraStatus1.getKeyValue() != null) {
            if (this.jCboContraStatus1.getKeyValue().equalsIgnoreCase("Y")) {
                JBSQL.ANDFilter((StringBuffer)filter, (String)"iscontra=true");
            } else {
                JBSQL.ANDFilter((StringBuffer)filter, (String)"iscontra=false");
            }
        }
        JBSQL.ANDFilterCombo((StringBuffer)filter, (String)"s.branchid", (JBComboBox)this.jCboBranch1);
        JBSQL.ANDFilter((StringBuffer)filter, (String)"s.istaxed=true");
        if ("B".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"(is_allocated IS NULL OR is_allocated = 'B')");
        } else if ("S".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
            JBSQL.ANDFilter((StringBuffer)filter, (String)"(is_allocated = 'S')");
        }
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setGROUPBY((StringBuffer)sql, (String)"s.sretno, bp.bpname, s.sretdate, s.excrate");
        JBSQL.setORDERBY((StringBuffer)sql, (String)"s.sretdate desc, s.sretno desc");
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        this.initTable();
        if (this.dsv.isOpen()) {
            this.dsv.close();
        }
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        System.out.println(sql.toString());
        this.qds.setAllRowIds(true);
        this.qds.setMetaDataUpdate(0);
        this.dsv.setStorageDataSet(this.qds.getStorageDataSet());
        this.dsv.open();
    }

    private void LoadMaster(String sretnoSumComa) {
        StringBuffer sql = new StringBuffer("SELECT CAST('RK' AS VARCHAR(2)) AS rk, taxregno, CAST('01' AS VARCHAR(2)) AS kd_jenis_transaksi, CAST('0' AS VARCHAR(1)) AS fg_pengganti, to_char(sretdate, 'dd/MM/yyyy') AS faktur_date, termtype AS IS_CREDITABLE, s.sretno, to_char(sretdate, 'dd/MM/yyyy') AS sretdate, bpname, CAST(date_part('month', sretdate) AS INT) AS masa_pajak, CAST(date_part('year', sretdate) AS INT) AS tahun_pajak, CAST(SUM(CAST((COALESCE(sd.taxableamt, 0)*COALESCE(s.excrate, 0)) AS NUMERIC(19,4))) AS NUMERIC(19,4)) AS jumlah_dpp, CAST(SUM(COALESCE(sd.basftotaltaxamt, 0)) AS NUMERIC(19,4)) AS jumlah_ppn, CAST(0 AS NUMERIC(19, 4)) AS PPnBM, (SELECT taxregno FROM cmp LIMIT 1) AS cmp_npwp FROM sret s JOIN bp ON s.custid = bp.bpid JOIN sretd sd ON sd.sretno = s.sretno ");
        StringBuffer filter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)filter, (String)("s.sretno IN (" + sretnoSumComa + ")"));
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setGROUPBY((StringBuffer)sql, (String)"s.sretno, bp.taxregno, bp.bpname, s.sretdate, termtype, s.excrate");
        JBSQL.setORDERBY((StringBuffer)sql, (String)"s.sretdate desc, s.sretno desc");
        if (this.qdsMaster.isOpen()) {
            this.qdsMaster.close();
        }
        this.qdsMaster.setMetaDataUpdate(0);
        this.qdsMaster.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qdsMaster.open();
        this.qdsMaster.setAllRowIds(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckboxDetail(boolean b, DataSetView ds) {
        int bookmark = ds.getRow();
        try {
            for (int i = 0; i < ds.getRowCount(); ++i) {
                ds.goToRow(i);
                ds.setBoolean("check", b);
            }
        }
        finally {
            ds.goToRow(bookmark);
        }
    }

    private boolean validasi() {
        boolean retval = false;
        for (int i = 0; i < this.dsv.getRowCount(); ++i) {
            this.dsv.goToRow(i);
            if (!this.dsv.getBoolean("check")) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private void setHeader() throws IOException {
        this.writer.append("RK");
        this.writer.append(',');
        this.writer.append("NPWP");
        this.writer.append(',');
        this.writer.append("NAMA");
        this.writer.append(',');
        this.writer.append("KD_JENIS_TRANSAKSI");
        this.writer.append(',');
        this.writer.append("FG_PENGGANTI");
        this.writer.append(',');
        this.writer.append("NOMOR_FAKTUR");
        this.writer.append(',');
        this.writer.append("TANGGAL_FAKTUR");
        this.writer.append(',');
        this.writer.append("IS_CREDITABLE");
        this.writer.append(',');
        this.writer.append("NOMOR_DOKUMEN_RETUR");
        this.writer.append(',');
        this.writer.append("TANGGAL_RETUR");
        this.writer.append(',');
        this.writer.append("MASA_PAJAK_RETUR");
        this.writer.append(',');
        this.writer.append("TAHUN_PAJAK_RETUR");
        this.writer.append(',');
        this.writer.append("NILAI_RETUR_DPP");
        this.writer.append(',');
        this.writer.append("NILAI_RETUR_PPN");
        this.writer.append(',');
        this.writer.append("NILAI_RETUR_PPNBM");
        this.writer.append('\n');
    }

    private void setDetail(String sretno) throws IOException {
        this.LoadDetail(sretno);
        for (int index = 0; index < this.qdsDetail.getRowCount(); ++index) {
            this.qdsDetail.goToRow(index);
            this.writer.append(this.qdsDetail.getString("rk"));
            this.writer.append(',');
            this.writer.append(EFakturUtil.normalizeNPWP(this.qdsDetail.getString("taxnikno"), this.qdsDetail.getString("taxregno")));
            this.writer.append(',');
            this.writer.append(EFakturUtil.formatName(this.qdsDetail.getString("bpname"), this.qdsDetail.getString("taxnikname"), this.qdsDetail.getString("taxregname"), this.qdsDetail.getString("taxnikno"), this.qdsDetail.getString("taxregno")));
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getString("kd_jenis_transaksi").length() > 0 ? '\'' + this.qdsDetail.getString("kd_jenis_transaksi") : "");
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getString("fg_pengganti"));
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getString("saleno").length() > 0 ? '\'' + this.qdsDetail.getString("saleno") : "");
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getString("faktur_date"));
            this.writer.append(',');
            this.writer.append("C".equalsIgnoreCase(this.qdsDetail.getString("is_creditable")) ? "0" : "1");
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getString("sretno").length() > 0 ? '\'' + this.qdsDetail.getString("sretno") : "");
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getString("sretdate"));
            this.writer.append(',');
            this.writer.append(String.valueOf(this.qdsDetail.getInt("masa_pajak")));
            this.writer.append(',');
            this.writer.append(String.valueOf(this.qdsDetail.getInt("tahun_pajak")));
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getBigDecimal("taxableamt").setScale(0, 3).toString());
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getBigDecimal("totaltaxamt").setScale(0, 3).toString());
            this.writer.append(',');
            this.writer.append(this.qdsDetail.getBigDecimal("ppnbm").toString());
            this.writer.append('\n');
        }
    }

    private void setValue() throws IOException {
        for (int i = 0; i < this.qdsMaster.getRowCount(); ++i) {
            this.qdsMaster.goToRow(i);
            try {
                this.taxstatus.LoadID(this.qdsMaster.getString("sretno"));
                this.taxstatus.addNewRow(this.qdsMaster.getString("sretno"), "S");
                this.setDetail(this.qdsMaster.getString("sretno"));
                this.taxstatus.saveChanges();
                this.TxtLog.append(String.format("Export baris ke-%s, %s ... BERHASIL\n", i + 1, this.qdsMaster.getString("sretno")));
                ++this.success;
                continue;
            }
            catch (Exception ex) {
                this.TxtLog.append(String.format("Export baris ke-%s, %s ... GAGAL\n", i, BHelp.getExceptionDetail((Exception)ex)));
                logger.error(String.format("Baris %d, ERROR: %s\n", i, BHelp.getExceptionDetail((Exception)ex)));
                ++this.error;
            }
        }
    }

    private void CreateCsv() throws IOException {
        this.writer = new FileWriter(this.path);
        this.setHeader();
        this.setValue();
        this.writer.flush();
        this.writer.close();
    }

    private boolean checkNpwp() {
        if (this.chkXML.isSelected()) {
            boolean npwpCmpEmpty = true;
            for (int i = 0; i < this.qdsMaster.getRowCount(); ++i) {
                this.qdsMaster.goToRow(i);
                String TIN = EFakturUtil.getTIN(this.qdsMaster.getString("cmp_npwp"), false);
                if (TIN == null || TIN.length() <= 0) continue;
                npwpCmpEmpty = false;
            }
            boolean isExport = EFakturUtil.checkEmptyNpwp(npwpCmpEmpty, null);
            if (!isExport) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prosesExport() {
        this.success = 0;
        this.error = 0;
        int bookmark = this.dsv.getRow();
        try {
            if (!this.validasi() && this.qds.getRowCount() > 0) {
                UIMgr.showErrorDialog((String)"Mohon centang data yang akan di proses !");
                return;
            }
            if (this.qds.getRowCount() <= 0) {
                UIMgr.showErrorDialog((String)"Tidak ada data yang akan di proses !");
                return;
            }
            if ("B".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
                if (!this.chkCSV.isSelected() && !this.chkXML.isSelected()) {
                    UIMgr.showErrorDialog((String)"Mohon pilih tipe format export !");
                    return;
                }
                if (this.chkCSV.isSelected() && this.path.endsWith(".xml")) {
                    UIMgr.showErrorDialog((String)"Kesalahan format file !", (Exception)new Exception("Silahkan pilih file dengan format csv"), (Component)this, (Logger)logger);
                    return;
                }
                if (this.chkXML.isSelected() && this.path.endsWith(".csv")) {
                    UIMgr.showErrorDialog((String)"Kesalahan format file !", (Exception)new Exception("Silahkan pilih file dengan format xml"), (Component)this, (Logger)logger);
                    return;
                }
                boolean first = true;
                StringBuilder trxnoSumComa = new StringBuilder();
                int rowCount = this.dsv.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    this.dsv.goToRow(i);
                    if (!this.dsv.getBoolean("check")) continue;
                    String trxno = this.dsv.getString("sretno");
                    if (first) {
                        trxnoSumComa.append(BHelp.QuoteSingle((String)trxno));
                        first = false;
                        continue;
                    }
                    trxnoSumComa.append(",").append(BHelp.QuoteSingle((String)trxno));
                }
                this.LoadMaster(trxnoSumComa.toString());
                if (!this.checkNpwp()) {
                    return;
                }
                File fileName = new File(this.path);
                if (fileName.exists()) {
                    if (UIMgr.YesNo((String)"Replace file yang sudah ada?") != 0) return;
                    if (this.chkXML.isSelected()) {
                        this.CreateXML();
                    } else {
                        this.CreateCsv();
                    }
                } else if (this.chkXML.isSelected()) {
                    this.CreateXML();
                } else {
                    this.CreateCsv();
                }
                this.TxtLog.append(String.format("\n\nJumlah :\nBerhasil : %d baris, Gagal : %d baris\n\n", this.success, this.error));
                UIMgr.showMessageDialog((String)String.format("Exported, OK ! \nBerhasil : %d baris, Gagal : %d baris\n", this.success, this.error), (Component)this);
                this.jTabbedPane1.setSelectedIndex(1);
            } else if ("S".equalsIgnoreCase(this.jCboAllocatedType1.getKeyValue())) {
                for (int i = 0; i < this.dsv.getRowCount(); ++i) {
                    this.dsv.goToRow(i);
                    if (!this.dsv.getBoolean("check")) continue;
                    this.taxstatus.LoadID(this.dsv.getString("sretno"));
                    this.taxstatus.addNewRow(this.dsv.getString("sretno"), "B");
                    this.taxstatus.saveChanges();
                }
            }
            this.jButton1.setEnabled(false);
            this.Load();
            return;
        }
        catch (Exception ex) {
            String filename;
            try {
                JFileChooser fileChooser = this.jPanelChooser1.getFileChooser();
                String parentDir = fileChooser.getCurrentDirectory().getPath() + FileInfo.getInstance().getFileSeparator();
                String path = fileChooser.getSelectedFile().getPath();
                filename = path.substring(parentDir.length());
            }
            catch (Exception e) {
                filename = this.jPanelChooser1.getFileName();
            }
            if (filename.matches(".*[\\\\/:*?\"<>|/].*")) {
                UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)new Exception("Nama file tidak boleh mengandung karakter '/', '\\', ':', '*', '?', '\"', '<', '>', atau '|'", ex), (Component)this, (Logger)logger);
                return;
            } else {
                UIMgr.showErrorDialog((String)"Export Gagal.", (Exception)ex, (Component)this, (Logger)logger);
            }
            return;
        }
        finally {
            ScreenManager.setCursorDefault((JInternalFrame)this);
            this.dsv.goToRow(bookmark);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jCboIsDraft1 = new JCboIsDraft();
        this.jLabel5 = new JLabel();
        this.jCboTermType1 = new JCboTermType();
        this.jLabel7 = new JLabel();
        this.jCboBranch1 = new JCboBranch();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.pikSrep1 = new PikSrep();
        this.jLabel4 = new JLabel();
        this.jBOSPeriode1 = new JBOSPeriode();
        this.pikCust1 = new PikCust();
        this.jLabel2 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jCboContraStatus1 = new JCboContraStatus();
        this.jScrollPane2 = new JScrollPane();
        this.jBdbTable1 = new JBdbTable();
        this.jPanel6 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jButton2 = new JButton();
        this.jPanel8 = new JPanel();
        this.jCboAllocatedType1 = new JCboAllocatedType();
        this.jLabel11 = new JLabel();
        this.LblKeterangan = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.TxtLog = new JTextArea();
        this.jPanelChooser1 = new JPanelChooser();
        this.btnRefreshForm = new JButton();
        this.jButton1 = new JButton();
        this.chkXML = new JCheckBox();
        this.chkCSV = new JCheckBox();
        this.jBStatusbarDialog1 = new JBStatusbarDialog();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setTitle("Export Retur Faktur Pajak Keluaran");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("EXPORT RETUR FAKTUR PAJAK KELUARAN");
        this.jPanel1.setBackground(new Color(204, 204, 204));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel2.setBackground(new Color(204, 204, 204));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Filter", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel4.setOpaque(false);
        this.jPanel7.setOpaque(false);
        this.jLabel5.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Termin:");
        this.jLabel7.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Draft:");
        this.jLabel3.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Cabang:");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel7Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE)).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboIsDraft1, GroupLayout.Alignment.TRAILING, -1, 151, Short.MAX_VALUE).addComponent((Component)this.jCboTermType1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent((Component)this.jCboBranch1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent((Component)this.jCboTermType1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent((Component)this.jCboIsDraft1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent((Component)this.jCboBranch1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setOpaque(false);
        this.pikSrep1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikSrep1.setOpaque(false);
        this.jLabel4.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Periode:");
        this.jBOSPeriode1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikCust1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.pikCust1.setOpaque(false);
        this.jLabel2.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Customer:");
        this.jLabel9.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel9.setText("Sales:");
        this.jLabel6.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Contra:");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel9).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.pikSrep1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.pikCust1, GroupLayout.Alignment.LEADING, -2, 229, -2)).addComponent((Component)this.jBOSPeriode1, -2, -1, -2).addComponent((Component)this.jCboContraStatus1, -2, -1, -2))));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent((Component)this.jBOSPeriode1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikCust1, -2, -1, -2).addComponent(this.jLabel2, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.pikSrep1, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jCboContraStatus1, -2, -1, -2).addComponent(this.jLabel6))));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addGap(40, 40, 40).addComponent(this.jPanel7, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jBdbTable1.setDataSet((DataSet)this.dsv);
        this.jScrollPane2.setViewportView((Component)this.jBdbTable1);
        this.jPanel6.setOpaque(false);
        this.jLabel22.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel22.setText("<html><u>Jangan Centang Semua</u></html>");
        this.jLabel22.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportReturFakturKeluaran.this.jLabel22MouseClicked(evt);
            }
        });
        this.jLabel21.setFont(new Font("Bitstream Vera Sans", 0, 10));
        this.jLabel21.setText("<html><u>Centang Semua</u></html>");
        this.jLabel21.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmExportReturFakturKeluaran.this.jLabel21MouseClicked(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel21, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel22, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21, -2, -1, -2).addComponent(this.jLabel22, -2, -1, -2)).addGap(25, 25, 25)));
        this.jButton2.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton2.setText("Lihat Detail");
        this.jButton2.setPreferredSize(new Dimension(141, 26));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportReturFakturKeluaran.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)), "Option", 0, 0, new Font("Dialog", 1, 11)));
        this.jPanel8.setOpaque(false);
        this.jCboAllocatedType1.setEnableRightClickEvent(false);
        this.jCboAllocatedType1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FrmExportReturFakturKeluaran.this.jCboAllocatedType1ItemStateChanged(evt);
            }
        });
        this.jLabel11.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel11.setText("Status: ");
        this.LblKeterangan.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.LblKeterangan.setHorizontalAlignment(4);
        this.LblKeterangan.setText("Keterangan");
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LblKeterangan, -2, 218, -2).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)((Object)this.jCboAllocatedType1), -2, 161, -2))).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.jCboAllocatedType1), -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LblKeterangan, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 146, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 665, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel8, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2, -1, 227, Short.MAX_VALUE).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, -2, 26, -2).addComponent(this.jButton2, -2, 26, -2)).addContainerGap()));
        this.jTabbedPane1.addTab("Data", this.jPanel2);
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.TxtLog.setColumns(20);
        this.TxtLog.setRows(5);
        this.jScrollPane1.setViewportView(this.TxtLog);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 923, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Log", this.jPanel3);
        this.jPanelChooser1.setLabelText("File");
        this.jPanelChooser1.setOpaque(false);
        this.btnRefreshForm.setFont(new Font("Dialog", 1, 11));
        this.btnRefreshForm.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/refresh.png")));
        this.btnRefreshForm.setText("Refresh");
        this.btnRefreshForm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportReturFakturKeluaran.this.btnRefreshFormActionPerformed(evt);
            }
        });
        this.jButton1.setFont(new Font("Bitstream Vera Sans", 1, 11));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/export.png")));
        this.jButton1.setText("Proses");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportReturFakturKeluaran.this.jButton1ActionPerformed(evt);
            }
        });
        this.chkXML.setText("Format XML");
        this.chkXML.setOpaque(false);
        this.chkXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportReturFakturKeluaran.this.chkXMLActionPerformed(evt);
            }
        });
        this.chkCSV.setText("Format CSV");
        this.chkCSV.setOpaque(false);
        this.chkCSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrmExportReturFakturKeluaran.this.chkCSVActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.jPanelChooser1, -2, 403, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkXML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCSV).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRefreshForm, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 112, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton1, -2, 26, -2).addComponent((Component)this.jPanelChooser1, -2, -1, -2).addComponent(this.btnRefreshForm, -2, 26, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.chkXML).addComponent(this.chkCSV))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1, -1, 454, Short.MAX_VALUE).addContainerGap()));
        this.jBStatusbarDialog1.setShowF2(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent((Component)this.jBStatusbarDialog1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jBStatusbarDialog1, -2, -1, -2)));
        this.pack();
    }

    private void btnRefreshFormActionPerformed(ActionEvent evt) {
        this.doRefresh();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.prosesExport();
    }

    private void jLabel22MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(false, this.dsv);
    }

    private void jLabel21MouseClicked(MouseEvent evt) {
        this.setCheckboxDetail(true, this.dsv);
    }

    private void setDlg(DlgDetailPajakReturKeluaran dlg) {
        dlg.setSretno(this.dsv.getString("sretno"));
        dlg.Load();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        DlgDetailPajakReturKeluaran dlg = DlgDetailPajakReturKeluaran.getInstance();
        this.setDlg(dlg);
        dlg.setVisible(true);
    }

    private void jCboAllocatedType1ItemStateChanged(ItemEvent evt) {
        this.Load();
    }

    private void chkXMLActionPerformed(ActionEvent evt) {
        if (this.chkXML.isSelected()) {
            this.chkCSV.setSelected(false);
            this.jPanelChooser1.setFileFilter("XML", "xml", true);
        } else {
            this.chkCSV.setSelected(true);
            this.jPanelChooser1.setFileFilter("Comma-separated values", "csv", true);
        }
    }

    private void chkCSVActionPerformed(ActionEvent evt) {
        if (this.chkCSV.isSelected()) {
            this.chkXML.setSelected(false);
            this.jPanelChooser1.setFileFilter("Comma-separated values", "csv", true);
        } else {
            this.chkXML.setSelected(true);
            this.jPanelChooser1.setFileFilter("XML", "xml", true);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("filename")) {
            this.jButton1.setEnabled(true);
            this.btnRefreshForm.setEnabled(true);
            BUtil.setEnabledJTabbedPane((JTabbedPane)this.jTabbedPane1, (boolean)true);
            this.path = this.jPanelChooser1.getFilePath();
            this.initKeyStroke();
        }
    }

    public String convertDate(String inputDate) {
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("dd/MM/yyyy");
            SimpleDateFormat outputFormat = new SimpleDateFormat("dd-MM-yyyy");
            Date date = inputFormat.parse(inputDate);
            return outputFormat.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    private void CreateXML() throws IOException {
        this.writer = new FileWriter(this.path);
        this.setHeaderXML();
        this.setValueXML();
        this.setFooterXML();
        this.writer.flush();
        this.writer.close();
    }

    private void writeTagXML(FileWriter writer, String tag, String value) throws IOException {
        this.writeTagXML(writer, tag, value, true);
    }

    private void writeTagXML(FileWriter writer, String tag, String value, boolean endWithEnter) throws IOException {
        if (value != null && value.length() > 0) {
            writer.append("<" + tag + ">");
            writer.append(EFakturUtil.formatXML(value));
            writer.append("</" + tag + ">");
        } else {
            writer.append("<" + tag + "/>");
        }
        if (endWithEnter) {
            writer.append('\n');
        }
    }

    private void setHeaderXML() throws IOException {
        this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.append('\n');
        this.writer.append("<InputTaxInvoiceReturn>");
        this.writer.append('\n');
        String TIN = EFakturUtil.getTIN(this.qdsMaster.getString("cmp_npwp"), false);
        this.writeTagXML(this.writer, "TIN", TIN);
        this.writer.append("<InputReturnDataList>");
        this.writer.append('\n');
    }

    private void setFooterXML() throws IOException {
        this.writer.append("</InputReturnDataList>");
        this.writer.append('\n');
        this.writer.append("</InputTaxInvoiceReturn>");
        this.writer.append('\n');
    }

    private void setDetailXML(String sretno) throws IOException {
        this.LoadDetail(sretno);
        this.qdsDetail.goToRow(0);
        String sellerTin = EFakturUtil.getTIN(this.qdsDetail.getString("cmp_npwp"), false);
        String ReturnTaxBase = EFakturUtil.formatNumericXML(this.totalTaxableamt);
        String ReturnOtherTaxBase = EFakturUtil.formatNumericXML(this.totalTaxableamt);
        String ReturnVAT = EFakturUtil.formatNumericXML(this.totalTotalTaxamt);
        String ReturnSTLG = EFakturUtil.formatNumericXML(this.totalPPnBM);
        this.writer.append("<InputReturnData>");
        this.writer.append('\n');
        this.writer.append("<TransactionDocumentData>");
        this.writer.append('\n');
        this.writeTagXML(this.writer, "InvoiceNumber", this.qdsDetail.getString("taxsretno"));
        this.writeTagXML(this.writer, "SellerTIN", sellerTin);
        this.writeTagXML(this.writer, "ReturnDate", this.convertDate(this.qdsDetail.getString("faktur_date")));
        this.writeTagXML(this.writer, "ReturnTaxBase", ReturnTaxBase);
        this.writeTagXML(this.writer, "ReturnOtherTaxBase", ReturnOtherTaxBase);
        this.writeTagXML(this.writer, "ReturnVAT", ReturnVAT);
        this.writeTagXML(this.writer, "ReturnSTLG", ReturnSTLG);
        this.writer.append("</TransactionDocumentData>");
        this.writer.append('\n');
        this.writer.append("<TransactionDetailsData>");
        this.writer.append('\n');
        for (int index = 0; index < this.qdsDetail.getRowCount(); ++index) {
            this.qdsDetail.goToRow(index);
            if (this.qdsDetail.isNull("itemid") || this.qdsDetail.getString("itemid").length() <= 0) continue;
            this.writer.append("<Rows>");
            this.writer.append('\n');
            this.writeTagXML(this.writer, "Type", EFakturUtil.getOptGoodService(this.qdsDetail.getString("itemtype")));
            this.writeTagXML(this.writer, "Name", this.qdsDetail.getString("itemdesc"));
            this.writeTagXML(this.writer, "Code", "000000");
            this.writeTagXML(this.writer, "Quantity", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("quantity")));
            this.writeTagXML(this.writer, "Unit", EFakturUtil.getUnitGoodService(this.qdsDetail.getString("itemtype")));
            this.writeTagXML(this.writer, "UnitPrice", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("baseprice")));
            this.writeTagXML(this.writer, "STLGRate", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("tarif_ppnbm")));
            this.writeTagXML(this.writer, "ReturnQuantity", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("qty")));
            this.writeTagXML(this.writer, "ReturnDiscount", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("totaldiscamt")));
            this.writeTagXML(this.writer, "ReturnTaxBase", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("taxableamt")));
            this.writeTagXML(this.writer, "ReturnOtherTaxBase", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("taxableamt")));
            this.writeTagXML(this.writer, "ReturnOtherTaxBaseCheck", "False");
            this.writeTagXML(this.writer, "ReturnVAT", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("totaltaxamt")));
            this.writeTagXML(this.writer, "ReturnSTLG", EFakturUtil.formatNumericXML(this.qdsDetail.getBigDecimal("ppnbm")));
            this.writer.append("</Rows>");
            this.writer.append('\n');
        }
        this.writer.append("<FooterRow>");
        this.writer.append('\n');
        this.writeTagXML(this.writer, "ReturnTaxBaseTotal", ReturnTaxBase);
        this.writeTagXML(this.writer, "ReturnOtherTaxBaseTotal", ReturnOtherTaxBase);
        this.writeTagXML(this.writer, "ReturnVATTotal", ReturnVAT);
        this.writeTagXML(this.writer, "ReturnSTLGTotal", ReturnSTLG);
        this.writer.append("</FooterRow>");
        this.writer.append('\n');
        this.writer.append("</TransactionDetailsData>");
        this.writer.append('\n');
        this.writer.append("</InputReturnData>");
        this.writer.append('\n');
    }

    private void setValueXML() throws IOException {
        for (int i = 0; i < this.qdsMaster.getRowCount(); ++i) {
            this.qdsMaster.goToRow(i);
            try {
                this.taxstatus.LoadID(this.qdsMaster.getString("sretno"));
                this.taxstatus.addNewRow(this.qdsMaster.getString("sretno"), "S");
                this.setDetailXML(this.qdsMaster.getString("sretno"));
                this.taxstatus.saveChanges();
                this.TxtLog.append(String.format("Export baris ke-%s, %s ... BERHASIL\n", i + 1, this.qdsMaster.getString("sretno")));
                ++this.success;
                continue;
            }
            catch (Exception ex) {
                this.TxtLog.append(String.format("Export baris ke-%s, %s ... GAGAL\n", i, BHelp.getExceptionDetail((Exception)ex)));
                logger.error(String.format("Baris %d, ERROR: %s\n", i, BHelp.getExceptionDetail((Exception)ex)));
                ++this.error;
            }
        }
    }
}

