/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.exportefaktur.util;

import com.bits.bee.exportefaktur.ui.FrmBulkUpdateNpwpBP;
import com.bits.bee.ui.FrmCompany;
import com.bits.bee.ui.ScreenManager;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class EFakturUtil {
    private static DecimalFormat fDecimal = new DecimalFormat("###0.####");

    public static String formatName(String bpname, String taxnikname, String taxregname, String nik, String npwp) {
        String type = "BP";
        if (npwp != null && npwp.trim().length() > 0) {
            if (null != taxregname && taxregname.trim().length() > 0) {
                type = "NPWP";
            } else if (null != taxnikname && taxnikname.trim().length() > 0) {
                type = "NIK";
            }
        } else if (nik != null && nik.trim().length() > 0) {
            if (null != taxnikname && taxnikname.trim().length() > 0) {
                type = "NIK";
            } else if (null != taxregname && taxregname.trim().length() > 0) {
                type = "NPWP";
            }
        } else if (null != taxregname && taxregname.trim().length() > 0) {
            type = "NPWP";
        } else if (null != taxnikname && taxnikname.trim().length() > 0) {
            type = "NIK";
        }
        if (type.equals("NPWP") && null != taxregname && taxregname.trim().length() > 0) {
            return BHelp.QuoteDouble((String)taxregname);
        }
        if (type.equals("NIK") && null != taxnikname && taxnikname.trim().length() > 0) {
            return BHelp.QuoteDouble((String)taxnikname);
        }
        return BHelp.QuoteDouble((String)bpname);
    }

    public static String normalizeNPWPOrFP(String npwpOrFP, boolean npwp) {
        if (null != npwpOrFP && npwpOrFP.trim().length() > 0) {
            return BHelp.QuoteDouble((String)npwpOrFP.replaceAll("\\D", ""));
        }
        if (npwp) {
            return BHelp.QuoteDouble((String)"000000000000000");
        }
        return BHelp.QuoteDouble((String)"");
    }

    public static String normalizeNPWPOrFP(String npwpOrFP) {
        return EFakturUtil.normalizeNPWPOrFP(npwpOrFP, false);
    }

    public static String normalizeNPWP(String nik, String npwp) {
        String npwp_Normalize = null;
        if (null != npwp && npwp.trim().length() > 0) {
            npwp_Normalize = npwp.replaceAll("\\D", "");
        }
        if (npwp_Normalize != null) {
            if (npwp_Normalize.length() < 16) {
                int length = npwp_Normalize.length();
                for (int i = 0; i < 16 - length; ++i) {
                    npwp_Normalize = "0" + npwp_Normalize;
                }
            }
            return BHelp.QuoteDouble((String)npwp_Normalize);
        }
        if (null != nik && nik.trim().length() > 0) {
            return BHelp.QuoteDouble((String)nik);
        }
        return BHelp.QuoteDouble((String)"0000000000000000");
    }

    public static String getTIN(String npwp, boolean zeroOnEmpty) {
        if (null != npwp && npwp.trim().length() > 0) {
            return npwp.replaceAll("\\D", "");
        }
        if (zeroOnEmpty) {
            return "0000000000000000";
        }
        return null;
    }

    public static String getTIN(String nik, String npwp, boolean zeroOnEmpty) {
        if (null != npwp && npwp.trim().length() > 0) {
            return EFakturUtil.getTIN(npwp, false);
        }
        if (null != nik && nik.trim().length() > 0) {
            return nik;
        }
        if (zeroOnEmpty) {
            return "0000000000000000";
        }
        return null;
    }

    public static String getNITKU(String npwp, boolean zeroOnEmpty) {
        String tin = EFakturUtil.getTIN(npwp, zeroOnEmpty);
        if (tin != null && tin.length() > 0) {
            tin = tin + "000000";
        }
        return tin;
    }

    public static String getNITKU(String nik, String npwp, boolean zeroOnEmpty) {
        String tin = EFakturUtil.getTIN(nik, npwp, zeroOnEmpty);
        if (tin != null && tin.length() > 0) {
            tin = tin + "000000";
        }
        return tin;
    }

    public static String getOptGoodService(String itemtype) {
        if (itemtype != null && itemtype.equals("SERV")) {
            return "B";
        }
        return "A";
    }

    public static String getUnitGoodService(String itemtype) {
        if (itemtype != null && itemtype.equals("SERV")) {
            return "UM.0033";
        }
        return "UM.0021";
    }

    public static String formatNumericXML(BigDecimal input) {
        String string = fDecimal.format(EFakturUtil.setScalingXML(input));
        if (string != null && !string.isEmpty()) {
            String decimalSeparator = String.valueOf(DecimalFormatSymbols.getInstance(Locale.getDefault()).getDecimalSeparator());
            if (!decimalSeparator.equals(".")) {
                string = string.replaceAll(decimalSeparator, ".");
            }
            string = string.replaceAll(",", ".");
        }
        return string;
    }

    public static BigDecimal setScalingXML(BigDecimal bigDec) {
        return EFakturUtil.setScaling(bigDec, 2, 4);
    }

    public static BigDecimal setScaling(BigDecimal bigDec, int scale, int roundMode) {
        return bigDec.setScale(scale, roundMode);
    }

    public static String formatXML(String value) {
        if (value != null && value.length() > 0) {
            return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return value;
    }

    public static String normalizeFP(String fp) {
        if (null != fp && fp.trim().length() > 0) {
            return BHelp.QuoteDouble((String)fp.replaceAll("\\D", "").substring(4));
        }
        return BHelp.QuoteDouble((String)"");
    }

    public static String normalizeZipCode(String zipCode) {
        if (null != zipCode && zipCode.trim().length() > 0) {
            return BHelp.QuoteDouble((String)zipCode);
        }
        return BHelp.QuoteDouble((String)"00000");
    }

    public static String normalizeCode(String itemCode) {
        return BHelp.QuoteDouble((String)itemCode);
    }

    public static String normalizeNumericValue(String numeric) {
        return BHelp.QuoteDouble((String)numeric);
    }

    public static String replaceEmptyWithDash(String replaceable) {
        if (null != replaceable && replaceable.trim().length() > 0) {
            return BHelp.QuoteDouble((String)replaceable);
        }
        return BHelp.QuoteDouble((String)"-");
    }

    public static String replaceEmptyWithZero(String replaceable) {
        if (null != replaceable && replaceable.trim().length() > 0) {
            return BHelp.QuoteDouble((String)replaceable);
        }
        return "0";
    }

    public static String roundDownBigDecimalValue(BigDecimal value) {
        return BHelp.QuoteDouble((String)String.valueOf(value.setScale(0, RoundingMode.FLOOR)));
    }

    public static boolean isExistNIKOrNPWPBP() {
        boolean status = false;
        try {
            QueryDataSet qds = new QueryDataSet();
            String sql = "SELECT taxnikno, taxnikname, taxregname FROM bp LIMIT 1";
            if (qds.isOpen()) {
                qds.close();
            }
            qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql));
            qds.open();
            status = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    public static boolean checkEmptyNpwp(boolean npwpCmpEmpty, String bpidSumComa_NpwpEmpty) {
        boolean value = true;
        if (npwpCmpEmpty || bpidSumComa_NpwpEmpty != null && bpidSumComa_NpwpEmpty.length() > 0) {
            Object[] choices;
            String msg;
            int option;
            if (npwpCmpEmpty && (option = EFakturUtil.showWarningDialog("Peringatan", msg = "<html>Yakin lanjut ekspor faktur dengan data NPWP Perusahaan kosong?<br>Proses ini berkemungkinan akan membuat gagal approve di efaktur.<br>Mulai update atau isi NPWP perusahaan anda yang kosong sekarang?</html>", choices = new Object[]{"Lewati, Tetap Ekspor", "Update Sekarang"})) == 1) {
                int tabCount;
                value = false;
                FrmCompany frmCompany = new FrmCompany();
                JTabbedPane jTabbedPane = EFakturUtil.getJTabbedPaneomponent((Container)frmCompany);
                if (jTabbedPane != null && (tabCount = jTabbedPane.getTabCount()) > 0) {
                    jTabbedPane.setSelectedIndex(1);
                }
                ScreenManager.getMainFrame().addInternalFrame((JInternalFrame)frmCompany);
            }
            if (value && bpidSumComa_NpwpEmpty != null && bpidSumComa_NpwpEmpty.length() > 0 && (option = EFakturUtil.showWarningDialog("Peringatan", msg = "<html>Yakin lanjut ekspor faktur dengan data NPWP/NIK Mitra Bisnis kosong?<br>Proses ini berkemungkinan akan membuat gagal approve di efaktur.<br>Mulai update atau isi NPWP/NIK dari Mitra Bisnis anda yang kosong sekarang?</html>", choices = new Object[]{"Lewati, Tetap Ekspor", "Update Sekarang"})) == 1) {
                value = false;
                FrmBulkUpdateNpwpBP frmBulkUpdateNpwpBP = new FrmBulkUpdateNpwpBP(bpidSumComa_NpwpEmpty);
                ScreenManager.getMainFrame().addInternalFrame((JInternalFrame)frmBulkUpdateNpwpBP);
                frmBulkUpdateNpwpBP.doEdit();
            }
        }
        return value;
    }

    public static int showWarningDialog(String title, String msg, Object[] choices) {
        Object defaultChoice = choices[0];
        int option = JOptionPane.showOptionDialog(ScreenManager.getParent(), msg, title, 0, 2, null, choices, defaultChoice);
        return option;
    }

    private static JTabbedPane getJTabbedPaneomponent(Container comp) {
        for (Component c : comp.getComponents()) {
            JTabbedPane creturn;
            if (c instanceof JTabbedPane) {
                return (JTabbedPane)c;
            }
            if (!(c instanceof Container) || (creturn = EFakturUtil.getJTabbedPaneomponent((Container)c)) == null) continue;
            return creturn;
        }
        return null;
    }
}

