/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.plugin.plugin.hargaminimal.maximal.bl;

import com.bits.bee.bl.Hashing;
import com.bits.bee.bl.PriceUtil;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.WhList;
import com.bits.bee.plugin.plugin.hargaminimal.maximal.ui.abstraction.PriceListAbstractCustom;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.CalcFieldsListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.Resolver;
import com.borland.dx.dataset.ResolverListener;
import com.borland.dx.dataset.ResolverResponse;
import com.borland.dx.sql.dataset.QueryResolver;
import com.borland.jb.util.ErrorResponse;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceListCustom
extends PriceListAbstractCustom
implements CalcFieldsListener,
ResourceGetter,
ResolverListener {
    private static final Logger logger = LoggerFactory.getLogger(PriceListCustom.class);
    public static final int MARGIN_HPP = 0;
    public static final int MARGIN_LASTPURC = 1;
    private int marginMode;
    private final LocaleInstance l = LocaleInstance.getInstance();
    private final String[] filterHPP = new String[]{"", "prc.price1 < Round((select * from fUnitCost(i.itemid," + BHelp.QuoteSingle((String)Reg.getInstance().getValueString("WHSTOCK")) + ",NULL,i.unit1)))", "prc.price1 > Round((select * from fUnitCost(i.itemid," + BHelp.QuoteSingle((String)Reg.getInstance().getValueString("WHSTOCK")) + ",NULL,i.unit1)))"};
    private boolean hash = false;
    private boolean isFirst = true;
    private final QueryResolver resolver = new QueryResolver();
    private int scale;
    private int roundingMode;
    private String group;
    private final NumberFormat formatter = NumberFormat.getInstance();
    private String stockColumn;
    private final ArrayList<String> stockList = new ArrayList();
    private final ArrayList<String> fieldName = new ArrayList();

    public PriceListCustom() {
        this.basesql = "SELECT i.itemid, i.itemdesc, i.unitdesc, it.itgrpname AS itgrpid, bd.brandname AS brandid, m.modelname AS modelid, i.grade, prc.crcid, prc.prclvlid, prc.price1, minprice, maxprice, prc.disc1exp, prc.price2, prc.disc2exp, prc.price3, prc.disc3exp, tax.taxexp, CAST(ROUND((SELECT * FROM fUnitCost(i.itemid," + BHelp.QuoteSingle((String)Reg.getInstance().getValueString("WHSALE")) + ",NULL,i.unit1)), " + Reg.getInstance().getValueString("ROUND") + ") AS NUMERIC(19,4)) AS cost, " + "prc.lastavgcost, " + "(SELECT * FROM fQtyStockDesc(i.itemid)) AS qty, fstocklocation(i.itemid) AS location, prc.lastpurcprice, " + "ROUND(flastpurccrcunit1(i.itemid, prc.crcid), 0) AS lastpurc, prc.usrid, i.conv2, i.conv3, " + "prclvl.prclvldesc " + "FROM item i " + "LEFT JOIN tax ON i.saletaxid=tax.taxid AND i.saletaxid='PPN' " + "LEFT JOIN prc on i.itemid=prc.itemid " + "JOIN prclvl ON prc.prclvlid=prclvl.prclvlid " + "LEFT JOIN brand bd ON i.brandid=bd.brandid " + "LEFT JOIN model m ON i.modelid=m.modelid " + "LEFT JOIN itgrp it ON i.itgrpid=it.itgrpid ";
        this.setBaseSQL(this.basesql);
        this.dataset.setResolvable(true);
        this.dataset.setTableName("prc");
        this.dataset.setMetaDataUpdate(0);
        this.initBTable();
    }

    private void initBTable() {
        this.AddCalcColumn("avgcost", this.getResourcesBL("col.avgcost"), 16);
        this.AddCalcColumn("marginstatus", this.getResourcesBL("col.avgcost"), 16);
        this.AddCalcColumn("profitmargin", this.getResourcesBL("col.profitmargin"), 16);
        this.createDataSet();
        this.hm = JBSQL.ColumnsToHashMap((Column[])this.dataset.getColumns());
        try {
            this.getStorageDataSet().addCalcFieldsListener((CalcFieldsListener)this);
        }
        catch (DataSetException ex) {
            logger.error("DataSet Exception", (Throwable)ex);
        }
        catch (TooManyListenersException ex) {
            logger.error("TooManyListenerException", (Throwable)ex);
        }
        this.initColumns();
        this.scale = 4;
        this.roundingMode = 4;
        this.setMarginMode(0);
    }

    private void initMarginMode() {
        this.setMarginMode(0);
    }

    private void initListener() {
        try {
            this.getStorageDataSet().addCalcFieldsListener((CalcFieldsListener)this);
        }
        catch (DataSetException ex) {
            logger.error("DataSet Exception", (Throwable)ex);
        }
        catch (TooManyListenersException ex) {
            logger.error("TooManyListenerException", (Throwable)ex);
        }
    }

    private void addAdditionalColumn() {
        this.AddCalcColumn("avgcost", this.getResourcesBL("col.avgcost"), 16);
        this.AddCalcColumn("marginstatus", this.getResourcesBL("col.avgcost"), 16);
        this.AddCalcColumn("profitmargin", this.getResourcesBL("col.profitmargin"), 16);
    }

    public void open() {
        super.open();
    }

    private String getQueryWh() {
        DataSet ds = WhList.getInstance((String)BAuthMgr.getDefault().getUserID()).getDataSet();
        int rowCount = ds.getRowCount();
        StringBuilder query = new StringBuilder();
        StringBuilder columnName = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            ds.goToRow(i);
            String columnAlias = String.format("stock_%s", ds.getString("whname")).replace(" ", "_");
            String nameField = String.format("Stock %s", ds.getString("whname"));
            this.stockList.add(columnAlias);
            this.fieldName.add(nameField);
            query.append(String.format("SUM(CASE WHEN whid='%s' THEN qty ELSE null END) AS %s,", ds.getString("whid"), columnAlias));
            if (i == 0) {
                columnName.append(columnAlias);
                continue;
            }
            columnName.append(",").append(columnAlias);
        }
        this.stockColumn = columnName.toString();
        return query.toString();
    }

    public String getStockname() {
        return this.stockColumn;
    }

    public ArrayList<String> getStockList() {
        return this.stockList;
    }

    public ArrayList<String> getFieldName() {
        return this.fieldName;
    }

    public void setHashing(boolean dohash) {
        this.hash = dohash;
    }

    public String getFilterHPP(int index) {
        return this.filterHPP[index];
    }

    private void initColumns() {
        this.dataset.setRowId("itemid", true);
        this.dataset.setRowId("prclvlid", true);
        this.dataset.setRowId("crcid", true);
        this.dataset.getColumn("price1").setResolvable(true);
        this.dataset.getColumn("price2").setResolvable(true);
        this.dataset.getColumn("minprice").setResolvable(true);
        this.dataset.getColumn("maxprice").setResolvable(true);
        this.dataset.getColumn("price3").setResolvable(true);
        this.dataset.getColumn("disc1exp").setResolvable(true);
        this.dataset.getColumn("disc2exp").setResolvable(true);
        this.dataset.getColumn("disc3exp").setResolvable(true);
        this.dataset.getColumn("usrid").setResolvable(true);
    }

    private void initResolvable() {
        for (int i = 0; i < this.dataset.getColumnCount(); ++i) {
            this.dataset.getColumn(i).setResolvable(false);
        }
        this.dataset.getColumn("minprice").setTableName("prc");
        this.dataset.getColumn("minprice").setResolvable(true);
        this.dataset.getColumn("maxprice").setTableName("prc");
        this.dataset.getColumn("maxprice").setResolvable(true);
        this.dataset.getColumn("price1").setTableName("prc");
        this.dataset.getColumn("price1").setResolvable(true);
        this.dataset.getColumn("price2").setTableName("prc");
        this.dataset.getColumn("price2").setResolvable(true);
        this.dataset.getColumn("price3").setTableName("prc");
        this.dataset.getColumn("price3").setResolvable(true);
        this.dataset.getColumn("disc1exp").setTableName("prc");
        this.dataset.getColumn("disc1exp").setResolvable(true);
        this.dataset.getColumn("disc2exp").setTableName("prc");
        this.dataset.getColumn("disc2exp").setResolvable(true);
        this.dataset.getColumn("disc3exp").setTableName("prc");
        this.dataset.getColumn("disc3exp").setResolvable(true);
        this.dataset.getColumn("lastpurcprice").setTableName("prc");
        this.dataset.getColumn("lastpurcprice").setResolvable(true);
        this.dataset.getColumn("lastavgcost").setTableName("prc");
        this.dataset.getColumn("lastavgcost").setResolvable(true);
        this.dataset.getColumn("usrid").setTableName("prc");
        this.dataset.getColumn("usrid").setResolvable(true);
        this.resolver.setDatabase(BDM.getDefault().getDatabase());
        this.dataset.setResolver((Resolver)this.resolver);
        try {
            if (this.isFirst) {
                this.resolver.addResolverListener((ResolverListener)this);
                this.isFirst = false;
            }
        }
        catch (TooManyListenersException ex) {
            logger.error("", (Throwable)ex);
        }
    }

    @Override
    public void Load() {
        super.Load();
        this.initColumns();
        this.initResolvable();
    }

    public void calcFields(ReadRow readRow, DataRow dataRow, boolean b) {
        if (BAuthMgr.getDefault().getAuth("816001", "HPP")) {
            dataRow.setString("avgcost", this.formatter.format(readRow.getBigDecimal("cost").intValue()));
        } else if (this.hash) {
            dataRow.setString("avgcost", Hashing.getInstance().doHash(readRow.getString("avgcost")));
        }
        if (this.marginMode == 0) {
            int compare;
            dataRow.setString("profitmargin", PriceUtil.getProfitMargin((BigDecimal)readRow.getBigDecimal("price1"), (BigDecimal)readRow.getBigDecimal("cost"), (int)this.scale, (int)this.roundingMode));
            int n = compare = readRow.getBigDecimal("lastavgcost").compareTo(BigDecimal.ZERO) == 0 ? 0 : readRow.getBigDecimal("cost").compareTo(readRow.getBigDecimal("lastavgcost"));
            if (compare > 0) {
                dataRow.setString("marginstatus", "DOWN");
            } else if (compare < 0) {
                dataRow.setString("marginstatus", "UP");
            } else {
                dataRow.setString("marginstatus", "SAME");
            }
        } else if (this.marginMode == 1) {
            int compare;
            dataRow.setString("profitmargin", PriceUtil.getProfitMargin((BigDecimal)readRow.getBigDecimal("price1"), (BigDecimal)readRow.getBigDecimal("lastpurc"), (int)this.scale, (int)this.roundingMode));
            int n = compare = readRow.getBigDecimal("lastpurcprice").compareTo(BigDecimal.ZERO) == 0 ? 0 : readRow.getBigDecimal("lastpurc").compareTo(readRow.getBigDecimal("lastpurcprice"));
            if (compare > 0) {
                dataRow.setString("marginstatus", "DOWN");
            } else if (compare < 0) {
                dataRow.setString("marginstatus", "UP");
            } else {
                dataRow.setString("marginstatus", "SAME");
            }
        }
    }

    public void setMarginMode(int marginMode) {
        this.marginMode = marginMode;
    }

    @Override
    public String getResourcesUI(String key) {
        return this.l.getMessageUI(((Object)((Object)this)).getClass(), key);
    }

    @Override
    public String getResourcesBL(String key) {
        return this.l.getMessageBL(((Object)((Object)this)).getClass(), key);
    }

    @Override
    public String getResourcesLib(String key) {
        return this.l.getMessageLib(((Object)((Object)this)).getClass(), key);
    }

    public void updateError(DataSet dataSet, ReadWriteRow readWriteRow, ReadRow readRow, ReadWriteRow readWriteRow0, DataSetException dataSetException, ErrorResponse errorResponse) {
    }

    public void deleteError(DataSet dataSet, ReadWriteRow readWriteRow, DataSetException dataSetException, ErrorResponse errorResponse) throws DataSetException {
    }

    public void insertError(DataSet dataSet, ReadWriteRow readWriteRow, DataSetException dataSetException, ErrorResponse errorResponse) {
    }

    public void updatedRow(ReadWriteRow readWriteRow, ReadRow readRow) {
    }

    public void deletedRow(ReadWriteRow readWriteRow) {
    }

    public void insertedRow(ReadWriteRow readWriteRow) {
    }

    public void updatingRow(ReadWriteRow readWriteRow, ReadRow readRow, ResolverResponse resolverResponse) {
        readWriteRow.setString("usrid", BAuthMgr.getDefault().getUserID());
        readWriteRow.setBigDecimal("lastpurcprice", readRow.getBigDecimal("lastpurc"));
        readWriteRow.setBigDecimal("lastavgcost", readRow.getBigDecimal("cost"));
    }

    public void deletingRow(ReadWriteRow readWriteRow, ResolverResponse resolverResponse) throws DataSetException {
    }

    public void insertingRow(ReadWriteRow readWriteRow, ResolverResponse resolverResponse) {
    }

    private void initGroupBy() {
        this.group = "prc.prclvlid ,it.itgrpname, bd.brandname, i.itemid, i.itemdesc, i.unitdesc, m.modelname, i.grade, prc.crcid, prclvl.prclvldesc, prc.price1, prc.disc1exp, prc.price2, prc.disc2exp, prc.price3, prc.disc3exp, tax.taxexp, CAST(ROUND((SELECT * FROM fUnitCost(i.itemid,E'01',NULL,i.unit1))) AS NUMERIC(19,4)), prc.lastavgcost, fstocklocation(i.itemid), prc.lastpurcprice, ROUND(flastpurccrcunit1(i.itemid, prc.crcid), 0), prc.usrid, i.conv2, i.conv3, prclvl.prclvldesc, i.unit1 ";
        this.setGroupby(this.group);
    }
}

