/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.plugin.plugin.hargaminimal.maximal.ui.abstraction;

import com.bits.bee.bl.Reg;
import com.bits.bee.bl.abstraction.PriceListFilter;
import com.bits.bee.plugin.plugin.hargaminimal.maximal.bl.PriceListFilterCustom;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BQuery;
import com.bits.lib.dx.JBSQL;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.bits.lib.security.ItemBranchPrvChecker;
import com.borland.dx.dataset.Column;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openide.util.Lookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PriceListAbstractCustom
extends BQuery
implements ResourceGetter {
    private static final Logger logger = LoggerFactory.getLogger(PriceListAbstractCustom.class);
    private StringBuffer classSQL;
    private StringBuffer filter = new StringBuffer();
    private String groupby;
    private String orderby;
    protected String baseSQL;
    protected HashMap hm;
    private final LocaleInstance l = LocaleInstance.getInstance();
    ItemBranchPrvChecker itemBPC = (ItemBranchPrvChecker)Lookup.getDefault().lookup(ItemBranchPrvChecker.class);
    private final List<PriceListFilter> filters = new ArrayList<PriceListFilter>();

    public PriceListAbstractCustom() {
        super(BDM.getDefault());
    }

    public void Load() {
        this.beforeLoad();
        this.classSQL = new StringBuffer(this.basesql);
        this.orderby = "prc.prclvlid, brandid, " + Reg.getInstance().getValueString("ITEM_ORDER") + ", prc.crcid";
        if (this.filter != null && this.filter.length() > 0) {
            JBSQL.setWHERE((StringBuffer)this.classSQL, (StringBuffer)this.filter);
        }
        if (null != this.groupby && this.groupby.length() > 0) {
            JBSQL.setGROUPBY((StringBuffer)this.classSQL, (String)this.groupby);
        }
        if (this.orderby.length() > 0) {
            JBSQL.setORDERBY((StringBuffer)this.classSQL, (String)this.orderby);
        }
        this.setSQL(this.classSQL.toString());
        this.open();
    }

    public Column getColumn(String colname) {
        return (Column)this.hm.get(colname);
    }

    public void setGroupBy(String whid) {
        this.groupby = "prc.prclvlid , bd.brandname, i.itemid, i.itemdesc, i.unitdesc, m.modelname, i.grade, prc.crcid, prclvl.prclvldesc, prc.price1, prc.disc1exp, prc.price2, prc.disc2exp, prc.price3, prc.disc3exp, tax.taxexp, CAST(ROUND((SELECT * FROM fUnitCost(i.itemid," + BHelp.QuoteSingle((String)whid) + ",NULL,i.unit1))) AS NUMERIC(19,4)), " + "prc.lastavgcost, (SELECT * FROM fQtyStockDesc(i.itemid," + BHelp.QuoteSingle((String)whid) + ")), fstocklocation(i.itemid), " + "prc.lastpurcprice, ROUND(flastpurccrcunit1(i.itemid, prc.crcid), 0), prc.usrid, i.conv2, i.conv3, prc.minprice, prc.maxprice ";
    }

    public void FilterReset() {
        this.filter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)"i.issale=TRUE AND (i._xt!=true OR (i.itemid<>'0' AND i.itemid<>'-1'))");
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)"i.itemid<>'0' AND i.itemid<>'-1'");
    }

    public void FilterPrcLevel(String prclvlid) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("prc.prclvlid='" + prclvlid + "'"));
    }

    public void FilterCrcID(String crcid) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("prc.crcid='" + crcid + "'"));
    }

    public void FilterItemIDLike(String itemid) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("upper(i.itemid) like upper('%" + itemid + "%')"));
    }

    public void FilterItemDescLike(String itemdesc) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("upper(itemdesc) like upper('%" + itemdesc + "%')"));
    }

    public void FilterItGrpID(String itgrpid) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("i.itgrpid IN (select * from fitgrplist('" + itgrpid + "') f)"));
    }

    public void FilterItGrp2ID(String itgrp2id) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("upper(i.itgrp2id) like upper('" + itgrp2id + "')"));
    }

    public void FilterItGrp3ID(String itgrp3id) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("upper(i.itgrp3id) like upper('" + itgrp3id + "')"));
    }

    public void FilterModel(String model) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("i.modelid='" + model + "'"));
    }

    public void FilterMerk(String merk) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("i.brandid='" + merk + "'"));
    }

    public void FilterActive(boolean b) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("i.active='" + b + "'"));
    }

    public void FilterVendorIDLike(String id) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)String.format("i.vendorid=%s", BHelp.QuoteSingle((String)id)));
    }

    public void FilterItem(String start, String end, boolean enable) {
        if (enable) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)("i.itemid IN (SELECT DISTINCT d.itemid FROM purcd d JOIN purc p ON d.purcno=p.purcno WHERE purcdate>=" + start + " AND purcdate<=" + end + " AND p.isdraft=FALSE)"));
        }
    }

    public void FilterGradeLike(String grade) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("upper(grade) like upper('%" + grade + "%')"));
    }

    public void FilterNotZero(String whid) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("(SELECT * FROM fQtyStock(i.itemid," + BHelp.QuoteSingle((String)whid) + "))>0"));
    }

    public void FilterBelowHPP(String where) {
        if (where != null && where.length() > 0) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)where);
        }
    }

    public void FilterRangeDownHPP(BigDecimal range1) {
        if (range1 != null && range1.compareTo(BigDecimal.ZERO) > 0) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)("CAST(ROUND((SELECT * FROM fUnitCost(i.itemid," + BHelp.QuoteSingle((String)Reg.getInstance().getValueString("WHSALE")) + ",NULL,i.unit1))) AS NUMERIC(19,4)) >= " + range1 + ""));
        }
    }

    public void FilterRangeUpHPP(BigDecimal range2) {
        if (range2 != null && range2.compareTo(BigDecimal.ZERO) > 0) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)("CAST(ROUND((SELECT * FROM fUnitCost(i.itemid," + BHelp.QuoteSingle((String)Reg.getInstance().getValueString("WHSALE")) + ",NULL,i.unit1))) AS NUMERIC(19,4)) <= " + range2 + ""));
        }
    }

    public void FilterRangeDownLastPurcPrice(BigDecimal range1) {
        if (range1 != null && range1.compareTo(BigDecimal.ZERO) > 0) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)("CAST(ROUND(flastpurccrcunit1(i.itemid, prc.crcid), 0) AS NUMERIC(19,4)) >= " + range1 + ""));
        }
    }

    public void FilterRangeUpLastPurcPrice(BigDecimal range2) {
        if (range2 != null && range2.compareTo(BigDecimal.ZERO) > 0) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)("CAST(ROUND(flastpurccrcunit1(i.itemid, prc.crcid), 0) AS NUMERIC(19,4)) <= " + range2 + ""));
        }
    }

    public void FilterBranchPrv() {
        if (this.itemBPC.hasPrivillege()) {
            JBSQL.ANDFilter((StringBuffer)this.filter, (String)this.itemBPC.getFilter("i.itemid"));
        }
    }

    public void FilterBarcodeLike(String barcode) {
        JBSQL.ANDFilter((StringBuffer)this.filter, (String)("upper(barcode) like upper('%" + barcode + "%')"));
    }

    public void setVisibleColumn(String nmKolom, boolean b) throws Exception {
        int visible = 0;
        try {
            if (b) {
                visible = 1;
            }
            if (nmKolom.indexOf(",") > 0) {
                String[] columns;
                for (String column : columns = nmKolom.split(",")) {
                    this.dataset.getColumn(column).setVisible(visible);
                }
            } else {
                this.dataset.getColumn(nmKolom).setVisible(visible);
            }
        }
        catch (Exception e) {
            logger.error("Set Visible Error", (Throwable)e);
        }
    }

    public String getQuery() {
        return this.classSQL.toString();
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(((Object)((Object)this)).getClass(), key);
    }

    public void setGroupby(String groupby) {
        this.groupby = groupby;
    }

    public String getGroupby() {
        return this.groupby;
    }

    private void beforeLoad() {
        for (PriceListFilterCustom priceListFilterCustom : this.filters) {
            priceListFilterCustom.doFilter(this, this.filter);
        }
    }
}

