/*
 * Decompiled with CFR 0.152.
 */
package com.bits.komisiprclvl.Object;

import com.bits.bee.komisi.base.BKomisiObject;
import com.bits.bee.komisi.base.BKomisiRule;
import com.bits.bee.komisi.base.BKomisiSubject;
import com.bits.bee.komisi.base.filter.BKomisiFilter;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KomisiObjectSale
implements BKomisiObject {
    private static Logger logger = LoggerFactory.getLogger(KomisiObjectSale.class);
    private QueryDataSet qds = new QueryDataSet();

    public DataSet getList(BKomisiSubject komisiSubject, BKomisiRule komisiRule, List<BKomisiFilter> filters) {
        if (null != komisiSubject && null != komisiRule && this.isRuleAccepted(komisiRule)) {
            StringBuffer filter = new StringBuffer();
            StringBuffer sql = new StringBuffer("SELECT m.saleno, d.saledno, d.itemid,d.itemdesc, qty, d.unit, funitindex(d.itemid,d.unit) as unitindex, m.crcid, (CAST ((CASE WHEN (m.total-m.paidamt)=0 THEN d.subtotal ELSE NULL END) AS NUMERIC (25,4))) AS subtotal, (CAST ((CASE WHEN (m.total-m.paidamt)=0 THEN d.listprice ELSE NULL END) AS NUMERIC (25,4))) AS listprice FROM saled d JOIN sale m ON d.saleno=m.saleno ");
            sql.append("JOIN komisiprclvl r ON r.itemid = d.itemid AND r.prclvlid = fprclvlid(m.custid) AND r.crcid=m.crcid ");
            JBSQL.ANDFilter((StringBuffer)filter, (String)String.format("m.%s=%s", komisiSubject.getSubjectColumn(), BHelp.QuoteSingle((String)komisiSubject.getSubjectValue())));
            JBSQL.ANDFilter((StringBuffer)filter, (String)filters.get(0).getFilter("m.saledate"));
            JBSQL.ANDFilter((StringBuffer)filter, (String)("(m.isdraft=false) AND r.type =" + BHelp.QuoteSingle((String)"ITEM")));
            JBSQL.ANDFilter((StringBuffer)filter, (String)(" r.ruleid=" + komisiRule.getRuleNo()));
            JBSQL.ANDFilter((StringBuffer)filter, (String)("m.crcid = " + BHelp.QuoteSingle((String)komisiRule.getCrc())));
            JBSQL.ANDFilter((StringBuffer)filter, (String)(" m.saleno NOT IN " + this.getExceptionGenerated(komisiRule.getRuleName(), komisiSubject.getSubjectValue())));
            JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
            JBSQL.setORDERBY((StringBuffer)sql, (String)"d.itemid");
            if (this.qds.isOpen()) {
                this.qds.close();
            }
            this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
            this.qds.open();
            return this.qds;
        }
        return null;
    }

    private String getExceptionGenerated(String RuleName, String SubjectValue) {
        StringBuffer sb = new StringBuffer("(Select distinct d.reftype from komisiprocess p JOIN komisiprocessd d ON  p.procsid = d.procsid JOIN komisi k ON k.procsid = p.procsid  where isgenerated=true and k.komisiitype=");
        sb.append(BHelp.QuoteSingle((String)RuleName)).append(" AND k.refno=").append(BHelp.QuoteSingle((String)SubjectValue));
        sb.append("AND k.reftype=").append(BHelp.QuoteSingle((String)"SREP")).append(")");
        return sb.toString();
    }

    public boolean isRuleAccepted(BKomisiRule komisiRule) {
        return "SALE".equals(komisiRule.getRuleType());
    }

    public BigDecimal getBaseAmount() {
        if (!this.qds.isNull("subtotal")) {
            return this.qds.getBigDecimal("subtotal");
        }
        return null;
    }

    public String getRefNo() {
        return this.qds.getString("itemid");
    }

    public String getReffProcess() {
        return this.qds.getString("saleno");
    }

    public short getReffNoProcess() {
        return this.qds.getShort("saledno");
    }

    public BigDecimal getItemPrice() {
        if (!this.qds.isNull("listprice")) {
            return this.qds.getBigDecimal("listprice");
        }
        return null;
    }

    public BigDecimal getQty() {
        return this.qds.getBigDecimal("qty");
    }

    public String getKomisiDesc() {
        return this.qds.getString("itemdesc");
    }

    public String getUnit() {
        return String.valueOf(this.qds.getShort("unitindex"));
    }

    public String getNote() {
        return null;
    }
}

