/*
 * Decompiled with CFR 0.152.
 */
package com.bits.komisiprclvl.Rule;

import com.bits.bee.bl.ItemList;
import com.bits.bee.komisi.base.BKomisiObject;
import com.bits.bee.komisi.base.BKomisiRule;
import com.bits.bee.komisi.base.BKomisiSubject;
import com.bits.bee.komisi.base.bl.KomisiProcessTrans;
import com.bits.bee.komisi.base.bl.KomisiTrans;
import com.bits.bee.komisi.base.filter.BKomisiFilter;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KomisiRuleReturSale
implements BKomisiRule {
    private static Logger logger = LoggerFactory.getLogger(BKomisiRule.class);
    private QueryDataSet qds = new QueryDataSet();

    public DataSet getList(BKomisiSubject komisiSubject, List<BKomisiFilter> filters) {
        StringBuffer sql = new StringBuffer("SELECT ruleid, itemid, prclvlid, crcid, komisiprc1, komisiprc2, komisiprc3, rulereq FROM komisiprclvl r");
        StringBuffer filter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)filter, (String)"r.isactive=TRUE");
        JBSQL.ANDFilter((StringBuffer)filter, (String)(" r.type=" + BHelp.QuoteSingle((String)"ITEM")));
        JBSQL.ANDFilter((StringBuffer)filter, (String)"( komisiprc1 IS NOT NULL OR komisiprc2 IS NOT NULL OR komisiprc3 IS NOT NULL)");
        JBSQL.setWHERE((StringBuffer)sql, (StringBuffer)filter);
        JBSQL.setORDERBY((StringBuffer)sql, (String)"itemid");
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        this.qds.open();
        return this.qds;
    }

    public String getJoinTable() {
        return "komisiprclvl";
    }

    public String getJoinColumn() {
        return "itemid";
    }

    public String getRuleType() {
        return "SALERETUR";
    }

    public String getExpression() {
        String komisiprc1 = this.qds.getString("komisiprc1") != null && this.qds.getString("komisiprc1").length() > 0 ? this.qds.getString("komisiprc1") : "0";
        String komisiprc2 = this.qds.getString("komisiprc2") != null && this.qds.getString("komisiprc2").length() > 0 ? this.qds.getString("komisiprc2") : "0";
        String komisiprc3 = this.qds.getString("komisiprc3") != null && this.qds.getString("komisiprc3").length() > 0 ? this.qds.getString("komisiprc3") : "0";
        return komisiprc1 + ";" + komisiprc2 + ";" + komisiprc3;
    }

    public Long getRuleNo() {
        return this.qds.getLong("ruleid");
    }

    public String getRuleName() {
        return "KomisiSaleRetur-1.0";
    }

    public boolean calcValue(KomisiTrans komisiTrans, BKomisiObject komisiObject) {
        BigDecimal itemAmount;
        boolean generated = true;
        String expression = null;
        String[] getExp = this.getExpression().split(";");
        DataSet dataSet = komisiTrans.getDataSetDetail();
        dataSet.insertRow(false);
        dataSet.setString("komisino", komisiTrans.getDataSetMaster().getString("komisino"));
        dataSet.setShort("komisidno", (short)(dataSet.getRowCount() + 1));
        dataSet.setString("reftype", "ITEM");
        dataSet.setString("refno", komisiObject.getRefNo());
        if ("1".equalsIgnoreCase(komisiObject.getUnit())) {
            expression = getExp[0];
            dataSet.setString("unit", ItemList.getInstance().getUnit1(komisiObject.getRefNo()));
        } else if ("2".equalsIgnoreCase(komisiObject.getUnit())) {
            expression = getExp[1];
            dataSet.setString("unit", ItemList.getInstance().getUnit2(komisiObject.getRefNo()));
        } else if ("3".equalsIgnoreCase(komisiObject.getUnit())) {
            expression = getExp[2];
            dataSet.setString("unit", ItemList.getInstance().getUnit3(komisiObject.getRefNo()));
        }
        dataSet.setString("komisiexp", expression);
        if ("ITEM".equalsIgnoreCase(this.getImplementation())) {
            itemAmount = komisiObject.getItemPrice();
            if (itemAmount == null) {
                dataSet.setBigDecimal("komisibaseamt", BigDecimal.ZERO);
                dataSet.setBigDecimal("komisiamt", BigDecimal.ZERO);
            } else {
                dataSet.setBigDecimal("komisibaseamt", itemAmount.multiply(komisiObject.getQty()));
                dataSet.setBigDecimal("komisiamt", BHelp.EvalDiscExp((BigDecimal)itemAmount, (String)expression).multiply(komisiObject.getQty()).multiply(new BigDecimal(-1)));
            }
        } else {
            itemAmount = komisiObject.getBaseAmount();
            if (itemAmount == null) {
                dataSet.setBigDecimal("komisibaseamt", BigDecimal.ZERO);
                dataSet.setBigDecimal("komisiamt", BigDecimal.ZERO);
            } else {
                dataSet.setBigDecimal("komisibaseamt", itemAmount);
                dataSet.setBigDecimal("komisiamt", BHelp.EvalDiscExp((BigDecimal)itemAmount, (String)expression).multiply(new BigDecimal(-1)));
            }
        }
        dataSet.setLong("ruleid", this.getRuleNo().longValue());
        dataSet.setBigDecimal("qty", komisiObject.getQty());
        dataSet.setString("komisiimp", this.getImplementation());
        dataSet.setString("reftrans", komisiObject.getReffProcess());
        dataSet.setString("komisidesc", "Retur " + komisiObject.getKomisiDesc());
        if (dataSet.getString("komisino").isEmpty() || dataSet.getString("komisino").length() <= 0 || itemAmount == null) {
            generated = false;
        }
        return generated;
    }

    public void insertProcessD(KomisiProcessTrans komisiProcessTrans, BKomisiObject komisiObject, Boolean isGenerated) {
        DataSet processDetail = komisiProcessTrans.getDataSetDetail();
        processDetail.insertRow(false);
        processDetail.setString("procsid", komisiProcessTrans.getDataSetMaster().getString("procsid"));
        processDetail.setShort("procsidno", (short)processDetail.getRowCount());
        processDetail.setString("reftype", komisiObject.getReffProcess());
        processDetail.setShort("refno", komisiObject.getReffNoProcess());
        processDetail.setBoolean("isprocessed", true);
        processDetail.setBoolean("isgenerated", isGenerated.booleanValue());
        if (!isGenerated.booleanValue()) {
            processDetail.setString("dnote", "Belum Lunas");
        }
    }

    public String getImplementation() {
        return this.qds.getString("rulereq");
    }

    public String getCrc() {
        return this.qds.getString("crcid");
    }
}

