/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pos.lang;

import com.bits.lib.i18n.LocaleManager;
import com.bits.lib.i18n.LocaleUpdater;
import com.bits.lib.i18n.MultiplePropertiesResourceBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocaleInstancePos
implements LocaleManager {
    private static LocaleInstancePos singleton;
    private Locale currentLocale;
    private ResourceBundle messagesLib;
    private ResourceBundle messagesBL;
    private ResourceBundle messagesUI;
    private MultiplePropertiesResourceBundle multipleBundle;
    private final ArrayList<LocaleUpdater> updaterList = new ArrayList();
    private final HashMap<String, String> libAdditionalMap = new HashMap();
    private final HashMap<String, String> blAdditionalMap = new HashMap();
    private final HashMap<String, String> uiAdditionalMap = new HashMap();

    public LocaleInstancePos() {
        this.initResources("in", "ID");
    }

    public static synchronized LocaleInstancePos getInstance() {
        if (singleton == null) {
            singleton = new LocaleInstancePos();
        }
        return singleton;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public ResourceBundle getMessagesLib() {
        return this.messagesLib;
    }

    public ResourceBundle getMessagesBL() {
        return this.messagesBL;
    }

    public ResourceBundle getMessagesUI() {
        return this.messagesUI;
    }

    private void initResources(String language, String country) {
        this.currentLocale = new Locale(language, country);
        this.messagesLib = ResourceBundle.getBundle("com/bits/bee/pos/lang/lib/MessageBundle", this.currentLocale);
        this.messagesBL = ResourceBundle.getBundle("com/bits/bee/pos/lang/bl/MessageBundle", this.currentLocale);
        this.messagesUI = ResourceBundle.getBundle("com/bits/bee/pos/lang/ui/MessageBundle", this.currentLocale);
        this.multipleBundle = new MultiplePropertiesResourceBundle("Bundle"){

            public Locale getLocale() {
                return LocaleInstancePos.this.currentLocale;
            }
        };
    }

    public String getMessageUI(Class clazz, String messageKey, String defaultValue) {
        try {
            String key = clazz == null ? String.format("Global.%s", messageKey) : String.format("%s.%s", clazz.getSimpleName(), messageKey);
            String bundleValue = this.uiAdditionalMap.get(key);
            if (null == bundleValue) {
                return this.messagesUI.getString(key);
            }
            return bundleValue;
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public String getMessageUI(Class clazz, String messageKey) {
        return this.getMessageUI(clazz, messageKey, messageKey + " = <null>");
    }

    public String getMessageBL(Class clazz, String messageKey, String defaultValue) {
        try {
            String key = clazz == null ? messageKey : String.format("%s.%s", clazz.getSimpleName(), messageKey);
            String bundleValue = this.blAdditionalMap.get(key);
            if (null == bundleValue) {
                return this.messagesBL.getString(key);
            }
            return bundleValue;
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public String getMessageBL(Class clazz, String messageKey) {
        return this.getMessageBL(clazz, messageKey, messageKey + " = <null>");
    }

    public String getMessageLib(Class clazz, String messageKey, String defaultValue) {
        try {
            String key = clazz == null ? messageKey : String.format("%s.%s", clazz.getSimpleName(), messageKey);
            String bundleValue = this.libAdditionalMap.get(key);
            if (null == bundleValue) {
                return this.messagesLib.getString(key);
            }
            return bundleValue;
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public String getMessageLib(Class clazz, String messageKey) {
        return this.getMessageLib(clazz, messageKey, messageKey + " = <null>");
    }

    public String getBundleMessage(String key) {
        return (String)this.multipleBundle.handleGetObject(key);
    }

    public void addLocaleUpdater(LocaleUpdater updater) {
        if (updater != null) {
            this.updaterList.add(updater);
        }
    }

    public void removeLocaleUpdater(LocaleUpdater updater) {
        int index = this.updaterList.indexOf(updater);
        if (index >= 0) {
            this.updaterList.remove(index);
        }
    }

    public void notifyUpdater() {
        for (LocaleUpdater updater : this.updaterList) {
            updater.updateLocale();
        }
    }

    public void putAdditionalLibResource(String key, String value) {
        this.libAdditionalMap.put(key, value);
    }

    public void putAdditionalBLResource(String key, String value) {
        this.blAdditionalMap.put(key, value);
    }

    public void putAdditionalUIResource(String key, String value) {
        this.uiAdditionalMap.put(key, value);
    }
}

