/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pos.ui;

import com.bits.bee.bl.XLSGenerator;
import com.bits.bee.pos.lang.LocaleInstancePos;
import com.bits.bee.ui.ScreenManager;
import com.bits.bee.ui.UIMgr;
import com.bits.lib.dbswing.JBPeriode;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import java.awt.Component;
import java.io.File;
import java.sql.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrmExportExcel
extends JFrame
implements ResourceGetter {
    private final JFileChooser xlsChooser;
    private final XLSGenerator xlsGen = new XLSGenerator();
    private static FrmExportExcel exportExcel = null;
    private QueryDataSet qds;
    private List<QueryDataSet> qdss;
    private final LocaleInstance l = LocaleInstance.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(FrmExportExcel.class);
    private final LocaleInstancePos lp = LocaleInstancePos.getInstance();

    public FrmExportExcel() {
        this.xlsChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XLS(*.xls)", "xls");
        this.xlsChooser.setFileFilter(filter);
        this.xlsChooser.setAcceptAllFileFilterUsed(false);
    }

    public static synchronized FrmExportExcel getInstance() {
        if (exportExcel == null) {
            exportExcel = new FrmExportExcel();
        }
        return exportExcel;
    }

    public void doExport(String name, JBPeriode jBOSPeriode, String[] header, QueryDataSet qds, String sheet) {
        this.setFileName(name, jBOSPeriode);
        this.doExport(header, qds, sheet);
    }

    public void doExport(String name, QueryDataSet qds) {
        this.doExport(name, null, null, qds, null);
    }

    public void doExport(String name, JBPeriode jBOSPeriode, QueryDataSet qds) {
        this.doExport(name, jBOSPeriode, null, qds, null);
    }

    public void setFileName(String name, JBPeriode jBOSPeriode) {
        String title = name;
        if (jBOSPeriode != null && (jBOSPeriode.getStartDate() != null || jBOSPeriode.getEndDate() != null)) {
            title = name + "-" + new Date(jBOSPeriode.getStartDate().getTime()).toString() + "-sd-" + new Date(jBOSPeriode.getEndDate().getTime()).toString();
        }
        this.xlsChooser.setSelectedFile(new File(title + ".xls"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport(String[] header, QueryDataSet qds, String sheet) {
        try {
            this.qds = qds;
            this.validateData();
            int retval = this.xlsChooser.showSaveDialog(this.getParent());
            if (retval == 0) {
                ScreenManager.setCursorThinking((JFrame)this);
                String namafile = this.xlsChooser.getSelectedFile().getAbsolutePath();
                if (namafile != null && namafile.length() > 0) {
                    File tmpDir;
                    boolean exists;
                    if (namafile.indexOf(".xls") < 0) {
                        namafile = namafile + ".xls";
                    }
                    if (exists = (tmpDir = new File(namafile)).exists()) {
                        if (UIMgr.YesNo((String)"Save", (String)this.getResourcesUI("ok.rplcxls")) == 0) {
                            this.generateToExcelByDirectory(header, sheet, namafile);
                            UIMgr.showMessageDialog((String)this.getResourcesUI("ok.savexls"), (Component)this);
                        }
                    } else {
                        this.generateToExcelByDirectory(header, sheet, namafile);
                        UIMgr.showMessageDialog((String)this.getResourcesUI("ok.savexls"), (Component)this);
                    }
                }
            }
        }
        catch (Exception ex) {
            UIMgr.showErrorDialog((String)this.getResourcesUI("ex.savexls"), (Exception)ex, (Component)this, (Logger)logger);
        }
        finally {
            ScreenManager.setCursorDefault((JFrame)this);
        }
    }

    private void validateData() throws Exception {
        if (this.qds.getRowCount() <= 0) {
            throw new Exception(this.getResourcesUI("ex.rowcount"));
        }
    }

    private void generateToExcelByDirectory(String[] header, String sheet, String fileLocation) {
        if (sheet == null) {
            sheet = "Worksheet";
        }
        this.xlsGen.createWorkBook(sheet);
        String[] headers = header;
        if (headers == null) {
            headers = this.qds.getColumnNames(this.qds.getColumnCount());
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = headers[i].replace("_", " ");
                headers[i] = WordUtils.capitalize((String)headers[i]);
            }
        }
        this.xlsGen.createHeader(headers);
        this.xlsGen.generateDataFromDataSet((DataSet)this.qds);
        if (fileLocation.indexOf(".xls") >= 0) {
            this.xlsGen.writeToChoosenDirectory(fileLocation);
        } else {
            this.xlsGen.writeToChoosenDirectory(fileLocation + ".xls");
        }
    }

    public String getResourcesUI(String key) {
        return this.lp.getMessageUI(this.getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.lp.getMessageBL(this.getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.lp.getMessageLib(this.getClass(), key);
    }
}

