/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pos.ui;

import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.CrcList;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Price;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.list.factory.IPriceList;
import com.bits.bee.bl.list.factory.IPriceListFactory;
import com.bits.bee.ui.myswing.PikItem;
import com.bits.lib.BHelp;
import com.bits.lib.abstraction.BUIResources;
import com.bits.lib.dbswing.JBdbTable;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.JBSQL;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class FrmPriceChecker
extends JInternalFrame
implements PropertyChangeListener {
    private final QueryDataSet qdsSingle = new QueryDataSet();
    private final QueryDataSet qdsAll = new QueryDataSet();
    private final DataSetView dsvAll = new DataSetView();
    private boolean toggle = false;
    private GroupLayout groupLayout;
    private JPanel currentPanel;
    private final NumberFormat formatter = NumberFormat.getInstance();
    private final IPriceList iPriceList = IPriceListFactory.getInstance().getIPriceList();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private PikItem pikItem1;
    private JBdbTable tblPrc;
    private JLabel txtAdvance;

    public FrmPriceChecker() {
        this.initComponents();
        this.initLayout();
        this.jLabel2.setText("");
        this.initListener();
        this.initKeyStroke();
    }

    private void initListener() {
        this.pikItem1.addPropertyChangeListener("pickerkey", (PropertyChangeListener)this);
    }

    private void initLayout() {
        this.groupLayout = (GroupLayout)this.jPanel2.getLayout();
        this.currentPanel = this.jPanel5;
    }

    private void initKeyStroke() {
        AbstractAction actF2 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmPriceChecker.this.focusPikItem(false);
            }
        };
        AbstractAction actF3 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FrmPriceChecker.this.toggle = !FrmPriceChecker.this.toggle;
                FrmPriceChecker.this.doToggle();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(113, 0), "F2");
        this.getRootPane().getActionMap().put("F2", actF2);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "F3");
        this.getRootPane().getActionMap().put("F3", actF3);
    }

    private void doToggle() {
        if (this.currentPanel == this.jPanel5) {
            this.groupLayout.replace(this.currentPanel, this.jPanel4);
            this.currentPanel = this.jPanel4;
        } else {
            this.groupLayout.replace(this.currentPanel, this.jPanel5);
            this.currentPanel = this.jPanel5;
        }
        this.pack();
        if (this.toggle) {
            this.txtAdvance.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/arrow_up.png")));
        } else {
            this.txtAdvance.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/arrow.png")));
        }
        this.focusPikItem(false);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (null != this.pikItem1) {
            this.focusPikItem(false);
        }
    }

    private String formatCurrency(BigDecimal input) {
        String string = this.formatter.format(input.intValue());
        return string;
    }

    private void LoadAll(String itemid) {
        this.loadSinglePrc(itemid);
        this.loadDetailPrc(itemid);
        if (itemid != null) {
            if (this.currentPanel == this.jPanel5) {
                this.groupLayout.replace(this.currentPanel, this.jPanel4);
                this.currentPanel = this.jPanel4;
                this.pack();
            }
            this.toggle = true;
            if (this.toggle) {
                this.txtAdvance.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/arrow_up.png")));
            } else {
                this.txtAdvance.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/arrow.png")));
            }
        }
    }

    private void focusPikItem(final boolean delay) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (delay) {
                        new Timer().schedule(new TimerTask(){

                            public void run() {
                                FrmPriceChecker.this.focusPikItem();
                            }
                        }, 100L);
                    } else {
                        FrmPriceChecker.this.focusPikItem();
                    }
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void focusPikItem() {
        try {
            this.requestFocus();
            this.pikItem1.requestFocus();
            this.pikItem1.requestFocusInWindow();
            this.pikItem1.getTextComponent().selectAll();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void loadSinglePrc(String itemid) {
        Price price = this.iPriceList.getPrice_BP(null, Cmp.getInstance().getCrcID(), itemid, BigDecimal.ONE, ItemList.getInstance().getUnit1(itemid), Reg.getInstance().getValueString("CUST_DEFAULT", "CASH"), null);
        BigDecimal amt = price.getListPrice();
        this.jLabel2.setText(String.format("%s. %s", CrcList.getInstance().getCrcSymbol(Cmp.getInstance().getCrcID()), this.formatCurrency(amt)));
    }

    private void loadDetailPrc(String itemid) {
        StringBuffer localSQL = new StringBuffer("select prc.prclvlid, lvl.prclvldesc, price1, price2, price3 FROM prc JOIN prclvl lvl ON lvl.prclvlid=prc.prclvlid ");
        StringBuffer localFilter = new StringBuffer();
        JBSQL.ANDFilter((StringBuffer)localFilter, (String)String.format("itemid=%s", BHelp.QuoteSingle((String)itemid)));
        JBSQL.ANDFilter((StringBuffer)localFilter, (String)String.format("crcid=%s", BHelp.QuoteSingle((String)Cmp.getInstance().getCrcID())));
        JBSQL.setWHERE((StringBuffer)localSQL, (StringBuffer)localFilter);
        JBSQL.setORDERBY((StringBuffer)localSQL, (String)"prc.prclvlid, lvl.prclvldesc");
        if (this.qdsAll.isOpen()) {
            this.qdsAll.close();
        }
        this.qdsAll.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), localSQL.toString()));
        this.qdsAll.open();
        this.initPrcTable();
        if (this.dsvAll.isOpen()) {
            this.dsvAll.close();
        }
        this.dsvAll.setStorageDataSet(this.qdsAll.getStorageDataSet());
        this.dsvAll.open();
    }

    private void initPrcTable() {
        StorageDataSet ds = this.qdsAll.getStorageDataSet();
        ds.getColumn("prclvlid").setVisible(0);
        ds.getColumn("prclvldesc").setWidth(8);
        ds.getColumn("prclvldesc").setCaption("Level Harga");
        ds.getColumn("price1").setWidth(10);
        ds.getColumn("price1").setCaption("Harga 1");
        ds.getColumn("price2").setWidth(10);
        ds.getColumn("price2").setCaption("Harga 2");
        ds.getColumn("price3").setWidth(10);
        ds.getColumn("price3").setCaption("Harga 3");
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblPrc = new JBdbTable();
        this.jLabel20 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pikItem1 = new PikItem();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.txtAdvance = new JLabel();
        this.jPanel5 = new JPanel();
        this.tblPrc.setDataSet((DataSet)this.dsvAll);
        this.tblPrc.setEditable(false);
        this.tblPrc.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                FrmPriceChecker.this.tblPrcKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.tblPrc);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 468, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE));
        this.setClosable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setTitle("Cek Harga | Kasir");
        this.jLabel20.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel20.setForeground(new Color(102, 102, 102));
        this.jLabel20.setText("Cek Harga");
        this.jPanel2.setBackground(new Color(204, 204, 204));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Filter", 0, 0, BUIResources.getDefaultFontBold()));
        this.jPanel1.setOpaque(false);
        this.jLabel1.setFont(new Font("Bitstream Vera Sans", 0, 11));
        this.jLabel1.setText("Kode Item (F2):");
        this.pikItem1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.pikItem1, -2, 342, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent((Component)this.pikItem1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBackground(new Color(0, 0, 0));
        this.jLabel2.setFont(new Font("Monospaced", 1, 30));
        this.jLabel2.setForeground(new Color(102, 255, 51));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("jLabel2");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 51, -2));
        this.txtAdvance.setFont(new Font("Dialog", 0, 12));
        this.txtAdvance.setIcon(new ImageIcon(this.getClass().getResource("/com/bits/bee/ui/myswing/images/icon/arrow.png")));
        this.txtAdvance.setText("<html><u>Detail (F3)</u></html>");
        this.txtAdvance.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FrmPriceChecker.this.txtAdvanceMouseClicked(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.txtAdvance, -2, -1, -2).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)).addGap(2, 2, 2))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtAdvance, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel20)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel20).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(15, 15, 15)));
        this.pack();
    }

    private void tblPrcKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 114) {
            this.toggle = !this.toggle;
            this.doToggle();
        } else if (evt.getKeyCode() == 113) {
            this.focusPikItem(false);
        }
    }

    private void txtAdvanceMouseClicked(MouseEvent evt) {
        this.toggle = !this.toggle;
        this.doToggle();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("pickerkey") && evt.getNewValue() != null) {
            this.LoadAll(evt.getNewValue().toString());
            this.focusPikItem(true);
        }
    }
}

