/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.CrcChangeAdapter;
import com.bits.bee.bl.CurrencyRateGetter;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.PrcList;
import com.bits.bee.bl.Price;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.Stock;
import com.bits.bee.bl.TransDetailMtd;
import com.bits.bee.bl.TransSetter;
import com.bits.bee.bl.abstraction.TriggerSaleItemChangedListener;
import com.bits.bee.bl.procedure.fQtyZToQty1;
import com.bits.bee.pluginpersewaan.bl.Booking;
import com.bits.bee.pluginpersewaan.bl.TransactionCalculatorBooking;
import com.bits.bee.pluginpersewaan.bl.TriggerSaleItemBookingChangedListener;
import com.bits.lib.BArrayString;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.exception.BDBExceptionHandler;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.i18n.ResourceGetter;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.Variant;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.logging.Level;
import org.openide.util.Lookup;
import org.slf4j.Logger;

public class BTSDetailBooking
extends BTable
implements TransDetailMtd,
TransSetter,
ResourceGetter {
    public TransactionCalculatorBooking tc = new TransactionCalculatorBooking();
    public CrcChangeAdapter crcChangeAdapter;
    public boolean taxed = false;
    public boolean taxInc = false;
    public boolean saving = false;
    public String vendorID;
    public CurrencyRateGetter rateGetter;
    public String lastUsedItem;
    public static Logger logger;
    public BDBExceptionHandler handler;
    public DataSetView dataClone;
    public Component nextfocuscomponent;
    public boolean found = false;
    public String lastunit = null;
    public String[] findCols;
    public boolean dataChanged = false;
    public boolean changeGranted = false;
    public String[] resetColumn;
    public BigDecimal oldTaxamt = BigDecimal.ZERO;
    public BigDecimal oldBaseTaxamt = BigDecimal.ZERO;
    public BigDecimal oldBaseFTaxamt = BigDecimal.ZERO;
    public BigDecimal oldSubtotal = BigDecimal.ZERO;
    public BigDecimal oldBaseSubtotal = BigDecimal.ZERO;
    public String oldItemID;
    public String oldUnit;
    public String oldPID;
    public BigDecimal oldQty = BigDecimal.ZERO;
    public BigDecimal oldQtyDay = BigDecimal.ZERO;
    public BigDecimal oldListprice = BigDecimal.ZERO;
    public String oldDiscExp;
    public String rememberDiscExp;
    public String oldTaxid;
    public boolean useBarcode = Reg.getInstance().getValueBoolean("USE_BC");
    public boolean useQtyX = Reg.getInstance().getValueBoolean("QTYX_ENABLED");
    public boolean regRememberDiscExp = Reg.getInstance().getValueBoolean("LAST_DISCEXP");
    public boolean checkPromotion = false;
    private TriggerSaleItemBookingChangedListener triggerItem;

    public BTSDetailBooking(BDM bdm, String tableName, String idNames) {
        super(bdm, tableName, idNames);
        this.initTrigger();
    }

    private void initTrigger() {
        TriggerSaleItemChangedListener lookup = (TriggerSaleItemChangedListener)Lookup.getDefault().lookup(TriggerSaleItemChangedListener.class);
        if (lookup != null) {
            try {
                Class<?> aClass = lookup.getClass();
                this.triggerItem = (TriggerSaleItemBookingChangedListener)aClass.newInstance();
            }
            catch (InstantiationException ex) {
                java.util.logging.Logger.getLogger(BTSDetailBooking.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                java.util.logging.Logger.getLogger(BTSDetailBooking.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.triggerItem = new DefaultTriggerItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllTax(boolean isResetTaxID) {
        if (this.getDataSet().rowCount() > 0) {
            int bookmark = this.getDataSet().getRow();
            this.setBypass(true);
            this.getDataSet().enableDataSetEvents(false);
            try {
                this.getDataSet().first();
                for (int i = 0; i < this.dataset.rowCount(); ++i) {
                    this.getDataSet().goToRow(i);
                    if (isResetTaxID) {
                        this.setItemTaxID(this.isTaxed());
                    }
                    this.calcItemBaseprice();
                    this.calcItemTax();
                    this.calcItemSubtotal();
                }
            }
            finally {
                this.getDataSet().enableDataSetEvents(true);
                this.getDataSet().goToRow(bookmark);
                this.firePropertyChange("resetmaster", null, BigDecimal.ZERO);
                this.setBypass(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalcAllTax() {
        if (this.getDataSet().rowCount() > 0) {
            int bookmark = this.getDataSet().getRow();
            this.setBypass(true);
            this.getDataSet().enableDataSetEvents(false);
            try {
                this.getDataSet().first();
                for (int i = 0; i < this.dataset.rowCount(); ++i) {
                    this.getDataSet().goToRow(i);
                    this.calcItemBaseprice();
                    this.calcItemTax();
                    this.calcItemSubtotal();
                }
            }
            finally {
                this.getDataSet().enableDataSetEvents(true);
                this.getDataSet().goToRow(bookmark);
                this.firePropertyChange("resetmaster", null, BigDecimal.ZERO);
                this.setBypass(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalcListPrice() {
        if (this.getDataSet().rowCount() > 0) {
            int bookmark = this.getDataSet().getRow();
            this.setBypass(true);
            this.getDataSet().enableDataSetEvents(false);
            try {
                this.getDataSet().first();
                for (int i = 0; i < this.dataset.rowCount(); ++i) {
                    this.getDataSet().goToRow(i);
                    this.setItemPrice();
                }
            }
            finally {
                this.getDataSet().enableDataSetEvents(true);
                this.getDataSet().goToRow(bookmark);
                this.firePropertyChange("resetmaster", null, BigDecimal.ZERO);
                this.setBypass(false);
            }
        }
    }

    public void resetItemTax() {
        this.setItemTaxID(this.isTaxed());
    }

    public boolean handleValidate(DataSet dataSet, Column column, Variant variant) {
        boolean retval = true;
        this.setChangeGranted(false);
        if (!this.dataChanged) {
            String columnName = column.getColumnName();
            if ("taxamt".equalsIgnoreCase(columnName)) {
                this.oldTaxamt = dataSet.getBigDecimal(columnName);
                this.oldBaseTaxamt = this.oldTaxamt.multiply(this.rateGetter != null ? this.rateGetter.getExcRate() : BigDecimal.ONE, BLUtil.MC_FOUR);
                this.oldBaseFTaxamt = this.oldTaxamt.multiply(this.rateGetter != null ? this.rateGetter.getFisRate() : BigDecimal.ONE, BLUtil.MC_FOUR);
                if (this.oldTaxamt.compareTo(variant.getBigDecimal()) != 0) {
                    this.setChangeGranted(true);
                }
            } else if ("subtotal".equalsIgnoreCase(columnName)) {
                this.oldSubtotal = dataSet.getBigDecimal(columnName);
                this.oldBaseSubtotal = this.oldSubtotal.multiply(this.rateGetter != null ? this.rateGetter.getExcRate() : BigDecimal.ONE, BLUtil.MC_FOUR);
                if (this.oldSubtotal.compareTo(variant.getBigDecimal()) != 0) {
                    this.setChangeGranted(true);
                }
            } else if ("itemid".equalsIgnoreCase(columnName)) {
                this.oldItemID = dataSet.getString(columnName);
                if (!this.oldItemID.equals(variant.getString())) {
                    this.setChangeGranted(true);
                }
            } else if ("pid".equalsIgnoreCase(columnName)) {
                this.oldPID = dataSet.getString(columnName);
                if (!this.oldPID.equals(variant.getString())) {
                    this.setChangeGranted(true);
                }
            } else if ("unit".equalsIgnoreCase(columnName)) {
                this.oldUnit = dataSet.getString(columnName);
                if (!this.oldUnit.equals(variant.getString())) {
                    this.setChangeGranted(true);
                }
            } else if ("qty".equalsIgnoreCase(columnName)) {
                this.oldQty = dataSet.getBigDecimal(columnName);
                if (this.oldQty.compareTo(variant.getBigDecimal()) != 0) {
                    this.setChangeGranted(true);
                }
            } else if ("qtyx".equalsIgnoreCase(columnName)) {
                if (this.useQtyX && !ItemList.getInstance().useQtyX(dataSet.getString("itemid"))) {
                    dataSet.setBigDecimal("qtyx", null);
                    if (this.getBDBExceptionHandler() != null) {
                        BDBExceptionHandler.handleException((DataSet)dataSet, null, (Exception)new Exception(this.getResourcesBL("ex.notuseqtyx")));
                    }
                }
            } else if ("qtyday".equalsIgnoreCase(columnName)) {
                this.oldQtyDay = dataSet.getBigDecimal(columnName);
                if (this.oldQtyDay.compareTo(variant.getBigDecimal()) != 0) {
                    this.setChangeGranted(true);
                }
            } else if ("listprice".equalsIgnoreCase(columnName)) {
                this.oldListprice = dataSet.getBigDecimal(columnName);
                if (this.oldListprice.compareTo(variant.getBigDecimal()) != 0) {
                    this.setChangeGranted(true);
                }
            } else if ("discexp".equalsIgnoreCase(columnName)) {
                this.oldDiscExp = dataSet.getString(columnName);
                this.rememberDiscExp = variant.getString();
                if (!this.oldDiscExp.equals(variant.getString())) {
                    this.setChangeGranted(true);
                }
            } else if ("taxid".equalsIgnoreCase(columnName)) {
                this.oldTaxid = dataSet.getString(columnName);
                if (!this.oldTaxid.equals(variant.getString())) {
                    this.setChangeGranted(true);
                }
            } else {
                retval = false;
            }
        }
        return retval;
    }

    public void checkItemPromotion() {
        Price price;
        if (this.getBPID() == null) {
            this.setBPID(Reg.getInstance().getValueString("CUST_DEFAULT"));
        }
        String crcid = null;
        if (this.crcChangeAdapter != null) {
            crcid = this.crcChangeAdapter.getNewCrc();
        }
        if ((price = PrcList.getInstance().getPrice_BP(crcid, this.getDataSet().getString("itemid"), this.getDataSet().getBigDecimal("qty"), this.getDataSet().getString("unit"), this.getBPID())) != null && price.getDiscExp() != null && price.getDiscExp().length() > 0) {
            this.oldDiscExp = this.dataset.getString("discexp");
            this.dataset.setString("discexp", price.getDiscExp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleColumnChanged(BArrayString colWatch, DataSet dataSet, Column column, Variant variant) {
        boolean retval = false;
        if (!this.dataChanged && this.isChangeGranted()) {
            try {
                this.dataChanged = true;
                String itemid = this.getString("itemid");
                if (colWatch.isExist(column.getServerColumnName())) {
                    retval = true;
                    String columnName = column.getColumnName();
                    if ("itemid".equalsIgnoreCase(columnName)) {
                        this.triggerItem.triggerItemChanged(this, colWatch, dataSet, column, variant);
                        boolean next = true;
                        if (this.getFindCols() != null && !ItemList.getInstance().getBooleanField(this.dataset.getString("itemid"), "usepid")) {
                            next = this.cekSaldoStock(true);
                        }
                        if (next) {
                            this.setItemPrice();
                            this.firePropertyChange(columnName, this.oldItemID, itemid);
                            this.firePropertyChange("subtotal", null, this.getDataSet().getBigDecimal("subtotal"));
                        }
                    } else if ("pid".equalsIgnoreCase(columnName)) {
                        this.getDataSet().setString("pid", variant.getString().trim());
                        boolean next = true;
                        if (this.getFindCols() != null && ItemList.getInstance().getBooleanField(this.dataset.getString("itemid"), "usepid")) {
                            this.cekSaldoStock(false);
                        }
                    } else if ("unit".equalsIgnoreCase(columnName)) {
                        if (this.getFindCols() != null) {
                            this.cekSaldoStock();
                        }
                        this.setItemPrice();
                        if (this.isCheckPromotion()) {
                            this.checkItemPromotion();
                        }
                        ((Booking)this.getParent().getMaster()).calcDay();
                        this.calcItemDisc();
                        this.calcItemBaseprice();
                        this.calcItemTax();
                        this.calcItemSubtotal();
                        this.firePropertyChange(columnName, this.oldUnit, variant.getString());
                    } else if ("qty".equalsIgnoreCase(columnName)) {
                        if (this.isCheckPromotion()) {
                            this.checkItemPromotion();
                        }
                        ((Booking)this.getParent().getMaster()).calcDay();
                        this.calcItemDisc();
                        this.calcItemBaseprice();
                        this.calcItemTax();
                        this.calcItemSubtotal();
                        this.firePropertyChange(columnName, this.oldQty, variant.getBigDecimal());
                        this.firePropertyChange("subtotal", null, this.getDataSet().getBigDecimal("subtotal"));
                        this.firePropertyChange("basesubtotal", null, this.getDataSet().getBigDecimal("basesubtotal"));
                    } else if ("listprice".equalsIgnoreCase(columnName)) {
                        ((Booking)this.getParent().getMaster()).calcDay();
                        this.calcItemDisc();
                        this.calcItemBaseprice();
                        this.calcItemTax();
                        this.calcItemSubtotal();
                        this.firePropertyChange(columnName, this.oldListprice, variant.getBigDecimal());
                        this.firePropertyChange("subtotal", null, this.getDataSet().getBigDecimal("subtotal"));
                        this.firePropertyChange("basesubtotal", null, this.getDataSet().getBigDecimal("basesubtotal"));
                    } else if ("qtyday".equalsIgnoreCase(columnName)) {
                        ((Booking)this.getParent().getMaster()).calcDay();
                        this.calcItemDisc();
                        this.calcItemBaseprice();
                        this.calcItemTax();
                        this.calcItemSubtotal();
                    } else if ("discexp".equalsIgnoreCase(columnName)) {
                        this.calcItemDisc();
                        this.calcItemBaseprice();
                        this.calcItemTax();
                        this.calcItemSubtotal();
                        this.firePropertyChange(columnName, this.oldDiscExp, variant.getString());
                        this.firePropertyChange("subtotal", null, this.getDataSet().getBigDecimal("subtotal"));
                        this.firePropertyChange("basesubtotal", null, this.getDataSet().getBigDecimal("basesubtotal"));
                    } else if ("taxid".equalsIgnoreCase(columnName)) {
                        this.calcItemTax();
                        this.firePropertyChange(columnName, this.oldTaxid, variant.getString());
                        if (this.isTaxInc()) {
                            ((Booking)this.getParent().getMaster()).calcDay();
                            this.calcItemSubtotal();
                            this.firePropertyChange("subtotal", null, this.getDataSet().getBigDecimal("subtotal"));
                            this.firePropertyChange("basesubtotal", null, this.getDataSet().getBigDecimal("basesubtotal"));
                        }
                    } else if ("taxamt".equalsIgnoreCase(columnName)) {
                        this.firePropertyChange(columnName, this.oldTaxamt.multiply(this.getDataSet().getBigDecimal("qty")), this.getDataSet().getBigDecimal("taxamt").multiply(this.getDataSet().getBigDecimal("qty")));
                        this.firePropertyChange("basftotaltaxamt", this.oldBaseFTaxamt.multiply(this.getDataSet().getBigDecimal("qty")), this.getDataSet().getBigDecimal("basftotaltaxamt"));
                        this.firePropertyChange("basetotaltaxamt", this.oldBaseTaxamt.multiply(this.getDataSet().getBigDecimal("qty")), this.getDataSet().getBigDecimal("basetotaltaxamt"));
                    } else if ("subtotal".equalsIgnoreCase(columnName)) {
                        this.firePropertyChange(columnName, this.oldSubtotal, this.getDataSet().getBigDecimal(columnName));
                        this.firePropertyChange("basesubtotal", this.oldBaseSubtotal, this.getDataSet().getBigDecimal("basesubtotal"));
                    } else {
                        retval = false;
                    }
                }
            }
            finally {
                this.dataChanged = false;
            }
        }
        return retval;
    }

    public boolean cekSaldoStock(boolean triggeredByItem) {
        if (!ItemList.getInstance().getBooleanField(this.dataset.getString("itemid"), "isstock")) {
            return true;
        }
        BigDecimal stock_qty = Stock.getInstance().getQty(this.dataset.getString("itemid"), this.dataset.getString("pid"), this.dataset.getString("whid"));
        BigDecimal bigDecimal = stock_qty = stock_qty == null ? BigDecimal.ZERO : stock_qty;
        if (this.dataClone != null) {
            DataRow readRow = new DataRow((DataSet)this.dataClone, this.getFindCols());
            readRow.setShort(this.getFindCols()[0], this.dataset.getShort("saledno"));
            readRow.setString(this.getFindCols()[1], this.dataset.getString("itemid"));
            this.found = this.dataClone.locate((ReadRow)readRow, 32);
        }
        if (Reg.getInstance().getValueBoolean("STOCK_GUARD").booleanValue() && ItemList.getInstance().isStock(this.dataset.getString("itemid")) && (fQtyZToQty1.getInstance().getQty1(this.dataset.getString("itemid"), this.dataset.getBigDecimal("qty"), this.dataset.getString("unit")).compareTo(stock_qty) > 0 && this.dataClone == null || this.dataClone != null && fQtyZToQty1.getInstance().getQty1(this.dataset.getString("itemid"), this.dataset.getBigDecimal("qty"), this.dataset.getString("unit")).compareTo(stock_qty.add(fQtyZToQty1.getInstance().getQty1(this.dataClone.getString("itemid"), this.dataClone.getBigDecimal("qty"), this.dataClone.getString("unit")))) > 0 && this.found || this.dataClone != null && fQtyZToQty1.getInstance().getQty1(this.dataset.getString("itemid"), this.dataset.getBigDecimal("qty"), this.dataset.getString("unit")).compareTo(stock_qty) > 0 && !this.found)) {
            if (this.dataClone != null && this.found) {
                this.dataset.setString("unit", this.dataClone.getString("unit"));
            } else if (this.lastunit != null && this.lastunit.length() > 0) {
                this.dataset.setString("unit", this.lastunit);
            } else {
                this.dataset.setString("unit", ItemList.getInstance().getUnitUnder(this.dataset.getString("itemid"), this.dataset.getString("unit")));
            }
            if (triggeredByItem) {
                this.dataset.setBigDecimal("qty", BigDecimal.ZERO);
            }
            String errOutOfStock = String.format(this.getResourcesBL("ex.outofstock"), this.dataset.getString("itemid"), this.dataset.getString("whid"), stock_qty.toString());
            if (this.getBDBExceptionHandler() != null) {
                if (this.nextfocuscomponent != null) {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, (Component)this.nextfocuscomponent, (Exception)new Exception(errOutOfStock));
                } else {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, (Exception)new Exception(errOutOfStock));
                }
            }
            return false;
        }
        return true;
    }

    public boolean cekSaldoStock() {
        return this.cekSaldoStock(false);
    }

    public void setCloneDataSet(DataSetView datasetView) {
        this.dataClone = datasetView;
    }

    public void setNextFocusComponent(Component c) {
        this.nextfocuscomponent = c;
    }

    public void calcItemListPrice() {
        this.recalcListPrice();
    }

    public void calcItemBaseprice() {
        this.tc.calcDetailBaseprice(this.getDataSet(), this.isTaxInc());
    }

    public void calcItemDisc() {
        this.tc.calcDetailDisc(this.getDataSet());
    }

    public void calcItemTax() {
        this.tc.calcDetailTax(this.getDataSet(), this.isTaxInc(), this.rateGetter != null ? this.rateGetter.getFisRate() : BigDecimal.ZERO, this.rateGetter != null ? this.rateGetter.getExcRate() : BigDecimal.ZERO);
    }

    public void calcItemSubtotal() {
        this.tc.calcDetailSubtotal(this.getDataSet(), this.rateGetter != null ? this.rateGetter.getExcRate() : BigDecimal.ONE);
    }

    public void setItemPrice() {
        if (this.getBPID() == null) {
            this.setBPID(Reg.getInstance().getValueString("CUST_DEFAULT"));
        }
        String crcid = null;
        if (this.crcChangeAdapter != null) {
            crcid = this.crcChangeAdapter.getNewCrc();
        }
        Price price = PrcList.getInstance().getPrice_BP(crcid, this.getDataSet().getString("itemid"), this.getDataSet().getBigDecimal("qty"), this.getDataSet().getString("unit"), this.getBPID());
        if (this.regRememberDiscExp) {
            this.getDataSet().setBigDecimal("listprice", price.getListPrice());
            if (price.getDiscExp() != null) {
                this.getDataSet().setString("discexp", this.rememberDiscExp);
                ((Booking)this.getParent().getMaster()).calcDay();
                this.calcItemDisc();
                this.calcItemBaseprice();
                this.calcItemTax();
                this.calcItemSubtotal();
            }
            this.getDataSet().setBigDecimal("taxableamt", price.getListPrice());
        } else if (price != null) {
            this.getDataSet().setBigDecimal("listprice", price.getListPrice());
            if (price.getDiscExp() != null) {
                this.getDataSet().setString("discexp", price.getDiscExp());
                ((Booking)this.getParent().getMaster()).calcDay();
                this.calcItemDisc();
                this.calcItemBaseprice();
                this.calcItemTax();
                this.calcItemSubtotal();
            }
            this.getDataSet().setBigDecimal("taxableamt", price.getListPrice());
        }
    }

    public void triggerItemChanged() {
        BigDecimal qty = BigDecimal.ONE;
        String itemid = this.getString("itemid");
        String exception = "ex.notforsale";
        ItemList itemList = ItemList.getInstance();
        if (itemid.indexOf("*") > 0) {
            String[] itemSplit = itemid.split("\\*");
            try {
                qty = new BigDecimal(itemSplit[0]);
                this.getDataSet().setBigDecimal("qty", qty);
                itemid = itemSplit[1];
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.useBarcode) {
            itemid = itemList.getItemIDByBarCode(itemid);
        }
        if (itemid != null && itemid.length() > 0 && !itemList.isSale(itemid)) {
            if (this.getBDBExceptionHandler() != null) {
                if (!itemList.isItemValid(itemid)) {
                    exception = "ex.itemnotfound";
                }
                if (this.nextfocuscomponent != null) {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, (Component)this.nextfocuscomponent, (Exception)new Exception(this.getResourcesBL(exception)));
                } else {
                    BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(this.getResourcesBL(exception)));
                }
            }
            this.setString("itemid", null);
        } else if (ItemList.getInstance().isItemValid(itemid)) {
            if (!itemList.isActive(itemid)) {
                exception = "ex.iteminactive";
                if (this.getBDBExceptionHandler() != null) {
                    if (this.nextfocuscomponent != null) {
                        BDBExceptionHandler.handleException((DataSet)this.dataset, (Component)this.nextfocuscomponent, (Exception)new Exception(LocaleInstance.getInstance().getMessageBL(null, exception)));
                    } else {
                        BDBExceptionHandler.handleException((DataSet)this.dataset, null, (Exception)new Exception(LocaleInstance.getInstance().getMessageBL(null, exception)));
                    }
                }
                this.setString("itemid", null);
            } else {
                this.setString("itemid", itemid);
                this.setString("itemdesc", itemList.getItemDesc(itemid));
                this.setString("unit", itemList.getSaleUnit(itemid));
                this.setBigDecimal("qty", qty);
                this.setItemTaxID(this.isTaxed());
            }
        }
        if (null != this.getResetColumn()) {
            for (String columnName : this.getResetColumn()) {
                this.dataset.setAssignedNull(columnName);
            }
        }
    }

    public void setItemTaxID(boolean isTaxed) {
        if (isTaxed) {
            this.setString("taxid", ItemList.getInstance().getSaleTaxID(this.dataset.getString("itemid")));
        } else {
            this.setString("taxid", null);
        }
    }

    public void setBPID(String BPID) {
        this.vendorID = BPID;
    }

    public String getBPID() {
        return this.vendorID;
    }

    public void setTaxInc(boolean taxInc) {
        this.taxInc = taxInc;
    }

    public boolean isTaxInc() {
        return this.taxInc;
    }

    public void setTaxed(boolean taxed) {
        this.taxed = taxed;
    }

    public boolean isTaxed() {
        return this.taxed;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public String getResourcesUI(String key) {
        return null;
    }

    public String getResourcesBL(String key) {
        return null;
    }

    public String getResourcesLib(String key) {
        return null;
    }

    public static Logger getLogger() {
        return logger;
    }

    public void setLogger(Logger logger) {
        BTSDetailBooking.logger = logger;
    }

    public BDBExceptionHandler getBDBExceptionHandler() {
        return this.handler;
    }

    public void setBDBExceptionHandler(BDBExceptionHandler handler) {
        this.handler = handler;
    }

    public String[] getFindCols() {
        return this.findCols;
    }

    public void setFindCols(String[] findCols) {
        this.findCols = findCols;
    }

    public boolean isChangeGranted() {
        return this.changeGranted;
    }

    public void setChangeGranted(boolean changeGranted) {
        this.changeGranted = changeGranted;
    }

    public CurrencyRateGetter getRateGetter() {
        return this.rateGetter;
    }

    public void setRateGetter(CurrencyRateGetter rateGetter) {
        this.rateGetter = rateGetter;
    }

    public void setCrcListener(CrcChangeAdapter crcListener) {
        this.crcChangeAdapter = crcListener;
    }

    public CrcChangeAdapter getCrcChangeAdapter() {
        return this.crcChangeAdapter;
    }

    public boolean isCheckPromotion() {
        return this.checkPromotion;
    }

    public void setCheckPromotion(boolean checkPromotion) {
        this.checkPromotion = checkPromotion;
    }

    public String[] getResetColumn() {
        return this.resetColumn;
    }

    public void setResetColumn(String[] resetColumn) {
        this.resetColumn = resetColumn;
    }

    class DefaultTriggerItem
    implements TriggerSaleItemBookingChangedListener {
        DefaultTriggerItem() {
        }

        public void triggerItemChanged(BTSDetailBooking btsDetail, BArrayString colWatch, DataSet dataSet, Column column, Variant variant) {
            BTSDetailBooking.this.triggerItemChanged();
        }
    }
}

