/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.bl;

import com.bits.bee.bl.BPAccList;
import com.bits.bee.bl.BPAddressList;
import com.bits.bee.bl.BPList;
import com.bits.bee.bl.BTSMaster;
import com.bits.bee.bl.Crc;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.TransMasterMtd;
import com.bits.bee.pluginpersewaan.bl.Booking;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTSMasterBooking
extends BTable
implements TransMasterMtd {
    private static Logger logger = LoggerFactory.getLogger(BTSMaster.class);
    private boolean triggeredFromBP = false;
    private boolean triggeredFromCrc = false;
    private String oldCustID;
    private boolean oldTaxed;
    private boolean oldTaxInc;
    private BigDecimal oldFreight = BigDecimal.ZERO;
    private String oldDiscExp;
    private String oldCrcID;
    private BigDecimal oldExcRate = BigDecimal.ZERO;
    private BigDecimal oldFisRate = BigDecimal.ZERO;
    private Date startrentdate;
    private Date endrentdate;
    private short defDueDays = Reg.getInstance().getValueShort("DUEDAYS");

    public BTSMasterBooking(BDM bdm, String tableName, String idNames) {
        super(bdm, tableName, idNames);
    }

    protected boolean handleValidate(DataSet dataSet, Column column, Variant variant) {
        boolean retval = true;
        String columnName = column.getColumnName();
        if ("custid".equalsIgnoreCase(columnName)) {
            this.oldCustID = dataSet.getString(columnName);
        } else if ("istaxed".equalsIgnoreCase(columnName)) {
            this.oldTaxed = dataSet.getBoolean(columnName);
        } else if ("taxinc".equalsIgnoreCase(columnName)) {
            this.oldTaxInc = dataSet.getBoolean(columnName);
        } else if ("freight".equalsIgnoreCase(columnName)) {
            this.oldFreight = dataSet.getBigDecimal(columnName);
        } else if ("discexp".equalsIgnoreCase(columnName)) {
            this.oldDiscExp = dataSet.getString(columnName);
        } else if ("crcid".equalsIgnoreCase(columnName)) {
            this.oldCrcID = dataSet.getString(columnName);
        } else if ("excrate".equalsIgnoreCase(columnName)) {
            this.oldExcRate = dataSet.getBigDecimal(columnName);
        } else if ("fisrate".equalsIgnoreCase(columnName)) {
            this.oldFisRate = dataSet.getBigDecimal(columnName);
        } else if ("startrentdate".equalsIgnoreCase(columnName)) {
            this.startrentdate = dataSet.getDate(columnName);
        } else if ("endrentdate".equalsIgnoreCase(columnName)) {
            this.endrentdate = dataSet.getDate(columnName);
        } else {
            retval = false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleColumnChanged(DataSet dataSet, Column column, Variant variant) {
        boolean retval;
        block26: {
            retval = true;
            try {
                String columnName = column.getColumnName();
                if ("custid".equalsIgnoreCase(columnName)) {
                    this.triggeredFromBP = true;
                    this.triggerBPChanged();
                    this.firePropertyChange(columnName, this.oldCustID, dataSet.getString(columnName));
                    break block26;
                }
                if ("istaxed".equalsIgnoreCase(columnName)) {
                    this.firePropertyChange(columnName, this.oldTaxed, dataSet.getBoolean(columnName));
                    if (!dataSet.getBoolean(columnName) && dataSet.getBoolean("taxinc")) {
                        dataSet.setBoolean("taxinc", false);
                    } else if (!this.triggeredFromBP) {
                        this.firePropertyChange("resetTax", null, true);
                    }
                    if (this.triggeredFromBP) {
                        this.firePropertyChange("resetTax", null, true);
                    }
                    break block26;
                }
                if ("taxinc".equalsIgnoreCase(columnName)) {
                    this.firePropertyChange(columnName, this.oldTaxInc, dataSet.getBoolean(columnName));
                    if (dataSet.getBoolean(columnName) && !dataSet.getBoolean("istaxed")) {
                        dataSet.setBoolean("istaxed", true);
                    }
                    this.firePropertyChange("resetTax", null, true);
                    break block26;
                }
                if ("freight".equalsIgnoreCase(columnName)) {
                    this.firePropertyChange(columnName, this.oldFreight, dataSet.getBigDecimal(columnName));
                    break block26;
                }
                if ("discexp".equalsIgnoreCase(columnName)) {
                    this.firePropertyChange(columnName, this.oldDiscExp, dataSet.getString(columnName));
                    break block26;
                }
                if ("crcid".equalsIgnoreCase(columnName)) {
                    this.triggeredFromCrc = true;
                    if (!dataSet.isNull(columnName)) {
                        dataSet.setBigDecimal("excrate", Crc.getInstance().getExcRate(dataSet.getString("crcid")));
                        dataSet.setBigDecimal("fisrate", Crc.getInstance().getFisRate(dataSet.getString("crcid")));
                    }
                    this.firePropertyChange(columnName, this.oldCrcID, dataSet.getString(columnName));
                    break block26;
                }
                if ("excrate".equalsIgnoreCase(columnName)) {
                    if (!this.triggeredFromCrc) {
                        this.firePropertyChange(columnName, this.oldExcRate, dataSet.getBigDecimal(columnName));
                    }
                    break block26;
                }
                if ("fisrate".equalsIgnoreCase(columnName)) {
                    if (!this.triggeredFromCrc) {
                        this.firePropertyChange(columnName, this.oldFisRate, dataSet.getBigDecimal(columnName));
                    }
                    break block26;
                }
                if ("termtype".equalsIgnoreCase(columnName)) {
                    try {
                        if (dataSet.getString(columnName).equals("R")) {
                            dataSet.setShort("duedays", BPAccList.getInstance().getARDueDays(dataSet.getString("custid")));
                            if (dataSet.getShort("duedays") == 0) {
                                dataSet.setShort("duedays", this.defDueDays);
                            }
                            break block26;
                        }
                        dataSet.setShort("duedays", (short)0);
                    }
                    catch (DataSetException ex) {}
                    break block26;
                }
                if ("startentdate".equalsIgnoreCase(column.getColumnName()) || "endrentdate".equalsIgnoreCase(column.getColumnName())) {
                    ((Booking)this.getParent().getMaster()).calcDay();
                } else {
                    retval = false;
                }
            }
            finally {
                this.triggeredFromBP = false;
                this.triggeredFromCrc = false;
            }
        }
        return retval;
    }

    public void triggerBPChanged() {
        this.setString("billto", BPAddressList.getInstance().getBillTo(this.getString("custid")));
        this.setString("shipto", BPAddressList.getInstance().getShipTo(this.getString("custid")));
        this.dataset.setBoolean("istaxed", BPList.getInstance().getSaleIsTaxed(this.dataset.getString("custid")));
        this.dataset.setBoolean("taxinc", BPList.getInstance().getSaleTaxInc(this.dataset.getString("custid")));
    }
}

