/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.BPList;
import com.bits.bee.bl.City;
import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.DP;
import com.bits.bee.bl.Defa;
import com.bits.bee.bl.Per;
import com.bits.bee.bl.Rcv;
import com.bits.bee.bl.RcvD;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.SPaid;
import com.bits.bee.bl.SaleTrans;
import com.bits.bee.bl.procedure.SPRecurringUpdate;
import com.bits.bee.bl.procedure.fGetLastDPID;
import com.bits.bee.bl.procedure.spLogTrans_New;
import com.bits.bee.bl.procedure.spRcv_New;
import com.bits.bee.bl.procedure.spRcv_Void;
import com.bits.bee.bl.util.memorized.MemorizedException;
import com.bits.bee.bl.util.memorized.MemorizedObject;
import com.bits.bee.bl.util.memorized.MemorizedSubject;
import com.bits.bee.bl.util.memorized.SPMemorizedUtil;
import com.bits.bee.bl.util.recurring.RecurringObject;
import com.bits.lib.BHelp;
import com.bits.lib.annotation.PostSaveEvent;
import com.bits.lib.annotation.PostVoidEvent;
import com.bits.lib.annotation.PreVoidEvent;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BProcSimple;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.i18n.LocaleInstance;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcvTransCustom
extends BTrans
implements MemorizedObject,
MemorizedSubject,
RecurringObject {
    private static Logger logger = LoggerFactory.getLogger(RcvTransCustom.class);
    public static final int SPAID = 0;
    public static final int RCVD = 1;
    private boolean alwaysTaxed = false;
    private RcvAdapter rcvAdapter = new RcvAdapter();
    private RcvDAdapter rcvDAdapter = new RcvDAdapter();
    private PaidAdapter paidAdapter = new PaidAdapter();
    private Rcv rcv = (Rcv)BTableProvider.createTable(Rcv.class);
    private RcvD rcvd = (RcvD)BTableProvider.createTable(RcvD.class);
    private SPaid spaid = (SPaid)BTableProvider.createTable(SPaid.class);
    private LocaleInstance l = LocaleInstance.getInstance();
    private int ROUND = Reg.getInstance().getValueInt("ROUND");
    private int rcvdCurrencyCounter;
    private QueryDataSet qds = new QueryDataSet();
    private SPMemorizedUtil spMemorizedUtil = new SPMemorizedUtil();
    private SPRecurringUpdate spRecurringUpdate = new SPRecurringUpdate();
    private boolean isModeDP = false;

    public RcvTransCustom() {
        this("RCV");
    }

    public RcvTransCustom(String noid) {
        super(BDM.getDefault(), noid, "rcvdate", "branchid", "rcvno", "Pembayaran Piutang");
        this.initRcv();
    }

    public void New() {
        super.New();
        this.New_setDefaultValues();
    }

    public void Save() throws Exception {
        this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
        BLUtil.renumberDetail((BTrans)this, (String)"spaidno");
        BLUtil.renumberDetail((BTrans)this, (String)"rcvdno", (int)1);
        super.Save();
    }

    public void New_setDefaultValues() {
        this.getDataSetMaster().setString("rcvno", "AUTO");
        this.getDataSetMaster().setString("rcvtype", "RCV");
        this.getDataSetMaster().setDate("rcvdate", BHelp.getCurrentDate_SQL());
        this.getDataSetMaster().setString("bpid", Reg.getInstance().getValueString("CUST_DEFAULT"));
        this.getDataSetMaster().setBoolean("isautogen", false);
        this.getDataSetMaster().setString("perid", Per.getInstance().getPeriodeActive());
        this.getDataSetMaster().setString("crtby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setTimestamp("crtdate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setBoolean("_xt", this.alwaysTaxed);
    }

    public void New(String custid) {
        this.New();
        this.New_setDefaultValues();
        this.getDataSetMaster().setString("bpid", custid);
    }

    public void NewDP() {
        this.New();
        this.getDataSetMaster().setString("rcvtype", "DP");
        DataRow dataRow = new DataRow(this.getDataSetDetail());
        dataRow.setShort("spaidno", (short)1);
        dataRow.setString("reftype", "DP");
        dataRow.setString("spaidnote", "Deposit Customer");
        dataRow.setString("crcid", this.getDataSetMaster().getString("crcid"));
        dataRow.setString("refno", null);
        dataRow.setBigDecimal("excrate", this.getDataSetMaster().getBigDecimal("excrate"));
        dataRow.setBigDecimal("fisrate", this.getDataSetMaster().getBigDecimal("fisrate"));
        this.getDataSetDetail().addRow(dataRow);
    }

    public void insertBegBalDP(String rcvno, BigDecimal amt) {
        this.getDataSetDetail(0).emptyAllRows();
        this.getDataSetMaster().setString("rcvtype", "DP");
        this.getDataSetMaster().setString("reftype", "BEG");
        this.getDataSetMaster().setBoolean("isautogen", true);
        this.getDataSetMaster().setBoolean("isautogendp", true);
        DataRow dataRow = new DataRow(this.getDataSetDetail());
        dataRow.setShort("spaidno", (short)1);
        dataRow.setString("reftype", "DP");
        dataRow.setString("spaidnote", "Deposit Customer");
        dataRow.setString("crcid", this.getDataSetMaster().getString("crcid"));
        dataRow.setString("refno", null);
        dataRow.setBigDecimal("spaidamt", amt);
        dataRow.setBigDecimal("excrate", this.getDataSetMaster().getBigDecimal("excrate"));
        dataRow.setBigDecimal("fisrate", this.getDataSetMaster().getBigDecimal("fisrate"));
        this.getDataSetDetail().addRow(dataRow);
        dataRow.setShort("spaidno", (short)2);
        dataRow.setString("reftype", "ACC");
        dataRow.setString("spaidnote", "Set Saldo Awal");
        dataRow.setString("crcid", this.getDataSetMaster().getString("crcid"));
        dataRow.setString("refno", Defa.getInstance().getValue("BEGBAL"));
        dataRow.setBigDecimal("spaidamt", amt.negate());
        dataRow.setBigDecimal("excrate", this.getDataSetMaster().getBigDecimal("excrate"));
        dataRow.setBigDecimal("fisrate", this.getDataSetMaster().getBigDecimal("fisrate"));
        this.getDataSetDetail().addRow(dataRow);
        if (!rcvno.isEmpty()) {
            try {
                this.getDetail().setStringAllRows("rcvno", rcvno);
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
        }
        this.CalcTotalPaid();
        this.CalcTotalPaidBC();
        this.CalcTotalrcvd();
        this.CalcTotalrcvdBC();
        this.CalcOverPay();
        this.getDataSetDetail().goToRow(0);
    }

    public void NewDP(String custid, String crcid, BigDecimal excRate, BigDecimal fisRate, String reftype, String refno) {
        this.New(custid);
        this.getDataSetMaster().setString("rcvtype", "DP");
        this.getDataSetMaster().setString("reftype", reftype);
        this.getDataSetMaster().setString("refno", refno);
        this.getDataSetMaster().setString("crcid", crcid);
        this.getDataSetMaster().setBigDecimal("excrate", excRate);
        this.getDataSetMaster().setBigDecimal("fisrate", fisRate);
        DataRow dataRow = new DataRow(this.getDataSetDetail());
        dataRow.setShort("spaidno", (short)1);
        dataRow.setString("reftype", "DP");
        dataRow.setString("spaidnote", "Deposit Customer");
        dataRow.setString("crcid", this.getDataSetMaster().getString("crcid"));
        dataRow.setString("refno", null);
        dataRow.setBigDecimal("excrate", this.getDataSetMaster().getBigDecimal("excrate"));
        dataRow.setBigDecimal("fisrate", this.getDataSetMaster().getBigDecimal("fisrate"));
        this.getDataSetDetail().addRow(dataRow);
    }

    public void MasterNewFromSale(String rcvno) {
        this.New();
        try {
            this.LoadID(rcvno);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    protected void CalcOverPay() {
        this.getDataSetMaster().setBigDecimal("overrcv", BLUtil.setScaling((BigDecimal)this.getDataSetMaster().getBigDecimal("totrcvamt").subtract(this.getDataSetMaster().getBigDecimal("totchg").add(this.getDataSetMaster().getBigDecimal("totspaid").subtract(this.getDataSetMaster().getBigDecimal("totrcvdisc")))), (int)this.ROUND, (int)4));
        this.getDataSetMaster().setBigDecimal("overrcvbc", BLUtil.setScaling((BigDecimal)this.getDataSetMaster().getBigDecimal("totrcvamtbc").subtract(this.getDataSetMaster().getBigDecimal("totchgbc").add(this.getDataSetMaster().getBigDecimal("totspaidbc").subtract(this.getDataSetMaster().getBigDecimal("totrcvdiscbc")))), (int)this.ROUND, (int)4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CalcTotalPaid() {
        boolean eof = false;
        BigDecimal total = new BigDecimal(0);
        BigDecimal disc = new BigDecimal(0);
        DataSet ds = this.getDataSetDetail(0);
        int bookmark = ds.getRow();
        int rowCount = ds.getRowCount();
        BigDecimal masterExcRate = this.getDataSetMaster().getBigDecimal("excrate");
        this.setBypass(true);
        ds.enableDataSetEvents(false);
        try {
            for (int i = 0; i < rowCount; ++i) {
                ds.goToRow(i);
                if (!ds.getBoolean("isfiscal")) {
                    total = total.add(ds.getBigDecimal("spaidamt"), BLUtil.MC_FOUR);
                    disc = disc.add(ds.getBigDecimal("spaiddiscamt"), BLUtil.MC_FOUR);
                    continue;
                }
                total = total.add(ds.getBigDecimal("spaidamt").divide(masterExcRate, MC_FOUR), BLUtil.MC_FOUR);
            }
        }
        finally {
            this.getDataSetMaster().setBigDecimal("totspaid", total);
            this.getDataSetMaster().setBigDecimal("totrcvdisc", disc);
            this.CalcTotalPaidBC();
            this.CalcOverPay();
            ds.enableDataSetEvents(true);
            ds.goToRow(bookmark);
            this.setBypass(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CalcTotalPaidBC() {
        boolean eof = false;
        BigDecimal total = new BigDecimal(0);
        BigDecimal disc = new BigDecimal(0);
        int bookmark = this.getDataSetDetail(0).getRow();
        this.setBypass(true);
        this.getDataSetDetail(0).enableDataSetEvents(false);
        try {
            for (int i = 0; i < this.getDataSetDetail(0).getRowCount(); ++i) {
                this.getDataSetDetail(0).goToRow(i);
                total = total.add(this.getDataSetDetail(0).getBigDecimal("spaidamt").multiply(this.getDataSetDetail(0).getBigDecimal("excrate"), BLUtil.MC_FOUR));
                disc = disc.add(this.getDataSetDetail(0).getBigDecimal("spaiddiscamt").multiply(this.getDataSetDetail(0).getBigDecimal("excrate"), BLUtil.MC_FOUR));
            }
        }
        finally {
            this.getDataSetMaster().setBigDecimal("totspaidbc", total);
            this.getDataSetMaster().setBigDecimal("totrcvdiscbc", disc);
            this.CalcOverPay();
            this.getDataSetDetail(0).enableDataSetEvents(true);
            this.getDataSetDetail(0).goToRow(bookmark);
            this.setBypass(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CalcTotalrcvd() {
        boolean eof = false;
        String crcId = this.getDataSetMaster().getString("crcid");
        this.rcvdCurrencyCounter = 1;
        BigDecimal total = new BigDecimal(0);
        DataSet dsRcvD = this.getDataSetDetail(1);
        this.setBypass(true);
        dsRcvD.enableDataSetEvents(false);
        int bookmark = dsRcvD.getRow();
        try {
            for (int i = 0; i < dsRcvD.getRowCount(); ++i) {
                dsRcvD.goToRow(i);
                if (!dsRcvD.getString("crcid").equals(crcId)) {
                    ++this.rcvdCurrencyCounter;
                }
                total = total.add(dsRcvD.getBigDecimal("rcvdamt").multiply(dsRcvD.getBigDecimal("excrate")).divide(this.getDataSetMaster().getBigDecimal("excrate"), this.ROUND, 4));
            }
        }
        finally {
            this.getDataSetMaster().setBigDecimal("totrcvamt", total);
            this.CalcTotalrcvdBC();
            this.CalcOverPay();
            dsRcvD.enableDataSetEvents(true);
            dsRcvD.goToRow(bookmark);
            this.setBypass(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CalcTotalrcvdBC() {
        boolean eof = false;
        BigDecimal total = new BigDecimal(0);
        this.setBypass(true);
        this.getDataSetDetail(1).enableDataSetEvents(false);
        int bookmark = this.getDataSetDetail(1).getRow();
        try {
            for (int i = 0; i < this.getDataSetDetail(1).getRowCount(); ++i) {
                this.getDataSetDetail(1).goToRow(i);
                total = total.add(this.getDataSetDetail(1).getBigDecimal("rcvdamt").multiply(this.getDataSetDetail(1).getBigDecimal("excrate"), BLUtil.MC_FOUR));
            }
        }
        finally {
            this.getDataSetMaster().setBigDecimal("totrcvamtbc", total);
            this.CalcOverPay();
            this.getDataSetDetail(1).enableDataSetEvents(true);
            this.getDataSetDetail(1).goToRow(bookmark);
            this.setBypass(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRateSPaid(String column) {
        this.setBypass(true);
        this.getDataSetDetail(0).enableDataSetEvents(false);
        int bookmark = this.getDataSetDetail(0).getRow();
        try {
            for (int i = 0; i < this.getDataSetDetail(0).getRowCount(); ++i) {
                this.getDataSetDetail(0).goToRow(i);
                this.getDataSetDetail(0).setBigDecimal(column, this.getDataSetMaster().getBigDecimal(column));
            }
        }
        finally {
            this.CalcTotalPaid();
            this.getDataSetDetail(0).enableDataSetEvents(true);
            this.getDataSetDetail(0).goToRow(bookmark);
            this.setBypass(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRateRcvd(String column) {
        this.setBypass(true);
        this.getDataSetDetail(1).enableDataSetEvents(false);
        int bookmark = this.getDataSetDetail(1).getRow();
        try {
            for (int i = 0; i < this.getDataSetDetail(1).getRowCount(); ++i) {
                this.getDataSetDetail(1).goToRow(i);
                if (!this.getDataSetMaster().getString("crcid").equalsIgnoreCase(this.getDataSetDetail(1).getString("crcid"))) continue;
                this.getDataSetDetail(1).setBigDecimal(column, this.getDataSetMaster().getBigDecimal(column));
            }
        }
        finally {
            this.CalcTotalrcvd();
            this.getDataSetDetail(1).enableDataSetEvents(true);
            this.getDataSetDetail(1).goToRow(bookmark);
            this.setBypass(false);
        }
    }

    public void initPrint() {
        DataRow localDr = BPList.getInstance().getSale_BPIDChanged(this.getDataSetMaster().getString("bpid"));
        DataSet drcmp = Cmp.getInstance().getDataSet();
        if (localDr != null) {
            this.getDataSetMaster().setString("taxregno", localDr.getString("taxregno"));
            this.getDataSetMaster().setString("vatregno", localDr.getString("vatregno"));
            this.getDataSetMaster().setDate("vatregdate", localDr.getDate("vatregdate"));
        }
        this.getDataSetMaster().setString("cmpname", drcmp.getString("cmpname"));
        this.getDataSetMaster().setString("cmpownername", drcmp.getString("ownername"));
        this.getDataSetMaster().setString("cmpaddr", drcmp.getString("cmpaddr"));
        this.getDataSetMaster().setString("cmpphone", drcmp.getString("phone"));
        this.getDataSetMaster().setString("cmpcity", City.getInstance().getCityName(drcmp.getString("cityid")));
        this.getDataSetMaster().setString("cmptaxregno", drcmp.getString("taxregno"));
        this.getDataSetMaster().setString("cmpvatregno", drcmp.getString("vatregno"));
        this.getDataSetMaster().setDate("cmpvatregdate", drcmp.getDate("vatregdate"));
        this.getDataSetMaster().setString("formserno", drcmp.getString("formserno"));
    }

    public boolean Rcv_Validate(boolean isSave) {
        return true;
    }

    public void validateFCN(String custID, boolean iscontra) throws Exception {
        if (!this.getDataSetMaster().getString("bpid").equalsIgnoreCase(custID)) {
            throw new Exception(this.getResourcesBL("ex.custnotsame"));
        }
        if (iscontra) {
            throw new Exception(this.getResourcesBL("ex.iscontra"));
        }
    }

    public void validateData() throws Exception {
        if (this.getDataSetDetail().getRowCount() <= 0) {
            throw new Exception(this.getResourcesBL("ex.notransaction"));
        }
        if (this.rcvdCurrencyCounter > 1 && this.getDataSetMaster().getBigDecimal("overrcv").compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException(this.getResourcesBL("ex.overrcv"));
        }
    }

    public void generateDP(DataSet trans, String refno, String reftype) {
        this.NewDP();
        if (trans.getString("dppaidno") != null && trans.getString("dppaidno").length() > 0) {
            this.getDataSetMaster().setString("rcvno", trans.getString("dppaidno"));
        }
        if (this.getDataSetMaster().getString("rcvno").isEmpty()) {
            this.getDataSetMaster().setString("rcvno", "AUTO");
        }
        this.getDataSetMaster().setString("bpid", trans.getString("bpid"));
        this.getDataSetMaster().setDate("rcvdate", trans.getDate("dpdate"));
        this.getDataSetMaster().setString("reftype", reftype);
        this.getDataSetMaster().setString("refno", refno);
        if (trans.getString("branchid").length() > 0) {
            this.getDataSetMaster().setString("branchid", trans.getString("branchid"));
        }
        this.getDataSetMaster().setString("crcid", trans.getString("crcid"));
        this.getDataSetMaster().setBigDecimal("excrate", trans.getBigDecimal("excrate"));
        this.getDataSetMaster().setBigDecimal("fisrate", trans.getBigDecimal("fisrate"));
        this.getDataSetMaster().setBoolean("isautogen", true);
        this.getDataSetMaster().setBoolean("isautogendp", true);
        if (this.getDataSetDetail(0).getString("refno") != null && !Long.toString(trans.getLong("dpid")).equalsIgnoreCase("0")) {
            this.getDataSetDetail(0).setString("refno", Long.toString(trans.getLong("dpid")));
        } else {
            this.getDataSetDetail(0).setString("refno", null);
        }
        this.getDataSetDetail(0).setString("crcid", trans.getString("crcid"));
        this.getDataSetDetail(0).setBigDecimal("excrate", trans.getBigDecimal("excrate"));
        this.getDataSetDetail(0).setBigDecimal("fisrate", trans.getBigDecimal("fisrate"));
        this.getDataSetDetail(0).setBigDecimal("spaidamt", trans.getBigDecimal("dpamt"));
        this.getDetail(1).New();
        DataRow dataRow = new DataRow(this.getDataSetDetail(1));
        dataRow.setString("rcvno", this.getDataSetMaster().getString("rcvno"));
        dataRow.setShort("rcvdno", (short)(this.getDataSetDetail(1).getRowCount() + 1));
        dataRow.setString("crcid", trans.getString("paidcrcid"));
        if (this.getDataSetMaster().getString("crcid").equalsIgnoreCase(trans.getString("paidcrcid"))) {
            dataRow.setBigDecimal("excrate", this.getDataSetMaster().getBigDecimal("excrate"));
            dataRow.setBigDecimal("fisrate", this.getDataSetMaster().getBigDecimal("fisrate"));
        } else {
            dataRow.setBigDecimal("excrate", trans.getBigDecimal("paidexcrate"));
            dataRow.setBigDecimal("fisrate", trans.getBigDecimal("paidfisrate"));
        }
        if (trans.getString("refno").length() > 0) {
            dataRow.setString("refno", trans.getString("refno"));
        }
        if (trans.getString("note").length() > 0) {
            dataRow.setString("rcvdnote", trans.getString("note"));
        }
        if (trans.getString("cashid").length() > 0) {
            dataRow.setString("cashid", trans.getString("cashid"));
        }
        if (trans.getString("cbgid").length() > 0) {
            dataRow.setString("cbgid", trans.getString("cbgid"));
        }
        if (trans.getString("mtd").length() > 0) {
            dataRow.setString("rcvdmtd", trans.getString("mtd"));
        }
        dataRow.setBigDecimal("rcvdamt", trans.getBigDecimal("dpamt"));
        this.getDataSetDetail(1).addRow(dataRow);
        this.CalcTotalPaid();
        this.CalcTotalPaidBC();
        this.CalcTotalrcvd();
        this.CalcTotalrcvdBC();
        this.CalcOverPay();
    }

    public void generateDP_Paid(DataSet trans, String refno, String reftype) {
        this.New();
        if (trans.getString("paidno") != null && trans.getString("paidno").length() > 0) {
            this.getDataSetMaster().setString("rcvno", trans.getString("paidno"));
        }
        this.getDataSetMaster().setString("bpid", trans.getString("bpid"));
        this.getDataSetMaster().setDate("rcvdate", trans.getDate("dpdate"));
        this.getDataSetMaster().setString("reftype", reftype);
        this.getDataSetMaster().setString("refno", refno);
        if (trans.getString("branchid").length() > 0) {
            this.getDataSetMaster().setString("branchid", trans.getString("branchid"));
        }
        this.getDataSetMaster().setString("crcid", trans.getString("crcid"));
        this.getDataSetMaster().setBigDecimal("excrate", trans.getBigDecimal("excrate"));
        this.getDataSetMaster().setBigDecimal("fisrate", trans.getBigDecimal("fisrate"));
        this.getDataSetMaster().setBoolean("isautogen", true);
        this.getDataSetMaster().setBoolean("isautogendp", true);
        this.getDetail(0).New();
        DataRow dataRow1 = new DataRow(this.getDataSetDetail(0));
        DataRow dataRow2 = new DataRow(this.getDataSetDetail(0));
        dataRow1.setString("rcvno", this.getMaster().getString("rcvno"));
        dataRow1.setShort("spaidno", (short)(this.getDataSetDetail(0).getRowCount() + 1));
        dataRow1.setString("reftype", "SALE");
        dataRow1.setString("refno", refno);
        dataRow1.setString("crcid", trans.getString("crcid"));
        dataRow1.setBigDecimal("excrate", trans.getBigDecimal("excrate"));
        dataRow1.setBigDecimal("fisrate", trans.getBigDecimal("fisrate"));
        dataRow1.setBigDecimal("spaidamt", trans.getBigDecimal("dpamt"));
        dataRow1.setString("reftype", "SALE");
        dataRow1.setString("spaidnote", "Penjualan " + refno);
        this.getDataSetDetail(0).addRow(dataRow1);
        dataRow2.setString("rcvno", this.getMaster().getString("rcvno"));
        dataRow2.setShort("spaidno", (short)(this.getDataSetDetail(0).getRowCount() + 1));
        dataRow2.setString("reftype", "DP");
        dataRow2.setString("refno", "" + fGetLastDPID.getInstance().getLastDPID(refno, "SALE"));
        dataRow2.setBigDecimal("spaidamt", trans.getBigDecimal("dpamt").negate());
        dataRow2.setString("crcid", trans.getString("crcid"));
        dataRow2.setBigDecimal("excrate", trans.getBigDecimal("excrate"));
        dataRow1.setBigDecimal("fisrate", trans.getBigDecimal("fisrate"));
        dataRow2.setString("spaidnote", "Uang Muka#" + fGetLastDPID.getInstance().getLastDPID(trans.getString("refno"), "SALE"));
        this.getDataSetDetail(0).addRow(dataRow2);
        this.CalcTotalPaid();
        this.CalcTotalPaidBC();
        this.CalcTotalrcvd();
        this.CalcTotalrcvdBC();
        this.CalcOverPay();
    }

    private void initRcv() {
        this.setMaster((BTable)this.rcv);
        this.addDetail((BTable)this.spaid);
        this.spaid.setMaster((BTable)this.rcv);
        this.addDetail((BTable)this.rcvd);
        this.setspNew((BProcSimple)new spRcv_New());
        this.setspVoid((BProcSimple)new spRcv_Void());
        this.setspLog((BProcSimple)new spLogTrans_New());
        this.setRefType("RCV");
        this.setCrtBy(BAuthMgr.getDefault().getUserID());
        this.getDataSetDetail(0).addDataChangeListener((DataChangeListener)this.paidAdapter);
        this.getDataSetDetail(1).addDataChangeListener((DataChangeListener)this.rcvDAdapter);
        this.spaid.addPropertyChangeListener("isfiscal", (PropertyChangeListener)this.paidAdapter);
        this.spaid.addPropertyChangeListener("netto", (PropertyChangeListener)this.paidAdapter);
        this.spaid.addPropertyChangeListener("spaidamt", (PropertyChangeListener)this.paidAdapter);
        this.spaid.addPropertyChangeListener("excrate", (PropertyChangeListener)this.paidAdapter);
        this.rcvd.addPropertyChangeListener("rcvdamt", (PropertyChangeListener)this.rcvDAdapter);
        this.rcvd.addPropertyChangeListener("excrate", (PropertyChangeListener)this.rcvDAdapter);
        this.rcv.addPropertyChangeListener("bpid", (PropertyChangeListener)this.rcvAdapter);
        this.rcv.addPropertyChangeListener("crcid", (PropertyChangeListener)this.rcvAdapter);
        this.rcv.addPropertyChangeListener("excrate", (PropertyChangeListener)this.rcvAdapter);
        this.rcv.addPropertyChangeListener("fisrate", (PropertyChangeListener)this.rcvAdapter);
        this.rcvd.setOrderBy("rcvno,rcvdno");
    }

    public void setAlwaysTaxed(boolean b) {
        this.alwaysTaxed = b;
        this.getDataSetMaster().setBoolean("_xt", b);
    }

    public void import_sale(String saleno) {
        SaleTrans saletrans = new SaleTrans();
        try {
            saletrans.LoadID(saleno);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        this.getDetail(0).New();
        this.getDataSetDetail(0).setString("reftype", "SALE");
        this.getDataSetDetail(0).setString("refno", saleno);
        this.getDataSetDetail(0).setBigDecimal("spaidamt", saletrans.getDataSetMaster().getBigDecimal("dueamt"));
        this.getDataSetDetail(0).setString("reftype", "SALE");
        this.getDataSetDetail(0).setString("spaidnote", "Penjualan " + saleno);
    }

    public void detailNew() {
        this.getDetail(1).New();
        this.getDataSetDetail(1).setString("rcvno", this.getDataSetMaster().getString("rcvno"));
        this.getDataSetDetail(1).setShort("rcvdno", (short)(this.getDataSetDetail(1).getRowCount() + 1));
        this.getDataSetDetail(1).setString("cashid", null);
    }

    public void addDefaultDP(DP dp) {
        if (dp.getDataSet().rowCount() > 0) {
            for (int i = 0; i < dp.getDataSet().rowCount(); ++i) {
                dp.getDataSet().goToRow(i);
                DataSet ds = this.getDataSetDetail(0);
                ds.insertRow(false);
                ds.setString("reftype", "DP");
                ds.setString("refno", "" + dp.getDataSet().getLong("dpid"));
                ds.setBigDecimal("spaidamt", dp.getDataSet().getBigDecimal("dpbal").negate());
                ds.setString("crcid", dp.getDataSet().getString("crcid"));
                ds.setBigDecimal("excrate", dp.getDataSet().getBigDecimal("excrate"));
                ds.setString("spaidnote", "Uang Muka#" + dp.getDataSet().getLong("dpid"));
            }
            this.getDataSetDetail().last();
        }
    }

    protected Class getSubclass() {
        return ((Object)((Object)this)).getClass();
    }

    @PreVoidEvent
    public void checkVersioning() throws Exception {
        if (this.qds.isOpen()) {
            this.qds.close();
        }
        this.qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), String.format("SELECT version FROM rcv WHERE rcvno=%s", BHelp.QuoteSingle((String)this.getDataSetMaster().getString("rcvno")))));
        this.qds.open();
        Long version = this.qds.getLong("version");
        if (version.compareTo(this.getDataSetMaster().getLong("version")) > 0) {
            throw new IllegalArgumentException(LocaleInstance.getInstance().getMessageBL(null, "ex.version"));
        }
    }

    @PostSaveEvent
    public void saveUpdateRecurring() throws Exception {
        if (!this.getDataSetMaster().isNull("recurno")) {
            this.spRecurringUpdate.execute(this.getDataSetMaster().getString("rcvno"), this.getDataSetMaster().getString("rcvnote"), this.getDataSetMaster().getString("recurno"), this.getDataSetMaster().getShort("recurdno"), true, this.getDataSetMaster().getBigDecimal("totspaid"));
        }
    }

    @PostVoidEvent
    public void voidUpdateRecurring() throws Exception {
        if (!this.getDataSetMaster().isNull("recurno")) {
            this.spRecurringUpdate.execute(null, null, this.getDataSetMaster().getString("recurno"), this.getDataSetMaster().getShort("recurdno"), false, this.getDataSetMaster().getBigDecimal("totspaid"));
        }
    }

    public void memorized(String memorizedNote) throws MemorizedException {
        if (this.getDataSetMaster().getBoolean("ismemorized")) {
            throw new MemorizedException(this.getResourcesBL("ex.already.memorized"));
        }
        try {
            boolean memorized = true;
            this.spMemorizedUtil.execute("rcv", "rcvno", this.getDataSetMaster().getString("rcvno"), memorized, memorizedNote);
            this.getDataSetMaster().setBoolean("ismemorized", memorized);
            this.getDataSetMaster().setString("memorizednote", memorizedNote);
        }
        catch (Exception ex) {
            throw new MemorizedException(this.getResourcesBL("ex.memorized.failed"), (Throwable)ex);
        }
    }

    public void unmemorized() throws MemorizedException {
        if (!this.getDataSetMaster().getBoolean("ismemorized")) {
            throw new MemorizedException(this.getResourcesBL("ex.not.memorized"));
        }
        try {
            boolean memorized = false;
            this.spMemorizedUtil.execute("rcv", "rcvno", this.getDataSetMaster().getString("rcvno"), memorized, "");
            this.getDataSetMaster().setBoolean("ismemorized", memorized);
            this.getDataSetMaster().setString("memorizednote", "");
        }
        catch (Exception ex) {
            throw new MemorizedException(this.getResourcesBL("ex.unmemorized.failed"), (Throwable)ex);
        }
    }

    public boolean isMemorized() {
        return this.getDataSetMaster().getBoolean("ismemorized");
    }

    public boolean isMemorizedEnabled() {
        return !this.getDataSetMaster().getBoolean("isautogen") && !this.getDataSetMaster().getBoolean("isdraft");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMemorized(ArrayList<String> memorizedRefs) throws MemorizedException {
        if (memorizedRefs != null) {
            String rcvType = this.getDataSetMaster().getString("rcvtype");
            try {
                if ("DP".equals(rcvType)) {
                    this.isModeDP = true;
                }
                for (String memorizeRef : memorizedRefs) {
                    this.importMemorized(memorizeRef);
                    if (!this.isModeDP) continue;
                    break;
                }
            }
            finally {
                this.isModeDP = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMemorized(String memorizedRef) throws MemorizedException {
        try {
            if (memorizedRef == null) {
                return;
            }
            Rcv localRcv = (Rcv)BTableProvider.createTable(Rcv.class);
            SPaid localSPaid = (SPaid)BTableProvider.createTable(SPaid.class);
            RcvD localRcvD = (RcvD)BTableProvider.createTable(RcvD.class);
            localRcv.LoadID(memorizedRef);
            localSPaid.LoadID(memorizedRef);
            localRcvD.LoadID(memorizedRef);
            if (!localRcv.getString("crcid").equals(this.getDataSetMaster().getString("crcid"))) {
                throw new MemorizedException("Mata uang tidak sama !");
            }
            this.getDataSetDetail(0).last();
            short lastSPaidNo = this.getDataSetDetail(0).getShort("spaidno");
            this.getDataSetDetail(1).last();
            short lastRcvDNo = this.getDataSetDetail(1).getShort("rcvdno");
            String rcvNo = this.getDataSetMaster().getString("rcvno");
            String crcId = this.getDataSetMaster().getString("crcid");
            int sPaidRowCount = localSPaid.getRowCount();
            int rcvDRowCount = localRcv.getRowCount();
            this.setBypass(true);
            this.enableDataSetEvents(false);
            try {
                DataRow localDr;
                int i;
                if (this.isModeDP) {
                    this.getDataSetDetail(0).setBigDecimal("spaidamt", localSPaid.getBigDecimal("spaidamt"));
                } else {
                    for (i = 0; i < sPaidRowCount; ++i) {
                        localSPaid.getDataSet().goToRow(i);
                        localDr = new DataRow(this.getDataSetDetail(0));
                        localDr.setShort("spaidno", (short)(lastSPaidNo + 1));
                        localDr.setString("rcvno", rcvNo);
                        localDr.setString("reftype", localSPaid.getString("reftype"));
                        localDr.setString("crcid", crcId);
                        localDr.setBigDecimal("spaidamt", localSPaid.getBigDecimal("spaidamt"));
                        localDr.setBigDecimal("excrate", localSPaid.getBigDecimal("excrate"));
                        localDr.setBigDecimal("fisrate", localSPaid.getBigDecimal("fisrate"));
                        if (!localSPaid.getDataSet().isNull("refno")) {
                            localDr.setString("refno", localSPaid.getString("refno"));
                        }
                        if (!localSPaid.getDataSet().isNull("deptid")) {
                            localDr.setString("deptid", localSPaid.getString("deptid"));
                        }
                        if (!localSPaid.getDataSet().isNull("prjid")) {
                            localDr.setString("prjid", localSPaid.getString("prjid"));
                        }
                        if (!localSPaid.getDataSet().isNull("spaidnote")) {
                            localDr.setString("spaidnote", localSPaid.getString("spaidnote"));
                        }
                        this.getDataSetDetail(0).addRow(localDr);
                    }
                }
                for (i = 0; i < rcvDRowCount; ++i) {
                    localRcvD.getDataSet().goToRow(i);
                    localDr = new DataRow(this.getDataSetDetail(1));
                    localDr.setShort("rcvdno", (short)(lastRcvDNo + 1));
                    localDr.setString("rcvno", rcvNo);
                    localDr.setString("crcid", localRcvD.getString("crcid"));
                    localDr.setString("rcvdmtd", localRcvD.getString("rcvdmtd"));
                    localDr.setBigDecimal("rcvdamt", localRcvD.getBigDecimal("rcvdamt"));
                    localDr.setBigDecimal("excrate", localRcvD.getBigDecimal("excrate"));
                    localDr.setBigDecimal("fisrate", localRcvD.getBigDecimal("fisrate"));
                    if (!localRcvD.getDataSet().isNull("refno")) {
                        localDr.setString("refno", localRcvD.getString("refno"));
                    }
                    if (!localRcvD.getDataSet().isNull("cbgid")) {
                        localDr.setString("cbgid", localRcvD.getString("cbgid"));
                    }
                    if (!localRcvD.getDataSet().isNull("cashid")) {
                        localDr.setString("cashid", localRcvD.getString("cashid"));
                    }
                    if (!localRcvD.getDataSet().isNull("rcvdnote")) {
                        localDr.setString("rcvdnote", localRcvD.getString("rcvdnote"));
                    }
                    this.getDataSetDetail(1).addRow(localDr);
                }
            }
            finally {
                this.CalcTotalPaid();
                this.CalcTotalPaidBC();
                this.CalcTotalrcvd();
                this.CalcTotalrcvdBC();
                this.enableDataSetEvents(true);
                this.setBypass(false);
            }
        }
        catch (Exception ex) {
            throw new MemorizedException("", (Throwable)ex);
        }
    }

    public String getResourcesUI(String key) {
        return this.l.getMessageUI(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesBL(String key) {
        return this.l.getMessageBL(((Object)((Object)this)).getClass(), key);
    }

    public String getResourcesLib(String key) {
        return this.l.getMessageLib(((Object)((Object)this)).getClass(), key);
    }

    public boolean isRecurring() {
        return this.getDataSetMaster().getBoolean("isrecurring");
    }

    public boolean isRecurringEnabled() {
        return !this.getDataSetMaster().getBoolean("isdraft") && !this.getDataSetMaster().getBoolean("isautogen");
    }

    public Date getReferenceDate() {
        return this.getDataSetMaster().getDate("rcvdate");
    }

    public BigDecimal getReferenceTotal() {
        return this.getDataSetMaster().getBigDecimal("totrcvamt");
    }

    public String getReferenceDesc() {
        return this.getDataSetMaster().getString("rcvnote");
    }

    public String getReferenceType() {
        return "RCV";
    }

    public String getReferenceNumber() {
        return this.getDataSetMaster().getString("rcvno");
    }

    public String getRecurringNumber() {
        return this.getDataSetMaster().getString("recurno");
    }

    class PaidAdapter
    implements DataChangeListener,
    PropertyChangeListener {
        PaidAdapter() {
        }

        public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (dataChangeEvent.getID() == 1) {
                if (RcvTransCustom.this.getDataSetDetail(0).isNull("rcvno")) {
                    RcvTransCustom.this.getDataSetDetail(0).setString("rcvno", RcvTransCustom.this.getMaster().getString("rcvno"));
                    RcvTransCustom.this.getDataSetDetail(0).setShort("spaidno", (short)RcvTransCustom.this.getDataSetDetail(0).getRowCount());
                }
            } else if (dataChangeEvent.getID() == 2) {
                RcvTransCustom.this.CalcTotalPaid();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("netto".equalsIgnoreCase(propertyName)) {
                RcvTransCustom.this.CalcTotalPaid();
            } else if ("excrate".equalsIgnoreCase(propertyName)) {
                RcvTransCustom.this.CalcTotalPaidBC();
            } else if ("isfiscal".equalsIgnoreCase(propertyName)) {
                RcvTransCustom.this.CalcTotalPaid();
                RcvTransCustom.this.CalcTotalPaidBC();
            }
        }
    }

    class RcvDAdapter
    implements DataChangeListener,
    PropertyChangeListener {
        RcvDAdapter() {
        }

        public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (dataChangeEvent.getID() == 1) {
                if (RcvTransCustom.this.getDataSetDetail(1).isNull("rcvno")) {
                    RcvTransCustom.this.getDataSetDetail(1).setString("rcvno", RcvTransCustom.this.getDataSetMaster().getString("rcvno"));
                    RcvTransCustom.this.getDataSetDetail(1).setShort("rcvdno", (short)(RcvTransCustom.this.getDataSetDetail(1).getRowCount() + 1));
                }
                RcvTransCustom.this.CalcTotalrcvd();
            } else if (dataChangeEvent.getID() == 2) {
                RcvTransCustom.this.CalcTotalrcvd();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("rcvdamt".equalsIgnoreCase(propertyName)) {
                RcvTransCustom.this.CalcTotalrcvd();
            } else if ("excrate".equalsIgnoreCase(propertyName)) {
                RcvTransCustom.this.CalcTotalrcvdBC();
            }
        }
    }

    class RcvAdapter
    implements PropertyChangeListener {
        RcvAdapter() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("bpid".equalsIgnoreCase(propertyName)) {
                RcvTransCustom.this.firePropertyChange("bpid", null, RcvTransCustom.this.getDataSetMaster().getString("bpid"));
            } else if ("crcid".equalsIgnoreCase(propertyName)) {
                if (RcvTransCustom.this.getDataSetMaster().getString("rcvtype").equalsIgnoreCase("DP")) {
                    RcvTransCustom.this.getDataSetDetail().setBigDecimal("excrate", RcvTransCustom.this.getDataSetMaster().getBigDecimal("excrate"));
                    RcvTransCustom.this.getDataSetDetail().setBigDecimal("fisrate", RcvTransCustom.this.getDataSetMaster().getBigDecimal("fisrate"));
                    RcvTransCustom.this.getDataSetDetail().setString("crcid", RcvTransCustom.this.getDataSetMaster().getString("crcid"));
                }
            } else if ("excrate".equalsIgnoreCase(propertyName)) {
                if (RcvTransCustom.this.getDataSetMaster().getString("rcvtype").equalsIgnoreCase("DP")) {
                    RcvTransCustom.this.getDataSetDetail().setBigDecimal("excrate", RcvTransCustom.this.getDataSetMaster().getBigDecimal("excrate"));
                } else {
                    RcvTransCustom.this.setRateSPaid("excrate");
                    RcvTransCustom.this.setRateRcvd("excrate");
                }
            } else if ("fisrate".equalsIgnoreCase(propertyName)) {
                if (RcvTransCustom.this.getDataSetMaster().getString("rcvtype").equalsIgnoreCase("DP")) {
                    RcvTransCustom.this.getDataSetDetail().setBigDecimal("fisrate", RcvTransCustom.this.getDataSetMaster().getBigDecimal("fisrate"));
                } else {
                    RcvTransCustom.this.setRateSPaid("fisrate");
                    RcvTransCustom.this.setRateRcvd("fisrate");
                }
            }
        }
    }
}

