/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.BPAccList;
import com.bits.bee.bl.BPList;
import com.bits.bee.bl.City;
import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.Crc;
import com.bits.bee.bl.CrcChangeAdapter;
import com.bits.bee.bl.CurrencyRateGetter;
import com.bits.bee.bl.DPList;
import com.bits.bee.bl.DPTransBL;
import com.bits.bee.bl.ItemList;
import com.bits.bee.bl.Pid;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.TransactionCalculator;
import com.bits.bee.pluginpersewaan.bl.BookingTrans;
import com.bits.bee.pluginpersewaan.bl.DPTransBLListRent;
import com.bits.bee.pluginpersewaan.bl.Rent;
import com.bits.bee.pluginpersewaan.bl.RentD;
import com.bits.bee.pluginpersewaan.bl.RentItemD;
import com.bits.bee.pluginpersewaan.bl.storedprocedure.spRent_New;
import com.bits.bee.pluginpersewaan.bl.storedprocedure.spRent_Void;
import com.bits.bee.pluginpersewaan.ui.FrmRent;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;

public class RentTrans
extends BTrans
implements ColumnChangeListener,
CurrencyRateGetter,
CrcChangeAdapter {
    private Rent master = null;
    private RentD detail = null;
    private RentItemD item = null;
    private RentAdapter rentAdapter = new RentAdapter();
    private RentdAdapter rentdAdapter = new RentdAdapter();
    private RentItemAdapter rentItemAdapter = new RentItemAdapter();
    private spRent_New spNew = new spRent_New();
    private spRent_Void spVoid = new spRent_Void();
    private int ROUND = Reg.getInstance().getValueInt("ROUND");
    private int ROUND_TAX = Reg.getInstance().getValueInt("ROUND_TAX");
    protected boolean prclvl_change = Reg.getInstance().getValueBoolean("PRCLVL_CHANGE");
    protected String oldPrcLvlID = null;
    private DataRow setBPID_changed = null;
    private boolean alwaysTaxed = false;
    private ArrayList alCtrlDel = new ArrayList();
    protected TransactionCalculator tc;
    protected boolean split_qty;
    protected DPList dpList = new DPList(DPList.DP_MODE.SO_DP);
    protected DPTransBLListRent dpTransBLList = new DPTransBLListRent(DPTransBLListRent.DP_MODE.SO_DP);

    public RentTrans() {
        super(BDM.getDefault(), "RENT", "rentdate", "branchid", "rentno", "rent");
        this.initTrans();
        this.setMaster((BTable)this.master);
        this.addDetail(this.detail);
        this.getDataSetDetail(0).addDataChangeListener((DataChangeListener)this.detail);
        this.initBk();
        this.setspNew(this.spNew);
        this.setspVoid(this.spVoid);
    }

    private void initTrans() {
        this.master = (Rent)BTableProvider.createTable(Rent.class);
        this.detail = (RentD)BTableProvider.createTable(RentD.class);
        this.item = (RentItemD)BTableProvider.createTable(RentItemD.class);
    }

    public void addBulkPID(Pid pid) throws Exception {
        short lastrentdno = 0;
        if (pid == null || pid.getDataSet().getRowCount() < 1) {
            return;
        }
        boolean isTaxed = this.getDataSetMaster().getBoolean("istaxed");
        this.setBypass(true);
        int bookmark = this.getDataSetDetail().getRow();
        this.enableDataSetEvents(false);
        try {
            if (pid != null && pid.getDataSet().getRowCount() > 0) {
                String itemid = this.getDataSetDetail().getString("itemid");
                String jtable_pid = this.getDataSetDetail().getString("pid");
                if (ItemList.getInstance().isItemValid(itemid) && ItemList.getInstance().usePID(itemid) && (jtable_pid == null || jtable_pid.length() < 1)) {
                    this.getDataSetDetail().deleteRow();
                }
            }
            lastrentdno = this.getDetail().getShort_LastRow("rentdno");
            for (int i = 0; i < pid.getDataSet().getRowCount(); ++i) {
                pid.getDataSet().goToRow(i);
                this.getDetail().New();
                this.getDataSetDetail(0).setString("rentno", this.getDataSetMaster().getString("rentno"));
                lastrentdno = (short)(lastrentdno + 1);
                this.getDataSetDetail(0).setShort("rentdno", lastrentdno);
                this.getDataSetDetail(0).setString("itemid", pid.getString("itemid"));
                this.getDataSetDetail(0).setString("itemdesc", pid.getString("itemdesc"));
                this.getDataSetDetail(0).setString("pid", pid.getString("pid"));
                this.getDataSetDetail(0).setString("unit", pid.getString("unit"));
                this.getDataSetDetail(0).setString("discexp", pid.getString("discexp"));
                this.getDataSetDetail(0).setBigDecimal("qty", pid.getBigDecimal("qty"));
                this.getDataSetDetail(0).setBigDecimal("listprice", pid.getBigDecimal("listprice"));
                this.getDataSetDetail(0).setString("whid", pid.getString("whid"));
                this.detail.resetItemTax();
                this.detail.calcItemBaseprice();
                this.detail.calcItemDisc();
                this.detail.calcItemTax();
                this.getDataSetDetail(0).post();
            }
            BLUtil.renumberDetail((BTrans)this, (String)"rentdno");
            this.totalCalc();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.enableDataSetEvents(true);
            this.getDataSetDetail().goToRow(bookmark);
            this.setBypass(false);
        }
    }

    public void New() {
        super.New();
        this.getDataSetMaster().setString("rentno", "AUTO");
        this.getDataSetMaster().setDate("rentdate", BHelp.getCurrentDate_SQL());
        this.getDataSetMaster().setDate("shipdate", BHelp.getCurrentDate_SQL());
        this.getDataSetMaster().setString("custid", "CASH");
        this.getDataSetMaster().setString("crtby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setTimestamp("crtdate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setString("crcid", BPAccList.getInstance().getCrcID(this.getDataSetMaster().getString("custid")));
        this.getDataSetMaster().setDate("startrentdate", BHelp.getCurrentDate_SQL());
        this.getDataSetMaster().setDate("endrentdate", BHelp.getCurrentDate_SQL());
    }

    public void Save() throws Exception {
        BLUtil.renumberDetail((BTrans)this, (String)"rentdno");
        System.out.println("basetotal 1" + this.getDataSetDetail().getColumn("basetotal"));
        super.Save();
        this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
    }

    protected void totalCalc() {
        super.calcMasterDisc(4, BLUtil.MC_FOUR, this.ROUND);
        super.calcDetailDisc2(4, BLUtil.MC_FOUR, this.ROUND);
        this.detail.resetAllTax(false);
        super.subTotalCalc(4, BLUtil.MC_FOUR, this.ROUND);
    }

    private void initBk() {
        this.setCrtBy(BAuthMgr.getDefault().getUserID());
        this.getDataSetDetail().addDataChangeListener((DataChangeListener)this.rentdAdapter);
        this.detail.setRateGetter(this);
        this.detail.addPropertyChangeListener("itemid", this.rentdAdapter);
        this.detail.addPropertyChangeListener("unit", this.rentdAdapter);
        this.detail.addPropertyChangeListener("qty", this.rentdAdapter);
        this.detail.addPropertyChangeListener("listprice", this.rentdAdapter);
        this.detail.addPropertyChangeListener("discexp", this.rentdAdapter);
        this.detail.addPropertyChangeListener("subtotal", this.rentdAdapter);
        this.detail.addPropertyChangeListener("taxamt", this.rentdAdapter);
        this.detail.addPropertyChangeListener("resetmaster", this.rentdAdapter);
        this.detail.addPropertyChangeListener("basesubtotal", this.rentdAdapter);
        this.detail.addPropertyChangeListener("basetotaltaxamt", this.rentdAdapter);
        this.detail.addPropertyChangeListener("basftotaltaxamt", this.rentdAdapter);
        this.detail.addPropertyChangeListener("taxid", this.rentdAdapter);
        this.detail.setCrcListener(this);
        this.master.addPropertyChangeListener("custid", this.rentAdapter);
        this.master.addPropertyChangeListener("istaxed", this.rentAdapter);
        this.master.addPropertyChangeListener("taxinc", this.rentAdapter);
        this.master.addPropertyChangeListener("resetTax", this.rentAdapter);
        this.master.addPropertyChangeListener("freight", this.rentAdapter);
        this.master.addPropertyChangeListener("discexp", this.rentAdapter);
        this.master.addPropertyChangeListener("crcid", this.rentAdapter);
        this.master.addPropertyChangeListener("excrate", this.rentAdapter);
        this.master.addPropertyChangeListener("fisrate", this.rentAdapter);
        this.master.setOrderBy("bookingno");
    }

    public BigDecimal getExcRate() {
        return this.getDataSetMaster().getBigDecimal("excrate");
    }

    public BigDecimal getFisRate() {
        return this.getDataSetMaster().getBigDecimal("fisrate");
    }

    public String getNewCrc() {
        return this.getDataSetMaster().getString("crcid");
    }

    public void changed(DataSet ds, Column column, Variant vrnt) {
    }

    public void validate(DataSet ds, Column column, Variant vrnt) throws Exception, DataSetException {
    }

    protected void CustID_Changed() {
        String BPPrcLvlID = BPList.getInstance().getPrcLvlID(this.getMaster().getString("custid"));
        this.detail.setBPID(this.getMaster().getString("custid"));
        this.setBPID_changed = BPList.getInstance().getSale_BPIDChanged(this.getMaster().getString("custid"));
        if (this.prclvl_change && this.oldPrcLvlID == null) {
            this.oldPrcLvlID = BPPrcLvlID;
        }
        if (this.setBPID_changed != null) {
            this.getDataSetMaster().setString("crcid", BPAccList.getInstance().getCrcID(this.getMaster().getString("custid")));
            if (!this.setBPID_changed.isNull("SRepID")) {
                this.getDataSetMaster().setString("srepid", this.setBPID_changed.getString("SRepID"));
            }
            if (!this.setBPID_changed.isNull("saletermtype")) {
                this.getMaster().setString("termtype", this.setBPID_changed.getString("saletermtype"));
            } else {
                this.getMaster().setString("termtype", Reg.getInstance().getValueString("SALETERMTYPE"));
            }
            if (!this.setBPID_changed.isNull("SaleTaxID")) {
                this.getMaster().setString("taxid", this.setBPID_changed.getString("SaleTaxID"));
            }
            if (!this.alwaysTaxed) {
                this.getDataSetMaster().setBoolean("taxinc", this.setBPID_changed.getBoolean("saletaxinc"));
                this.getDataSetMaster().setBoolean("istaxed", this.setBPID_changed.getBoolean("saleistaxed"));
            } else {
                this.getDataSetMaster().setBoolean("taxinc", true);
                this.getDataSetMaster().setBoolean("istaxed", true);
            }
            this.getMaster().setShort("duedays", this.setBPID_changed.getShort("ARDueDays"));
            this.getMaster().setShort("discdays", this.setBPID_changed.getShort("ARDiscDays"));
        }
    }

    public void import_booking(String bookingno) throws Exception {
        Object qtyDue = null;
        BookingTrans bookingTrans = new BookingTrans();
        bookingTrans.LoadID(bookingno);
        int count = this.getDataSetDetail().rowCount();
        this.setBypass(true);
        int bookmark = this.getDataSetDetail().getRow();
        this.enableDataSetEvents(false);
        bookingTrans.enableDataSetEvents(false);
        short localLastRentDNo = this.getDetail().getShort_LastRow("rentdno");
        DataSet bookingMaster = bookingTrans.getDataSetMaster();
        if (bookingMaster.getBoolean("isdraft")) {
            throw new Exception("Booking masih dalam mode draft !");
        }
        if (!bookingMaster.getBoolean("active")) {
            throw new Exception("Booking tidak aktif !");
        }
        try {
            this.New();
            FrmRent frmRent = new FrmRent();
            frmRent.doNew();
            this.getDataSetMaster().setString("custid", bookingMaster.getString("custid"));
            this.getDataSetMaster().setString("termtype", bookingMaster.getString("termtype"));
            this.getDataSetMaster().setString("crcid", bookingMaster.getString("crcid"));
            this.getDataSetMaster().setBigDecimal("excrate", bookingMaster.getBigDecimal("excrate"));
            this.getDataSetMaster().setBigDecimal("fisrate", bookingMaster.getBigDecimal("fisrate"));
            this.getDataSetMaster().setBoolean("istaxed", bookingMaster.getBoolean("istaxed"));
            this.getDataSetMaster().setBoolean("taxinc", bookingMaster.getBoolean("taxinc"));
            this.getDataSetMaster().setDate("startrentdate", bookingMaster.getDate("startrentdate"));
            this.getDataSetMaster().setDate("endrentdate", bookingMaster.getDate("endrentdate"));
            this.getDataSetMaster().setString("guaranteetype", bookingMaster.getString("guaranteetype"));
            this.getDataSetMaster().setString("guaranteeno", bookingMaster.getString("guaranteeno"));
            this.getDataSetMaster().setString("guaranteenote", bookingMaster.getString("guaranteenote"));
            this.getDataSetMaster().setString("refno", bookingMaster.getString("bookingno"));
            if (!bookingMaster.isNull("bookingno")) {
                this.getDataSetMaster().setString("bookingno", bookingMaster.getString("bookingno"));
            }
            if (!bookingMaster.isNull("duedays")) {
                this.getDataSetMaster().setShort("duedays", bookingMaster.getShort("duedays"));
            }
            if (!bookingMaster.isNull("srepid")) {
                this.getDataSetMaster().setString("srepid", bookingMaster.getString("srepid"));
            }
            if (!bookingMaster.isNull("billto")) {
                this.getDataSetMaster().setString("billto", bookingMaster.getString("billto"));
            }
            if (!bookingMaster.isNull("shipto")) {
                this.getDataSetMaster().setString("shipto", bookingMaster.getString("shipto"));
            }
            if (!bookingMaster.isNull("branchid")) {
                this.getDataSetMaster().setString("branchid", bookingMaster.getString("branchid"));
            }
            if (!bookingMaster.isNull("bookingnote")) {
                this.getDataSetMaster().setString("rentnote", bookingMaster.getString("bookingnote"));
            }
            if (!bookingMaster.isNull("shiptime")) {
                this.getDataSetMaster().setTime("shiptime", bookingMaster.getTime("shiptime"));
            }
            for (int j = 0; j < bookingTrans.getDataSetDetail().getRowCount(); ++j) {
                DataSet bookingDetail = bookingTrans.getDataSetDetail();
                bookingTrans.getDataSetDetail().goToRow(j);
                String itemid = bookingDetail.getString("itemid");
                this.getDetail().New();
                this.getDataSetDetail(0).setString("rentno", this.getDataSetMaster().getString("rentno"));
                this.getDataSetDetail(0).setString("bookingno", bookingDetail.getString("bookingno"));
                localLastRentDNo = (short)(localLastRentDNo + 1);
                this.getDataSetDetail(0).setShort("rentdno", localLastRentDNo);
                this.getDataSetDetail(0).setShort("bookingdno", bookingDetail.getShort("bookingdno"));
                this.getDataSetDetail(0).setString("pid", bookingDetail.getString("pid"));
                if (!bookingDetail.isNull("taxid")) {
                    this.getDataSetDetail(0).setString("taxid", bookingDetail.getString("taxid"));
                }
                this.getDataSetDetail(0).setString("itemid", bookingDetail.getString("itemid"));
                this.getDataSetDetail(0).setString("whid", bookingDetail.getString("whid"));
                this.getDataSetDetail(0).setString("itemdesc", bookingDetail.getString("itemdesc"));
                this.getDataSetDetail(0).setBigDecimal("qty", bookingDetail.getBigDecimal("qty"));
                this.getDataSetDetail(0).setBigDecimal("qtyday", bookingDetail.getBigDecimal("qtyday"));
                this.getDataSetDetail(0).setString("unit", bookingDetail.getString("unit"));
                this.getDataSetDetail(0).setBigDecimal("listprice", bookingDetail.getBigDecimal("listprice"));
                this.getDataSetDetail(0).setString("discexp", bookingDetail.getString("discexp"));
                this.getDataSetDetail(0).setBigDecimal("discamt", bookingDetail.getBigDecimal("discamt"));
                this.getDataSetDetail(0).setBigDecimal("subtotal", bookingDetail.getBigDecimal("subtotal"));
                this.detail.setTaxed(this.getDataSetMaster().getBoolean("istaxed"));
                this.detail.setTaxInc(this.getDataSetMaster().getBoolean("taxinc"));
                this.detail.calcItemDisc();
                this.detail.calcItemBaseprice();
                this.detail.calcItemTax();
                this.detail.calcItemSubtotal();
                this.getDataSetDetail().post();
            }
            if (this.getDataSetMaster().getBoolean("taxinc")) {
                // empty if block
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.totalCalc();
            this.recalcMasterData();
            this.enableDataSetEvents(true);
            bookingTrans.enableDataSetEvents(true);
            this.getDataSetDetail(0).goToRow(bookmark);
            this.setBypass(false);
            this.totalCalc();
        }
    }

    public void importDP_Booking(String bookingno, DPTransBL dsDP) throws Exception {
        BookingTrans bookingTrans = new BookingTrans();
        bookingTrans.LoadID(bookingno);
        DataSet bookingMaster = bookingTrans.getDataSetMaster();
        DPTransBL dPTransBL = new DPTransBL();
        dPTransBL.Load("refno = " + BHelp.QuoteSingle((String)bookingno));
        DataRow dr = new DataRow(dPTransBL.getDataSet());
        DataRow newrow = new DataRow(dsDP.getDataSet());
        dsDP.getDataSet().emptyAllRows();
        dPTransBL.getDataSet().getRowCount();
        System.out.println("refno : " + dPTransBL.getDataSet().getString("refno"));
        if (dPTransBL.getDataSet().getString("refno").length() > 0) {
            newrow.setString("refno", dPTransBL.getDataSet().getString("refno"));
        }
        if (dPTransBL.getDataSet().getString("note").length() > 0) {
            newrow.setString("note", dPTransBL.getDataSet().getString("note"));
        }
        if (dPTransBL.getDataSet().getString("cashid").length() > 0) {
            newrow.setString("cashid", dPTransBL.getDataSet().getString("cashid"));
        }
        if (dPTransBL.getDataSet().getString("cbgid").length() > 0) {
            newrow.setString("cbgid", dPTransBL.getDataSet().getString("cbgid"));
        }
        if (dPTransBL.getDataSet().getString("mtd").length() > 0) {
            newrow.setString("mtd", dPTransBL.getDataSet().getString("mtd"));
        }
        newrow.setString("reftype", "BOOK");
        newrow.setLong("dpid", BigDecimal.ZERO.longValue());
        newrow.setString("paidno", "AUTO");
        newrow.setString("dppaidno", "AUTO");
        newrow.setString("bpid", bookingMaster.getString("custid"));
        newrow.setString("branchid", bookingMaster.getString("branchid"));
        newrow.setString("crcid", bookingMaster.getString("crcid"));
        newrow.setString("paidcrcid", dPTransBL.getDataSet().getString("crcid"));
        if (dPTransBL.getDataSet().getDate("dpdate") != null && dPTransBL.getDataSet().getDate("dpdate").toString().length() > 0) {
            newrow.setDate("dpdate", dPTransBL.getDataSet().getDate("dpdate"));
        } else {
            newrow.setDate("dpdate", bookingMaster.getDate("rentdate"));
        }
        newrow.setBigDecimal("excrate", bookingMaster.getBigDecimal("excrate"));
        newrow.setBigDecimal("fisrate", bookingMaster.getBigDecimal("fisrate"));
        if (bookingMaster.getString("crcid").equalsIgnoreCase(dPTransBL.getDataSet().getString("crcid"))) {
            newrow.setBigDecimal("paidexcrate", bookingMaster.getBigDecimal("excrate"));
            newrow.setBigDecimal("paidfisrate", bookingMaster.getBigDecimal("fisrate"));
        } else {
            newrow.setBigDecimal("paidexcrate", Crc.getInstance().getExcRate(dPTransBL.getDataSet().getString("crcid")));
            newrow.setBigDecimal("paidfisrate", Crc.getInstance().getFisRate(dPTransBL.getDataSet().getString("crcid")));
        }
        newrow.setBigDecimal("dpamt", dPTransBL.getDataSet().getBigDecimal("dpamt"));
        newrow.setBigDecimal("usedamt", dPTransBL.getDataSet().getBigDecimal("usedamt"));
        newrow.setBigDecimal("paidamt", dPTransBL.getDataSet().getBigDecimal("paidamt"));
        newrow.setBigDecimal("dpbal", dPTransBL.getDataSet().getBigDecimal("dpBal"));
        newrow.setBoolean("isautogendp", true);
        System.out.println(bookingno);
        dsDP.getDataSet().addRow(newrow);
    }

    public void initPrint() {
        DataSet drcmp = Cmp.getInstance().getDataSet();
        this.getDataSetMaster().setString("cmpname", drcmp.getString("cmpname"));
        this.getDataSetMaster().setString("cmpownername", drcmp.getString("ownername"));
        this.getDataSetMaster().setString("cmpaddr", drcmp.getString("cmpaddr"));
        this.getDataSetMaster().setString("cmpphone", drcmp.getString("phone"));
        this.getDataSetMaster().setString("cmpcity", City.getInstance().getCityName(drcmp.getString("cityid")));
        this.getDataSetMaster().setString("cmptaxregno", drcmp.getString("taxregno"));
        this.getDataSetMaster().setString("cmpvatregno", drcmp.getString("vatregno"));
        this.getDataSetMaster().setDate("cmpvatregdate", drcmp.getDate("vatregdate"));
        this.getDataSetMaster().setString("formserno", drcmp.getString("formserno"));
        this.getDataSetMaster().setBigDecimal("dpamt", this.getDP(this.getDataSetMaster().getString("rentno")));
    }

    public void initTableDP(DPTransBL dsDP) throws Exception {
        DataRow newrow = new DataRow(dsDP.getDataSet());
        newrow.getColumn("dpid").setVisible(0);
        newrow.getColumn("paidno").setVisible(0);
        newrow.getColumn("bpid").setVisible(0);
        newrow.getColumn("branchid").setVisible(0);
        newrow.getColumn("mtd").setVisible(0);
        newrow.getColumn("cashid").setVisible(0);
        newrow.getColumn("cashdesc").setVisible(0);
        newrow.getColumn("cbgid").setVisible(0);
        newrow.getColumn("paidamt").setVisible(0);
        newrow.getColumn("note").setVisible(0);
        newrow.getColumn("refno").setVisible(0);
        newrow.getColumn("excrate").setVisible(0);
        newrow.getColumn("fisrate").setVisible(0);
        newrow.getColumn("paidcrcid").setVisible(0);
        newrow.getColumn("paidexcrate").setVisible(0);
        newrow.getColumn("paidfisrate").setVisible(0);
        newrow.getColumn("isautogendp").setVisible(0);
    }

    public DPList getDPList() {
        return this.dpList;
    }

    public DPTransBLListRent getDPTransList() {
        return this.dpTransBLList;
    }

    public void generateDP(String refno, String reftype, DPTransBL dp) throws Exception {
        this.dpTransBLList.loadID(refno, reftype);
        dp.getDataSet().emptyAllRows();
        DataRow newrow = new DataRow(dp.getDataSet());
        if (this.dpTransBLList.getDataSet().getRowCount() > 0) {
            if (this.dpTransBLList.getDataSet().getString("refno").length() > 0) {
                newrow.setString("refno", this.dpTransBLList.getDataSet().getString("refno"));
            }
            if (this.dpTransBLList.getDataSet().getString("note").length() > 0) {
                newrow.setString("note", this.dpTransBLList.getDataSet().getString("note"));
            }
            if (this.dpTransBLList.getDataSet().getString("cashid").length() > 0) {
                newrow.setString("cashid", this.dpTransBLList.getDataSet().getString("cashid"));
            }
            if (this.dpTransBLList.getDataSet().getString("cbgid").length() > 0) {
                newrow.setString("cbgid", this.dpTransBLList.getDataSet().getString("cbgid"));
            }
            if (this.dpTransBLList.getDataSet().getString("mtd").length() > 0) {
                newrow.setString("mtd", this.dpTransBLList.getDataSet().getString("mtd"));
            }
            newrow.setLong("dpid", this.dpTransBLList.getDataSet().getBigDecimal("dpid").longValue());
            newrow.setString("paidno", this.dpTransBLList.getDataSet().getString("paidno"));
            newrow.setString("dppaidno", this.dpTransBLList.getDataSet().getString("dppaidno"));
            newrow.setString("bpid", this.dpTransBLList.getDataSet().getString("bpid"));
            newrow.setString("branchid", this.dpTransBLList.getDataSet().getString("branchid"));
            newrow.setString("crcid", this.dpTransBLList.getDataSet().getString("crcid"));
            newrow.setString("paidcrcid", this.dpTransBLList.getDataSet().getString("paidcrcid"));
            newrow.setDate("dpdate", this.dpTransBLList.getDataSet().getDate("dpdate"));
            newrow.setBigDecimal("dpamt", this.dpTransBLList.getDataSet().getBigDecimal("dpamt"));
            newrow.setBigDecimal("usedamt", this.dpTransBLList.getDataSet().getBigDecimal("usedamt"));
            newrow.setBigDecimal("dpbal", this.dpTransBLList.getDataSet().getBigDecimal("dpbal"));
            newrow.setBigDecimal("paidamt", this.dpTransBLList.getDataSet().getBigDecimal("paidamt"));
            newrow.setBigDecimal("excrate", this.dpTransBLList.getDataSet().getBigDecimal("excrate"));
            newrow.setBigDecimal("fisrate", this.dpTransBLList.getDataSet().getBigDecimal("fisrate"));
            newrow.setBigDecimal("paidexcrate", this.dpTransBLList.getDataSet().getBigDecimal("paidexcrate"));
            newrow.setBigDecimal("paidfisrate", this.dpTransBLList.getDataSet().getBigDecimal("paidfisrate"));
            newrow.setBoolean("isautogendp", this.dpTransBLList.getDataSet().getBoolean("isautogendp"));
            dp.getDataSet().addRow(newrow);
        }
    }

    public String getBookingNo(String rentno) {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bookingno FROM rent WHERE rentno = " + BHelp.QuoteSingle((String)rentno));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getString("bookingno");
    }

    public String getRefNo(String id) {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT refno FROM dp WHERE refno = " + BHelp.QuoteSingle((String)id));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getString("refno");
    }

    public BigDecimal getDPBooking(String id) {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT dpamt FROM dp WHERE refno = " + BHelp.QuoteSingle((String)id));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getBigDecimal("dpamt");
    }

    public BigDecimal getDP(String id) {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer sql = new StringBuffer();
        if (this.getDPBooking(this.getDataSetMaster().getString("bookingno")).compareTo(BigDecimal.ZERO) == 1) {
            return this.getDPBooking(this.getDataSetMaster().getString("bookingno"));
        }
        sql.append("SELECT dpamt FROM dp WHERE refno = " + BHelp.QuoteSingle((String)id));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getBigDecimal("dpamt");
    }

    class RentItemAdapter
    implements DataChangeListener {
        RentItemAdapter() {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (dataChangeEvent.getID() == 1 && RentTrans.this.getDataSetDetail(1).isNull("rentno")) {
                RentTrans.this.getDetail(1).setString("rentno", RentTrans.this.getMaster().getString("rentno"));
                RentTrans.this.getDetail(1).setShort("itemrentdno", (short)(RentTrans.this.getDataSetDetail(0).getRow() + 1));
            }
        }

        public void postRow(DataChangeEvent dataChangeEvent) {
        }
    }

    class RentdAdapter
    implements DataChangeListener,
    PropertyChangeListener {
        RentdAdapter() {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (dataChangeEvent.getID() == 1 && RentTrans.this.getDataSetDetail(0).isNull("rentno")) {
                RentTrans.this.getDetail(0).setString("rentno", RentTrans.this.getMaster().getString("rentno"));
                RentTrans.this.getDetail(0).setShort("rentdno", (short)(RentTrans.this.getDataSetDetail(0).getRow() + 1));
                RentTrans.this.getDetail(0).setString("whid", Reg.getInstance().getValueString("WHSTOCK"));
            }
        }

        public void postRow(DataChangeEvent dataChangeEvent) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("qty".equalsIgnoreCase(propertyName) || "listprice".equalsIgnoreCase(propertyName) || "unit".equalsIgnoreCase(propertyName) || "itemid".equalsIgnoreCase(propertyName) || "discexp".equalsIgnoreCase(propertyName)) {
                if ("unit".equalsIgnoreCase(propertyName)) {
                    RentTrans.this.recalcMasterData();
                }
                RentTrans.this.totalCalc();
            } else if ("taxamt".equalsIgnoreCase(propertyName)) {
                RentTrans.this.calcMasterTaxamt((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
                System.out.println("taxamt");
            } else if ("subtotal".equalsIgnoreCase(propertyName)) {
                RentTrans.this.calcMasterSubtotal((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
                RentTrans.this.totalCalc();
                System.out.println("subtotal n");
            } else if ("resetmaster".equalsIgnoreCase(propertyName)) {
                RentTrans.this.recalcMasterData();
                System.out.println("reset master 0 :" + RentTrans.this.getDataSetMaster().getBigDecimal("basetotal"));
            } else if ("basftotaltaxamt".equalsIgnoreCase(propertyName)) {
                RentTrans.this.calcMasterBaseFTaxamt((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("basetotaltaxamt".equalsIgnoreCase(propertyName)) {
                RentTrans.this.calcMasterBaseTaxamt((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("basesubtotal".equalsIgnoreCase(propertyName)) {
                RentTrans.this.calcMasterBaseSubtotal((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
                System.out.println("base subtotal");
            } else if ("taxid".equalsIgnoreCase(propertyName)) {
                RentTrans.this.recalcMasterTaxTotal();
                System.out.println("taxid");
            } else if ("crcid".equalsIgnoreCase(propertyName) || "excrate".equalsIgnoreCase(propertyName) || "fisrate".equalsIgnoreCase(propertyName)) {
                RentTrans.this.totalCalc();
            }
        }
    }

    class RentAdapter
    implements PropertyChangeListener {
        RentAdapter() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("discexp".equalsIgnoreCase(propertyName)) {
                RentTrans.this.calcMasterDisc(4, BLUtil.MC_FOUR, RentTrans.this.ROUND);
                RentTrans.this.calcDetailDisc2(4, BLUtil.MC_FOUR, RentTrans.this.ROUND);
                RentTrans.this.detail.recalcAllTax();
            } else if ("custid".equalsIgnoreCase(propertyName)) {
                RentTrans.this.CustID_Changed();
            } else if ("istaxed".equalsIgnoreCase(propertyName)) {
                RentTrans.this.detail.setTaxed(RentTrans.this.getDataSetMaster().getBoolean("istaxed"));
                System.out.println("istaxed");
            } else if ("taxinc".equalsIgnoreCase(propertyName)) {
                RentTrans.this.detail.setTaxInc(RentTrans.this.getDataSetMaster().getBoolean("taxinc"));
                if (RentTrans.this.getDataSetMaster().getBigDecimal("discamt").compareTo(BigDecimal.ZERO) != 0) {
                    RentTrans.this.detail.resetAllTax(true);
                    RentTrans.this.calcMasterDisc(4, BLUtil.MC_FOUR, RentTrans.this.ROUND);
                    RentTrans.this.calcDetailDisc2(4, BLUtil.MC_FOUR, RentTrans.this.ROUND);
                }
            } else if ("resettax".equalsIgnoreCase(propertyName)) {
                RentTrans.this.detail.resetAllTax(true);
                System.out.println("resettax");
            } else if ("crcid".equalsIgnoreCase(propertyName) || "excrate".equalsIgnoreCase(propertyName) || "fisrate".equalsIgnoreCase(propertyName)) {
                RentTrans.this.totalCalc();
            }
        }
    }
}

