/*
 * Decompiled with CFR 0.152.
 */
package com.bits.bee.pluginpersewaan.bl;

import com.bits.bee.bl.BLUtil;
import com.bits.bee.bl.BPAccList;
import com.bits.bee.bl.BPList;
import com.bits.bee.bl.City;
import com.bits.bee.bl.Cmp;
import com.bits.bee.bl.CrcChangeAdapter;
import com.bits.bee.bl.CurrencyRateGetter;
import com.bits.bee.bl.Reg;
import com.bits.bee.bl.TransactionCalculator;
import com.bits.bee.pluginpersewaan.bl.RentTrans;
import com.bits.bee.pluginpersewaan.bl.Retur;
import com.bits.bee.pluginpersewaan.bl.ReturD;
import com.bits.bee.pluginpersewaan.bl.storedprocedure.spRetur_New;
import com.bits.bee.pluginpersewaan.bl.storedprocedure.spRetur_Void;
import com.bits.bee.pluginpersewaan.ui.FrmRetur;
import com.bits.bee.ui.UIMgr;
import com.bits.lib.BHelp;
import com.bits.lib.dx.BDM;
import com.bits.lib.dx.BTable;
import com.bits.lib.dx.BTrans;
import com.bits.lib.dx.provider.BTableProvider;
import com.bits.lib.security.BAuthMgr;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnChangeListener;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;

public class ReturTrans
extends BTrans
implements ColumnChangeListener,
CurrencyRateGetter,
CrcChangeAdapter {
    private Retur master = null;
    private ReturD detail = null;
    private ReturAdapater returAdapter = new ReturAdapater();
    private ReturDAdapter returDAdapter = new ReturDAdapter();
    private int ROUND = Reg.getInstance().getValueInt("ROUND");
    private int ROUND_TAX = Reg.getInstance().getValueInt("ROUND_TAX");
    protected boolean prclvl_change = Reg.getInstance().getValueBoolean("PRCLVL_CHANGE");
    protected String oldPrcLvlID = null;
    private DataRow setBPID_changed = null;
    private boolean alwaysTaxed = false;
    private ArrayList alCtrlDel = new ArrayList();
    protected TransactionCalculator tc;
    private spRetur_New spNew = new spRetur_New();
    private spRetur_Void spVoid = new spRetur_Void();

    public ReturTrans() {
        super(BDM.getDefault(), "RETUR", "returno", "retur");
        this.initTrans();
        this.setMaster((BTable)this.master);
        this.addDetail((BTable)this.detail);
        this.setspNew(this.spNew);
        this.setspVoid(this.spVoid);
        this.initBk();
    }

    private void initTrans() {
        this.master = (Retur)BTableProvider.createTable(Retur.class);
        this.detail = (ReturD)BTableProvider.createTable(ReturD.class);
    }

    public void New() {
        super.New();
        this.getDataSetMaster().setString("returno", "AUTO");
        this.getDataSetMaster().setDate("returdate", BHelp.getCurrentDate_SQL());
        this.getDataSetMaster().setString("custid", "CASH");
        this.getDataSetMaster().setString("crtby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
        this.getDataSetMaster().setTimestamp("crtdate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setTimestamp("upddate", BHelp.getCurrentDateTime());
        this.getDataSetMaster().setString("crcid", BPAccList.getInstance().getCrcID(this.getDataSetMaster().getString("custid")));
        this.getDataSetMaster().setTime("receivetime", BHelp.getCurrentTime());
        this.getDataSetMaster().setDate("receivedate", BHelp.getCurrentDate_SQL());
    }

    public void Save() throws Exception {
        BLUtil.renumberDetail((BTrans)this, (String)"returdno");
        super.Save();
        this.getDataSetMaster().setString("updby", BAuthMgr.getDefault().getUserID());
    }

    protected void CustID_Changed() {
        String BPPrcLvlID = BPList.getInstance().getPrcLvlID(this.getMaster().getString("custid"));
        this.detail.setBPID(this.getMaster().getString("custid"));
        this.setBPID_changed = BPList.getInstance().getSale_BPIDChanged(this.getMaster().getString("custid"));
        if (this.prclvl_change && this.oldPrcLvlID == null) {
            this.oldPrcLvlID = BPPrcLvlID;
        }
        if (this.setBPID_changed != null) {
            this.getDataSetMaster().setString("crcid", BPAccList.getInstance().getCrcID(this.getMaster().getString("custid")));
            if (!this.setBPID_changed.isNull("SRepID")) {
                this.getDataSetMaster().setString("srepid", this.setBPID_changed.getString("SRepID"));
            }
            if (!this.setBPID_changed.isNull("saletermtype")) {
                this.getMaster().setString("termtype", this.setBPID_changed.getString("saletermtype"));
            } else {
                this.getMaster().setString("termtype", Reg.getInstance().getValueString("SALETERMTYPE"));
            }
            if (!this.setBPID_changed.isNull("SaleTaxID")) {
                this.getMaster().setString("taxid", this.setBPID_changed.getString("SaleTaxID"));
            }
            if (!this.alwaysTaxed) {
                this.getDataSetMaster().setBoolean("taxinc", this.setBPID_changed.getBoolean("saletaxinc"));
                this.getDataSetMaster().setBoolean("istaxed", this.setBPID_changed.getBoolean("saleistaxed"));
            } else {
                this.getDataSetMaster().setBoolean("taxinc", true);
                this.getDataSetMaster().setBoolean("istaxed", true);
            }
            this.getMaster().setShort("duedays", this.setBPID_changed.getShort("ARDueDays"));
            this.getMaster().setShort("discdays", this.setBPID_changed.getShort("ARDiscDays"));
        }
    }

    protected void totalCalc() {
        super.calcMasterDisc(4, BLUtil.MC_FOUR, this.ROUND);
        super.calcDetailDisc2(4, BLUtil.MC_FOUR, this.ROUND);
        this.detail.resetAllTax(false);
        super.subTotalCalc(4, BLUtil.MC_FOUR, this.ROUND);
    }

    private void initBk() {
        this.setCrtBy(BAuthMgr.getDefault().getUserID());
        this.getDataSetDetail().addDataChangeListener((DataChangeListener)this.returDAdapter);
        this.detail.setRateGetter(this);
        this.detail.addPropertyChangeListener("itemid", this.returDAdapter);
        this.detail.addPropertyChangeListener("unit", this.returDAdapter);
        this.detail.addPropertyChangeListener("qty", this.returDAdapter);
        this.detail.addPropertyChangeListener("listprice", this.returDAdapter);
        this.detail.addPropertyChangeListener("discexp", this.returDAdapter);
        this.detail.addPropertyChangeListener("subtotal", this.returDAdapter);
        this.detail.addPropertyChangeListener("taxamt", this.returDAdapter);
        this.detail.addPropertyChangeListener("resetmaster", this.returDAdapter);
        this.detail.addPropertyChangeListener("basesubtotal", this.returDAdapter);
        this.detail.addPropertyChangeListener("basetotaltaxamt", this.returDAdapter);
        this.detail.addPropertyChangeListener("basftotaltaxamt", this.returDAdapter);
        this.detail.addPropertyChangeListener("taxid", this.returDAdapter);
        this.detail.setCrcListener(this);
        this.master.addPropertyChangeListener("custid", this.returAdapter);
        this.master.addPropertyChangeListener("istaxed", this.returAdapter);
        this.master.addPropertyChangeListener("taxinc", this.returAdapter);
        this.master.addPropertyChangeListener("resetTax", this.returAdapter);
        this.master.addPropertyChangeListener("freight", this.returAdapter);
        this.master.addPropertyChangeListener("discexp", this.returAdapter);
        this.master.addPropertyChangeListener("crcid", this.returAdapter);
        this.master.addPropertyChangeListener("excrate", this.returAdapter);
        this.master.addPropertyChangeListener("fisrate", this.returAdapter);
        this.master.setOrderBy("returno");
    }

    public BigDecimal getExcRate() {
        return this.getDataSetMaster().getBigDecimal("excrate");
    }

    public BigDecimal getFisRate() {
        return this.getDataSetMaster().getBigDecimal("fisrate");
    }

    public String getNewCrc() {
        return this.getDataSetMaster().getString("crcid");
    }

    public void changed(DataSet ds, Column column, Variant vrnt) {
    }

    public void validate(DataSet ds, Column column, Variant vrnt) throws Exception, DataSetException {
    }

    public void import_rent(String rentno) throws Exception {
        Object qtyDue = null;
        RentTrans rentTrans = new RentTrans();
        rentTrans.LoadID(rentno);
        int count = this.getDataSetDetail().rowCount();
        this.setBypass(true);
        int bookmark = this.getDataSetDetail().getRow();
        this.enableDataSetEvents(false);
        rentTrans.enableDataSetEvents(false);
        short localLastReturDNo = this.getDetail().getShort_LastRow("returdno");
        DataSet rentMaster = rentTrans.getDataSetMaster();
        if (rentMaster.getBoolean("isdraft")) {
            throw new Exception("Rental masih dalam mode draft !");
        }
        if (!rentMaster.getBoolean("active")) {
            throw new Exception("Rental tidak aktif !");
        }
        try {
            this.New();
            FrmRetur frmRetur = new FrmRetur();
            frmRetur.doNew();
            this.getDataSetMaster().setString("custid", rentMaster.getString("custid"));
            this.getDataSetMaster().setString("termtype", rentMaster.getString("termtype"));
            this.getDataSetMaster().setString("crcid", rentMaster.getString("crcid"));
            this.getDataSetMaster().setBoolean("isdraft", rentMaster.getBoolean("isdraft"));
            this.getDataSetMaster().setBoolean("istaxed", rentMaster.getBoolean("istaxed"));
            this.getDataSetMaster().setBoolean("taxinc", rentMaster.getBoolean("taxinc"));
            this.getDataSetMaster().setDate("returdate", rentMaster.getDate("startrentdate"));
            this.getDataSetMaster().setBigDecimal("subtotal", rentMaster.getBigDecimal("subtotal"));
            this.getDataSetMaster().setBigDecimal("total", rentMaster.getBigDecimal("total"));
            if (!rentMaster.isNull("rentno")) {
                this.getDataSetMaster().setString("rentno", rentMaster.getString("rentno"));
            }
            if (!rentMaster.isNull("srepid")) {
                this.getDataSetMaster().setString("srepid", rentMaster.getString("srepid"));
            }
            if (!rentMaster.isNull("billto")) {
                this.getDataSetMaster().setString("billto", rentMaster.getString("billto"));
            }
            if (!rentMaster.isNull("shipto")) {
                this.getDataSetMaster().setString("shipto", rentMaster.getString("shipto"));
            }
            if (!rentMaster.isNull("branchid")) {
                this.getDataSetMaster().setString("branchid", rentMaster.getString("branchid"));
            }
            for (int j = 0; j < rentTrans.getDataSetDetail().getRowCount(); ++j) {
                DataSet rentDetail = rentTrans.getDataSetDetail();
                rentTrans.getDataSetDetail().goToRow(j);
                String itemid = rentDetail.getString("itemid");
                this.getDetail().New();
                this.getDataSetDetail().setString("returno", this.getDataSetMaster().getString("returno"));
                this.getDataSetDetail().setString("rentno", rentDetail.getString("rentno"));
                localLastReturDNo = (short)(localLastReturDNo + 1);
                this.getDataSetDetail().setShort("returdno", localLastReturDNo);
                this.getDataSetDetail().setShort("rentdno", rentDetail.getShort("rentdno"));
                if (!rentDetail.isNull("taxid")) {
                    this.getDataSetDetail(0).setString("taxid", rentDetail.getString("taxid"));
                }
                this.getDataSetDetail().setString("itemid", rentDetail.getString("itemid"));
                this.getDataSetDetail().setString("itemdesc", rentDetail.getString("itemdesc"));
                this.getDataSetDetail().setString("pid", rentDetail.getString("pid"));
                this.getDataSetDetail().setBigDecimal("qty", rentDetail.getBigDecimal("qty"));
                this.getDataSetDetail().setString("unit", rentDetail.getString("unit"));
                this.getDataSetDetail().setBigDecimal("listprice", rentDetail.getBigDecimal("listprice"));
                this.getDataSetDetail().setString("discexp", rentDetail.getString("discexp"));
                this.getDataSetDetail().setBigDecimal("discamt", rentDetail.getBigDecimal("discamt"));
                this.getDataSetDetail().setBigDecimal("subtotal", rentDetail.getBigDecimal("subtotal"));
                this.detail.setTaxed(this.getDataSetMaster().getBoolean("istaxed"));
                this.detail.setTaxInc(this.getDataSetMaster().getBoolean("taxinc"));
                this.detail.calcItemDisc();
                this.detail.calcItemBaseprice();
                this.detail.calcItemTax();
                this.detail.calcItemSubtotal();
                this.getDataSetDetail().post();
            }
            if (this.getDataSetMaster().getBoolean("taxinc")) {
                // empty if block
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.totalCalc();
            this.recalcMasterData();
            this.enableDataSetEvents(true);
            rentTrans.enableDataSetEvents(true);
            this.getDataSetDetail().goToRow(bookmark);
            this.setBypass(false);
            this.totalCalc();
        }
    }

    public void initPrint() {
        DataSet drcmp = Cmp.getInstance().getDataSet();
        this.getDataSetMaster().setString("cmpname", drcmp.getString("cmpname"));
        this.getDataSetMaster().setString("cmpownername", drcmp.getString("ownername"));
        this.getDataSetMaster().setString("cmpaddr", drcmp.getString("cmpaddr"));
        this.getDataSetMaster().setString("cmpphone", drcmp.getString("phone"));
        this.getDataSetMaster().setString("cmpcity", City.getInstance().getCityName(drcmp.getString("cityid")));
        this.getDataSetMaster().setString("cmptaxregno", drcmp.getString("taxregno"));
        this.getDataSetMaster().setString("cmpvatregno", drcmp.getString("vatregno"));
        this.getDataSetMaster().setDate("cmpvatregdate", drcmp.getDate("vatregdate"));
        this.getDataSetMaster().setString("formserno", drcmp.getString("formserno"));
    }

    public boolean validateImport(String rentno) throws Exception {
        RentTrans rentTrans = new RentTrans();
        rentTrans.LoadID(rentno);
        if (this.getDataSetMaster().getDate("returdate").compareTo(rentTrans.getDataSetMaster().getDate("startrentdate")) < 0) {
            UIMgr.showErrorDialog((String)"Tanggal retur tidak boleh kurang dari tanggal sewa");
            return false;
        }
        return true;
    }

    public String getBookingNo(String rentno) {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bookingno FROM rent WHERE rentno = " + BHelp.QuoteSingle((String)rentno));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getString("bookingno");
    }

    public String getRefNo(String id) {
        QueryDataSet qds = new QueryDataSet();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT refno FROM dp WHERE refno = " + BHelp.QuoteSingle((String)id));
        if (qds.isOpen()) {
            qds.close();
        }
        qds.setQuery(new QueryDescriptor(BDM.getDefault().getDatabase(), sql.toString()));
        qds.open();
        return qds.getString("refno");
    }

    class ReturDAdapter
    implements DataChangeListener,
    PropertyChangeListener {
        ReturDAdapter() {
        }

        public void dataChanged(DataChangeEvent dataChangeEvent) {
            if (dataChangeEvent.getID() == 1 && ReturTrans.this.getDataSetDetail().isNull("rentno")) {
                ReturTrans.this.getDetail().setString("rentno", ReturTrans.this.getMaster().getString("rentno"));
                ReturTrans.this.getDetail().setShort("rentdno", (short)(ReturTrans.this.getDataSetDetail().getRow() + 1));
            }
        }

        public void postRow(DataChangeEvent dataChangeEvent) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("subtotal".equalsIgnoreCase(propertyName) || "qty".equalsIgnoreCase(propertyName) || "listprice".equalsIgnoreCase(propertyName) || "unit".equalsIgnoreCase(propertyName) || "itemid".equalsIgnoreCase(propertyName) || "discexp".equalsIgnoreCase(propertyName)) {
                if ("unit".equalsIgnoreCase(propertyName)) {
                    ReturTrans.this.recalcMasterData();
                }
                ReturTrans.this.totalCalc();
            } else if ("taxamt".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.calcMasterTaxamt((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("subtotal".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.calcMasterSubtotal((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("resetmaster".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.recalcMasterData();
            } else if ("basftotaltaxamt".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.calcMasterBaseFTaxamt((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("basetotaltaxamt".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.calcMasterBaseTaxamt((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("basesubtotal".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.calcMasterBaseSubtotal((BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            } else if ("taxid".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.recalcMasterTaxTotal();
            } else if ("crcid".equalsIgnoreCase(propertyName) || "excrate".equalsIgnoreCase(propertyName) || "fisrate".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.totalCalc();
            }
        }
    }

    class ReturAdapater
    implements PropertyChangeListener {
        ReturAdapater() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String propertyName = propertyChangeEvent.getPropertyName();
            if ("discexp".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.calcMasterDisc(4, BLUtil.MC_FOUR, ReturTrans.this.ROUND);
                ReturTrans.this.calcDetailDisc2(4, BLUtil.MC_FOUR, ReturTrans.this.ROUND);
                ReturTrans.this.detail.recalcAllTax();
            } else if ("custid".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.CustID_Changed();
            } else if ("istaxed".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.detail.setTaxed(ReturTrans.this.getDataSetMaster().getBoolean("istaxed"));
            } else if ("taxinc".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.detail.setTaxInc(ReturTrans.this.getDataSetMaster().getBoolean("taxinc"));
                if (ReturTrans.this.getDataSetMaster().getBigDecimal("discamt").compareTo(BigDecimal.ZERO) != 0) {
                    ReturTrans.this.detail.resetAllTax(true);
                    ReturTrans.this.calcMasterDisc(4, BLUtil.MC_FOUR, ReturTrans.this.ROUND);
                    ReturTrans.this.calcDetailDisc2(4, BLUtil.MC_FOUR, ReturTrans.this.ROUND);
                }
            } else if ("resettax".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.detail.resetAllTax(true);
            } else if ("crcid".equalsIgnoreCase(propertyName) || "excrate".equalsIgnoreCase(propertyName) || "fisrate".equalsIgnoreCase(propertyName)) {
                ReturTrans.this.totalCalc();
            }
        }
    }
}

